/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001b\tiqk\u001c:eeY+7-T8eK2T!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"aD\u000b\n\u0005Y\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\r\u0001\u0005\u000b\u0007I\u0011B\r\u0002\u000b5|G-\u001a7\u0016\u0003i\u0001Ba\u0007\u0010\"I9\u0011q\u0002H\u0005\u0003;A\ta\u0001\u0015:fI\u00164\u0017BA\u0010!\u0005\ri\u0015\r\u001d\u0006\u0003;A\u0001\"a\u0007\u0012\n\u0005\r\u0002#AB*ue&tw\rE\u0002\u0010K\u001dJ!A\n\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=A\u0013BA\u0015\u0011\u0005\u00151En\\1u\u0011!Y\u0003A!A!\u0002\u0013Q\u0012AB7pI\u0016d\u0007\u0005\u0003\u0004.\u0001\u0011\u0005AAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\n\u0004C\u0001\u0019\u0001\u001b\u0005\u0011\u0001\"\u0002\r-\u0001\u0004Q\u0002\"B\u001a\u0001\t\u0013!\u0014\u0001E2pg&tWmU5nS2\f'/\u001b;z)\r)\u0004H\u000f\t\u0003\u001fYJ!a\u000e\t\u0003\r\u0011{WO\u00197f\u0011\u0015I$\u00071\u0001%\u0003\t1\u0018\u0007C\u0003<e\u0001\u0007A%\u0001\u0002we!)Q\b\u0001C\u0001}\u0005IAO]1og\u001a|'/\u001c\u000b\u0003\u007f\u0015\u0003\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0003\u0002\r1Lg.\u00197h\u0013\t!\u0015I\u0001\u0004WK\u000e$xN\u001d\u0005\u0006\rr\u0002\r!I\u0001\u0005o>\u0014H\rC\u0003I\u0001\u0011\u0005\u0011*\u0001\u0007gS:$7+\u001f8p]fl7\u000fF\u0002K\u001d>\u00032aD\u0013L!\u0011yA*I\u001b\n\u00055\u0003\"A\u0002+va2,'\u0007C\u0003G\u000f\u0002\u0007\u0011\u0005C\u0003Q\u000f\u0002\u0007\u0011+A\u0002ok6\u0004\"a\u0004*\n\u0005M\u0003\"aA%oi\")\u0001\n\u0001C\u0001+R\u0019!J\u0016-\t\u000b]#\u0006\u0019A \u0002\rY,7\r^8s\u0011\u0015\u0001F\u000b1\u0001R\u0011\u0015Q\u0006\u0001\"\u0001\u001a\u0003)9W\r\u001e,fGR|'o\u001d\u0015\u0003\u0001q\u0003\"!\u00181\u000e\u0003yS!a\u0018\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002b=\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class Word2VecModel
implements Serializable {
    private final Map<String, float[]> model;

    private Map<String, float[]> model() {
        return this.model;
    }

    public double org$apache$spark$mllib$feature$Word2VecModel$$cosineSimilarity(float[] v1, float[] v2) {
        Predef$.MODULE$.require(v1.length == v2.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Vectors should have the same length";
            }
        });
        int n = v1.length;
        float norm1 = BLAS.getInstance().snrm2(n, v1, 1);
        float norm2 = BLAS.getInstance().snrm2(n, v2, 1);
        if (norm1 == 0.0f || norm2 == 0.0f) {
            return 0.0;
        }
        return BLAS.getInstance().sdot(n, v1, 1, v2, 1) / norm1 / norm2;
    }

    public Vector transform(String word) {
        Option option = this.model().get((Object)word);
        if (option instanceof Some) {
            Some some = (Some)option;
            float[] vec = (float[])some.x();
            Vector vector = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.floatArrayOps(vec).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(float x$5) {
                    return this.apply$mcDF$sp(x$5);
                }

                public double apply$mcDF$sp(float x$5) {
                    return x$5;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            return vector;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not in vocabulary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})));
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector, num);
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        Predef$.MODULE$.require(num > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of similar words should > 0";
            }
        });
        float[] fVector = (float[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply(double x$6) {
                return this.apply$mcFD$sp(x$6);
            }

            public float apply$mcFD$sp(double x$6) {
                return (float)x$6;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        return (Tuple2[])((TraversableOnce)((TraversableLike)((IterableLike)this.model().mapValues((Function1)new Serializable(this, fVector){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecModel $outer;
            private final float[] fVector$1;

            public final double apply(float[] vec) {
                return this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$cosineSimilarity(this.fVector$1, vec);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fVector$1 = fVector$1;
            }
        }).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<String, Object> x$7) {
                return -x$7._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).take(num + 1)).tail()).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Map<String, float[]> getVectors() {
        return this.model();
    }

    public Word2VecModel(Map<String, float[]> model) {
        this.model = model;
    }
}

