/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.mllib.optimization.NNLS;
import org.jblas.DoubleMatrix;
import org.jblas.SimpleBlas;
import scala.Predef$;

public final class NNLS$ {
    public static final NNLS$ MODULE$;

    static {
        new NNLS$();
    }

    public NNLS.Workspace createWorkspace(int n) {
        return new NNLS.Workspace(n);
    }

    public double[] solve(DoubleMatrix ata, DoubleMatrix atb, NNLS.Workspace ws) {
        ws.wipe();
        int n = atb.rows;
        DoubleMatrix scratch = ws.scratch();
        DoubleMatrix grad = ws.grad();
        DoubleMatrix x = ws.x();
        DoubleMatrix dir = ws.dir();
        DoubleMatrix lastDir = ws.lastDir();
        DoubleMatrix res = ws.res();
        int iterMax = Math.max(400, 20 * n);
        double lastNorm = 0.0;
        int lastWall = 0;
        int i = 0;
        for (int iterno = 0; iterno < iterMax; ++iterno) {
            SimpleBlas.gemv((double)1.0, (DoubleMatrix)ata, (DoubleMatrix)x, (double)0.0, (DoubleMatrix)res);
            SimpleBlas.axpy((double)-1.0, (DoubleMatrix)atb, (DoubleMatrix)res);
            SimpleBlas.copy((DoubleMatrix)res, (DoubleMatrix)grad);
            for (i = 0; i < n; ++i) {
                if (!(grad.data[i] > 0.0) || x.data[i] != 0.0) continue;
                grad.data[i] = 0.0;
            }
            double ngrad = SimpleBlas.dot((DoubleMatrix)grad, (DoubleMatrix)grad);
            SimpleBlas.copy((DoubleMatrix)grad, (DoubleMatrix)dir);
            double step = this.steplen$1(grad, res, ata, scratch);
            double ndir = 0.0;
            double nx = SimpleBlas.dot((DoubleMatrix)x, (DoubleMatrix)x);
            if (iterno > lastWall + 1) {
                double alpha = ngrad / lastNorm;
                SimpleBlas.axpy((double)alpha, (DoubleMatrix)lastDir, (DoubleMatrix)dir);
                double dstep = this.steplen$1(dir, res, ata, scratch);
                ndir = SimpleBlas.dot((DoubleMatrix)dir, (DoubleMatrix)dir);
                if (this.stop$1(dstep, ndir, nx)) {
                    SimpleBlas.copy((DoubleMatrix)grad, (DoubleMatrix)dir);
                    ndir = SimpleBlas.dot((DoubleMatrix)dir, (DoubleMatrix)dir);
                } else {
                    step = dstep;
                }
            } else {
                ndir = SimpleBlas.dot((DoubleMatrix)dir, (DoubleMatrix)dir);
            }
            if (this.stop$1(step, ndir, nx)) {
                return (double[])x.data.clone();
            }
            for (i = 0; i < n; ++i) {
                if (!(step * dir.data[i] > x.data[i])) continue;
                step = x.data[i] / dir.data[i];
            }
            for (i = 0; i < n; ++i) {
                if (step * dir.data[i] > x.data[i] * 0.99999999999999) {
                    x.data[i] = 0.0;
                    lastWall = iterno;
                    continue;
                }
                double[] dArray = x.data;
                int n2 = i;
                dArray[n2] = dArray[n2] - step * dir.data[i];
            }
            SimpleBlas.copy((DoubleMatrix)dir, (DoubleMatrix)lastDir);
            lastNorm = ngrad;
        }
        return (double[])x.data.clone();
    }

    private final double steplen$1(DoubleMatrix dir, DoubleMatrix res, DoubleMatrix ata$1, DoubleMatrix scratch$1) {
        double top = SimpleBlas.dot((DoubleMatrix)dir, (DoubleMatrix)res);
        SimpleBlas.gemv((double)1.0, (DoubleMatrix)ata$1, (DoubleMatrix)dir, (double)0.0, (DoubleMatrix)scratch$1);
        return top / (SimpleBlas.dot((DoubleMatrix)scratch$1, (DoubleMatrix)dir) + 1.0E-20);
    }

    private final boolean stop$1(double step, double ndir, double nx) {
        return Predef$.MODULE$.double2Double(step).isNaN() || step < 1.0E-7 || step > 1.0E40 || ndir < 1.0E-12 * nx || ndir < 1.0E-32;
    }

    private NNLS$() {
        MODULE$ = this;
    }
}

