/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@Experimental
@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001b\t\u0011\u0012j]8u_:L7MU3he\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\tIwNC\u0001\u001a\u0003\u0011Q\u0017M^1\n\u0005m1\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u000f\u0001\u0005\u0003\u0007I\u0011\u0002\u0010\u0002\u0011%\u001cx\u000e^8oS\u000e,\u0012a\b\t\u0003\u001f\u0001J!!\t\t\u0003\u000f\t{w\u000e\\3b]\"A1\u0005\u0001BA\u0002\u0013%A%\u0001\u0007jg>$xN\\5d?\u0012*\u0017\u000f\u0006\u0002&QA\u0011qBJ\u0005\u0003OA\u0011A!\u00168ji\"9\u0011FIA\u0001\u0002\u0004y\u0012a\u0001=%c!A1\u0006\u0001B\u0001B\u0003&q$A\u0005jg>$xN\\5dA!)Q\u0006\u0001C\u0005]\u00051A(\u001b8jiz\"\"aL\u0019\u0011\u0005A\u0002Q\"\u0001\u0002\t\u000bua\u0003\u0019A\u0010\t\u000b5\u0002A\u0011A\u001a\u0015\u0003=BQ!\u000e\u0001\u0005\u0002Y\n1b]3u\u0013N|Go\u001c8jGR\u0011q\u0007O\u0007\u0002\u0001!)Q\u0004\u000ea\u0001?!)!\b\u0001C\u0001w\u0005\u0019!/\u001e8\u0015\u0005qz\u0004C\u0001\u0019>\u0013\tq$AA\fJg>$xN\\5d%\u0016<'/Z:tS>tWj\u001c3fY\")\u0001)\u000fa\u0001\u0003\u0006)\u0011N\u001c9viB\u0019!)R$\u000e\u0003\rS!\u0001\u0012\u0004\u0002\u0007I$G-\u0003\u0002G\u0007\n\u0019!\u000b\u0012#\u0011\u000b=A%J\u0013&\n\u0005%\u0003\"A\u0002+va2,7\u0007\u0005\u0002\u0010\u0017&\u0011A\n\u0005\u0002\u0007\t>,(\r\\3\t\u000bi\u0002A\u0011\u0001(\u0015\u0005qz\u0005\"\u0002!N\u0001\u0004\u0001\u0006cA)V/6\t!K\u0003\u0002\u001a'*\u0011AKB\u0001\u0004CBL\u0017B\u0001,S\u0005\u001dQ\u0015M^1S\t\u0012\u0003Ra\u0004%Y1b\u0003\"!\u0017/\u000e\u0003iS!a\u0017\r\u0002\t1\fgnZ\u0005\u0003\u0019jCQA\u0018\u0001\u0005\n}\u000bQ\u0003]8pY\u0006#'.Y2f]R4\u0016n\u001c7bi>\u00148\u000f\u0006\u0002aGB\u0019q\"Y$\n\u0005\t\u0004\"!B!se\u0006L\b\"\u0002!^\u0001\u0004\u0001\u0007\"B3\u0001\t\u00131\u0017!\b9be\u0006dG.\u001a7Q_>d\u0017\t\u001a6bG\u0016tGOV5pY\u0006$xN]:\u0015\u0005\u0001<\u0007\"\u0002!e\u0001\u0004\t\u0005F\u0001\u0001j!\tQW.D\u0001l\u0015\tag!\u0001\u0006b]:|G/\u0019;j_:L!A\\6\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197")
public class IsotonicRegression
implements Serializable {
    private boolean isotonic;

    private boolean isotonic() {
        return this.isotonic;
    }

    private void isotonic_$eq(boolean x$1) {
        this.isotonic = x$1;
    }

    public IsotonicRegression setIsotonic(boolean isotonic) {
        this.isotonic_$eq(isotonic);
        return this;
    }

    public IsotonicRegressionModel run(RDD<Tuple3<Object, Object, Object>> input) {
        RDD preprocessedInput = this.isotonic() ? input : input.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)(-BoxesRunTime.unboxToDouble((Object)x._1()))), x._2(), x._3());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        Tuple3<Object, Object, Object>[] pooled = this.parallelPoolAdjacentViolators(preprocessedInput);
        double[] predictions = this.isotonic() ? (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$1) {
                return BoxesRunTime.unboxToDouble((Object)x$1._1());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$2) {
                return -BoxesRunTime.unboxToDouble((Object)x$2._1());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] boundaries = (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$3) {
                return BoxesRunTime.unboxToDouble((Object)x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return new IsotonicRegressionModel(boundaries, predictions, this.isotonic());
    }

    public IsotonicRegressionModel run(JavaRDD<Tuple3<Double, Double, Double>> input) {
        return this.run((RDD<Tuple3<Object, Object, Object>>)input.rdd().retag(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    public Tuple3<Object, Object, Object>[] org$apache$spark$mllib$regression$IsotonicRegression$$poolAdjacentViolators(Tuple3<Object, Object, Object>[] input) {
        if (Predef$.MODULE$.refArrayOps((Object[])input).isEmpty()) {
            return (Tuple3[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        int i = 0;
        while (i < input.length) {
            int j;
            for (j = i; j < input.length - 1 && BoxesRunTime.unboxToDouble((Object)input[j]._1()) > BoxesRunTime.unboxToDouble((Object)input[j + 1]._1()); ++j) {
            }
            if (i == j) {
                ++i;
                continue;
            }
            while (i >= 0 && BoxesRunTime.unboxToDouble((Object)input[i]._1()) > BoxesRunTime.unboxToDouble((Object)input[i + 1]._1())) {
                this.pool$1(input, i, j);
                --i;
            }
            i = j;
        }
        ArrayBuffer compressed = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Tuple3 tuple3 = (Tuple3)Predef$.MODULE$.refArrayOps((Object[])input).head();
        if (tuple3 != null) {
            Tuple3 tuple32;
            double curLabel = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double curFeature = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double curWeight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel), (Object)BoxesRunTime.boxToDouble((double)curFeature), (Object)BoxesRunTime.boxToDouble((double)curWeight));
            DoubleRef curLabel2 = new DoubleRef(BoxesRunTime.unboxToDouble((Object)tuple33._1()));
            DoubleRef curFeature2 = new DoubleRef(BoxesRunTime.unboxToDouble((Object)tuple33._2()));
            DoubleRef curWeight2 = new DoubleRef(BoxesRunTime.unboxToDouble((Object)tuple33._3()));
            DoubleRef rightBound = new DoubleRef(curFeature2.elem);
            for (i = 1; i < input.length; ++i) {
                Tuple3<Object, Object, Object> tuple34 = input[i];
                if (tuple34 != null) {
                    Tuple3 tuple35;
                    double label = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                    double feature = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                    double weight = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                    Tuple3 tuple36 = tuple35 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)feature), (Object)BoxesRunTime.boxToDouble((double)weight));
                    double label2 = BoxesRunTime.unboxToDouble((Object)tuple36._1());
                    double feature2 = BoxesRunTime.unboxToDouble((Object)tuple36._2());
                    double weight2 = BoxesRunTime.unboxToDouble((Object)tuple36._3());
                    if (label2 == curLabel2.elem) {
                        curWeight2.elem += weight2;
                        rightBound.elem = feature2;
                        continue;
                    }
                    this.merge$1(compressed, curLabel2, curFeature2, curWeight2, rightBound);
                    curLabel2.elem = label2;
                    curFeature2.elem = feature2;
                    curWeight2.elem = weight2;
                    rightBound.elem = curFeature2.elem;
                    continue;
                }
                throw new MatchError(tuple34);
            }
            this.merge$1(compressed, curLabel2, curFeature2, curWeight2, rightBound);
            return (Tuple3[])compressed.toArray(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        throw new MatchError((Object)tuple3);
    }

    private Tuple3<Object, Object, Object>[] parallelPoolAdjacentViolators(RDD<Tuple3<Object, Object, Object>> input) {
        Tuple3[] parallelStepResult = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])input.sortBy((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1()));
            }
        }, input.sortBy$default$2(), input.sortBy$default$3(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class)).glom().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsotonicRegression $outer;

            public final ArrayOps<Tuple3<Object, Object, Object>> apply(Tuple3<Object, Object, Object>[] input) {
                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$regression$IsotonicRegression$$poolAdjacentViolators(input));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect()).sortBy((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1()));
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$));
        return this.org$apache$spark$mllib$regression$IsotonicRegression$$poolAdjacentViolators(parallelStepResult);
    }

    private final void pool$1(Tuple3[] input, int start, int end) {
        Tuple3[] poolSubArray = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])input).slice(start, end + 1);
        double weightedSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])poolSubArray).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> lp) {
                return BoxesRunTime.unboxToDouble((Object)lp._1()) * BoxesRunTime.unboxToDouble((Object)lp._3());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double weight = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])poolSubArray).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$4) {
                return BoxesRunTime.unboxToDouble((Object)x$4._3());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        for (int i = start; i <= end; ++i) {
            input[i] = new Tuple3((Object)BoxesRunTime.boxToDouble((double)(weightedSum / weight)), input[i]._2(), input[i]._3());
        }
    }

    private final void merge$1(ArrayBuffer compressed$1, DoubleRef curLabel$1, DoubleRef curFeature$1, DoubleRef curWeight$1, DoubleRef rightBound$1) {
        compressed$1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel$1.elem), (Object)BoxesRunTime.boxToDouble((double)curFeature$1.elem), (Object)BoxesRunTime.boxToDouble((double)curWeight$1.elem)));
        if (rightBound$1.elem > curFeature$1.elem) {
            compressed$1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel$1.elem), (Object)BoxesRunTime.boxToDouble((double)rightBound$1.elem), (Object)BoxesRunTime.boxToDouble((double)0.0)));
        }
    }

    private IsotonicRegression(boolean isotonic) {
        this.isotonic = isotonic;
    }

    public IsotonicRegression() {
        this(true);
    }
}

