/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.attribute;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.AttributeKeys$;
import org.apache.spark.ml.attribute.AttributeType$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.IndexedSeqView$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u00015\u0011a\"\u0011;ue&\u0014W\u000f^3He>,\bO\u0003\u0002\u0004\t\u0005I\u0011\r\u001e;sS\n,H/\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001a\u0003\u0011q\u0017-\\3\u0016\u0003i\u0001\"a\u0007\u0010\u000f\u0005=a\u0012BA\u000f\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0004\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\u0001\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u000b9\fW.\u001a\u0011\t\u0011\u0011\u0002!Q1A\u0005\u0002\u0015\nQB\\;n\u0003R$(/\u001b2vi\u0016\u001cX#\u0001\u0014\u0011\u0007=9\u0013&\u0003\u0002)!\t1q\n\u001d;j_:\u0004\"a\u0004\u0016\n\u0005-\u0002\"aA%oi\"AQ\u0006\u0001B\u0001B\u0003%a%\u0001\bok6\fE\u000f\u001e:jEV$Xm\u001d\u0011\t\u0011=\u0002!\u0011!Q\u0001\nA\nQ!\u0019;ueN\u00042aD\u00142!\ry!\u0007N\u0005\u0003gA\u0011Q!\u0011:sCf\u0004\"!\u000e\u001c\u000e\u0003\tI!a\u000e\u0002\u0003\u0013\u0005#HO]5ckR,\u0007\"B\u001d\u0001\t\u0013Q\u0014A\u0002\u001fj]&$h\b\u0006\u0003<yur\u0004CA\u001b\u0001\u0011\u0015A\u0002\b1\u0001\u001b\u0011\u0015!\u0003\b1\u0001'\u0011\u0015y\u0003\b1\u00011\u0011\u0015I\u0004\u0001\"\u0001A)\tY\u0014\tC\u0003\u0019\u007f\u0001\u0007!\u0004C\u0003:\u0001\u0011\u00051\tF\u0002<\t\u0016CQ\u0001\u0007\"A\u0002iAQ\u0001\n\"A\u0002%BQ!\u000f\u0001\u0005\u0002\u001d#2a\u000f%J\u0011\u0015Ab\t1\u0001\u001b\u0011\u0015yc\t1\u00012\u0011\u001dY\u0005A1A\u0005\u00021\u000b!\"\u0019;ue&\u0014W\u000f^3t+\u0005\u0001\u0004B\u0002(\u0001A\u0003%\u0001'A\u0006biR\u0014\u0018NY;uKN\u0004\u0003\u0002\u0003)\u0001\u0011\u000b\u0007I\u0011B)\u0002\u00179\fW.\u001a+p\u0013:$W\r_\u000b\u0002%B!1d\u0015\u000e*\u0013\t!\u0006EA\u0002NCBD\u0001B\u0016\u0001\t\u0002\u0003\u0006KAU\u0001\r]\u0006lW\rV8J]\u0012,\u0007\u0010\t\u0005\u00061\u0002!\t!W\u0001\u0005g&TX-F\u0001*\u0011\u0015Y\u0006\u0001\"\u0001]\u0003\u001dA\u0017m]!uiJ$\"!\u00181\u0011\u0005=q\u0016BA0\u0011\u0005\u001d\u0011un\u001c7fC:DQ!\u0019.A\u0002i\t\u0001\"\u0019;ue:\u000bW.\u001a\u0005\u0006G\u0002!\t\u0001Z\u0001\bS:$W\r_(g)\tIS\rC\u0003bE\u0002\u0007!\u0004C\u0003h\u0001\u0011\u0005\u0001.A\u0003baBd\u0017\u0010\u0006\u00025S\")\u0011M\u001aa\u00015!)1\u000e\u0001C\u0001Y\u00069q-\u001a;BiR\u0014HC\u0001\u001bn\u0011\u0015\t'\u000e1\u0001\u001b\u0011\u00159\u0007\u0001\"\u0001p)\t!\u0004\u000fC\u0003r]\u0002\u0007\u0011&A\u0005biR\u0014\u0018J\u001c3fq\")1\u000e\u0001C\u0001gR\u0011A\u0007\u001e\u0005\u0006cJ\u0004\r!\u000b\u0005\u0007m\u0002!\tAA<\u0002\u001dQ|W*\u001a;bI\u0006$\u0018-S7qYV\t\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006)A/\u001f9fg*\u0011QPB\u0001\u0004gFd\u0017BA@{\u0005!iU\r^1eCR\f\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000bi>lU\r^1eCR\fGc\u0001=\u0002\b!9\u0011\u0011BA\u0001\u0001\u0004A\u0018\u0001E3ySN$\u0018N\\4NKR\fG-\u0019;b\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u001b!\u0012\u0001\u001f\u0005\b\u0003#\u0001A\u0011AA\n\u00035!xn\u0015;sk\u000e$h)[3mIR!\u0011QCA\u000e!\rI\u0018qC\u0005\u0004\u00033Q(aC*ueV\u001cGOR5fY\u0012Dq!!\u0003\u0002\u0010\u0001\u0007\u0001\u0010C\u0004\u0002\u0012\u0001!\t!a\b\u0015\u0005\u0005U\u0001bBA\u0012\u0001\u0011\u0005\u0013QE\u0001\u0007KF,\u0018\r\\:\u0015\u0007u\u000b9\u0003\u0003\u0005\u0002*\u0005\u0005\u0002\u0019AA\u0016\u0003\u0015yG\u000f[3s!\ry\u0011QF\u0005\u0004\u0003_\u0001\"aA!os\"9\u00111\u0007\u0001\u0005B\u0005U\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003%B3\u0001AA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0013Q\b\u0002\r\t\u00164X\r\\8qKJ\f\u0005/[\u0004\b\u0003\u000f\u0012\u0001\u0012AA%\u00039\tE\u000f\u001e:jEV$Xm\u0012:pkB\u00042!NA&\r\u0019\t!\u0001#\u0001\u0002NM!\u00111\n\b\u0015\u0011\u001dI\u00141\nC\u0001\u0003#\"\"!!\u0013\t\u0013\u0005U\u00131\nC\u0001\u0005\u0005]\u0013\u0001\u00044s_6lU\r^1eCR\fG#B\u001e\u0002Z\u0005u\u0003bBA.\u0003'\u0002\r\u0001_\u0001\t[\u0016$\u0018\rZ1uC\"1\u0001$a\u0015A\u0002iA\u0001\"!\u0019\u0002L\u0011\u0005\u00111M\u0001\u0010MJ|Wn\u0015;sk\u000e$h)[3mIR\u00191(!\u001a\t\u0011\u0005\u001d\u0014q\fa\u0001\u0003+\tQAZ5fY\u0012D!\"a\u001b\u0002L\u0005\u0005I\u0011BA7\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0004\u0003BA9\u0003wj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0005Y\u0006twM\u0003\u0002\u0002z\u0005!!.\u0019<b\u0013\u0011\ti(a\u001d\u0003\r=\u0013'.Z2uQ\u0011\tY%!\u000f)\t\u0005\u0015\u0013\u0011\b")
public class AttributeGroup
implements Serializable {
    private final String name;
    private final Option<Object> numAttributes;
    private final Option<Attribute[]> attributes;
    private Map<String, Object> nameToIndex;
    private volatile boolean bitmap$0;

    public static AttributeGroup fromStructField(StructField structField) {
        return AttributeGroup$.MODULE$.fromStructField(structField);
    }

    private Map nameToIndex$lzycompute() {
        AttributeGroup attributeGroup = this;
        synchronized (attributeGroup) {
            if (!this.bitmap$0) {
                this.nameToIndex = (Map)this.attributes().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Object> apply(Attribute[] x$2) {
                        return ((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])x$2).view().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<Tuple2<String, Object>> apply(Attribute attr) {
                                return Option$.MODULE$.option2Iterable(attr.name().map((Function1)new Serializable(this, attr){
                                    public static final long serialVersionUID = 0L;
                                    private final Attribute attr$1;

                                    public final Tuple2<String, Object> apply(String x$3) {
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)x$3), this.attr$1.index().get());
                                    }
                                    {
                                        this.attr$1 = attr$1;
                                    }
                                }));
                            }
                        }, IndexedSeqView$.MODULE$.arrCanBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Nothing$> apply() {
                        return Predef$.MODULE$.Map().empty();
                    }
                });
                this.bitmap$0 = true;
            }
            return this.nameToIndex;
        }
    }

    public String name() {
        return this.name;
    }

    public Option<Object> numAttributes() {
        return this.numAttributes;
    }

    public Option<Attribute[]> attributes() {
        return this.attributes;
    }

    private Map<String, Object> nameToIndex() {
        return this.bitmap$0 ? this.nameToIndex : this.nameToIndex$lzycompute();
    }

    public int size() {
        return this.numAttributes().isDefined() ? BoxesRunTime.unboxToInt((Object)this.numAttributes().get()) : (this.attributes().isDefined() ? ((Attribute[])this.attributes().get()).length : -1);
    }

    public boolean hasAttr(String attrName) {
        return this.nameToIndex().contains((Object)attrName);
    }

    public int indexOf(String attrName) {
        return BoxesRunTime.unboxToInt((Object)this.nameToIndex().apply((Object)attrName));
    }

    public Attribute apply(String attrName) {
        return ((Attribute[])this.attributes().get())[this.indexOf(attrName)];
    }

    public Attribute getAttr(String attrName) {
        return this.apply(attrName);
    }

    public Attribute apply(int attrIndex) {
        return ((Attribute[])this.attributes().get())[attrIndex];
    }

    public Attribute getAttr(int attrIndex) {
        return this.apply(attrIndex);
    }

    public Metadata toMetadataImpl() {
        Object object;
        MetadataBuilder bldr = new MetadataBuilder();
        if (this.attributes().isDefined()) {
            ArrayBuffer numericMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer nominalMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer binaryMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            Predef$.MODULE$.refArrayOps((Object[])this.attributes().get()).foreach((Function1)new Serializable(this, numericMetadata, nominalMetadata, binaryMetadata){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer numericMetadata$1;
                private final ArrayBuffer nominalMetadata$1;
                private final ArrayBuffer binaryMetadata$1;

                public final Object apply(Attribute x0$2) {
                    Attribute attribute;
                    block6: {
                        ArrayBuffer arrayBuffer;
                        block3: {
                            block5: {
                                block4: {
                                    block2: {
                                        attribute = x0$2;
                                        if (!(attribute instanceof NumericAttribute)) break block2;
                                        NumericAttribute numericAttribute = (NumericAttribute)attribute;
                                        NumericAttribute numericAttribute2 = numericAttribute.withoutIndex();
                                        NumericAttribute numericAttribute3 = NumericAttribute$.MODULE$.defaultAttr();
                                        arrayBuffer = !(numericAttribute2 != null ? !((Object)numericAttribute2).equals(numericAttribute3) : numericAttribute3 != null) ? BoxedUnit.UNIT : this.numericMetadata$1.$plus$eq((Object)numericAttribute.toMetadataImpl(false));
                                        break block3;
                                    }
                                    if (!(attribute instanceof NominalAttribute)) break block4;
                                    NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                                    arrayBuffer = this.nominalMetadata$1.$plus$eq((Object)nominalAttribute.toMetadataImpl(false));
                                    break block3;
                                }
                                if (!(attribute instanceof BinaryAttribute)) break block5;
                                BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
                                arrayBuffer = this.binaryMetadata$1.$plus$eq((Object)binaryAttribute.toMetadataImpl(false));
                                break block3;
                            }
                            UnresolvedAttribute$ unresolvedAttribute$ = UnresolvedAttribute$.MODULE$;
                            Attribute attribute2 = attribute;
                            if (unresolvedAttribute$ != null ? !unresolvedAttribute$.equals(attribute2) : attribute2 != null) break block6;
                            arrayBuffer = BoxedUnit.UNIT;
                        }
                        return arrayBuffer;
                    }
                    throw new MatchError((Object)attribute);
                }
                {
                    this.numericMetadata$1 = numericMetadata$1;
                    this.nominalMetadata$1 = nominalMetadata$1;
                    this.binaryMetadata$1 = binaryMetadata$1;
                }
            });
            MetadataBuilder attrBldr = new MetadataBuilder();
            Object object2 = numericMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Numeric().name(), (Metadata[])numericMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            Object object3 = nominalMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Nominal().name(), (Metadata[])nominalMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            Object object4 = binaryMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Binary().name(), (Metadata[])binaryMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            bldr.putMetadata(AttributeKeys$.MODULE$.ATTRIBUTES(), attrBldr.build());
            object = bldr.putLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES(), (long)((Attribute[])this.attributes().get()).length);
        } else {
            object = this.numAttributes().isDefined() ? bldr.putLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES(), (long)BoxesRunTime.unboxToInt((Object)this.numAttributes().get())) : BoxedUnit.UNIT;
        }
        return bldr.build();
    }

    public Metadata toMetadata(Metadata existingMetadata) {
        return new MetadataBuilder().withMetadata(existingMetadata).putMetadata(AttributeKeys$.MODULE$.ML_ATTR(), this.toMetadataImpl()).build();
    }

    public Metadata toMetadata() {
        return this.toMetadata(Metadata$.MODULE$.empty());
    }

    public StructField toStructField(Metadata existingMetadata) {
        return new StructField(this.name(), (DataType)new VectorUDT(), false, this.toMetadata(existingMetadata));
    }

    public StructField toStructField() {
        return this.toStructField(Metadata$.MODULE$.empty());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof AttributeGroup)) return false;
        AttributeGroup attributeGroup = (AttributeGroup)object;
        String string = this.name();
        String string2 = attributeGroup.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<Object> option = this.numAttributes();
        Option<Object> option2 = attributeGroup.numAttributes();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option option3 = this.attributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Attribute> apply(Attribute[] x$4) {
                return Predef$.MODULE$.refArrayOps((Object[])x$4).toSeq();
            }
        });
        Option option4 = attributeGroup.attributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Attribute> apply(Attribute[] x$5) {
                return Predef$.MODULE$.refArrayOps((Object[])x$5).toSeq();
            }
        });
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int sum = 17;
        sum = 37 * sum + this.name().hashCode();
        sum = 37 * sum + this.numAttributes().hashCode();
        sum = 37 * sum + this.attributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Attribute> apply(Attribute[] x$6) {
                return Predef$.MODULE$.refArrayOps((Object[])x$6).toSeq();
            }
        }).hashCode();
        return (int)var1_1;
    }

    private AttributeGroup(String name, Option<Object> numAttributes, Option<Attribute[]> attrs) {
        this.name = name;
        this.numAttributes = numAttributes;
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(name)).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot have an empty string for name.";
            }
        });
        Predef$.MODULE$.require(!numAttributes.isDefined() || !attrs.isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot have both numAttributes and attrs defined.";
            }
        });
        this.attributes = attrs.map((Function1)new $anonfun$3(this));
    }

    public AttributeGroup(String name) {
        this(name, (Option<Object>)None$.MODULE$, (Option<Attribute[]>)None$.MODULE$);
    }

    public AttributeGroup(String name, int numAttributes) {
        this(name, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numAttributes)), (Option<Attribute[]>)None$.MODULE$);
    }

    public AttributeGroup(String name, Attribute[] attrs) {
        this(name, (Option<Object>)None$.MODULE$, (Option<Attribute[]>)new Some((Object)attrs));
    }
}

