/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.GBTClassifier$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTParams$class;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeClassifierParams$class;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.LogLoss$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u00055\u0011Qb\u0012\"U\u00072\f7o]5gS\u0016\u0014(BA\u0002\u0005\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001AD\u0010&QA)q\u0002\u0005\n\u001b95\tA!\u0003\u0002\u0012\t\tI\u0001K]3eS\u000e$xN\u001d\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\ta\u0001\\5oC2<'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBC\u0001\u0004WK\u000e$xN\u001d\t\u00037\u0001i\u0011A\u0001\t\u00037uI!A\b\u0002\u0003-\u001d\u0013Ek\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\tQ\u0014X-Z\u0005\u0003I\u0005\u0012\u0011b\u0012\"U!\u0006\u0014\u0018-\\:\u0011\u0005\u00012\u0013BA\u0014\"\u0005Q!&/Z3DY\u0006\u001c8/\u001b4jKJ\u0004\u0016M]1ngB\u0011\u0011FK\u0007\u0002\r%\u00111F\u0002\u0002\b\u0019><w-\u001b8h\u0011!i\u0003A!b\u0001\n\u0003r\u0013aA;jIV\tq\u0006\u0005\u00021m9\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)$\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00030\u0003\u0011)\u0018\u000e\u001a\u0011\t\u000bq\u0002A\u0011A\u001f\u0002\rqJg.\u001b;?)\tQb\bC\u0003.w\u0001\u0007q\u0006C\u0003=\u0001\u0011\u0005\u0001\tF\u0001\u001b\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0003-\u0019X\r^'bq\u0012+\u0007\u000f\u001e5\u0015\u0005\u0011+U\"\u0001\u0001\t\u000b\u0019\u000b\u0005\u0019A$\u0002\u000bY\fG.^3\u0011\u0005EB\u0015BA%3\u0005\rIe\u000e\u001e\u0005\u0006\u0017\u0002!\t\u0005T\u0001\u000bg\u0016$X*\u0019=CS:\u001cHC\u0001#N\u0011\u00151%\n1\u0001H\u0011\u0015y\u0005\u0001\"\u0011Q\u0003Y\u0019X\r^'j]&s7\u000f^1oG\u0016\u001c\b+\u001a:O_\u0012,GC\u0001#R\u0011\u00151e\n1\u0001H\u0011\u0015\u0019\u0006\u0001\"\u0011U\u00039\u0019X\r^'j]&sgm\\$bS:$\"\u0001R+\t\u000b\u0019\u0013\u0006\u0019\u0001,\u0011\u0005E:\u0016B\u0001-3\u0005\u0019!u.\u001e2mK\")!\f\u0001C!7\u0006\u00012/\u001a;NCblU-\\8ss&sWJ\u0011\u000b\u0003\trCQAR-A\u0002\u001dCQA\u0018\u0001\u0005B}\u000bqb]3u\u0007\u0006\u001c\u0007.\u001a(pI\u0016LEm\u001d\u000b\u0003\t\u0002DQAR/A\u0002\u0005\u0004\"!\r2\n\u0005\r\u0014$a\u0002\"p_2,\u0017M\u001c\u0005\u0006K\u0002!\tEZ\u0001\u0016g\u0016$8\t[3dWB|\u0017N\u001c;J]R,'O^1m)\t!u\rC\u0003GI\u0002\u0007q\tC\u0003j\u0001\u0011\u0005#.A\u0006tKRLU\u000e];sSRLHC\u0001#l\u0011\u00151\u0005\u000e1\u00010\u0011\u0015i\u0007\u0001\"\u0011o\u0003I\u0019X\r^*vEN\fW\u000e\u001d7j]\u001e\u0014\u0016\r^3\u0015\u0005\u0011{\u0007\"\u0002$m\u0001\u00041\u0006\"B9\u0001\t\u0003\u0012\u0018aB:fiN+W\r\u001a\u000b\u0003\tNDQA\u00129A\u0002Q\u0004\"!M;\n\u0005Y\u0014$\u0001\u0002'p]\u001eDQ\u0001\u001f\u0001\u0005Be\f!b]3u\u001b\u0006D\u0018\n^3s)\t!%\u0010C\u0003Go\u0002\u0007q\tC\u0003}\u0001\u0011\u0005S0A\u0006tKR\u001cF/\u001a9TSj,GC\u0001#\u007f\u0011\u001515\u00101\u0001W\u0011%\t\t\u0001\u0001b\u0001\n\u0003\t\u0019!\u0001\u0005m_N\u001cH+\u001f9f+\t\t)\u0001E\u0003\u0002\b\u00055q&\u0004\u0002\u0002\n)\u0019\u00111\u0002\u0003\u0002\u000bA\f'/Y7\n\t\u0005=\u0011\u0011\u0002\u0002\u0006!\u0006\u0014\u0018-\u001c\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\u0006\u0005IAn\\:t)f\u0004X\r\t\u0005\b\u0003/\u0001A\u0011AA\r\u0003-\u0019X\r\u001e'pgN$\u0016\u0010]3\u0015\u0007\u0011\u000bY\u0002\u0003\u0004G\u0003+\u0001\ra\f\u0005\u0007\u0003?\u0001A\u0011\u0001\u0018\u0002\u0017\u001d,G\u000fT8tgRK\b/\u001a\u0005\t\u0003G\u0001A\u0011\t\u0003\u0002&\u0005qq-\u001a;PY\u0012dun]:UsB,WCAA\u0014!\u0011\tI#!\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tA\u0001\\8tg*\u0011!EF\u0005\u0005\u0003g\tYC\u0001\u0003M_N\u001c\bbBA\u001c\u0001\u0011E\u0013\u0011H\u0001\u0006iJ\f\u0017N\u001c\u000b\u00049\u0005m\u0002\u0002CA\u001f\u0003k\u0001\r!a\u0010\u0002\u000f\u0011\fG/Y:fiB!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002F\u0019\t1a]9m\u0013\u0011\tI%a\u0011\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007f\u0001\u0001\u0002NA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9&!\u0015\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u000f\u0005m#\u0001#\u0001\u0002^\u0005iqI\u0011+DY\u0006\u001c8/\u001b4jKJ\u00042aGA0\r\u0019\t!\u0001#\u0001\u0002bM1\u0011qLA2\u0003S\u00022!MA3\u0013\r\t9G\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0007E\nY'C\u0002\u0002nI\u0012AbU3sS\u0006d\u0017N_1cY\u0016Dq\u0001PA0\t\u0003\t\t\b\u0006\u0002\u0002^!Q\u0011QOA0\u0005\u0004%)!a\u001e\u0002%M,\b\u000f]8si\u0016$Gj\\:t)f\u0004Xm]\u000b\u0003\u0003s\u0002B!MA>_%\u0019\u0011Q\u0010\u001a\u0003\u000b\u0005\u0013(/Y=\t\u0013\u0005\u0005\u0015q\fQ\u0001\u000e\u0005e\u0014aE:vaB|'\u000f^3e\u0019>\u001c8\u000fV=qKN\u0004\u0003BCAC\u0003?\n\t\u0011\"\u0003\u0002\b\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\t\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\t1\fgn\u001a\u0006\u0003\u0003'\u000bAA[1wC&!\u0011qSAG\u0005\u0019y%M[3di\"\"\u0011qLA'Q\u0011\tI&!\u0014")
public final class GBTClassifier
extends Predictor<Vector, GBTClassifier, GBTClassificationModel>
implements GBTParams,
TreeClassifierParams,
Logging {
    private final String uid;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final LongParam seed;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final IntParam checkpointInterval;

    public static String[] supportedLossTypes() {
        return GBTClassifier$.MODULE$.supportedLossTypes();
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams$class.getOldImpurity(this);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    public Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final double getStepSize() {
        return GBTParams$class.getStepSize(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    public Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return DecisionTreeParams$class.getCheckpointInterval(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GBTClassifier setMaxDepth(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public GBTClassifier setMaxBins(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public GBTClassifier setMinInstancesPerNode(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public GBTClassifier setMinInfoGain(double value) {
        return (GBTClassifier)DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public GBTClassifier setMaxMemoryInMB(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public GBTClassifier setCacheNodeIds(boolean value) {
        return (GBTClassifier)DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public GBTClassifier setCheckpointInterval(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public GBTClassifier setImpurity(String value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "GBTClassifier.setImpurity should NOT be used";
            }
        });
        return this;
    }

    @Override
    public GBTClassifier setSubsamplingRate(double value) {
        return (GBTClassifier)TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public GBTClassifier setSeed(long value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The 'seed' parameter is currently ignored by Gradient Boosting.";
            }
        });
        return (GBTClassifier)TreeEnsembleParams$class.setSeed(this, value);
    }

    @Override
    public GBTClassifier setMaxIter(int value) {
        return (GBTClassifier)GBTParams$class.setMaxIter(this, value);
    }

    @Override
    public GBTClassifier setStepSize(double value) {
        return (GBTClassifier)GBTParams$class.setStepSize(this, value);
    }

    public Param<String> lossType() {
        return this.lossType;
    }

    public GBTClassifier setLossType(String value) {
        return (GBTClassifier)this.set(this.lossType(), value);
    }

    public String getLossType() {
        return this.$(this.lossType()).toLowerCase();
    }

    @Override
    public Loss getOldLossType() {
        String string;
        String string2 = string = this.getLossType();
        if (!("logistic" != null ? !"logistic".equals(string2) : string2 != null)) {
            LogLoss$ logLoss$ = LogLoss$.MODULE$;
            return logLoss$;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTClassifier was given bad loss type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getLossType()})));
    }

    @Override
    public GBTClassificationModel train(DataFrame dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
        if (option instanceof Some) {
            Some some = (Some)option;
            int n = BoxesRunTime.unboxToInt((Object)some.x());
            int n2 = n;
            int n3 = n2;
            int numClasses = n3;
            Predef$.MODULE$.require(numClasses == 2, (Function0)new Serializable(this, numClasses){
                public static final long serialVersionUID = 0L;
                private final int numClasses$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTClassifier only supports binary classification but was given numClasses = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1)}));
                }
                {
                    this.numClasses$1 = numClasses$1;
                }
            });
            RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
            BoostingStrategy boostingStrategy = GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, Algo$.MODULE$.Classification());
            GradientBoostedTrees oldGBT = new GradientBoostedTrees(boostingStrategy);
            GradientBoostedTreesModel oldModel = oldGBT.run(oldDataset);
            return GBTClassificationModel$.MODULE$.fromOld(oldModel, this, categoricalFeatures);
        }
        None$ none$ = None$.MODULE$;
        Option<Object> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"GBTClassifier was given input").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" with invalid label column ", ", without the number of classes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.labelCol())}))).append((Object)" specified. See StringIndexer.").toString());
        }
        throw new MatchError(option);
    }

    public GBTClassifier(String uid) {
        this.uid = uid;
        DecisionTreeParams$class.$init$(this);
        HasSeed$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        HasMaxIter$class.$init$(this);
        GBTParams$class.$init$(this);
        TreeClassifierParams$class.$init$(this);
        this.lossType = new Param(this, "lossType", new StringBuilder().append((Object)"Loss function which GBT tries to minimize (case-insensitive). Supported options:").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])GBTClassifier$.MODULE$.supportedLossTypes()).mkString(", ")}))).toString(), new $anonfun$1(this));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.lossType().$minus$greater("logistic")}));
    }

    public GBTClassifier() {
        this(Identifiable$.MODULE$.randomUID("gbtc"));
    }
}

