/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.classification.LogisticCostFun;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001b\t\u0011Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019q\u0012\u0005E\u0003\u0010!IQ2$D\u0001\u0003\u0013\t\t\"AA\fQe>\u0014\u0017MY5mSN$\u0018nY\"mCN\u001c\u0018NZ5feB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0007Y&t\u0017\r\\4\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005\u00191Vm\u0019;peB\u0011q\u0002\u0001\t\u0003\u001fqI!!\b\u0002\u0003/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\b \u0013\t\u0001#A\u0001\rM_\u001eL7\u000f^5d%\u0016<'/Z:tS>t\u0007+\u0019:b[N\u0004\"AI\u0012\u000e\u0003\u0019I!\u0001\n\u0004\u0003\u000f1{wmZ5oO\"Aa\u0005\u0001BC\u0002\u0013\u0005s%A\u0002vS\u0012,\u0012\u0001\u000b\t\u0003S=r!AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\na\u0001\u0015:fI\u00164\u0017B\u0001\u00192\u0005\u0019\u0019FO]5oO*\u0011af\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005Q\u0005!Q/\u001b3!\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q\u0011!d\u000e\u0005\u0006MQ\u0002\r\u0001\u000b\u0005\u0006k\u0001!\t!\u000f\u000b\u00025!)1\b\u0001C\u0001y\u0005Y1/\u001a;SK\u001e\u0004\u0016M]1n)\tid(D\u0001\u0001\u0011\u0015y$\b1\u0001A\u0003\u00151\u0018\r\\;f!\tQ\u0013)\u0003\u0002CW\t1Ai\\;cY\u0016DQ\u0001\u0012\u0001\u0005\u0002\u0015\u000b!c]3u\u000b2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[R\u0011QH\u0012\u0005\u0006\u007f\r\u0003\r\u0001\u0011\u0005\u0006\u0011\u0002!\t!S\u0001\u000bg\u0016$X*\u0019=Ji\u0016\u0014HCA\u001fK\u0011\u0015yt\t1\u0001L!\tQC*\u0003\u0002NW\t\u0019\u0011J\u001c;\t\u000b=\u0003A\u0011\u0001)\u0002\rM,G\u000fV8m)\ti\u0014\u000bC\u0003@\u001d\u0002\u0007\u0001\tC\u0003T\u0001\u0011\u0005A+A\btKR4\u0015\u000e^%oi\u0016\u00148-\u001a9u)\tiT\u000bC\u0003@%\u0002\u0007a\u000b\u0005\u0002+/&\u0011\u0001l\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0006\u0001\"\u0001\\\u00031\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7e)\tiD\fC\u0003@3\u0002\u0007\u0001\tC\u0003_\u0001\u0011Es,A\u0003ue\u0006Lg\u000e\u0006\u0002\u001cA\")\u0011-\u0018a\u0001E\u00069A-\u0019;bg\u0016$\bCA2g\u001b\u0005!'BA3\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003O\u0012\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3)\u0005\u0001I\u0007C\u00016n\u001b\u0005Y'B\u00017\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003].\u0014A\"\u0012=qKJLW.\u001a8uC2\u0004")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
Logging {
    private final String uid;
    private final DoubleParam threshold;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final double getThreshold() {
        return HasThreshold$class.getThreshold(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LogisticRegressionModel train(DataFrame dataset) {
        RDD instances = this.extractLabeledPoints(dataset).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint x0$1) {
                LabeledPoint labeledPoint = x0$1;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    Vector features = labeledPoint.features();
                    double d = label;
                    if (features != null) {
                        Vector vector = features;
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                        return tuple2;
                    }
                }
                throw new MatchError((Object)labeledPoint);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Tuple2 x$4 = new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer());
        Serializable x$5 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c, Tuple2<Object, Vector> v) {
                Tuple2 tuple2 = new Tuple2(c, v);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple22._1();
                        MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple22._2();
                        if (summarizer != null) {
                            MultivariateOnlineSummarizer multivariateOnlineSummarizer = summarizer;
                            if (labelSummarizer != null) {
                                MultiClassSummarizer multiClassSummarizer = labelSummarizer;
                                if (tuple23 != null) {
                                    double label = tuple23._1$mcD$sp();
                                    Vector features = (Vector)tuple23._2();
                                    double d = label;
                                    if (features != null) {
                                        Vector vector = features;
                                        Tuple2 tuple24 = new Tuple2((Object)multivariateOnlineSummarizer.add(vector), (Object)multiClassSummarizer.add(d));
                                        return tuple24;
                                    }
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        };
        Serializable x$6 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c2) {
                Tuple2 tuple2 = new Tuple2(c1, c2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        MultivariateOnlineSummarizer summarizer1 = (MultivariateOnlineSummarizer)tuple22._1();
                        MultiClassSummarizer classSummarizer1 = (MultiClassSummarizer)tuple22._2();
                        if (summarizer1 != null) {
                            MultivariateOnlineSummarizer multivariateOnlineSummarizer = summarizer1;
                            if (classSummarizer1 != null) {
                                MultiClassSummarizer multiClassSummarizer = classSummarizer1;
                                if (tuple23 != null) {
                                    MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
                                    MultiClassSummarizer classSummarizer2 = (MultiClassSummarizer)tuple23._2();
                                    if (summarizer2 != null) {
                                        MultivariateOnlineSummarizer multivariateOnlineSummarizer2 = summarizer2;
                                        if (classSummarizer2 != null) {
                                            MultiClassSummarizer multiClassSummarizer2 = classSummarizer2;
                                            Tuple2 tuple24 = new Tuple2((Object)multivariateOnlineSummarizer.merge(multivariateOnlineSummarizer2), (Object)multiClassSummarizer.merge(multiClassSummarizer2));
                                            return tuple24;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        };
        int x$7 = instances.treeAggregate$default$4((Object)x$4);
        Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)x$4, (Function2)x$5, (Function2)x$6, x$7, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            Tuple2 tuple23;
            MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple24._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple24._2();
            long[] histogram2 = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numClasses = histogram2.length;
            int numFeatures = summarizer2.mean().size();
            if (numInvalid != 0L) {
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in {0 to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numClasses - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numInvalid)}))).toString();
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$1;

                    public final String apply() {
                        return this.msg$1;
                    }
                    {
                        this.msg$1 = msg$1;
                    }
                });
                throw new SparkException(msg);
            }
            if (numClasses > 2) {
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently, LogisticRegression with ElasticNet in ML package only supports "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"binary classification. Found ", " in the input dataset."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numClasses)}))).toString();
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$2;

                    public final String apply() {
                        return this.msg$2;
                    }
                    {
                        this.msg$2 = msg$2;
                    }
                });
                throw new SparkException(msg);
            }
            double[] featuresMean = summarizer2.mean().toArray();
            double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(summarizer2.variance().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.sqrt(x);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
            double regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
            LogisticCostFun costFun = new LogisticCostFun((RDD<Tuple2<Object, Vector>>)instances, numClasses, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), featuresStd, featuresMean, regParamL2);
            LBFGS optimizer = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 ? new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double())) : new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, regParamL1), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.zeros(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures);
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                initialWeightsWithIntercept.toArray()[numFeatures] = package$.MODULE$.log((double)histogram2[1] / (double)histogram2[0]);
            }
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialWeightsWithIntercept.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            FirstOrderMinimizer.State state = (FirstOrderMinimizer.State)states.next();
            ArrayBuilder lossHistory = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            while (states.hasNext()) {
                lossHistory.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.value()));
                state = (FirstOrderMinimizer.State)states.next();
            }
            lossHistory.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.value()));
            double[] rawWeights = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
            for (int i = 0; i < numFeatures; ++i) {
                int n = i;
                rawWeights[n] = rawWeights[n] * (featuresStd[i] != 0.0 ? 1.0 / featuresStd[i] : 0.0);
            }
            Vector weightsWithIntercept = Vectors$.MODULE$.dense(rawWeights);
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            Tuple2 tuple25 = tuple22 = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? new Tuple2((Object)Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsWithIntercept.toArray()).slice(0, weightsWithIntercept.size() - 1)), (Object)BoxesRunTime.boxToDouble((double)weightsWithIntercept.apply(weightsWithIntercept.size() - 1))) : new Tuple2((Object)weightsWithIntercept, (Object)BoxesRunTime.boxToDouble((double)0.0));
            if (tuple22 != null) {
                Tuple2 tuple26;
                Vector weights = (Vector)tuple22._1();
                double intercept = tuple22._2$mcD$sp();
                Tuple2 tuple27 = tuple26 = new Tuple2((Object)weights, (Object)BoxesRunTime.boxToDouble((double)intercept));
                Vector weights2 = (Vector)tuple27._1();
                double intercept2 = tuple27._2$mcD$sp();
                return new LogisticRegressionModel(this.uid(), weights2.compressed(), intercept2);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    private final Function1 regParamL1Fun$1(int numFeatures$1, double regParamL1$1) {
        return new Serializable(this, numFeatures$1, regParamL1$1){
            public static final long serialVersionUID = 0L;
            private final int numFeatures$1;
            private final double regParamL1$1;

            public final double apply(int index) {
                return this.apply$mcDI$sp(index);
            }

            public double apply$mcDI$sp(int index) {
                return index == this.numFeatures$1 ? 0.0 : this.regParamL1$1;
            }
            {
                this.numFeatures$1 = numFeatures$1;
                this.regParamL1$1 = regParamL1$1;
            }
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasThreshold$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.threshold().$minus$greater(BoxesRunTime.boxToDouble((double)0.5))}));
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

