/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u001b\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dm\u0001Ba\u0004\t\u001355\t!!\u0003\u0002\u0012\u0005\ty!+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u00051A.\u001b8bY\u001eT!a\u0006\u0004\u0002\u000b5dG.\u001b2\n\u0005e!\"A\u0002,fGR|'\u000f\u0005\u0002\u0010\u0001A\u0011q\u0002H\u0005\u0003;\t\u0011a\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8QCJ\fWn\u001d\u0005\t?\u0001\u0011)\u0019!C!A\u0005\u0019Q/\u001b3\u0016\u0003\u0005\u0002\"A\t\u0015\u000f\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0002\rA\u0013X\rZ3g\u0013\tI#F\u0001\u0004TiJLgn\u001a\u0006\u0003O\u0011B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0005k&$\u0007\u0005\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u0003\u001d9X-[4iiN,\u0012A\u0005\u0005\tc\u0001\u0011\t\u0011)A\u0005%\u0005Aq/Z5hQR\u001c\b\u0005\u0003\u00054\u0001\t\u0015\r\u0011\"\u00015\u0003%Ig\u000e^3sG\u0016\u0004H/F\u00016!\t\u0019c'\u0003\u00028I\t1Ai\\;cY\u0016D\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I!N\u0001\u000bS:$XM]2faR\u0004\u0003BB\u001e\u0001\t\u0003!A(\u0001\u0004=S:LGO\u0010\u000b\u00055urt\bC\u0003 u\u0001\u0007\u0011\u0005C\u0003/u\u0001\u0007!\u0003C\u00034u\u0001\u0007Q\u0007C\u0003B\u0001\u0011E#)A\u0004qe\u0016$\u0017n\u0019;\u0015\u0005U\u001a\u0005\"\u0002#A\u0001\u0004\u0011\u0012\u0001\u00034fCR,(/Z:\t\u000b\u0019\u0003A\u0011I$\u0002\t\r|\u0007/\u001f\u000b\u00035!CQ!S#A\u0002)\u000bQ!\u001a=ue\u0006\u0004\"a\u0013(\u000e\u00031S!!\u0014\u0003\u0002\u000bA\f'/Y7\n\u0005=c%\u0001\u0003)be\u0006lW*\u00199)\u0005\u0001\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003-N\u0013A\"\u0012=qKJLW.\u001a8uC2\u0004")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams {
    private final String uid;
    private final Vector weights;
    private final double intercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.weights()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        return this.copyValues(new LinearRegressionModel(this.uid(), this.weights(), this.intercept()), extra);
    }

    public LinearRegressionModel(String uid, Vector weights, double intercept) {
        this.uid = uid;
        this.weights = weights;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
    }
}

