/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public abstract class DecisionTreeParams$class {
    public static DecisionTreeParams setMaxDepth(DecisionTreeParams $this, int value) {
        return (DecisionTreeParams)$this.set($this.maxDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public static final int getMaxDepth(DecisionTreeParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.maxDepth()));
    }

    public static DecisionTreeParams setMaxBins(DecisionTreeParams $this, int value) {
        return (DecisionTreeParams)$this.set($this.maxBins(), BoxesRunTime.boxToInteger((int)value));
    }

    public static final int getMaxBins(DecisionTreeParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.maxBins()));
    }

    public static DecisionTreeParams setMinInstancesPerNode(DecisionTreeParams $this, int value) {
        return (DecisionTreeParams)$this.set($this.minInstancesPerNode(), BoxesRunTime.boxToInteger((int)value));
    }

    public static final int getMinInstancesPerNode(DecisionTreeParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.minInstancesPerNode()));
    }

    public static DecisionTreeParams setMinInfoGain(DecisionTreeParams $this, double value) {
        return (DecisionTreeParams)$this.set($this.minInfoGain(), BoxesRunTime.boxToDouble((double)value));
    }

    public static final double getMinInfoGain(DecisionTreeParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$($this.minInfoGain()));
    }

    public static DecisionTreeParams setMaxMemoryInMB(DecisionTreeParams $this, int value) {
        return (DecisionTreeParams)$this.set($this.maxMemoryInMB(), BoxesRunTime.boxToInteger((int)value));
    }

    public static final int getMaxMemoryInMB(DecisionTreeParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.maxMemoryInMB()));
    }

    public static DecisionTreeParams setCacheNodeIds(DecisionTreeParams $this, boolean value) {
        return (DecisionTreeParams)$this.set($this.cacheNodeIds(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public static final boolean getCacheNodeIds(DecisionTreeParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$($this.cacheNodeIds()));
    }

    public static DecisionTreeParams setCheckpointInterval(DecisionTreeParams $this, int value) {
        return (DecisionTreeParams)$this.set($this.checkpointInterval(), BoxesRunTime.boxToInteger((int)value));
    }

    public static final int getCheckpointInterval(DecisionTreeParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.checkpointInterval()));
    }

    public static Strategy getOldStrategy(DecisionTreeParams $this, Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        Strategy strategy = Strategy$.MODULE$.defaultStategy(oldAlgo);
        strategy.impurity_$eq(oldImpurity);
        strategy.checkpointInterval_$eq($this.getCheckpointInterval());
        strategy.maxBins_$eq($this.getMaxBins());
        strategy.maxDepth_$eq($this.getMaxDepth());
        strategy.maxMemoryInMB_$eq($this.getMaxMemoryInMB());
        strategy.minInfoGain_$eq($this.getMinInfoGain());
        strategy.minInstancesPerNode_$eq($this.getMinInstancesPerNode());
        strategy.useNodeIdCache_$eq($this.getCacheNodeIds());
        strategy.numClasses_$eq(numClasses);
        strategy.categoricalFeaturesInfo_$eq((Map<Object, Object>)categoricalFeatures);
        strategy.subsamplingRate_$eq(subsamplingRate);
        return strategy;
    }

    public static void $init$(DecisionTreeParams $this) {
        $this.org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(new IntParam((Identifiable)$this, "maxDepth", "Maximum depth of the tree. (>= 0) E.g., depth 0 means 1 leaf node; depth 1 means 1 internal node + 2 leaf nodes.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0)));
        $this.org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(new IntParam((Identifiable)$this, "maxBins", "Max number of bins for discretizing continuous features.  Must be >=2 and >= number of categories for any categorical feature.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(2.0)));
        $this.org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(new IntParam((Identifiable)$this, "minInstancesPerNode", "Minimum number of instances each child must have after split.  If a split causes the left or right child to have fewer than minInstancesPerNode, the split will be discarded as invalid. Should be >= 1.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(1.0)));
        $this.org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(new DoubleParam($this, "minInfoGain", "Minimum information gain for a split to be considered at a tree node."));
        $this.org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(new IntParam((Identifiable)$this, "maxMemoryInMB", "Maximum memory in MB allocated to histogram aggregation.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0)));
        $this.org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(new BooleanParam($this, "cacheNodeIds", "If false, the algorithm will pass trees to executors to match instances with nodes. If true, the algorithm will cache node IDs for each instance. Caching can speed up training of deeper trees."));
        $this.org$apache$spark$ml$tree$DecisionTreeParams$_setter_$checkpointInterval_$eq(new IntParam((Identifiable)$this, "checkpointInterval", "Specifies how often to checkpoint the cached node IDs.  E.g. 10 means that the cache will get checkpointed every 10 iterations. This is only used if cacheNodeIds is true and if the checkpoint directory is set in the SparkContext. Must be >= 1.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(1.0)));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.maxDepth().$minus$greater(BoxesRunTime.boxToInteger((int)5)), $this.maxBins().$minus$greater(BoxesRunTime.boxToInteger((int)32)), $this.minInstancesPerNode().$minus$greater(BoxesRunTime.boxToInteger((int)1)), $this.minInfoGain().$minus$greater(BoxesRunTime.boxToDouble((double)0.0)), $this.maxMemoryInMB().$minus$greater(BoxesRunTime.boxToInteger((int)256)), $this.cacheNodeIds().$minus$greater(BoxesRunTime.boxToBoolean((boolean)false)), $this.checkpointInterval().$minus$greater(BoxesRunTime.boxToInteger((int)10))}));
    }
}

