/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.OutputStream;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.ClassificationModel$class;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.PMMLExportable;
import org.apache.spark.mllib.pmml.PMMLExportable$class;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.util.Saveable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0019\u0001a\u0002\u0006\r\u001fIA\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u000be\u0016<'/Z:tS>t\u0017BA\n\u0011\u0005Y9UM\\3sC2L'0\u001a3MS:,\u0017M]'pI\u0016d\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005M\u0019E.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f!\ty\"%D\u0001!\u0015\t\tC!\u0001\u0003vi&d\u0017BA\u0012!\u0005!\u0019\u0016M^3bE2,\u0007CA\u0013)\u001b\u00051#BA\u0014\u0005\u0003\u0011\u0001X.\u001c7\n\u0005%2#A\u0004)N\u001b2+\u0005\u0010]8si\u0006\u0014G.\u001a\u0005\tW\u0001\u0011)\u0019!C!Y\u00059q/Z5hQR\u001cX#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0011A\u00027j]\u0006dw-\u0003\u00023_\t1a+Z2u_JD\u0011\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!L\u001b\u0002\u0011],\u0017n\u001a5ug\u0002J!a\u000b\n\t\u0011]\u0002!Q1A\u0005Ba\n\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0016\u0003e\u0002\"!\u0007\u001e\n\u0005mR\"A\u0002#pk\ndW\rC\u0005>\u0001\t\u0005\t\u0015!\u0003:}\u0005Q\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\u0011\n\u0005]\u0012\u0002\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011A!\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002\u0005B\u0011\u0011dQ\u0005\u0003\tj\u00111!\u00138u\u0011!1\u0005A!A!\u0002\u0013\u0011\u0015\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A!\u0002\u00159,Xn\u00117bgN,7\u000f\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003C\u0003-qW/\\\"mCN\u001cXm\u001d\u0011\t\u000b1\u0003A\u0011A'\u0002\rqJg.\u001b;?)\u0015qu\nU)S!\t)\u0002\u0001C\u0003,\u0017\u0002\u0007Q\u0006C\u00038\u0017\u0002\u0007\u0011\bC\u0003A\u0017\u0002\u0007!\tC\u0003I\u0017\u0002\u0007!\tC\u0004U\u0001\t\u0007I\u0011B!\u0002!\u0011\fG/Y,ji\"\u0014\u0015.Y:TSj,\u0007B\u0002,\u0001A\u0003%!)A\teCR\fw+\u001b;i\u0005&\f7oU5{K\u0002Bq\u0001\u0017\u0001C\u0002\u0013%\u0011,\u0001\u0007xK&<\u0007\u000e^:BeJ\f\u00170F\u0001[!\rI2,O\u0005\u00039j\u0011Q!\u0011:sCfDaA\u0018\u0001!\u0002\u0013Q\u0016!D<fS\u001eDGo]!se\u0006L\b\u0005C\u0003M\u0001\u0011\u0005\u0001\rF\u0002OC\nDQaK0A\u00025BQaN0A\u0002eBq\u0001\u001a\u0001A\u0002\u0013%Q-A\u0005uQJ,7\u000f[8mIV\ta\rE\u0002\u001aOfJ!\u0001\u001b\u000e\u0003\r=\u0003H/[8o\u0011\u001dQ\u0007\u00011A\u0005\n-\fQ\u0002\u001e5sKNDw\u000e\u001c3`I\u0015\fHC\u00017p!\tIR.\u0003\u0002o5\t!QK\\5u\u0011\u001d\u0001\u0018.!AA\u0002\u0019\f1\u0001\u001f\u00132\u0011\u0019\u0011\b\u0001)Q\u0005M\u0006QA\u000f\u001b:fg\"|G\u000e\u001a\u0011\t\u000bQ\u0004A\u0011A;\u0002\u0019M,G\u000f\u00165sKNDw\u000e\u001c3\u0015\u0005Y<X\"\u0001\u0001\t\u000b\u0011\u001c\b\u0019A\u001d)\u0005ML\bC\u0001>~\u001b\u0005Y(B\u0001?\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003}n\u0014A\"\u0012=qKJLW.\u001a8uC2Da!!\u0001\u0001\t\u0003)\u0017\u0001D4fiRC'/Z:i_2$\u0007FA@z\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tab\u00197fCJ$\u0006N]3tQ>dG\rF\u0001wQ\r\t)!\u001f\u0005\b\u0003\u001f\u0001A\u0011KA\t\u00031\u0001(/\u001a3jGR\u0004v.\u001b8u)\u001dI\u00141CA\f\u00037Aq!!\u0006\u0002\u000e\u0001\u0007Q&\u0001\u0006eCR\fW*\u0019;sSbDq!!\u0007\u0002\u000e\u0001\u0007Q&\u0001\u0007xK&<\u0007\u000e^'biJL\u0007\u0010\u0003\u00048\u0003\u001b\u0001\r!\u000f\u0005\b\u0003?\u0001A\u0011IA\u0011\u0003\u0011\u0019\u0018M^3\u0015\u000b1\f\u0019#a\f\t\u0011\u0005\u0015\u0012Q\u0004a\u0001\u0003O\t!a]2\u0011\t\u0005%\u00121F\u0007\u0002\r%\u0019\u0011Q\u0006\u0004\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u0005E\u0012Q\u0004a\u0001\u0003g\tA\u0001]1uQB!\u0011QGA\u001e\u001d\rI\u0012qG\u0005\u0004\u0003sQ\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002>\u0005}\"AB*ue&twMC\u0002\u0002:iAq!a\u0011\u0001\t#\n)%A\u0007g_Jl\u0017\r\u001e,feNLwN\\\u000b\u0003\u0003gAq!!\u0013\u0001\t\u0003\nY%\u0001\u0005u_N#(/\u001b8h)\t\t\u0019dB\u0004\u0002P\tA\t!!\u0015\u0002/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007cA\u000b\u0002T\u00191\u0011A\u0001E\u0001\u0003+\u001ar!a\u0015\u0002X\u0005u\u0003\u0004E\u0002\u001a\u00033J1!a\u0017\u001b\u0005\u0019\te.\u001f*fMB!q$a\u0018O\u0013\r\t\t\u0007\t\u0002\u0007\u0019>\fG-\u001a:\t\u000f1\u000b\u0019\u0006\"\u0001\u0002fQ\u0011\u0011\u0011\u000b\u0005\t\u0003S\n\u0019\u0006\"\u0011\u0002l\u0005!An\\1e)\u0015q\u0015QNA8\u0011!\t)#a\u001aA\u0002\u0005\u001d\u0002\u0002CA\u0019\u0003O\u0002\r!a\r\t\u0015\u0005M\u00141KA\u0001\n\u0013\t)(A\u0006sK\u0006$'+Z:pYZ,GCAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nA\u0001\\1oO*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006m$AB(cU\u0016\u001cG\u000f")
public class LogisticRegressionModel
extends GeneralizedLinearModel
implements ClassificationModel,
Saveable,
PMMLExportable {
    private final int numFeatures;
    private final int numClasses;
    private final int org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize;
    private final double[] org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray;
    private Option<Object> threshold;

    public static LogisticRegressionModel load(SparkContext sparkContext, String string) {
        return LogisticRegressionModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    @Experimental
    public void toPMML(String localPath) {
        PMMLExportable$class.toPMML((PMMLExportable)this, localPath);
    }

    @Override
    @Experimental
    public void toPMML(SparkContext sc, String path) {
        PMMLExportable$class.toPMML(this, sc, path);
    }

    @Override
    @Experimental
    public void toPMML(OutputStream outputStream) {
        PMMLExportable$class.toPMML((PMMLExportable)this, outputStream);
    }

    @Override
    @Experimental
    public String toPMML() {
        return PMMLExportable$class.toPMML(this);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel$class.predict(this, testData);
    }

    @Override
    public Vector weights() {
        return super.weights();
    }

    @Override
    public double intercept() {
        return super.intercept();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public int numClasses() {
        return this.numClasses;
    }

    public int org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize() {
        return this.org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize;
    }

    public double[] org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray() {
        return this.org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray;
    }

    private Option<Object> threshold() {
        return this.threshold;
    }

    private void threshold_$eq(Option<Object> x$1) {
        this.threshold = x$1;
    }

    @Experimental
    public LogisticRegressionModel setThreshold(double threshold) {
        this.threshold_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)threshold)));
        return this;
    }

    @Experimental
    public Option<Object> getThreshold() {
        return this.threshold();
    }

    @Experimental
    public LogisticRegressionModel clearThreshold() {
        this.threshold_$eq((Option<Object>)None$.MODULE$);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double predictPoint(Vector dataMatrix, Vector weightMatrix, double intercept) {
        double d;
        Predef$.MODULE$.require(dataMatrix.size() == this.numFeatures());
        if (this.numClasses() == 2) {
            double margin = BLAS$.MODULE$.dot(weightMatrix, dataMatrix) + intercept;
            double score = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
            Option<Object> option = this.threshold();
            if (option instanceof Some) {
                Some some = (Some)option;
                double t = BoxesRunTime.unboxToDouble((Object)some.x());
                if (!(score > t)) return 0.0;
                return 1.0;
            }
            None$ none$ = None$.MODULE$;
            Option<Object> option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError(option);
                }
            } else if (!none$.equals(option2)) throw new MatchError(option);
            double d2 = score;
            d = d2;
            return d;
        }
        IntRef bestClass = new IntRef(0);
        DoubleRef maxMargin = new DoubleRef(0.0);
        boolean withBias = dataMatrix.size() + 1 == this.org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numClasses() - 1).foreach$mVc$sp((Function1)new Serializable(this, dataMatrix, bestClass, maxMargin, withBias){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;
            private final Vector dataMatrix$1;
            private final IntRef bestClass$1;
            private final DoubleRef maxMargin$1;
            private final boolean withBias$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                DoubleRef margin = new DoubleRef(0.0);
                this.dataMatrix$1.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, margin, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$predictPoint$1 $outer;
                    private final DoubleRef margin$1;
                    private final int i$1;

                    public final void apply(int index, double value) {
                        this.apply$mcVID$sp(index, value);
                    }

                    public void apply$mcVID$sp(int index, double value) {
                        if (value != 0.0) {
                            this.margin$1.elem += value * this.$outer.org$apache$spark$mllib$classification$LogisticRegressionModel$$anonfun$$$outer().org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray()[this.i$1 * this.$outer.org$apache$spark$mllib$classification$LogisticRegressionModel$$anonfun$$$outer().org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize() + index];
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.margin$1 = margin$1;
                        this.i$1 = i$1;
                    }
                });
                if (this.withBias$1) {
                    margin.elem += this.$outer.org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray()[i * this.$outer.org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize() + this.dataMatrix$1.size()];
                }
                if (margin.elem > this.maxMargin$1.elem) {
                    this.maxMargin$1.elem = margin.elem;
                    this.bestClass$1.elem = i + 1;
                }
            }

            public /* synthetic */ LogisticRegressionModel org$apache$spark$mllib$classification$LogisticRegressionModel$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataMatrix$1 = dataMatrix$1;
                this.bestClass$1 = bestClass$1;
                this.maxMargin$1 = maxMargin$1;
                this.withBias$1 = withBias$1;
            }
        });
        d = bestClass.elem;
        return d;
    }

    @Override
    public void save(SparkContext sc, String path) {
        GLMClassificationModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getClass().getName(), this.numFeatures(), this.numClasses(), this.weights(), this.intercept(), this.threshold());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", numClasses = ", ", threshold = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.toString(), BoxesRunTime.boxToInteger((int)this.numClasses()), this.threshold().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "None";
            }
        })}));
    }

    public LogisticRegressionModel(Vector weights, double intercept, int numFeatures, int numClasses) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        super(weights, intercept);
        ClassificationModel$class.$init$(this);
        PMMLExportable$class.$init$(this);
        if (numClasses == 2) {
            Predef$.MODULE$.require(weights.size() == numFeatures, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegressionModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionModel with numClasses = 2 was given non-matching values:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numFeatures = ", ", but weights.size = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numFeatures()), BoxesRunTime.boxToInteger((int)this.$outer.weights().size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            int weightsSizeWithoutIntercept = (numClasses - 1) * numFeatures;
            int weightsSizeWithIntercept = (numClasses - 1) * (numFeatures + 1);
            Predef$.MODULE$.require(weights.size() == weightsSizeWithoutIntercept || weights.size() == weightsSizeWithIntercept, (Function0)new Serializable(this, weightsSizeWithoutIntercept, weightsSizeWithIntercept){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegressionModel $outer;
                private final int weightsSizeWithoutIntercept$1;
                private final int weightsSizeWithIntercept$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionModel.load with numClasses = ", " and numFeatures = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numClasses()), BoxesRunTime.boxToInteger((int)this.$outer.numFeatures())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected weights of length ", " (without intercept)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.weightsSizeWithoutIntercept$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or ", " (with intercept),"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.weightsSizeWithIntercept$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but was given weights of length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.weights().size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.weightsSizeWithoutIntercept$1 = weightsSizeWithoutIntercept$1;
                    this.weightsSizeWithIntercept$1 = weightsSizeWithIntercept$1;
                }
            });
        }
        this.org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize = weights.size() / (numClasses - 1);
        Vector vector = weights;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            double[] dArray = denseVector.values();
            this.org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray = dArray;
            this.threshold = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"weights only supports dense vector but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{weights.getClass()})));
    }

    public LogisticRegressionModel(Vector weights, double intercept) {
        this(weights, intercept, weights.size(), 2);
    }
}

