/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u00015\u0011!BT1jm\u0016\u0014\u0015-_3t\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\r\u000e\u0003\u0019I!A\u0007\u0004\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BA\u0002\u0013%Q$\u0001\u0004mC6\u0014G-Y\u000b\u0002=A\u0011qbH\u0005\u0003AA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0007I\u0011B\u0012\u0002\u00151\fWN\u00193b?\u0012*\u0017\u000f\u0006\u0002%OA\u0011q\"J\u0005\u0003MA\u0011A!\u00168ji\"9\u0001&IA\u0001\u0002\u0004q\u0012a\u0001=%c!A!\u0006\u0001B\u0001B\u0003&a$A\u0004mC6\u0014G-\u0019\u0011\t\u00111\u0002!\u00111A\u0005\n5\n\u0011\"\\8eK2$\u0016\u0010]3\u0016\u00039\u0002\"a\f\u001a\u000f\u0005=\u0001\u0014BA\u0019\u0011\u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\u0002\u0002\u0002\u0003\u001c\u0001\u0005\u0003\u0007I\u0011B\u001c\u0002\u001b5|G-\u001a7UsB,w\fJ3r)\t!\u0003\bC\u0004)k\u0005\u0005\t\u0019\u0001\u0018\t\u0011i\u0002!\u0011!Q!\n9\n!\"\\8eK2$\u0016\u0010]3!\u0011\u0015a\u0004\u0001\"\u0003>\u0003\u0019a\u0014N\\5u}Q\u0019a\bQ!\u0011\u0005}\u0002Q\"\u0001\u0002\t\u000bqY\u0004\u0019\u0001\u0010\t\u000b1Z\u0004\u0019\u0001\u0018\t\u000bq\u0002A\u0011A\"\u0015\u0005y\"\u0005\"\u0002\u000fC\u0001\u0004q\u0002\"\u0002\u001f\u0001\t\u00031E#\u0001 \t\u000b!\u0003A\u0011A%\u0002\u0013M,G\u000fT1nE\u0012\fGC\u0001 K\u0011\u0015ar\t1\u0001\u001f\u0011\u0015a\u0005\u0001\"\u0001\u001e\u0003%9W\r\u001e'b[\n$\u0017\rC\u0003O\u0001\u0011\u0005q*\u0001\u0007tKRlu\u000eZ3m)f\u0004X\r\u0006\u0002?!\")A&\u0014a\u0001]!)!\u000b\u0001C\u0001[\u0005aq-\u001a;N_\u0012,G\u000eV=qK\")A\u000b\u0001C\u0001+\u0006\u0019!/\u001e8\u0015\u0005YK\u0006CA X\u0013\tA&AA\bOC&4XMQ1zKNlu\u000eZ3m\u0011\u0015Q6\u000b1\u0001\\\u0003\u0011!\u0017\r^1\u0011\u0007q{\u0016-D\u0001^\u0015\tqf!A\u0002sI\u0012L!\u0001Y/\u0003\u0007I#E\t\u0005\u0002cK6\t1M\u0003\u0002e\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\n\u0005\u0019\u001c'\u0001\u0004'bE\u0016dW\r\u001a)pS:$x!\u00025\u0003\u0011\u0003I\u0017A\u0003(bSZ,')Y=fgB\u0011qH\u001b\u0004\u0006\u0003\tA\ta[\n\u0004U:!\u0002\"\u0002\u001fk\t\u0003iG#A5\t\u0011=T'\u0019!C\u0001\u00055\n1\"T;mi&tw.\\5bY\"1\u0011O\u001bQ\u0001\n9\nA\"T;mi&tw.\\5bY\u0002B\u0001b\u001d6C\u0002\u0013\u0005!!L\u0001\n\u0005\u0016\u0014hn\\;mY&Da!\u001e6!\u0002\u0013q\u0013A\u0003\"fe:|W\u000f\u001c7jA!AqO\u001bb\u0001\n\u0003\u0011\u00010A\ntkB\u0004xN\u001d;fI6{G-\u001a7UsB,7/F\u0001z!\rQxPL\u0007\u0002w*\u0011A0`\u0001\nS6lW\u000f^1cY\u0016T!A \t\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\u0002m\u00141aU3u\u0011\u001d\t)A\u001bQ\u0001\ne\fAc];qa>\u0014H/\u001a3N_\u0012,G\u000eV=qKN\u0004\u0003bBA\u0005U\u0012\u0005\u00111B\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004-\u00065\u0001bBA\b\u0003\u000f\u0001\raW\u0001\u0006S:\u0004X\u000f\u001e\u0005\b\u0003\u0013QG\u0011AA\n)\u00151\u0016QCA\f\u0011\u001d\ty!!\u0005A\u0002mCa\u0001HA\t\u0001\u0004q\u0002bBA\u0005U\u0012\u0005\u00111\u0004\u000b\b-\u0006u\u0011qDA\u0011\u0011\u001d\ty!!\u0007A\u0002mCa\u0001HA\r\u0001\u0004q\u0002B\u0002\u0017\u0002\u001a\u0001\u0007a\u0006C\u0005\u0002&)\f\t\u0011\"\u0003\u0002(\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\t1\fgn\u001a\u0006\u0003\u0003g\tAA[1wC&!\u0011qGA\u0017\u0005\u0019y%M[3di\u0002")
public class NaiveBayes
implements Serializable,
Logging {
    private double org$apache$spark$mllib$classification$NaiveBayes$$lambda;
    private String org$apache$spark$mllib$classification$NaiveBayes$$modelType;
    private transient Logger org$apache$spark$Logging$$log_;

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d, String string) {
        return NaiveBayes$.MODULE$.train(rDD, d, string);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d) {
        return NaiveBayes$.MODULE$.train(rDD, d);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD) {
        return NaiveBayes$.MODULE$.train(rDD);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public double org$apache$spark$mllib$classification$NaiveBayes$$lambda() {
        return this.org$apache$spark$mllib$classification$NaiveBayes$$lambda;
    }

    private void org$apache$spark$mllib$classification$NaiveBayes$$lambda_$eq(double x$1) {
        this.org$apache$spark$mllib$classification$NaiveBayes$$lambda = x$1;
    }

    public String org$apache$spark$mllib$classification$NaiveBayes$$modelType() {
        return this.org$apache$spark$mllib$classification$NaiveBayes$$modelType;
    }

    private void org$apache$spark$mllib$classification$NaiveBayes$$modelType_$eq(String x$1) {
        this.org$apache$spark$mllib$classification$NaiveBayes$$modelType = x$1;
    }

    public NaiveBayes setLambda(double lambda) {
        this.org$apache$spark$mllib$classification$NaiveBayes$$lambda_$eq(lambda);
        return this;
    }

    public double getLambda() {
        return this.org$apache$spark$mllib$classification$NaiveBayes$$lambda();
    }

    public NaiveBayes setModelType(String modelType) {
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0)new Serializable(this, modelType){
            public static final long serialVersionUID = 0L;
            private final String modelType$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NaiveBayes was created with an unknown modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.modelType$2}));
            }
            {
                this.modelType$2 = modelType$2;
            }
        });
        this.org$apache$spark$mllib$classification$NaiveBayes$$modelType_$eq(modelType);
        return this;
    }

    public String getModelType() {
        return this.org$apache$spark$mllib$classification$NaiveBayes$$modelType();
    }

    public NaiveBayesModel run(RDD<LabeledPoint> data) {
        Tuple2 tuple2;
        Serializable requireNonnegativeValues = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Vector v) {
                Vector vector;
                block6: {
                    double[] dArray;
                    block5: {
                        block4: {
                            vector = v;
                            if (!(vector instanceof SparseVector)) break block4;
                            SparseVector sparseVector = (SparseVector)vector;
                            dArray = sparseVector.values();
                            break block5;
                        }
                        if (!(vector instanceof DenseVector)) break block6;
                        DenseVector denseVector = (DenseVector)vector;
                        dArray = denseVector.values();
                    }
                    double[] values = dArray;
                    if (Predef$.MODULE$.doubleArrayOps(values).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(double x$11) {
                            return this.apply$mcZD$sp(x$11);
                        }

                        public boolean apply$mcZD$sp(double x$11) {
                            return x$11 >= 0.0;
                        }
                    })) {
                        return;
                    }
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Naive Bayes requires nonnegative feature values but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                }
                throw new MatchError((Object)vector);
            }
        };
        Serializable requireZeroOneBernoulliValues = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Vector v) {
                Vector vector;
                block6: {
                    double[] dArray;
                    block5: {
                        block4: {
                            vector = v;
                            if (!(vector instanceof SparseVector)) break block4;
                            SparseVector sparseVector = (SparseVector)vector;
                            dArray = sparseVector.values();
                            break block5;
                        }
                        if (!(vector instanceof DenseVector)) break block6;
                        DenseVector denseVector = (DenseVector)vector;
                        dArray = denseVector.values();
                    }
                    double[] values = dArray;
                    if (Predef$.MODULE$.doubleArrayOps(values).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(double v) {
                            return this.apply$mcZD$sp(v);
                        }

                        public boolean apply$mcZD$sp(double v) {
                            return v == 0.0 || v == 1.0;
                        }
                    })) {
                        return;
                    }
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bernoulli naive Bayes requires 0 or 1 feature values but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                }
                throw new MatchError((Object)vector);
            }
        };
        Tuple2[] aggregated = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint p) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)p.label()), (Object)p.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Double$.MODULE$).combineByKey((Function1)new Serializable(this, (Function1)requireNonnegativeValues, (Function1)requireZeroOneBernoulliValues){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayes $outer;
            private final Function1 requireNonnegativeValues$1;
            private final Function1 requireZeroOneBernoulliValues$1;

            public final Tuple2<Object, DenseVector> apply(Vector v) {
                String string = this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$modelType();
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                Object object = !(string != null ? !string.equals(string2) : string2 != null) ? this.requireZeroOneBernoulliValues$1.apply((Object)v) : this.requireNonnegativeValues$1.apply((Object)v);
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)v.copy().toDense());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.requireNonnegativeValues$1 = requireNonnegativeValues$1;
                this.requireZeroOneBernoulliValues$1 = requireZeroOneBernoulliValues$1;
            }
        }, (Function2)new Serializable(this, (Function1)requireNonnegativeValues){
            public static final long serialVersionUID = 0L;
            private final Function1 requireNonnegativeValues$1;

            public final Tuple2<Object, DenseVector> apply(Tuple2<Object, DenseVector> c, Vector v) {
                this.requireNonnegativeValues$1.apply((Object)v);
                BLAS$.MODULE$.axpy(1.0, v, (Vector)c._2());
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(c._1$mcJ$sp() + 1L)), c._2());
            }
            {
                this.requireNonnegativeValues$1 = requireNonnegativeValues$1;
            }
        }, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, DenseVector> apply(Tuple2<Object, DenseVector> c1, Tuple2<Object, DenseVector> c2) {
                BLAS$.MODULE$.axpy(1.0, (Vector)c2._2(), (Vector)c1._2());
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(c1._1$mcJ$sp() + c2._1$mcJ$sp())), c1._2());
            }
        }).collect();
        int numLabels2 = aggregated.length;
        LongRef numDocuments = new LongRef(0L);
        Predef$.MODULE$.refArrayOps((Object[])aggregated).foreach((Function1)new Serializable(this, numDocuments){
            public static final long serialVersionUID = 0L;
            private final LongRef numDocuments$1;

            public final void apply(Tuple2<Object, Tuple2<Object, DenseVector>> x0$1) {
                Tuple2 tuple2;
                Tuple2<Object, Tuple2<Object, DenseVector>> tuple22 = x0$1;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    long n = tuple2._1$mcJ$sp();
                    this.numDocuments$1.elem += n;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.numDocuments$1 = numDocuments$1;
            }
        });
        Tuple2 tuple22 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])aggregated).head();
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            int n;
            DenseVector v = (DenseVector)tuple2._2();
            int numFeatures = n = v.size();
            double[] labels = new double[numLabels2];
            double[] pi = new double[numLabels2];
            double[][] theta = (double[][])Array$.MODULE$.fill(numLabels2, (Function0)new Serializable(this, numFeatures){
                public static final long serialVersionUID = 0L;
                private final int numFeatures$2;

                public final double[] apply() {
                    return new double[this.numFeatures$2];
                }
                {
                    this.numFeatures$2 = numFeatures$2;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            double piLogDenom = package$.MODULE$.log((double)numDocuments.elem + (double)numLabels2 * this.org$apache$spark$mllib$classification$NaiveBayes$$lambda());
            IntRef i = new IntRef(0);
            Predef$.MODULE$.refArrayOps((Object[])aggregated).foreach((Function1)new Serializable(this, numFeatures, labels, pi, theta, piLogDenom, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NaiveBayes $outer;
                private final int numFeatures$2;
                private final double[] labels$1;
                private final double[] pi$1;
                private final double[][] theta$1;
                private final double piLogDenom$1;
                private final IntRef i$1;

                public final void apply(Tuple2<Object, Tuple2<Object, DenseVector>> x0$2) {
                    Tuple2<Object, Tuple2<Object, DenseVector>> tuple2;
                    block3: {
                        block6: {
                            double d;
                            DenseVector sumTermFreqs;
                            block5: {
                                String string;
                                long n;
                                block4: {
                                    tuple2 = x0$2;
                                    if (tuple2 == null) break block3;
                                    double label = tuple2._1$mcD$sp();
                                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                                    if (tuple22 == null) break block3;
                                    n = tuple22._1$mcJ$sp();
                                    sumTermFreqs = (DenseVector)tuple22._2();
                                    this.labels$1[this.i$1.elem] = label;
                                    this.pi$1[this.i$1.elem] = package$.MODULE$.log((double)n + this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$lambda()) - this.piLogDenom$1;
                                    string = this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$modelType();
                                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                                    String string3 = string;
                                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block4;
                                    d = package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sumTermFreqs.values()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + (double)this.numFeatures$2 * this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$lambda());
                                    break block5;
                                }
                                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                                String string5 = string;
                                if (string4 != null ? !string4.equals(string5) : string5 != null) break block6;
                                d = package$.MODULE$.log((double)n + 2.0 * this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$lambda());
                            }
                            double thetaLogDenom = d;
                            for (int j = 0; j < this.numFeatures$2; ++j) {
                                this.theta$1[this.i$1.elem][j] = package$.MODULE$.log(sumTermFreqs.apply(j) + this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$lambda()) - thetaLogDenom;
                            }
                            ++this.i$1.elem;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$classification$NaiveBayes$$modelType()})));
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.numFeatures$2 = numFeatures$2;
                    this.labels$1 = labels$1;
                    this.pi$1 = pi$1;
                    this.theta$1 = theta$1;
                    this.piLogDenom$1 = piLogDenom$1;
                    this.i$1 = i$1;
                }
            });
            return new NaiveBayesModel(labels, pi, theta, this.org$apache$spark$mllib$classification$NaiveBayes$$modelType());
        }
        throw new MatchError((Object)tuple22);
    }

    public NaiveBayes(double lambda, String modelType) {
        this.org$apache$spark$mllib$classification$NaiveBayes$$lambda = lambda;
        this.org$apache$spark$mllib$classification$NaiveBayes$$modelType = modelType;
        Logging.class.$init$((Logging)this);
    }

    public NaiveBayes(double lambda) {
        this(lambda, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayes() {
        this(1.0, NaiveBayes$.MODULE$.Multinomial());
    }
}

