/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.OutputStream;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel$;
import org.apache.spark.mllib.clustering.KMeansModel$SaveLoadV1_0$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.PMMLExportable;
import org.apache.spark.mllib.pmml.PMMLExportable$class;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0001\u0003\u00015\u00111bS'fC:\u001cXj\u001c3fY*\u00111\u0001B\u0001\u000bG2,8\u000f^3sS:<'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u00019!\"$\b\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011\u0001B;uS2L!!\u0007\f\u0003\u0011M\u000bg/Z1cY\u0016\u0004\"aD\u000e\n\u0005q\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0011\u0001X.\u001c7\n\u0005\tz\"A\u0004)N\u001b2+\u0005\u0010]8si\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u0019!C\u0001K\u0005q1\r\\;ti\u0016\u00148)\u001a8uKJ\u001cX#\u0001\u0014\u0011\u0007=9\u0013&\u0003\u0002)!\t)\u0011I\u001d:bsB\u0011!&L\u0007\u0002W)\u0011A\u0006B\u0001\u0007Y&t\u0017\r\\4\n\u00059Z#A\u0002,fGR|'\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u0003'\u0003=\u0019G.^:uKJ\u001cUM\u001c;feN\u0004\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0014A\u0002\u001fj]&$h\b\u0006\u00025mA\u0011Q\u0007A\u0007\u0002\u0005!)A%\ra\u0001M!)!\u0007\u0001C\u0001qQ\u0011A'\u000f\u0005\u0006u]\u0002\raO\u0001\bG\u0016tG/\u001a:t!\ra\u0014)K\u0007\u0002{)\u0011ahP\u0001\u0005Y\u0006twMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$\u0001C%uKJ\f'\r\\3\t\u000b\u0011\u0003A\u0011A#\u0002\u0003-,\u0012A\u0012\t\u0003\u001f\u001dK!\u0001\u0013\t\u0003\u0007%sG\u000fC\u0003K\u0001\u0011\u00051*A\u0004qe\u0016$\u0017n\u0019;\u0015\u0005\u0019c\u0005\"B'J\u0001\u0004I\u0013!\u00029pS:$\b\"\u0002&\u0001\t\u0003yEC\u0001)W!\r\tFKR\u0007\u0002%*\u00111KB\u0001\u0004e\u0012$\u0017BA+S\u0005\r\u0011F\t\u0012\u0005\u0006/:\u0003\r\u0001W\u0001\u0007a>Lg\u000e^:\u0011\u0007E#\u0016\u0006C\u0003K\u0001\u0011\u0005!\f\u0006\u0002\\KB\u0019A\f\u00192\u000e\u0003uS!\u0001\u00110\u000b\u0005}3\u0011aA1qS&\u0011\u0011-\u0018\u0002\b\u0015\u00064\u0018M\u0015#E!\ta4-\u0003\u0002e{\t9\u0011J\u001c;fO\u0016\u0014\b\"B,Z\u0001\u00041\u0007c\u0001/aS!)\u0001\u000e\u0001C\u0001S\u0006Y1m\\7qkR,7i\\:u)\tQW\u000e\u0005\u0002\u0010W&\u0011A\u000e\u0005\u0002\u0007\t>,(\r\\3\t\u000b9<\u0007\u0019\u0001-\u0002\t\u0011\fG/\u0019\u0005\u0006a\u0002!I!]\u0001\u0017G2,8\u000f^3s\u0007\u0016tG/\u001a:t/&$\bNT8s[V\t!\u000fE\u0002twvt!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]d\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\tQ\b#A\u0004qC\u000e\\\u0017mZ3\n\u0005\tc(B\u0001>\u0011!\t)d0\u0003\u0002\u0000\u0005\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0007bBA\u0002\u0001\u0011\u0005\u0013QA\u0001\u0005g\u00064X\r\u0006\u0004\u0002\b\u00055\u0011\u0011\u0004\t\u0004\u001f\u0005%\u0011bAA\u0006!\t!QK\\5u\u0011!\ty!!\u0001A\u0002\u0005E\u0011AA:d!\u0011\t\u0019\"!\u0006\u000e\u0003\u0019I1!a\u0006\u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!\tY\"!\u0001A\u0002\u0005u\u0011\u0001\u00029bi\"\u0004B!a\b\u0002&9\u0019q\"!\t\n\u0007\u0005\r\u0002#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003G\u0001\u0002bBA\u0017\u0001\u0011E\u0013qF\u0001\u000eM>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005uqaBA\u001a\u0005!\u0005\u0011QG\u0001\f\u00176+\u0017M\\:N_\u0012,G\u000eE\u00026\u0003o1a!\u0001\u0002\t\u0002\u0005e2CBA\u001c\u001d\u0005m\"\u0004\u0005\u0003\u0016\u0003{!\u0014bAA -\t1Aj\\1eKJDqAMA\u001c\t\u0003\t\u0019\u0005\u0006\u0002\u00026!A\u0011qIA\u001c\t\u0003\nI%\u0001\u0003m_\u0006$G#\u0002\u001b\u0002L\u00055\u0003\u0002CA\b\u0003\u000b\u0002\r!!\u0005\t\u0011\u0005m\u0011Q\ta\u0001\u0003;1q!!\u0015\u00028\u0011\u000b\u0019FA\u0004DYV\u001cH/\u001a:\u0014\r\u0005=c\"!\u0016\u001b!\ry\u0011qK\u0005\u0004\u00033\u0002\"a\u0002)s_\u0012,8\r\u001e\u0005\u000b\u0003;\nyE!f\u0001\n\u0003)\u0015AA5e\u0011)\t\t'a\u0014\u0003\u0012\u0003\u0006IAR\u0001\u0004S\u0012\u0004\u0003BC'\u0002P\tU\r\u0011\"\u0001\u0002fU\t\u0011\u0006\u0003\u0006\u0002j\u0005=#\u0011#Q\u0001\n%\na\u0001]8j]R\u0004\u0003b\u0002\u001a\u0002P\u0011\u0005\u0011Q\u000e\u000b\u0007\u0003_\n\u0019(!\u001e\u0011\t\u0005E\u0014qJ\u0007\u0003\u0003oAq!!\u0018\u0002l\u0001\u0007a\t\u0003\u0004N\u0003W\u0002\r!\u000b\u0005\u000b\u0003s\ny%!A\u0005\u0002\u0005m\u0014\u0001B2paf$b!a\u001c\u0002~\u0005}\u0004\"CA/\u0003o\u0002\n\u00111\u0001G\u0011!i\u0015q\u000fI\u0001\u0002\u0004I\u0003BCAB\u0003\u001f\n\n\u0011\"\u0001\u0002\u0006\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAADU\r1\u0015\u0011R\u0016\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0013\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0006=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011QTA(#\u0003%\t!a(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0015\u0016\u0004S\u0005%\u0005BCAS\u0003\u001f\n\t\u0011\"\u0011\u0002(\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!+\u0011\u0007q\nY+C\u0002\u0002(uB\u0011\"a,\u0002P\u0005\u0005I\u0011A#\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005M\u0016qJA\u0001\n\u0003\t),\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0016Q\u0018\t\u0004\u001f\u0005e\u0016bAA^!\t\u0019\u0011I\\=\t\u0013\u0005}\u0016\u0011WA\u0001\u0002\u00041\u0015a\u0001=%c!Q\u00111YA(\u0003\u0003%\t%!2\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a2\u0011\r\u0005%\u0017qZA\\\u001b\t\tYMC\u0002\u0002NB\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t.a3\u0003\u0011%#XM]1u_JD!\"!6\u0002P\u0005\u0005I\u0011AAl\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAm\u0003?\u00042aDAn\u0013\r\ti\u000e\u0005\u0002\b\u0005>|G.Z1o\u0011)\ty,a5\u0002\u0002\u0003\u0007\u0011q\u0017\u0005\u000b\u0003G\fy%!A\u0005B\u0005\u0015\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0019C!\"!;\u0002P\u0005\u0005I\u0011IAv\u0003!!xn\u0015;sS:<GCAAU\u0011)\ty/a\u0014\u0002\u0002\u0013\u0005\u0013\u0011_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u00171\u001f\u0005\u000b\u0003\u007f\u000bi/!AA\u0002\u0005]v\u0001CA|\u0003oAI!!?\u0002\u000f\rcWo\u001d;feB!\u0011\u0011OA~\r!\t\t&a\u000e\t\n\u0005u8\u0003BA~\u001diAqAMA~\t\u0003\u0011\t\u0001\u0006\u0002\u0002z\"A!QAA~\t\u0003\u00119!A\u0003baBd\u0017\u0010\u0006\u0003\u0002p\t%\u0001\u0002\u0003B\u0006\u0005\u0007\u0001\rA!\u0004\u0002\u0003I\u0004BAa\u0004\u0003\u00165\u0011!\u0011\u0003\u0006\u0004\u0005'1\u0011aA:rY&!!q\u0003B\t\u0005\r\u0011vn\u001e\u0005\u000b\u0005\u000b\tY0!A\u0005\u0002\nmACBA8\u0005;\u0011y\u0002C\u0004\u0002^\te\u0001\u0019\u0001$\t\r5\u0013I\u00021\u0001*\u0011)\u0011\u0019#a?\u0002\u0002\u0013\u0005%QE\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Ca\r\u0011\u000b=\u0011IC!\f\n\u0007\t-\u0002C\u0001\u0004PaRLwN\u001c\t\u0006\u001f\t=b)K\u0005\u0004\u0005c\u0001\"A\u0002+va2,'\u0007\u0003\u0006\u00036\t\u0005\u0012\u0011!a\u0001\u0003_\n1\u0001\u001f\u00131\u0011)\u0011I$a?\u0002\u0002\u0013%!1H\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003>A\u0019AHa\u0010\n\u0007\t\u0005SH\u0001\u0004PE*,7\r^\u0004\n\u0005\u000b\n9\u0004#\u0001\u0003\u0005\u000f\nAbU1wK2{\u0017\r\u001a,2?B\u0002B!!\u001d\u0003J\u0019I!1JA\u001c\u0011\u0003\u0011!Q\n\u0002\r'\u00064X\rT8bIZ\u000bt\fM\n\u0004\u0005\u0013r\u0001b\u0002\u001a\u0003J\u0011\u0005!\u0011\u000b\u000b\u0003\u0005\u000fB!B!\u0016\u0003J\t\u0007I\u0011BAT\u0003E!\b.[:G_Jl\u0017\r\u001e,feNLwN\u001c\u0005\n\u00053\u0012I\u0005)A\u0005\u0003S\u000b!\u0003\u001e5jg\u001a{'/\\1u-\u0016\u00148/[8oA!Y!Q\fB%\u0005\u0004%\tAAAT\u00035!\b.[:DY\u0006\u001c8OT1nK\"I!\u0011\rB%A\u0003%\u0011\u0011V\u0001\u000fi\"L7o\u00117bgNt\u0015-\\3!\u0011!\t\u0019A!\u0013\u0005\u0002\t\u0015D\u0003CA\u0004\u0005O\u0012IG!\u001c\t\u0011\u0005=!1\ra\u0001\u0003#AqAa\u001b\u0003d\u0001\u0007A'A\u0003n_\u0012,G\u000e\u0003\u0005\u0002\u001c\t\r\u0004\u0019AA\u000f\u0011!\t9E!\u0013\u0005\u0002\tED#\u0002\u001b\u0003t\tU\u0004\u0002CA\b\u0005_\u0002\r!!\u0005\t\u0011\u0005m!q\u000ea\u0001\u0003;A!B!\u000f\u00028\u0005\u0005I\u0011\u0002B\u001e\u0001")
public class KMeansModel
implements Saveable,
Serializable,
PMMLExportable {
    private final Vector[] clusterCenters;

    public static KMeansModel load(SparkContext sparkContext, String string) {
        return KMeansModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    @Experimental
    public void toPMML(String localPath) {
        PMMLExportable$class.toPMML((PMMLExportable)this, localPath);
    }

    @Override
    @Experimental
    public void toPMML(SparkContext sc, String path) {
        PMMLExportable$class.toPMML(this, sc, path);
    }

    @Override
    @Experimental
    public void toPMML(OutputStream outputStream) {
        PMMLExportable$class.toPMML((PMMLExportable)this, outputStream);
    }

    @Override
    @Experimental
    public String toPMML() {
        return PMMLExportable$class.toPMML(this);
    }

    public Vector[] clusterCenters() {
        return this.clusterCenters;
    }

    public int k() {
        return this.clusterCenters().length;
    }

    public int predict(Vector point) {
        return KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)this.clusterCentersWithNorm(), new VectorWithNorm(point))._1$mcI$sp();
    }

    public RDD<Object> predict(RDD<Vector> points) {
        Iterable<VectorWithNorm> centersWithNorm = this.clusterCentersWithNorm();
        Broadcast bcCentersWithNorm = points.context().broadcast(centersWithNorm, ClassTag$.MODULE$.apply(Iterable.class));
        return points.map((Function1)new Serializable(this, bcCentersWithNorm){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcCentersWithNorm$1;

            public final int apply(Vector p) {
                return KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcCentersWithNorm$1.value()), new VectorWithNorm(p))._1$mcI$sp();
            }
            {
                this.bcCentersWithNorm$1 = bcCentersWithNorm$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public JavaRDD<Integer> predict(JavaRDD<Vector> points) {
        return this.predict((RDD<Vector>)points.rdd()).toJavaRDD();
    }

    public double computeCost(RDD<Vector> data) {
        Iterable<VectorWithNorm> centersWithNorm = this.clusterCentersWithNorm();
        Broadcast bcCentersWithNorm = data.context().broadcast(centersWithNorm, ClassTag$.MODULE$.apply(Iterable.class));
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1)new Serializable(this, bcCentersWithNorm){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcCentersWithNorm$2;

            public final double apply(Vector p) {
                return KMeans$.MODULE$.pointCost((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcCentersWithNorm$2.value()), new VectorWithNorm(p));
            }
            {
                this.bcCentersWithNorm$2 = bcCentersWithNorm$2;
            }
        }, ClassTag$.MODULE$.Double())).sum();
    }

    private Iterable<VectorWithNorm> clusterCentersWithNorm() {
        return (Iterable)Predef$.MODULE$.refArrayOps((Object[])this.clusterCenters()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Vector x$1) {
                return new VectorWithNorm(x$1);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    @Override
    public void save(SparkContext sc, String path) {
        KMeansModel$SaveLoadV1_0$.MODULE$.save(sc, this, path);
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    public KMeansModel(Vector[] clusterCenters) {
        this.clusterCenters = clusterCenters;
        PMMLExportable$class.$init$(this);
    }

    public KMeansModel(java.lang.Iterable<Vector> centers) {
        this((Vector[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(centers).asScala()).toArray(ClassTag$.MODULE$.apply(Vector.class)));
    }

    public static class Cluster
    implements Product,
    Serializable {
        private final int id;
        private final Vector point;

        public int id() {
            return this.id;
        }

        public Vector point() {
            return this.point;
        }

        public Cluster copy(int id, Vector point) {
            return new Cluster(id, point);
        }

        public int copy$default$1() {
            return this.id();
        }

        public Vector copy$default$2() {
            return this.point();
        }

        public String productPrefix() {
            return "Cluster";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.point();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.id());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Cluster;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.point()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Cluster)) return false;
            boolean bl = true;
            if (!bl) return false;
            Cluster cluster = (Cluster)x$1;
            if (this.id() != cluster.id()) return false;
            Vector vector = this.point();
            Vector vector2 = cluster.point();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!((Object)vector).equals(vector2)) return false;
            if (!cluster.canEqual(this)) return false;
            return true;
        }

        public Cluster(int id, Vector point) {
            this.id = id;
            this.point = point;
            Product.class.$init$((Product)this);
        }
    }
}

