/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.evaluation.RankingMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011aBU1oW&tw-T3ue&\u001c7O\u0003\u0002\u0004\t\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0011a\u0002L\n\u0005\u0001=)\u0012\u0004\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-]i\u0011AB\u0005\u00031\u0019\u0011q\u0001T8hO&tw\r\u0005\u0002\u00115%\u00111$\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005\u0019\u0002O]3eS\u000e$\u0018n\u001c8B]\u0012d\u0015MY3mgB\u0019qD\t\u0013\u000e\u0003\u0001R!!\t\u0004\u0002\u0007I$G-\u0003\u0002$A\t\u0019!\u000b\u0012#\u0011\tA)seJ\u0005\u0003ME\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\t)U%\u0011\u0011&\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003W1b\u0001\u0001B\u0003.\u0001\t\u0007aFA\u0001U#\ty#\u0007\u0005\u0002\u0011a%\u0011\u0011'\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u00012'\u0003\u00025#\t\u0019\u0011I\\=\t\u0011Y\u0002!1!Q\u0001\f]\n!\"\u001a<jI\u0016t7-\u001a\u00132!\rA4HK\u0007\u0002s)\u0011!(E\u0001\be\u00164G.Z2u\u0013\ta\u0014H\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019a\u0014N\\5u}Q\u0011\u0001\t\u0012\u000b\u0003\u0003\u000e\u00032A\u0011\u0001+\u001b\u0005\u0011\u0001\"\u0002\u001c>\u0001\b9\u0004\"B\u000f>\u0001\u0004q\u0002\"\u0002$\u0001\t\u00039\u0015a\u00039sK\u000eL7/[8o\u0003R$\"\u0001S&\u0011\u0005AI\u0015B\u0001&\u0012\u0005\u0019!u.\u001e2mK\")A*\u0012a\u0001\u001b\u0006\t1\u000e\u0005\u0002\u0011\u001d&\u0011q*\u0005\u0002\u0004\u0013:$\b\u0002C)\u0001\u0011\u000b\u0007I\u0011\u0001*\u0002)5,\u0017M\\!wKJ\fw-\u001a)sK\u000eL7/[8o+\u0005A\u0005\u0002\u0003+\u0001\u0011\u0003\u0005\u000b\u0015\u0002%\u0002+5,\u0017M\\!wKJ\fw-\u001a)sK\u000eL7/[8oA!)a\u000b\u0001C\u0001/\u00061a\u000eZ2h\u0003R$\"\u0001\u0013-\t\u000b1+\u0006\u0019A')\u0005\u0001Q\u0006CA._\u001b\u0005a&BA/\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003?r\u0013A\"\u0012=qKJLW.\u001a8uC2<Q!\u0019\u0002\t\u0002\t\faBU1oW&tw-T3ue&\u001c7\u000f\u0005\u0002CG\u001a)\u0011A\u0001E\u0001IN\u00191mD\r\t\u000by\u001aG\u0011\u00014\u0015\u0003\tDQ\u0001[2\u0005\u0002%\f!a\u001c4\u0016\u0007)l'\u0010\u0006\u0002l_B\u0019!\t\u00017\u0011\u0005-jG!\u00028h\u0005\u0004q#!A#\t\u000bu9\u0007\u0019\u00019\u0011\u0007E4\b0D\u0001s\u0015\t\u0019H/\u0001\u0003kCZ\f'BA;\u0007\u0003\r\t\u0007/[\u0005\u0003oJ\u0014qAS1wCJ#E\t\u0005\u0003\u0011KeL\bCA\u0016{\t\u0015isM1\u0001|#\tyC\u0010\u0005\u0003~\u0003\u0007aW\"\u0001@\u000b\u0007}\f\t!\u0001\u0003mC:<'\"A:\n\u0007\u0005\u0015aP\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011%\tIaYA\u0001\n\u0013\tY!A\u0006sK\u0006$'+Z:pYZ,GCAA\u0007!\ri\u0018qB\u0005\u0004\u0003#q(AB(cU\u0016\u001cG\u000f\u000b\u0002d5\"\u0012\u0001M\u0017")
public class RankingMetrics<T>
implements Logging,
Serializable {
    private final RDD<Tuple2<Object, Object>> predictionAndLabels;
    private double meanAveragePrecision;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    public static <E, T extends Iterable<E>> RankingMetrics<E> of(JavaRDD<Tuple2<T, T>> javaRDD) {
        return RankingMetrics$.MODULE$.of(javaRDD);
    }

    private double meanAveragePrecision$lzycompute() {
        RankingMetrics rankingMetrics = this;
        synchronized (rankingMetrics) {
            if (!this.bitmap$0) {
                this.meanAveragePrecision = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RankingMetrics $outer;

                    public final double apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            double d;
                            Object pred = tuple2._1();
                            Object lab = tuple2._2();
                            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
                            if (labSet.nonEmpty()) {
                                int cnt = 0;
                                double precSum = 0.0;
                                int n = ScalaRunTime$.MODULE$.array_length(pred);
                                for (int i = 0; i < n; ++i) {
                                    if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                                    precSum += (double)(++cnt) / (double)(i + 1);
                                }
                                d = precSum / (double)labSet.size();
                            } else {
                                this.$outer.logWarning((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Empty ground truth set, check input data";
                                    }
                                });
                                d = 0.0;
                            }
                            double d2 = d;
                            return d2;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double())).mean();
                this.bitmap$0 = true;
            }
            return this.meanAveragePrecision;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public double precisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "ranking position k should be positive";
            }
        });
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RankingMetrics $outer;
            private final int k$1;

            public final double apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double d;
                    Object pred = tuple2._1();
                    Object lab = tuple2._2();
                    Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
                    if (labSet.nonEmpty()) {
                        int n = package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length(pred), this.k$1);
                        int cnt = 0;
                        for (int i = 0; i < n; ++i) {
                            if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                            ++cnt;
                        }
                        d = (double)cnt / (double)this.k$1;
                    } else {
                        this.$outer.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Empty ground truth set, check input data";
                            }
                        });
                        d = 0.0;
                    }
                    double d2 = d;
                    return d2;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.k$1 = k$1;
            }
        }, ClassTag$.MODULE$.Double())).mean();
    }

    public double meanAveragePrecision() {
        return this.bitmap$0 ? this.meanAveragePrecision : this.meanAveragePrecision$lzycompute();
    }

    public double ndcgAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "ranking position k should be positive";
            }
        });
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RankingMetrics $outer;
            private final int k$2;

            public final double apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    double d;
                    Object pred = tuple2._1();
                    Object lab = tuple2._2();
                    Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
                    if (labSet.nonEmpty()) {
                        int labSetSize = labSet.size();
                        int n = package$.MODULE$.min(package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSetSize), this.k$2);
                        double maxDcg = 0.0;
                        double dcg = 0.0;
                        for (int i = 0; i < n; ++i) {
                            double gain = 1.0 / package$.MODULE$.log((double)(i + 2));
                            if (labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) {
                                dcg += gain;
                            }
                            if (i >= labSetSize) continue;
                            maxDcg += gain;
                        }
                        d = dcg / maxDcg;
                    } else {
                        this.$outer.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Empty ground truth set, check input data";
                            }
                        });
                        d = 0.0;
                    }
                    double d2 = d;
                    return d2;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.k$2 = k$2;
            }
        }, ClassTag$.MODULE$.Double())).mean();
    }

    public RankingMetrics(RDD<Tuple2<Object, Object>> predictionAndLabels, ClassTag<T> evidence$1) {
        this.predictionAndLabels = predictionAndLabels;
        Logging.class.$init$((Logging)this);
    }
}

