/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u001b\t\t\"+Z4sKN\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u000b\u0005\r!\u0011AC3wC2,\u0018\r^5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\u0019I!a\u0006\u0004\u0003\u000f1{wmZ5oO\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\rqe\u0016$\u0017n\u0019;j_:\fe\u000eZ(cg\u0016\u0014h/\u0019;j_:\u001c\bcA\u000e\u001fA5\tAD\u0003\u0002\u001e\r\u0005\u0019!\u000f\u001a3\n\u0005}a\"a\u0001*E\tB!q\"I\u0012$\u0013\t\u0011\u0003C\u0001\u0004UkBdWM\r\t\u0003\u001f\u0011J!!\n\t\u0003\r\u0011{WO\u00197f\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0011\u0011f\u000b\t\u0003U\u0001i\u0011A\u0001\u0005\u00063\u0019\u0002\rA\u0007\u0005\u0007O\u0001!\t\u0001B\u0017\u0015\u0005%r\u0003\"B\r-\u0001\u0004y\u0003C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003iE\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u0011Y\u0002\u0001R1A\u0005\n]\nqa];n[\u0006\u0014\u00180F\u00019!\tID(D\u0001;\u0015\tYD!\u0001\u0003ti\u0006$\u0018BA\u001f;\u0005yiU\u000f\u001c;jm\u0006\u0014\u0018.\u0019;f'R\fG/[:uS\u000e\fGnU;n[\u0006\u0014\u0018\u0010\u0003\u0005@\u0001!\u0005\t\u0015)\u00039\u0003!\u0019X/\\7bef\u0004\u0003\"B!\u0001\t\u0003\u0011\u0015!E3ya2\f\u0017N\\3e-\u0006\u0014\u0018.\u00198dKV\t1\u0005C\u0003E\u0001\u0011\u0005!)A\tnK\u0006t\u0017IY:pYV$X-\u0012:s_JDQA\u0012\u0001\u0005\u0002\t\u000b\u0001#\\3b]N\u000bX/\u0019:fI\u0016\u0013(o\u001c:\t\u000b!\u0003A\u0011\u0001\"\u0002)I|w\u000e^'fC:\u001c\u0016/^1sK\u0012,%O]8s\u0011\u0015Q\u0005\u0001\"\u0001C\u0003\t\u0011(\u0007\u000b\u0002\u0001\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011qJB\u0001\u000bC:tw\u000e^1uS>t\u0017BA)O\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public class RegressionMetrics
implements Logging {
    private final RDD<Tuple2<Object, Object>> predictionAndObservations;
    private MultivariateStatisticalSummary summary;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    /*
     * WARNING - void declaration
     */
    private MultivariateStatisticalSummary summary$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if (!this.bitmap$0) {
                void var2_2;
                MultivariateStatisticalSummary summary = (MultivariateStatisticalSummary)this.predictionAndObservations.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            double prediction = tuple2._1$mcD$sp();
                            double observation = tuple2._2$mcD$sp();
                            Vector vector = Vectors$.MODULE$.dense(observation, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{observation - prediction}));
                            return vector;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).aggregate((Object)new MultivariateOnlineSummarizer(), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer summary, Vector v) {
                        return summary.add(v);
                    }
                }, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer sum1, MultivariateOnlineSummarizer sum2) {
                        return sum1.merge(sum2);
                    }
                }, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
                this.summary = var2_2;
                this.bitmap$0 = true;
            }
            return this.summary;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private MultivariateStatisticalSummary summary() {
        return this.bitmap$0 ? this.summary : this.summary$lzycompute();
    }

    public double explainedVariance() {
        return 1.0 - this.summary().variance().apply(1) / this.summary().variance().apply(0);
    }

    public double meanAbsoluteError() {
        return this.summary().normL1().apply(1) / (double)this.summary().count();
    }

    public double meanSquaredError() {
        double rmse = this.summary().normL2().apply(1) / package$.MODULE$.sqrt((double)this.summary().count());
        return rmse * rmse;
    }

    public double rootMeanSquaredError() {
        return this.summary().normL2().apply(1) / package$.MODULE$.sqrt((double)this.summary().count());
    }

    public double r2() {
        return 1.0 - package$.MODULE$.pow(this.summary().normL2().apply(1), 2.0) / (this.summary().variance().apply(0) * (double)(this.summary().count() - 1L));
    }

    public RegressionMetrics(RDD<Tuple2<Object, Object>> predictionAndObservations) {
        this.predictionAndObservations = predictionAndObservations;
        Logging.class.$init$((Logging)this);
    }

    public RegressionMetrics(DataFrame predictionAndObservations) {
        this((RDD<Tuple2<Object, Object>>)predictionAndObservations.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row r) {
                return new Tuple2.mcDD.sp(r.getDouble(0), r.getDouble(1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

