/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.storage.Zero;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u00111!\u0013#G\u0015\t\u0019A!A\u0004gK\u0006$XO]3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!Q1A\u0005\u0002Y\t!\"\\5o\t>\u001cgI]3r+\u00059\u0002CA\b\u0019\u0013\tI\u0002CA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\f[&tGi\\2Ge\u0016\f\b\u0005C\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0003?\u0005\u0002\"\u0001\t\u0001\u000e\u0003\tAQ!\u0006\u000fA\u0002]AQ!\b\u0001\u0005\u0002\r\"\u0012a\b\u0005\u0006K\u0001!\tAJ\u0001\u0004M&$HCA\u0014+!\t\u0001\u0003&\u0003\u0002*\u0005\tA\u0011\n\u0012$N_\u0012,G\u000eC\u0003,I\u0001\u0007A&A\u0004eCR\f7/\u001a;\u0011\u00075\u0002$'D\u0001/\u0015\tyc!A\u0002sI\u0012L!!\r\u0018\u0003\u0007I#E\t\u0005\u00024m5\tAG\u0003\u00026\t\u00051A.\u001b8bY\u001eL!a\u000e\u001b\u0003\rY+7\r^8s\u0011\u0015)\u0003\u0001\"\u0001:)\t9#\bC\u0003,q\u0001\u00071\bE\u0002=\u0003Jj\u0011!\u0010\u0006\u0003}}\nAA[1wC*\u0011\u0001IB\u0001\u0004CBL\u0017B\u0001\">\u0005\u001dQ\u0015M^1S\t\u0012C#\u0001\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d3\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011J\u0012\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\\\u0004\u0006\u0017\nAI\u0001T\u0001\u0004\u0013\u00123\u0005C\u0001\u0011N\r\u0015\t!\u0001#\u0003O'\tie\u0002C\u0003\u001e\u001b\u0012\u0005\u0001\u000bF\u0001M\r\u0011\u0011V\nA*\u00037\u0011{7-^7f]R4%/Z9vK:\u001c\u00170Q4he\u0016<\u0017\r^8s'\r\tf\u0002\u0016\t\u0003\u001fUK!A\u0016\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011U\t&Q1A\u0005\u0002YA\u0001bG)\u0003\u0002\u0003\u0006Ia\u0006\u0005\u0006;E#\tA\u0017\u000b\u00037v\u0003\"\u0001X)\u000e\u00035CQ!F-A\u0002]AqaX)A\u0002\u0013%\u0001-A\u0001n+\u0005\t\u0007CA\bc\u0013\t\u0019\u0007C\u0001\u0003M_:<\u0007bB3R\u0001\u0004%IAZ\u0001\u0006[~#S-\u001d\u000b\u0003O*\u0004\"a\u00045\n\u0005%\u0004\"\u0001B+oSRDqa\u001b3\u0002\u0002\u0003\u0007\u0011-A\u0002yIEBa!\\)!B\u0013\t\u0017AA7!\u0011%y\u0017\u000b1AA\u0002\u0013%\u0001/\u0001\u0002eMV\t\u0011\u000fE\u0002sm\u0006l\u0011a\u001d\u0006\u0003kQT\u0011!^\u0001\u0007EJ,WM_3\n\u0005]\u001c(a\u0003#f]N,g+Z2u_JD\u0011\"_)A\u0002\u0003\u0007I\u0011\u0002>\u0002\r\u00114w\fJ3r)\t97\u0010C\u0004lq\u0006\u0005\t\u0019A9\t\ru\f\u0006\u0015)\u0003r\u0003\r!g\r\t\u0005\u0006;E#\ta \u000b\u00027\"9\u00111A)\u0005\u0002\u0005\u0015\u0011aA1eIR!\u0011qAA\u0005\u001b\u0005\t\u0006bBA\u0006\u0003\u0003\u0001\rAM\u0001\u0004I>\u001c\u0007bBA\b#\u0012\u0005\u0011\u0011C\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0005\u0003\u000f\t\u0019\u0002C\u0004\u0002\u0016\u00055\u0001\u0019A.\u0002\u000b=$\b.\u001a:\t\u000f\u0005e\u0011\u000b\"\u0003\u0002\u001c\u00059\u0011n]#naRLXCAA\u000f!\ry\u0011qD\u0005\u0004\u0003C\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003K\tF\u0011AA\u0014\u0003\rIGM\u001a\u000b\u0002e\u0001")
public class IDF {
    private final int minDocFreq;

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public IDFModel fit(RDD<Vector> dataset) {
        DocumentFrequencyAggregator x$1 = new DocumentFrequencyAggregator(this.minDocFreq());
        Serializable x$2 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DocumentFrequencyAggregator apply(DocumentFrequencyAggregator df, Vector v) {
                return df.add(v);
            }
        };
        Serializable x$3 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DocumentFrequencyAggregator apply(DocumentFrequencyAggregator df1, DocumentFrequencyAggregator df2) {
                return df1.merge(df2);
            }
        };
        int x$4 = dataset.treeAggregate$default$4((Object)x$1);
        Vector idf = ((DocumentFrequencyAggregator)dataset.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(DocumentFrequencyAggregator.class))).idf();
        return new IDFModel(idf);
    }

    public IDFModel fit(JavaRDD<Vector> dataset) {
        return this.fit((RDD<Vector>)dataset.rdd());
    }

    public IDF(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public IDF() {
        this(0);
    }

    public static class DocumentFrequencyAggregator
    implements Serializable {
        private final int minDocFreq;
        private long m;
        private breeze.linalg.DenseVector<Object> df;

        public int minDocFreq() {
            return this.minDocFreq;
        }

        private long m() {
            return this.m;
        }

        private void m_$eq(long x$1) {
            this.m = x$1;
        }

        private breeze.linalg.DenseVector<Object> df() {
            return this.df;
        }

        private void df_$eq(breeze.linalg.DenseVector<Object> x$1) {
            this.df = x$1;
        }

        public DocumentFrequencyAggregator add(Vector doc) {
            Vector vector;
            block8: {
                block7: {
                    DenseVector denseVector;
                    Option<double[]> option;
                    block6: {
                        SparseVector sparseVector;
                        Option<Tuple3<Object, int[], double[]>> option2;
                        if (this.isEmpty()) {
                            this.df_$eq((breeze.linalg.DenseVector<Object>)breeze.linalg.DenseVector$.MODULE$.zeros$mJc$sp(doc.size(), ClassTag$.MODULE$.Long(), (Zero)Zero.LongZero$.MODULE$));
                        }
                        if (!((vector = doc) instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) break block6;
                        int[] indices = (int[])((Tuple3)option2.get())._2();
                        double[] values = (double[])((Tuple3)option2.get())._3();
                        int nnz = Predef$.MODULE$.intArrayOps(indices).size();
                        for (int k = 0; k < nnz; ++k) {
                            if (!(values[k] > 0.0)) continue;
                            breeze.linalg.DenseVector<Object> denseVector2 = this.df();
                            int n = indices[k];
                            denseVector2.update$mcJ$sp(n, denseVector2.apply$mcJ$sp(n) + 1L);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block8;
                    double[] values = (double[])option.get();
                    int n = Predef$.MODULE$.doubleArrayOps(values).size();
                    for (int j = 0; j < n; ++j) {
                        if (!(values[j] > 0.0)) continue;
                        breeze.linalg.DenseVector<Object> denseVector3 = this.df();
                        int n2 = j;
                        denseVector3.update$mcJ$sp(n2, denseVector3.apply$mcJ$sp(n2) + 1L);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.m_$eq(this.m() + 1L);
                return this;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only sparse and dense vectors are supported but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vector.getClass()})));
        }

        public DocumentFrequencyAggregator merge(DocumentFrequencyAggregator other) {
            Object object;
            if (other.isEmpty()) {
                object = BoxedUnit.UNIT;
            } else {
                this.m_$eq(this.m() + other.m());
                if (this.df() == null) {
                    this.df_$eq((breeze.linalg.DenseVector<Object>)other.df().copy$mcJ$sp());
                    object = BoxedUnit.UNIT;
                } else {
                    object = this.df().$plus$eq(other.df(), breeze.linalg.DenseVector$.MODULE$.dv_dv_UpdateOp_Long_OpAdd());
                }
            }
            return this;
        }

        private boolean isEmpty() {
            return this.m() == 0L;
        }

        public Vector idf() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Haven't seen any document yet.");
            }
            int n = this.df().length();
            double[] inv = new double[n];
            for (int j = 0; j < n; ++j) {
                if (this.df().apply$mcJ$sp(j) < (long)this.minDocFreq()) continue;
                inv[j] = package$.MODULE$.log(((double)this.m() + 1.0) / ((double)this.df().apply$mcJ$sp(j) + 1.0));
            }
            return Vectors$.MODULE$.dense(inv);
        }

        public DocumentFrequencyAggregator(int minDocFreq) {
            this.minDocFreq = minDocFreq;
            this.m = 0L;
        }

        public DocumentFrequencyAggregator() {
            this(0);
        }
    }
}

