/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.PCAModel;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00053A!\u0001\u0002\u0001\u001b\t\u0019\u0001kQ!\u000b\u0005\r!\u0011a\u00024fCR,(/\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005\t1.F\u0001\u0018!\ty\u0001$\u0003\u0002\u001a!\t\u0019\u0011J\u001c;\t\u0011m\u0001!\u0011!Q\u0001\n]\t!a\u001b\u0011\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0012\u0005\u0005\u0002!\u00015\t!\u0001C\u0003\u00169\u0001\u0007q\u0003C\u0003$\u0001\u0011\u0005A%A\u0002gSR$\"!\n\u0015\u0011\u0005\u00012\u0013BA\u0014\u0003\u0005!\u00016)Q'pI\u0016d\u0007\"B\u0015#\u0001\u0004Q\u0013aB:pkJ\u001cWm\u001d\t\u0004W9\u0002T\"\u0001\u0017\u000b\u000552\u0011a\u0001:eI&\u0011q\u0006\f\u0002\u0004%\u0012#\u0005CA\u00195\u001b\u0005\u0011$BA\u001a\u0005\u0003\u0019a\u0017N\\1mO&\u0011QG\r\u0002\u0007-\u0016\u001cGo\u001c:\t\u000b\r\u0002A\u0011A\u001c\u0015\u0005\u0015B\u0004\"B\u00157\u0001\u0004I\u0004c\u0001\u001e@a5\t1H\u0003\u0002={\u0005!!.\u0019<b\u0015\tqd!A\u0002ba&L!\u0001Q\u001e\u0003\u000f)\u000bg/\u0019*E\t\u0002")
public class PCA {
    private final int k;

    public int k() {
        return this.k;
    }

    public PCAModel fit(RDD<Vector> sources) {
        Matrix matrix;
        block4: {
            DenseMatrix denseMatrix;
            block3: {
                block2: {
                    DenseMatrix denseMatrix2;
                    Predef$.MODULE$.require(this.k() <= ((Vector)sources.first()).size(), (Function0)new Serializable(this, sources){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PCA $outer;
                        private final RDD sources$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source vector size is ", " must be greater than k=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Vector)this.sources$1.first()).size()), BoxesRunTime.boxToInteger((int)this.$outer.k())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.sources$1 = sources$1;
                        }
                    });
                    RowMatrix mat = new RowMatrix(sources);
                    matrix = mat.computePrincipalComponents(this.k());
                    if (!(matrix instanceof DenseMatrix)) break block2;
                    denseMatrix = denseMatrix2 = (DenseMatrix)matrix;
                    break block3;
                }
                if (!(matrix instanceof SparseMatrix)) break block4;
                SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                denseMatrix = sparseMatrix.toDense();
            }
            DenseMatrix pc = denseMatrix;
            return new PCAModel(this.k(), pc);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Unsupported matrix format. Expected ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparseMatrix or DenseMatrix. Instead got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{matrix.getClass()}))).toString());
    }

    public PCAModel fit(JavaRDD<Vector> sources) {
        return this.fit((RDD<Vector>)sources.rdd());
    }

    public PCA(int k) {
        this.k = k;
        Predef$.MODULE$.require(k >= 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PCA $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PCA requires a number of principal components k >= 1 but was given ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

