/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseMatrix;
import java.util.Arrays;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Matrix$class;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.spark-project.guava.base.Objects;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@SQLUserDefinedType(udt=MatrixUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u00015\u00111\u0002R3og\u0016l\u0015\r\u001e:jq*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0005\t3\u0001\u0011)\u0019!C\u00015\u00059a.^7S_^\u001cX#A\u000e\u0011\u0005=a\u0012BA\u000f\u0011\u0005\rIe\u000e\u001e\u0005\t?\u0001\u0011\t\u0011)A\u00057\u0005Aa.^7S_^\u001c\b\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u001dqW/\\\"pYND\u0001b\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\t]Vl7i\u001c7tA!AQ\u0005\u0001BC\u0002\u0013\u0005a%\u0001\u0004wC2,Xm]\u000b\u0002OA\u0019q\u0002\u000b\u0016\n\u0005%\u0002\"!B!se\u0006L\bCA\b,\u0013\ta\u0003C\u0001\u0004E_V\u0014G.\u001a\u0005\t]\u0001\u0011\t\u0011)A\u0005O\u00059a/\u00197vKN\u0004\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011I\u0019\u0002\u0019%\u001cHK]1ogB|7/\u001a3\u0016\u0003I\u0002\"aD\u001a\n\u0005Q\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\tm\u0001\u0011\t\u0011)A\u0005e\u0005i\u0011n\u001d+sC:\u001c\bo\\:fI\u0002BQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtD#\u0002\u001e<yur\u0004CA\u000b\u0001\u0011\u0015Ir\u00071\u0001\u001c\u0011\u0015\ts\u00071\u0001\u001c\u0011\u0015)s\u00071\u0001(\u0011\u0015\u0001t\u00071\u00013\u0011\u0015A\u0004\u0001\"\u0001A)\u0011Q\u0014IQ\"\t\u000bey\u0004\u0019A\u000e\t\u000b\u0005z\u0004\u0019A\u000e\t\u000b\u0015z\u0004\u0019A\u0014\t\u000b\u0015\u0003A\u0011\t$\u0002\r\u0015\fX/\u00197t)\t\u0011t\tC\u0003I\t\u0002\u0007\u0011*A\u0001p!\ty!*\u0003\u0002L!\t\u0019\u0011I\\=\t\u000b5\u0003A\u0011\t(\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u0007\u0005\u0007!\u0002!\t\u0001B)\u0002\u0011Q|'I]3fu\u0016,\u0012A\u0015\t\u0004'^SS\"\u0001+\u000b\u0005\r)&\"\u0001,\u0002\r\t\u0014X-\u001a>f\u0013\t9B\u000b\u0003\u0004Z\u0001\u0011\u0005AAW\u0001\u0006CB\u0004H.\u001f\u000b\u0003UmCQ\u0001\u0018-A\u0002m\t\u0011!\u001b\u0005\u00063\u0002!\tE\u0018\u000b\u0004U}\u0003\u0007\"\u0002/^\u0001\u0004Y\u0002\"B1^\u0001\u0004Y\u0012!\u00016\t\r\r\u0004A\u0011\u0001\u0003e\u0003\u0015Ig\u000eZ3y)\rYRM\u001a\u0005\u00069\n\u0004\ra\u0007\u0005\u0006C\n\u0004\ra\u0007\u0005\u0007Q\u0002!\t\u0001B5\u0002\rU\u0004H-\u0019;f)\u0011QWN\\8\u0011\u0005=Y\u0017B\u00017\u0011\u0005\u0011)f.\u001b;\t\u000bq;\u0007\u0019A\u000e\t\u000b\u0005<\u0007\u0019A\u000e\t\u000bA<\u0007\u0019\u0001\u0016\u0002\u0003YDQA\u001d\u0001\u0005BM\fAaY8qsV\t!\b\u0003\u0004v\u0001\u0011\u0005AA^\u0001\u0004[\u0006\u0004HC\u0001\u001ex\u0011\u0015AH\u000f1\u0001z\u0003\u00051\u0007\u0003B\b{U)J!a\u001f\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u00025\u0001\t\u0003!Q\u0010\u0006\u0002;}\")\u0001\u0010 a\u0001s\"1\u0011\u0011\u0001\u0001\u0005BM\f\u0011\u0002\u001e:b]N\u0004xn]3\t\u0011\u0005\u0015\u0001\u0001\"\u0011\u0007\u0003\u000f\tQBZ8sK\u0006\u001c\u0007.Q2uSZ,Gc\u00016\u0002\n!9\u00010a\u0001A\u0002\u0005-\u0001cB\b\u0002\u000emY\"F[\u0005\u0004\u0003\u001f\u0001\"!\u0003$v]\u000e$\u0018n\u001c84\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+\t\u0001\u0002^8Ta\u0006\u00148/Z\u000b\u0003\u0003/\u00012!FA\r\u0013\r\tYB\u0001\u0002\r'B\f'o]3NCR\u0014\u0018\u000e\u001f\u0015\b\u0001\u0005}\u0011qFA\u0019!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\tQ\u0001^=qKNT1!!\u000b\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003[\t\u0019C\u0001\nT#2+6/\u001a:EK\u001aLg.\u001a3UsB,\u0017aA;ei\u000e\u0012\u00111\u0007\t\u0004+\u0005U\u0012bAA\u001c\u0005\tIQ*\u0019;sSb,F\tV\u0004\b\u0003w\u0011\u0001\u0012AA\u001f\u0003-!UM\\:f\u001b\u0006$(/\u001b=\u0011\u0007U\tyD\u0002\u0004\u0002\u0005!\u0005\u0011\u0011I\n\u0006\u0003\u007fq\u00111\t\t\u0004\u001f\u0005\u0015\u0013bAA$!\ta1+\u001a:jC2L'0\u00192mK\"9\u0001(a\u0010\u0005\u0002\u0005-CCAA\u001f\u0011!\ty%a\u0010\u0005\u0002\u0005E\u0013!\u0002>fe>\u001cH#\u0002\u001e\u0002T\u0005U\u0003BB\r\u0002N\u0001\u00071\u0004\u0003\u0004\"\u0003\u001b\u0002\ra\u0007\u0005\t\u00033\ny\u0004\"\u0001\u0002\\\u0005!qN\\3t)\u0015Q\u0014QLA0\u0011\u0019I\u0012q\u000ba\u00017!1\u0011%a\u0016A\u0002mA\u0001\"a\u0019\u0002@\u0011\u0005\u0011QM\u0001\u0004Kf,Gc\u0001\u001e\u0002h!9\u0011\u0011NA1\u0001\u0004Y\u0012!\u00018\t\u0011\u00055\u0014q\bC\u0001\u0003_\nAA]1oIR9!(!\u001d\u0002t\u0005U\u0004BB\r\u0002l\u0001\u00071\u0004\u0003\u0004\"\u0003W\u0002\ra\u0007\u0005\t\u0003o\nY\u00071\u0001\u0002z\u0005\u0019!O\\4\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006!Q\u000f^5m\u0015\t\t\u0019)\u0001\u0003kCZ\f\u0017\u0002BAD\u0003{\u0012aAU1oI>l\u0007\u0002CAF\u0003\u007f!\t!!$\u0002\u000bI\fg\u000e\u001a8\u0015\u000fi\ny)!%\u0002\u0014\"1\u0011$!#A\u0002mAa!IAE\u0001\u0004Y\u0002\u0002CA<\u0003\u0013\u0003\r!!\u001f\t\u0011\u0005]\u0015q\bC\u0001\u00033\u000bA\u0001Z5bOR\u0019!(a'\t\u0011\u0005u\u0015Q\u0013a\u0001\u0003?\u000baA^3di>\u0014\bcA\u000b\u0002\"&\u0019\u00111\u0015\u0002\u0003\rY+7\r^8s\u0011)\t9+a\u0010\u0002\u0002\u0013%\u0011\u0011V\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002,B!\u0011QVAZ\u001b\t\tyK\u0003\u0003\u00022\u0006\u0005\u0015\u0001\u00027b]\u001eLA!!.\u00020\n1qJ\u00196fGR\u0004")
public class DenseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    private final double[] values;
    private final boolean isTransposed;

    public static DenseMatrix diag(Vector vector) {
        return DenseMatrix$.MODULE$.diag(vector);
    }

    public static DenseMatrix randn(int n, int n2, Random random) {
        return DenseMatrix$.MODULE$.randn(n, n2, random);
    }

    public static DenseMatrix rand(int n, int n2, Random random) {
        return DenseMatrix$.MODULE$.rand(n, n2, random);
    }

    public static DenseMatrix eye(int n) {
        return DenseMatrix$.MODULE$.eye(n);
    }

    public static DenseMatrix ones(int n, int n2) {
        return DenseMatrix$.MODULE$.ones(n, n2);
    }

    public static DenseMatrix zeros(int n, int n2) {
        return DenseMatrix$.MODULE$.zeros(n, n2);
    }

    @Override
    public void org$apache$spark$mllib$linalg$Matrix$_setter_$isTransposed_$eq(boolean x$1) {
    }

    @Override
    public double[] toArray() {
        return Matrix$class.toArray(this);
    }

    @Override
    public DenseMatrix multiply(DenseMatrix y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(DenseVector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(Vector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public String toString() {
        return Matrix$class.toString(this);
    }

    @Override
    public String toString(int maxLines, int maxLineWidth) {
        return Matrix$class.toString(this, maxLines, maxLineWidth);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public boolean isTransposed() {
        return this.isTransposed;
    }

    public boolean equals(Object o) {
        DenseMatrix denseMatrix;
        Object object = o;
        boolean bl = object instanceof DenseMatrix ? (denseMatrix = (DenseMatrix)object).numRows() == this.numRows() && denseMatrix.numCols() == this.numCols() && Arrays.equals(this.toArray(), denseMatrix.toArray()) : false;
        return bl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Predef$.MODULE$.int2Integer(this.numRows()), Predef$.MODULE$.int2Integer(this.numCols()), this.toArray()});
    }

    @Override
    public breeze.linalg.Matrix<Object> toBreeze() {
        DenseMatrix.mcD.sp sp2;
        if (this.isTransposed()) {
            DenseMatrix.mcD.sp breezeMatrix = new DenseMatrix.mcD.sp(this.numCols(), this.numRows(), this.values());
            sp2 = (breeze.linalg.Matrix)breezeMatrix.t(breeze.linalg.DenseMatrix$.MODULE$.canTranspose());
        } else {
            sp2 = new DenseMatrix.mcD.sp(this.numRows(), this.numCols(), this.values());
        }
        return sp2;
    }

    public double apply(int i) {
        return this.values()[i];
    }

    @Override
    public double apply(int i, int j) {
        return this.values()[this.index(i, j)];
    }

    @Override
    public int index(int i, int j) {
        return this.isTransposed() ? j + this.numCols() * i : i + this.numRows() * j;
    }

    @Override
    public void update(int i, int j, double v) {
        this.values()[this.index((int)i, (int)j)] = v;
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix(this.numRows(), this.numCols(), (double[])this.values().clone());
    }

    @Override
    public DenseMatrix map(Function1<Object, Object> f) {
        return new DenseMatrix(this.numRows(), this.numCols(), (double[])Predef$.MODULE$.doubleArrayOps(this.values()).map(f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), this.isTransposed());
    }

    @Override
    public DenseMatrix update(Function1<Object, Object> f) {
        int len = this.values().length;
        for (int i = 0; i < len; ++i) {
            this.values()[i] = f.apply$mcDD$sp(this.values()[i]);
        }
        return this;
    }

    @Override
    public DenseMatrix transpose() {
        return new DenseMatrix(this.numCols(), this.numRows(), this.values(), !this.isTransposed());
    }

    @Override
    public void foreachActive(Function3<Object, Object, Object, BoxedUnit> f) {
        if (this.isTransposed()) {
            for (int i = 0; i < this.numRows(); ++i) {
                int indStart = i * this.numCols();
                for (int j = 0; j < this.numCols(); ++j) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[indStart + j]));
                }
            }
        } else {
            for (int j = 0; j < this.numCols(); ++j) {
                int indStart = j * this.numRows();
                for (int i = 0; i < this.numRows(); ++i) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[indStart + i]));
                }
            }
        }
    }

    public SparseMatrix toSparse() {
        ArrayBuilder.ofDouble spVals = new ArrayBuilder.ofDouble();
        int[] colPtrs = new int[this.numCols() + 1];
        ArrayBuilder.ofInt rowIndices = new ArrayBuilder.ofInt();
        int nnz = 0;
        int j = 0;
        while (j < this.numCols()) {
            for (int i = 0; i < this.numRows(); ++i) {
                double v = this.values()[this.index(i, j)];
                if (v == 0.0) continue;
                rowIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                spVals.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                ++nnz;
            }
            colPtrs[++j] = nnz;
        }
        return new SparseMatrix(this.numRows(), this.numCols(), colPtrs, (int[])rowIndices.result(), (double[])spVals.result());
    }

    public DenseMatrix(int numRows2, int numCols, double[] values, boolean isTransposed) {
        this.numRows = numRows2;
        this.numCols = numCols;
        this.values = values;
        this.isTransposed = isTransposed;
        Matrix$class.$init$(this);
        Predef$.MODULE$.require(values.length == numRows2 * numCols, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DenseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of values supplied doesn't match the ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size of the matrix! values.length: ", ", numRows * numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length), BoxesRunTime.boxToInteger((int)(this.$outer.numRows() * this.$outer.numCols()))}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public DenseMatrix(int numRows2, int numCols, double[] values) {
        this(numRows2, numCols, values, false);
    }
}

