/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.CSCMatrix;
import breeze.linalg.CSCMatrix$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Matrix$class;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@SQLUserDefinedType(udt=MatrixUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,W*\u0019;sSbT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0007\u001b\u0006$(/\u001b=\t\u0011e\u0001!Q1A\u0005\u0002i\tqA\\;n%><8/F\u0001\u001c!\tyA$\u0003\u0002\u001e!\t\u0019\u0011J\u001c;\t\u0011}\u0001!\u0011!Q\u0001\nm\t\u0001B\\;n%><8\u000f\t\u0005\tC\u0001\u0011)\u0019!C\u00015\u00059a.^7D_2\u001c\b\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u00119,XnQ8mg\u0002B\u0001\"\n\u0001\u0003\u0006\u0004%\tAJ\u0001\bG>d\u0007\u000b\u001e:t+\u00059\u0003cA\b)7%\u0011\u0011\u0006\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\tW\u0001\u0011\t\u0011)A\u0005O\u0005A1m\u001c7QiJ\u001c\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001'\u0003)\u0011xn^%oI&\u001cWm\u001d\u0005\t_\u0001\u0011\t\u0011)A\u0005O\u0005Y!o\\<J]\u0012L7-Z:!\u0011!\t\u0004A!b\u0001\n\u0003\u0011\u0014A\u0002<bYV,7/F\u00014!\ry\u0001\u0006\u000e\t\u0003\u001fUJ!A\u000e\t\u0003\r\u0011{WO\u00197f\u0011!A\u0004A!A!\u0002\u0013\u0019\u0014a\u0002<bYV,7\u000f\t\u0005\tu\u0001\u0011)\u0019!C!w\u0005a\u0011n\u001d+sC:\u001c\bo\\:fIV\tA\b\u0005\u0002\u0010{%\u0011a\b\u0005\u0002\b\u0005>|G.Z1o\u0011!\u0001\u0005A!A!\u0002\u0013a\u0014!D5t)J\fgn\u001d9pg\u0016$\u0007\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\b\t\u00163u\tS%K!\t)\u0002\u0001C\u0003\u001a\u0003\u0002\u00071\u0004C\u0003\"\u0003\u0002\u00071\u0004C\u0003&\u0003\u0002\u0007q\u0005C\u0003.\u0003\u0002\u0007q\u0005C\u00032\u0003\u0002\u00071\u0007C\u0003;\u0003\u0002\u0007A\bC\u0003C\u0001\u0011\u0005A\n\u0006\u0004E\u001b:{\u0005+\u0015\u0005\u00063-\u0003\ra\u0007\u0005\u0006C-\u0003\ra\u0007\u0005\u0006K-\u0003\ra\n\u0005\u0006[-\u0003\ra\n\u0005\u0006c-\u0003\ra\r\u0005\u0007'\u0002!\t\u0001\u0002+\u0002\u0011Q|'I]3fu\u0016,\u0012!\u0016\t\u0004-j#T\"A,\u000b\u0005\rA&\"A-\u0002\r\t\u0014X-\u001a>f\u0013\t9r\u000bC\u0003]\u0001\u0011\u0005S,A\u0003baBd\u0017\u0010F\u00025=\u0002DQaX.A\u0002m\t\u0011!\u001b\u0005\u0006Cn\u0003\raG\u0001\u0002U\"11\r\u0001C\u0001\t\u0011\fQ!\u001b8eKb$2aG3g\u0011\u0015y&\r1\u0001\u001c\u0011\u0015\t'\r1\u0001\u001c\u0011\u0019A\u0007\u0001\"\u0001\u0005S\u00061Q\u000f\u001d3bi\u0016$BA[7o_B\u0011qb[\u0005\u0003YB\u0011A!\u00168ji\")ql\u001aa\u00017!)\u0011m\u001aa\u00017!)\u0001o\u001aa\u0001i\u0005\ta\u000fC\u0003s\u0001\u0011\u00053/\u0001\u0003d_BLX#\u0001#\t\rU\u0004A\u0011\u0001\u0003w\u0003\ri\u0017\r\u001d\u000b\u0003\t^DQ\u0001\u001f;A\u0002e\f\u0011A\u001a\t\u0005\u001fi$D'\u0003\u0002|!\tIa)\u001e8di&|g.\r\u0005\u0007Q\u0002!\t\u0001B?\u0015\u0005\u0011s\b\"\u0002=}\u0001\u0004I\bBBA\u0001\u0001\u0011\u00053/A\u0005ue\u0006t7\u000f]8tK\"A\u0011Q\u0001\u0001\u0005B\u0019\t9!A\u0007g_J,\u0017m\u00195BGRLg/\u001a\u000b\u0004U\u0006%\u0001b\u0002=\u0002\u0004\u0001\u0007\u00111\u0002\t\b\u001f\u000551d\u0007\u001bk\u0013\r\ty\u0001\u0005\u0002\n\rVt7\r^5p]NBq!a\u0005\u0001\t\u0003\t)\"A\u0004u_\u0012+gn]3\u0016\u0005\u0005]\u0001cA\u000b\u0002\u001a%\u0019\u00111\u0004\u0002\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\u0015\b\u0001\u0005}\u0011qFA\u0019!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\tQ\u0001^=qKNT1!!\u000b\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003[\t\u0019C\u0001\nT#2+6/\u001a:EK\u001aLg.\u001a3UsB,\u0017aA;ei\u000e\u0012\u00111\u0007\t\u0004+\u0005U\u0012bAA\u001c\u0005\tIQ*\u0019;sSb,F\tV\u0004\b\u0003w\u0011\u0001\u0012AA\u001f\u00031\u0019\u0006/\u0019:tK6\u000bGO]5y!\r)\u0012q\b\u0004\u0007\u0003\tA\t!!\u0011\u0014\u000b\u0005}b\"a\u0011\u0011\u0007=\t)%C\u0002\u0002HA\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqAQA \t\u0003\tY\u0005\u0006\u0002\u0002>!A\u0011qJA \t\u0003\t\t&A\u0004ge>l7iT(\u0015\u000f\u0011\u000b\u0019&!\u0016\u0002X!1\u0011$!\u0014A\u0002mAa!IA'\u0001\u0004Y\u0002\u0002CA-\u0003\u001b\u0002\r!a\u0017\u0002\u000f\u0015tGO]5fgB1\u0011QLA7\u0003grA!a\u0018\u0002j9!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f1\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0007\u0005-\u0004#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0014\u0011\u000f\u0002\t\u0013R,'/\u00192mK*\u0019\u00111\u000e\t\u0011\r=\t)hG\u000e5\u0013\r\t9\b\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005m\u0014q\bC\u0001\u0003{\nQa\u001d9fs\u0016$2\u0001RA@\u0011\u001d\t\t)!\u001fA\u0002m\t\u0011A\u001c\u0005\t\u0003\u000b\u000by\u0004\"\u0003\u0002\b\u0006iq-\u001a8SC:$W*\u0019;sSb$\u0012\u0002RAE\u0003\u0017\u000bi)!%\t\re\t\u0019\t1\u0001\u001c\u0011\u0019\t\u00131\u0011a\u00017!9\u0011qRAB\u0001\u0004!\u0014a\u00023f]NLG/\u001f\u0005\t\u0003'\u000b\u0019\t1\u0001\u0002\u0016\u0006\u0019!O\\4\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006!Q\u000f^5m\u0015\t\ty*\u0001\u0003kCZ\f\u0017\u0002BAR\u00033\u0013aAU1oI>l\u0007\u0002CAT\u0003\u007f!\t!!+\u0002\rM\u0004(/\u00198e)%!\u00151VAW\u0003_\u000b\t\f\u0003\u0004\u001a\u0003K\u0003\ra\u0007\u0005\u0007C\u0005\u0015\u0006\u0019A\u000e\t\u000f\u0005=\u0015Q\u0015a\u0001i!A\u00111SAS\u0001\u0004\t)\n\u0003\u0005\u00026\u0006}B\u0011AA\\\u0003\u001d\u0019\bO]1oI:$\u0012\u0002RA]\u0003w\u000bi,a0\t\re\t\u0019\f1\u0001\u001c\u0011\u0019\t\u00131\u0017a\u00017!9\u0011qRAZ\u0001\u0004!\u0004\u0002CAJ\u0003g\u0003\r!!&\t\u0011\u0005\r\u0017q\bC\u0001\u0003\u000b\faa\u001d9eS\u0006<Gc\u0001#\u0002H\"A\u0011\u0011ZAa\u0001\u0004\tY-\u0001\u0004wK\u000e$xN\u001d\t\u0004+\u00055\u0017bAAh\u0005\t1a+Z2u_JD!\"a5\u0002@\u0005\u0005I\u0011BAk\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005]\u0007\u0003BAm\u0003?l!!a7\u000b\t\u0005u\u0017QT\u0001\u0005Y\u0006tw-\u0003\u0003\u0002b\u0006m'AB(cU\u0016\u001cG\u000f")
public class SparseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    private final int[] colPtrs;
    private final int[] rowIndices;
    private final double[] values;
    private final boolean isTransposed;

    public static SparseMatrix spdiag(Vector vector) {
        return SparseMatrix$.MODULE$.spdiag(vector);
    }

    public static SparseMatrix sprandn(int n, int n2, double d, Random random) {
        return SparseMatrix$.MODULE$.sprandn(n, n2, d, random);
    }

    public static SparseMatrix sprand(int n, int n2, double d, Random random) {
        return SparseMatrix$.MODULE$.sprand(n, n2, d, random);
    }

    public static SparseMatrix speye(int n) {
        return SparseMatrix$.MODULE$.speye(n);
    }

    public static SparseMatrix fromCOO(int n, int n2, Iterable<Tuple3<Object, Object, Object>> iterable) {
        return SparseMatrix$.MODULE$.fromCOO(n, n2, iterable);
    }

    @Override
    public void org$apache$spark$mllib$linalg$Matrix$_setter_$isTransposed_$eq(boolean x$1) {
    }

    @Override
    public double[] toArray() {
        return Matrix$class.toArray(this);
    }

    @Override
    public DenseMatrix multiply(DenseMatrix y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(DenseVector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(Vector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public String toString() {
        return Matrix$class.toString(this);
    }

    @Override
    public String toString(int maxLines, int maxLineWidth) {
        return Matrix$class.toString(this, maxLines, maxLineWidth);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public int[] colPtrs() {
        return this.colPtrs;
    }

    public int[] rowIndices() {
        return this.rowIndices;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public boolean isTransposed() {
        return this.isTransposed;
    }

    @Override
    public breeze.linalg.Matrix<Object> toBreeze() {
        CSCMatrix.mcD.sp sp2;
        if (this.isTransposed()) {
            CSCMatrix.mcD.sp breezeMatrix = new CSCMatrix.mcD.sp(this.values(), this.numCols(), this.numRows(), this.colPtrs(), this.rowIndices(), (Zero)Zero.DoubleZero$.MODULE$);
            sp2 = (breeze.linalg.Matrix)breezeMatrix.t(CSCMatrix$.MODULE$.canTranspose(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()));
        } else {
            sp2 = new CSCMatrix.mcD.sp(this.values(), this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (Zero)Zero.DoubleZero$.MODULE$);
        }
        return sp2;
    }

    @Override
    public double apply(int i, int j) {
        int ind = this.index(i, j);
        return ind < 0 ? 0.0 : this.values()[ind];
    }

    @Override
    public int index(int i, int j) {
        return this.isTransposed() ? Arrays.binarySearch(this.rowIndices(), this.colPtrs()[i], this.colPtrs()[i + 1], j) : Arrays.binarySearch(this.rowIndices(), this.colPtrs()[j], this.colPtrs()[j + 1], i);
    }

    @Override
    public void update(int i, int j, double v) {
        int ind = this.index(i, j);
        if (ind == -1) {
            throw new NoSuchElementException("The given row and column indices correspond to a zero value. Only non-zero elements in Sparse Matrices can be updated.");
        }
        this.values()[ind] = v;
    }

    @Override
    public SparseMatrix copy() {
        return new SparseMatrix(this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (double[])this.values().clone());
    }

    @Override
    public SparseMatrix map(Function1<Object, Object> f) {
        return new SparseMatrix(this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (double[])Predef$.MODULE$.doubleArrayOps(this.values()).map(f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), this.isTransposed());
    }

    @Override
    public SparseMatrix update(Function1<Object, Object> f) {
        int len = this.values().length;
        for (int i = 0; i < len; ++i) {
            this.values()[i] = f.apply$mcDD$sp(this.values()[i]);
        }
        return this;
    }

    @Override
    public SparseMatrix transpose() {
        return new SparseMatrix(this.numCols(), this.numRows(), this.colPtrs(), this.rowIndices(), this.values(), !this.isTransposed());
    }

    @Override
    public void foreachActive(Function3<Object, Object, Object, BoxedUnit> f) {
        if (this.isTransposed()) {
            for (int i = 0; i < this.numRows(); ++i) {
                int idxEnd = this.colPtrs()[i + 1];
                for (int idx = this.colPtrs()[i]; idx < idxEnd; ++idx) {
                    int j = this.rowIndices()[idx];
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[idx]));
                }
            }
        } else {
            for (int j = 0; j < this.numCols(); ++j) {
                int idxEnd = this.colPtrs()[j + 1];
                for (int idx = this.colPtrs()[j]; idx < idxEnd; ++idx) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)this.rowIndices()[idx]), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[idx]));
                }
            }
        }
    }

    public DenseMatrix toDense() {
        return new DenseMatrix(this.numRows(), this.numCols(), this.toArray());
    }

    public SparseMatrix(int numRows2, int numCols, int[] colPtrs, int[] rowIndices, double[] values, boolean isTransposed) {
        this.numRows = numRows2;
        this.numCols = numCols;
        this.colPtrs = colPtrs;
        this.rowIndices = rowIndices;
        this.values = values;
        this.isTransposed = isTransposed;
        Matrix$class.$init$(this);
        Predef$.MODULE$.require(values.length == rowIndices.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of row indices and values don't match! ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"values.length: ", ", rowIndices.length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length), BoxesRunTime.boxToInteger((int)this.$outer.rowIndices().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(colPtrs.length == numCols + 1 || colPtrs.length == numRows2 + 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The length of the column indices should be the number of columns + 1. Currently, colPointers.length: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.colPtrs().length), BoxesRunTime.boxToInteger((int)this.$outer.numCols())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(values.length == BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(colPtrs).last()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The last value of colPtrs must equal the number of ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"elements. values.length: ", ", colPtrs.last: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length), Predef$.MODULE$.intArrayOps(this.$outer.colPtrs()).last()}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public SparseMatrix(int numRows2, int numCols, int[] colPtrs, int[] rowIndices, double[] values) {
        this(numRows2, numCols, colPtrs, rowIndices, values, false);
    }
}

