/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.GeneralizedLinearModel$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001e3Q!\u0001\u0002\u0002\u00025\u0011acR3oKJ\fG.\u001b>fI2Kg.Z1s\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!G\u0001\bo\u0016Lw\r\u001b;t+\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0004\b\u0002\u0007-\u0016\u001cGo\u001c:\t\u0011\u0005\u0002!\u0011!Q\u0001\ni\t\u0001b^3jO\"$8\u000f\t\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f^\u000b\u0002KA\u0011qBJ\u0005\u0003OA\u0011a\u0001R8vE2,\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0015%tG/\u001a:dKB$\b\u0005C\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0004[=\u0002\u0004C\u0001\u0018\u0001\u001b\u0005\u0011\u0001\"\u0002\r+\u0001\u0004Q\u0002\"B\u0012+\u0001\u0004)\u0003\"\u0002\u001a\u0001\r#\u0019\u0014\u0001\u00049sK\u0012L7\r\u001e)pS:$H\u0003B\u00135maBQ!N\u0019A\u0002i\t!\u0002Z1uC6\u000bGO]5y\u0011\u00159\u0014\u00071\u0001\u001b\u000319X-[4ii6\u000bGO]5y\u0011\u0015\u0019\u0013\u00071\u0001&\u0011\u0015Q\u0004\u0001\"\u0001<\u0003\u001d\u0001(/\u001a3jGR$\"\u0001\u0010\"\u0011\u0007u\u0002U%D\u0001?\u0015\tyd!A\u0002sI\u0012L!!\u0011 \u0003\u0007I#E\tC\u0003Ds\u0001\u0007A)\u0001\u0005uKN$H)\u0019;b!\ri\u0004I\u0007\u0005\u0006u\u0001!\tA\u0012\u000b\u0003K\u001dCQaQ#A\u0002iAQ!\u0013\u0001\u0005B)\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002\u0017B\u0011Aj\u0014\b\u0003\u001f5K!A\u0014\t\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001dBA#\u0001A*\u0011\u0005Q;V\"A+\u000b\u0005Y3\u0011AC1o]>$\u0018\r^5p]&\u0011\u0001,\u0016\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b")
public abstract class GeneralizedLinearModel
implements Serializable {
    private final Vector weights;
    private final double intercept;

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    public abstract double predictPoint(Vector var1, Vector var2, double var3);

    public RDD<Object> predict(RDD<Vector> testData) {
        Vector localWeights = this.weights();
        Broadcast bcWeights = testData.context().broadcast((Object)localWeights, ClassTag$.MODULE$.apply(Vector.class));
        double localIntercept = this.intercept();
        return testData.mapPartitions((Function1)new Serializable(this, bcWeights, localIntercept){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearModel $outer;
            private final Broadcast bcWeights$1;
            public final double localIntercept$1;

            public final Iterator<Object> apply(Iterator<Vector> iter) {
                Vector w = (Vector)this.bcWeights$1.value();
                return iter.map((Function1)new Serializable(this, w){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$predict$1 $outer;
                    private final Vector w$1;

                    public final double apply(Vector v) {
                        return this.$outer.org$apache$spark$mllib$regression$GeneralizedLinearModel$$anonfun$$$outer().predictPoint(v, this.w$1, this.$outer.localIntercept$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.w$1 = w$1;
                    }
                });
            }

            public /* synthetic */ GeneralizedLinearModel org$apache$spark$mllib$regression$GeneralizedLinearModel$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcWeights$1 = bcWeights$1;
                this.localIntercept$1 = localIntercept$1;
            }
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    public double predict(Vector testData) {
        return this.predictPoint(testData, this.weights(), this.intercept());
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": intercept = ", ", numFeatures = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), BoxesRunTime.boxToDouble((double)this.intercept()), BoxesRunTime.boxToInteger((int)this.weights().size())}));
    }

    public GeneralizedLinearModel(Vector weights, double intercept) {
        this.weights = weights;
        this.intercept = intercept;
    }
}

