/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.stat.KernelDensity$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\ti1*\u001a:oK2$UM\\:jifT!a\u0001\u0003\u0002\tM$\u0018\r\u001e\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u001c\u00015\t!\u0001C\u0004\u001e\u0001\u0001\u0007I\u0011\u0002\u0010\u0002\u0013\t\fg\u000eZ<jIRDW#A\u0010\u0011\u0005=\u0001\u0013BA\u0011\u0011\u0005\u0019!u.\u001e2mK\"91\u0005\u0001a\u0001\n\u0013!\u0013!\u00042b]\u0012<\u0018\u000e\u001a;i?\u0012*\u0017\u000f\u0006\u0002&QA\u0011qBJ\u0005\u0003OA\u0011A!\u00168ji\"9\u0011FIA\u0001\u0002\u0004y\u0012a\u0001=%c!11\u0006\u0001Q!\n}\t!BY1oI^LG\r\u001e5!\u0011%i\u0003\u00011AA\u0002\u0013%a&\u0001\u0004tC6\u0004H.Z\u000b\u0002_A\u0019\u0001gM\u0010\u000e\u0003ER!A\r\u0004\u0002\u0007I$G-\u0003\u00025c\t\u0019!\u000b\u0012#\t\u0013Y\u0002\u0001\u0019!a\u0001\n\u00139\u0014AC:b[BdWm\u0018\u0013fcR\u0011Q\u0005\u000f\u0005\bSU\n\t\u00111\u00010\u0011\u0019Q\u0004\u0001)Q\u0005_\u000591/Y7qY\u0016\u0004\u0003\"\u0002\u001f\u0001\t\u0003i\u0014\u0001D:fi\n\u000bg\u000eZ<jIRDGC\u0001 @\u001b\u0005\u0001\u0001\"B\u000f<\u0001\u0004y\u0002\"B!\u0001\t\u0003\u0011\u0015!C:fiN\u000bW\u000e\u001d7f)\tq4\tC\u0003.\u0001\u0002\u0007q\u0006C\u0003B\u0001\u0011\u0005Q\t\u0006\u0002?\r\")Q\u0006\u0012a\u0001\u000fB\u0019\u0001*T(\u000e\u0003%S!AS&\u0002\t)\fg/\u0019\u0006\u0003\u0019\u001a\t1!\u00199j\u0013\tq\u0015JA\u0004KCZ\f'\u000b\u0012#\u0011\u0005A#V\"A)\u000b\u0005I\u001b\u0016\u0001\u00027b]\u001eT\u0011AS\u0005\u0003CECQA\u0016\u0001\u0005\u0002]\u000b\u0001\"Z:uS6\fG/\u001a\u000b\u00031n\u00032aD- \u0013\tQ\u0006CA\u0003BeJ\f\u0017\u0010C\u0003]+\u0002\u0007\u0001,\u0001\u0004q_&tGo\u001d\u0015\u0003\u0001y\u0003\"a\u00182\u000e\u0003\u0001T!!\u0019\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002dA\naQ\t\u001f9fe&lWM\u001c;bY\u001e)QM\u0001E\u0005M\u0006i1*\u001a:oK2$UM\\:jif\u0004\"aG4\u0007\u000b\u0005\u0011\u0001\u0012\u00025\u0014\u0007\u001dtA\u0003C\u0003\u0019O\u0012\u0005!\u000eF\u0001g\u0011\u0015aw\r\"\u0001n\u0003\u001dqwN]7QI\u001a$Ra\b8qeRDQa\\6A\u0002}\tA!\\3b]\")\u0011o\u001ba\u0001?\u0005\t2\u000f^1oI\u0006\u0014H\rR3wS\u0006$\u0018n\u001c8\t\u000bM\\\u0007\u0019A\u0010\u0002E1|wm\u0015;b]\u0012\f'\u000f\u001a#fm&\fG/[8o!2,8\u000fS1mM2{wM\r)j\u0011\u0015)8\u000e1\u0001 \u0003\u0005A\bbB<h\u0003\u0003%I\u0001_\u0001\fe\u0016\fGMU3t_24X\rF\u0001z!\t\u0001&0\u0003\u0002|#\n1qJ\u00196fGR\u0004")
public class KernelDensity
implements Serializable {
    private double bandwidth = 1.0;
    private RDD<Object> sample;

    public static double normPdf(double d, double d2, double d3, double d4) {
        return KernelDensity$.MODULE$.normPdf(d, d2, d3, d4);
    }

    private double bandwidth() {
        return this.bandwidth;
    }

    private void bandwidth_$eq(double x$1) {
        this.bandwidth = x$1;
    }

    private RDD<Object> sample() {
        return this.sample;
    }

    private void sample_$eq(RDD<Object> x$1) {
        this.sample = x$1;
    }

    public KernelDensity setBandwidth(double bandwidth) {
        Predef$.MODULE$.require(bandwidth > 0.0, (Function0)new Serializable(this, bandwidth){
            public static final long serialVersionUID = 0L;
            private final double bandwidth$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bandwidth must be positive, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.bandwidth$1)}));
            }
            {
                this.bandwidth$1 = bandwidth$1;
            }
        });
        this.bandwidth_$eq(bandwidth);
        return this;
    }

    public KernelDensity setSample(RDD<Object> sample) {
        this.sample_$eq(sample);
        return this;
    }

    public KernelDensity setSample(JavaRDD<Double> sample) {
        this.sample_$eq((RDD<Object>)sample.rdd());
        return this;
    }

    public double[] estimate(double[] points) {
        RDD<Object> sample = this.sample();
        double bandwidth = this.bandwidth();
        Predef$.MODULE$.require(sample != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Must set sample before calling estimate.";
            }
        });
        int n = points.length;
        double logStandardDeviationPlusHalfLog2Pi = package$.MODULE$.log(bandwidth) + 0.5 * package$.MODULE$.log((double)2 * package$.MODULE$.Pi());
        Tuple2 tuple2 = (Tuple2)sample.aggregate((Object)new Tuple2((Object)new double[n], (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)new $anonfun$1(this, points, bandwidth, n, logStandardDeviationPlusHalfLog2Pi), (Function2)new $anonfun$2(this, n), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            double[] densities = (double[])tuple2._1();
            long count = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)densities, (Object)BoxesRunTime.boxToLong((long)count));
            double[] densities2 = (double[])tuple23._1();
            long count2 = tuple23._2$mcJ$sp();
            BLAS.getInstance().dscal(n, 1.0 / (double)count2, densities2, 1);
            return densities2;
        }
        throw new MatchError((Object)tuple2);
    }
}

