/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.LBFGS;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.DataValidators$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\tYBj\\4jgRL7MU3he\u0016\u001c8/[8o/&$\b\u000e\u0014\"G\u000fNS!a\u0001\u0003\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f1A\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0003\u0002\u0015I,wM]3tg&|g.\u0003\u0002\u0014!\tQr)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:BY\u001e|'/\u001b;i[B\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0018\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0004\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005U\u0001\u0001bB\u0012\u0001\u0005\u0004%\t\u0005J\u0001\n_B$\u0018.\\5{KJ,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0003Q\u0011\tAb\u001c9uS6L'0\u0019;j_:L!AK\u0014\u0003\u000b1\u0013eiR*)\u0007\tb#\u0007\u0005\u0002.a5\taF\u0003\u00020\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Er#!B*j]\u000e,\u0017%A\u001a\u0002\u000bEr\u0013G\f\u0019\t\rU\u0002\u0001\u0015!\u0003&\u0003)y\u0007\u000f^5nSj,'\u000f\t\u0015\u0004i1\u0012\u0004b\u0002\u001d\u0001\u0005\u0004%\t&O\u0001\u000bm\u0006d\u0017\u000eZ1u_J\u001cX#\u0001\u001e\u0011\u0007m\u0002%)D\u0001=\u0015\tid(A\u0005j[6,H/\u00192mK*\u0011qHG\u0001\u000bG>dG.Z2uS>t\u0017BA!=\u0005\u0011a\u0015n\u001d;\u0011\te\u0019UIT\u0005\u0003\tj\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007\u0019K5*D\u0001H\u0015\tAe!A\u0002sI\u0012L!AS$\u0003\u0007I#E\t\u0005\u0002\u0010\u0019&\u0011Q\n\u0005\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\t\u00033=K!\u0001\u0015\u000e\u0003\u000f\t{w\u000e\\3b]\"1!\u000b\u0001Q\u0001\ni\n1B^1mS\u0012\fGo\u001c:tA!)A\u000b\u0001C\u0005+\u0006\u0019R.\u001e7uS2\u000b'-\u001a7WC2LG-\u0019;peV\t!\tC\u0003X\u0001\u0011\u0005\u0001,A\u0007tKRtU/\\\"mCN\u001cXm\u001d\u000b\u00033jk\u0011\u0001\u0001\u0005\u00067Z\u0003\r\u0001X\u0001\u000b]Vl7\t\\1tg\u0016\u001c\bCA\r^\u0013\tq&DA\u0002J]RD3A\u0016\u0017aC\u0005\t\u0017!B\u0019/g9\u0002\u0004\"B2\u0001\t#\"\u0017aC2sK\u0006$X-T8eK2$2\u0001F3n\u0011\u00151'\r1\u0001h\u0003\u001d9X-[4iiN\u0004\"\u0001[6\u000e\u0003%T!A\u001b\u0003\u0002\r1Lg.\u00197h\u0013\ta\u0017N\u0001\u0004WK\u000e$xN\u001d\u0005\u0006]\n\u0004\ra\\\u0001\nS:$XM]2faR\u0004\"!\u00079\n\u0005ET\"A\u0002#pk\ndW\rK\u0002\u0001YI\u0002")
public class LogisticRegressionWithLBFGS
extends GeneralizedLinearAlgorithm<LogisticRegressionModel>
implements Serializable {
    private final LBFGS optimizer;
    private final List<Function1<RDD<LabeledPoint>, Object>> validators;

    @Override
    public LBFGS optimizer() {
        return this.optimizer;
    }

    public List<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    private Function1<RDD<LabeledPoint>, Object> multiLabelValidator() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionWithLBFGS $outer;

            public final boolean apply(RDD<LabeledPoint> data) {
                return this.$outer.numOfLinearPredictor() > 1 ? BoxesRunTime.unboxToBoolean((Object)DataValidators$.MODULE$.multiLabelValidator(this.$outer.numOfLinearPredictor() + 1).apply(data)) : BoxesRunTime.unboxToBoolean((Object)DataValidators$.MODULE$.binaryLabelValidator().apply(data));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public LogisticRegressionWithLBFGS setNumClasses(int numClasses) {
        Predef$.MODULE$.require(numClasses > 1);
        this.numOfLinearPredictor_$eq(numClasses - 1);
        Object object = numClasses > 2 ? this.optimizer().setGradient(new LogisticGradient(numClasses)) : BoxedUnit.UNIT;
        return this;
    }

    @Override
    public LogisticRegressionModel createModel(Vector weights2, double intercept) {
        return this.numOfLinearPredictor() == 1 ? new LogisticRegressionModel(weights2, intercept) : new LogisticRegressionModel(weights2, intercept, this.numFeatures(), this.numOfLinearPredictor() + 1);
    }

    public LogisticRegressionWithLBFGS() {
        this.setFeatureScaling(true);
        this.optimizer = new LBFGS(new LogisticGradient(), new SquaredL2Updater());
        this.validators = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{this.multiLabelValidator()}));
    }
}

