/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import scala.Array$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001b\ti\u0001*\u001b8hK\u001e\u0013\u0018\rZ5f]RT!a\u0001\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011\u0001b\u0012:bI&,g\u000e\u001e\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"a\u0004\u0001\t\u000b]\u0001A\u0011\t\r\u0002\u000f\r|W\u000e];uKR!\u0011\u0004\u000b\u0016-!\u0011QRdH\u0013\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\u0019a\u0017N\\1mO&\u0011A%\t\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005i1\u0013BA\u0014\u001c\u0005\u0019!u.\u001e2mK\")\u0011F\u0006a\u0001?\u0005!A-\u0019;b\u0011\u0015Yc\u00031\u0001&\u0003\u0015a\u0017MY3m\u0011\u0015ic\u00031\u0001 \u0003\u001d9X-[4iiNDQa\u0006\u0001\u0005B=\"R!\n\u00192eMBQ!\u000b\u0018A\u0002}AQa\u000b\u0018A\u0002\u0015BQ!\f\u0018A\u0002}AQ\u0001\u000e\u0018A\u0002}\t1bY;n\u000fJ\fG-[3oi\"\u0012\u0001A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0019\t!\"\u00198o_R\fG/[8o\u0013\tY\u0004H\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public class HingeGradient
extends Gradient {
    @Override
    public Tuple2<Vector, Object> compute(Vector data, double label, Vector weights2) {
        Tuple2 tuple2;
        double labelScaled = (double)2 * label - 1.0;
        double dotProduct = BLAS$.MODULE$.dot(data, weights2);
        if (1.0 > labelScaled * dotProduct) {
            Vector gradient2 = data.copy();
            BLAS$.MODULE$.scal(-labelScaled, gradient2);
            tuple2 = new Tuple2((Object)gradient2, (Object)BoxesRunTime.boxToDouble((double)(1.0 - labelScaled * dotProduct)));
        } else {
            tuple2 = new Tuple2((Object)Vectors$.MODULE$.sparse(weights2.size(), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())), (Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        return tuple2;
    }

    @Override
    public double compute(Vector data, double label, Vector weights2, Vector cumGradient) {
        double d;
        double labelScaled = (double)2 * label - 1.0;
        double dotProduct = BLAS$.MODULE$.dot(data, weights2);
        if (1.0 > labelScaled * dotProduct) {
            BLAS$.MODULE$.axpy(-labelScaled, data, cumGradient);
            d = 1.0 - labelScaled * dotProduct;
        } else {
            d = 0.0;
        }
        return d;
    }
}

