/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.rdd.RandomRDD$;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.mllib.rdd.RandomVectorRDD$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\u0001\u0003\u0001\u0011a!a\u0004*b]\u0012|WNV3di>\u0014(\u000b\u0012#\u000b\u0005\r!\u0011a\u0001:eI*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0004\u001dA\u0011R\"A\b\u000b\u0005\r1\u0011BA\t\u0010\u0005\r\u0011F\t\u0012\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\ta\u0001\\5oC2<\u0017BA\f\u0015\u0005\u00191Vm\u0019;pe\"A\u0011\u0004\u0001B\u0001B\u0003%1$\u0001\u0002tG\u000e\u0001\u0001C\u0001\u000f\u001e\u001b\u00051\u0011B\u0001\u0010\u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!\u0001\u0003A!A!\u0002\u0013\t\u0013\u0001B:ju\u0016\u0004\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012A\u0001T8oO\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0006wK\u000e$xN]*ju\u0016\u0004\"A\t\u0016\n\u0005-\u001a#aA%oi\"AQ\u0006\u0001B\u0001B\u0003%\u0011&A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\t_\u0001\u0011)\u0019!C\u0005a\u0005\u0019!O\\4\u0016\u0003E\u00022AM\u001b8\u001b\u0005\u0019$B\u0001\u001b\u0005\u0003\u0019\u0011\u0018M\u001c3p[&\u0011ag\r\u0002\u0014%\u0006tGm\\7ECR\fw)\u001a8fe\u0006$xN\u001d\t\u0003EaJ!!O\u0012\u0003\r\u0011{WO\u00197f\u0011!Y\u0004A!A!\u0002\u0013\t\u0014\u0001\u0002:oO\u0002B#AO\u001f\u0011\u0005\tr\u0014BA $\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0003C\u0003\u0011\u0019X-\u001a3\u0016\u0003\u0005B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0006g\u0016,G\r\t\u0015\u0003\u0007vBQa\u0012\u0001\u0005\u0002!\u000ba\u0001P5oSRtDcB%L\u00196su\n\u0015\t\u0003\u0015\u0002i\u0011A\u0001\u0005\u00063\u0019\u0003\ra\u0007\u0005\u0006A\u0019\u0003\r!\t\u0005\u0006Q\u0019\u0003\r!\u000b\u0005\u0006[\u0019\u0003\r!\u000b\u0005\u0006_\u0019\u0003\r!\r\u0005\b\u0003\u001a\u0003\n\u00111\u0001\"\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003\u001d\u0019w.\u001c9vi\u0016$2\u0001\u00161f!\r)VL\u0005\b\u0003-ns!a\u0016.\u000e\u0003aS!!\u0017\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013B\u0001/$\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0011%#XM]1u_JT!\u0001X\u0012\t\u000b\u0005\f\u0006\u0019\u00012\u0002\u000fM\u0004H.\u001b;J]B\u0011AdY\u0005\u0003I\u001a\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u000b\u0019\f\u0006\u0019A4\u0002\u000f\r|g\u000e^3yiB\u0011A\u0004[\u0005\u0003S\u001a\u00111\u0002V1tW\u000e{g\u000e^3yi\")1\u000e\u0001C)Y\u0006iq-\u001a;QCJ$\u0018\u000e^5p]N,\u0012!\u001c\t\u0004E9\u0014\u0017BA8$\u0005\u0015\t%O]1z\u000f!\t(!!A\t\u0002\u0011\u0011\u0018a\u0004*b]\u0012|WNV3di>\u0014(\u000b\u0012#\u0011\u0005)\u001bh\u0001C\u0001\u0003\u0003\u0003E\t\u0001\u0002;\u0014\u0007M,\b\u0010\u0005\u0002#m&\u0011qo\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\tJ\u0018B\u0001>$\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001595\u000f\"\u0001})\u0005\u0011\bb\u0002@t#\u0003%\ta`\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005\u0005!fA\u0011\u0002\u0004-\u0012\u0011Q\u0001\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0010\r\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019\"!\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0018M\f\t\u0011\"\u0003\u0002\u001a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\t1\fgn\u001a\u0006\u0003\u0003K\tAA[1wC&!\u0011\u0011FA\u0010\u0005\u0019y%M[3di\u0002")
public class RandomVectorRDD
extends RDD<Vector> {
    private final long size;
    private final int vectorSize;
    private final int numPartitions;
    private final transient RandomDataGenerator<Object> rng;
    private final transient long seed;

    public static long $lessinit$greater$default$6() {
        return RandomVectorRDD$.MODULE$.$lessinit$greater$default$6();
    }

    private RandomDataGenerator<Object> rng() {
        return this.rng;
    }

    private long seed() {
        return this.seed;
    }

    public Iterator<Vector> compute(Partition splitIn, TaskContext context) {
        RandomRDDPartition split = (RandomRDDPartition)splitIn;
        return RandomRDD$.MODULE$.getVectorIterator(split, this.vectorSize);
    }

    public Partition[] getPartitions() {
        return RandomRDD$.MODULE$.getPartitions(this.size, this.numPartitions, this.rng(), this.seed());
    }

    public RandomVectorRDD(SparkContext sc, long size, int vectorSize, int numPartitions, RandomDataGenerator<Object> rng, long seed) {
        this.size = size;
        this.vectorSize = vectorSize;
        this.numPartitions = numPartitions;
        this.rng = rng;
        this.seed = seed;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Vector.class));
        Predef$.MODULE$.require(size > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive RDD size required.";
            }
        });
        Predef$.MODULE$.require(numPartitions > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive number of partitions required";
            }
        });
        Predef$.MODULE$.require(vectorSize > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive vector size required.";
            }
        });
        Predef$.MODULE$.require(package$.MODULE$.ceil((double)size / (double)numPartitions) <= (double)Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition size cannot exceed Int.MaxValue";
            }
        });
    }
}

