/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.rdd.MLPairRDDFunctions$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.apache.spark.rdd.RDD;
import org.json4s.JsonAST;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class MatrixFactorizationModel$
implements Loader<MatrixFactorizationModel>,
Serializable {
    public static final MatrixFactorizationModel$ MODULE$;

    static {
        new MatrixFactorizationModel$();
    }

    public Tuple2<Object, Object>[] org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend(double[] recommendToFeatures, RDD<Tuple2<Object, double[]>> recommendableFeatures, int num) {
        RDD scored = recommendableFeatures.map((Function1)new Serializable(recommendToFeatures){
            public static final long serialVersionUID = 0L;
            private final double[] recommendToFeatures$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, double[]> x0$9) {
                Tuple2<Object, double[]> tuple2 = x0$9;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    double[] features = (double[])tuple2._2();
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(id, BLAS.getInstance().ddot(features.length, this.recommendToFeatures$1, 1, features, 1));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.recommendToFeatures$1 = recommendToFeatures$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])scored.top(num, package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$3) {
                return x$3._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$));
    }

    public RDD<Tuple2<Object, Tuple2<Object, Object>[]>> org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(int rank, RDD<Tuple2<Object, double[]>> srcFeatures, RDD<Tuple2<Object, double[]>> dstFeatures, int num) {
        RDD<Tuple2<int[], DenseMatrix>> srcBlocks = this.blockify(rank, srcFeatures);
        RDD<Tuple2<int[], DenseMatrix>> dstBlocks = this.blockify(rank, dstFeatures);
        RDD ratings = srcBlocks.cartesian(dstBlocks, ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<Object, Tuple2<Object, Object>>> apply(Tuple2<Tuple2<int[], DenseMatrix>, Tuple2<int[], DenseMatrix>> x0$10) {
                Tuple2<Tuple2<int[], DenseMatrix>, Tuple2<int[], DenseMatrix>> tuple2 = x0$10;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int[] srcIds = (int[])tuple22._1();
                        DenseMatrix srcFactors = (DenseMatrix)tuple22._2();
                        if (tuple23 != null) {
                            int[] dstIds = (int[])tuple23._1();
                            DenseMatrix dstFactors = (DenseMatrix)tuple23._2();
                            int m = srcIds.length;
                            int n = dstIds.length;
                            DenseMatrix ratings = srcFactors.transpose().multiply(dstFactors);
                            Tuple2[] output = new Tuple2[m * n];
                            IntRef k = new IntRef(0);
                            ratings.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, srcIds, dstIds, output, k){
                                public static final long serialVersionUID = 0L;
                                private final int[] srcIds$1;
                                private final int[] dstIds$1;
                                private final Tuple2[] output$1;
                                private final IntRef k$1;

                                public final void apply(int i, int j, double r) {
                                    this.output$1[this.k$1.elem] = new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.srcIds$1[i]), (Object)new Tuple2.mcID.sp(this.dstIds$1[j], r));
                                    ++this.k$1.elem;
                                }
                                {
                                    this.srcIds$1 = srcIds$1;
                                    this.dstIds$1 = dstIds$1;
                                    this.output$1 = output$1;
                                    this.k$1 = k$1;
                                }
                            });
                            Seq seq = Predef$.MODULE$.refArrayOps((Object[])output).toSeq();
                            return seq;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return MLPairRDDFunctions$.MODULE$.fromPairRDD(ratings, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class)).topByKey(num, package$.MODULE$.Ordering().by((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$4) {
                return x$4._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$));
    }

    private RDD<Tuple2<int[], DenseMatrix>> blockify(int rank, RDD<Tuple2<Object, double[]>> features) {
        int blockSize = 4096;
        int blockStorage = rank * blockSize;
        return features.mapPartitions((Function1)new Serializable(rank, blockSize, blockStorage){
            public static final long serialVersionUID = 0L;
            public final int rank$1;
            public final int blockSize$1;
            public final int blockStorage$1;

            public final Iterator<Tuple2<int[], DenseMatrix>> apply(Iterator<Tuple2<Object, double[]>> iter) {
                return iter.grouped(this.blockSize$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.blockify.1 $outer;

                    public final Tuple2<int[], DenseMatrix> apply(Seq<Tuple2<Object, double[]>> grouped) {
                        ArrayBuilder ids = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
                        ids.sizeHint(this.$outer.blockSize$1);
                        ArrayBuilder factors = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                        factors.sizeHint(this.$outer.blockStorage$1);
                        IntRef i = new IntRef(0);
                        grouped.foreach((Function1)new Serializable(this, ids, factors, i){
                            public static final long serialVersionUID = 0L;
                            private final ArrayBuilder ids$1;
                            private final ArrayBuilder factors$1;
                            private final IntRef i$1;

                            public final void apply(Tuple2<Object, double[]> x0$11) {
                                Tuple2<Object, double[]> tuple2 = x0$11;
                                if (tuple2 != null) {
                                    int id = tuple2._1$mcI$sp();
                                    double[] factor = (double[])tuple2._2();
                                    this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)id));
                                    this.factors$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps(factor));
                                    ++this.i$1.elem;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.ids$1 = ids$1;
                                this.factors$1 = factors$1;
                                this.i$1 = i$1;
                            }
                        });
                        return new Tuple2(ids.result(), (Object)new DenseMatrix(this.$outer.rank$1, i.elem, (double[])factors.result()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.rank$1 = rank$1;
                this.blockSize$1 = blockSize$1;
                this.blockStorage$1 = blockStorage$1;
            }
        }, features.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MatrixFactorizationModel load(SparkContext sc, String path) {
        Tuple3<String, String, JsonAST.JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
        if (tuple3 != null) {
            void var10_10;
            void var9_9;
            void var8_8;
            Tuple2 tuple2;
            String loadedClassName = (String)tuple3._1();
            String formatVersion = (String)tuple3._2();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)loadedClassName, (Object)formatVersion);
            String loadedClassName2 = (String)tuple22._1();
            String formatVersion2 = (String)tuple22._2();
            String classNameV1_0 = MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.thisClassName();
            Tuple2 tuple23 = new Tuple2((Object)loadedClassName2, (Object)formatVersion2);
            if (tuple23 != null) {
                String string;
                String className = (String)tuple23._1();
                String string2 = string = (String)tuple23._2();
                if (!("1.0" != null ? !"1.0".equals(string2) : string2 != null)) {
                    String string3 = className;
                    String string4 = classNameV1_0;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        MatrixFactorizationModel matrixFactorizationModel = MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.load(sc, path);
                        return matrixFactorizationModel;
                    }
                }
            }
            throw new IOException(new StringBuilder().append((Object)"MatrixFactorizationModel.load did not recognize model with").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(class: ", ", version: ", "). Supported:\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_8, var9_9}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  (", ", 1.0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var10_10}))).toString());
        }
        throw new MatchError(tuple3);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MatrixFactorizationModel$() {
        MODULE$ = this;
    }
}

