/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.util.Locale;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticCostFun;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams$class;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth$class;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0001\u0003\u00015\u0011!\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qAdH\u0013\u0011\u000b=\u0001\"\u0003G\r\u000e\u0003\tI!!\u0005\u0002\u0003/A\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u0016\u0014\bCA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0003\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001b\u0013\tY\"AA\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011q\"H\u0005\u0003=\t\u0011\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0003vi&d\u0017B\u0001\u0013\"\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0004\u0002\u0011%tG/\u001a:oC2L!AK\u0014\u0003\u000f1{wmZ5oO\"AA\u0006\u0001BC\u0002\u0013\u0005S&A\u0002vS\u0012,\u0012A\f\t\u0003_Ur!\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\na\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A'\r\u0015\u0004Wez\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003}m\u0012QaU5oG\u0016\f\u0013\u0001Q\u0001\u0006c9\"d\u0006\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005]\u0005!Q/\u001b3!Q\r\t\u0015h\u0010\u0005\u0006\u000b\u0002!\tAR\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005a9\u0005\"\u0002\u0017E\u0001\u0004q\u0003fA$:\u007f!\u001aA)\u000f&\"\u0003-\u000bQ!\r\u00183]ABQ!\u0012\u0001\u0005\u00025#\u0012\u0001\u0007\u0015\u0004\u0019fz\u0004\"\u0002)\u0001\t\u0003\t\u0016aC:fiJ+w\rU1sC6$\"AU*\u000e\u0003\u0001AQ\u0001V(A\u0002U\u000bQA^1mk\u0016\u0004\"\u0001\r,\n\u0005]\u000b$A\u0002#pk\ndW\rK\u0002Ps)CQA\u0017\u0001\u0005\u0002m\u000b!c]3u\u000b2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[R\u0011!\u000b\u0018\u0005\u0006)f\u0003\r!\u0016\u0015\u00043fz\u0004\"B0\u0001\t\u0003\u0001\u0017AC:fi6\u000b\u00070\u0013;feR\u0011!+\u0019\u0005\u0006)z\u0003\rA\u0019\t\u0003a\rL!\u0001Z\u0019\u0003\u0007%sG\u000fK\u0002_s)CQa\u001a\u0001\u0005\u0002!\faa]3u)>dGC\u0001*j\u0011\u0015!f\r1\u0001VQ\r1\u0017h\u0010\u0005\u0006Y\u0002!\t!\\\u0001\u0010g\u0016$h)\u001b;J]R,'oY3qiR\u0011!K\u001c\u0005\u0006).\u0004\ra\u001c\t\u0003aAL!!]\u0019\u0003\u000f\t{w\u000e\\3b]\"\u001a1.O \t\u000bQ\u0004A\u0011A;\u0002\u0013M,GOR1nS2LHC\u0001*w\u0011\u0015!6\u000f1\u0001/Q\r\u0019\u0018\b_\u0011\u0002s\u0006)!GL\u0019/a!)1\u0010\u0001C\u0001y\u0006\u00112/\u001a;Ti\u0006tG-\u0019:eSj\fG/[8o)\t\u0011V\u0010C\u0003Uu\u0002\u0007q\u000eK\u0002{s}\f#!!\u0001\u0002\u000bErSG\f\u0019\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b\u0005a1/\u001a;UQJ,7\u000f[8mIR\u0019!+!\u0003\t\rQ\u000b\u0019\u00011\u0001VQ\u0011\t\u0019!O@\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012\u0005aq-\u001a;UQJ,7\u000f[8mIV\tQ\u000b\u000b\u0003\u0002\u000eez\bbBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\rg\u0016$x+Z5hQR\u001cu\u000e\u001c\u000b\u0004%\u0006m\u0001B\u0002+\u0002\u0016\u0001\u0007a\u0006K\u0003\u0002\u0016e\ny\"\t\u0002\u0002\"\u0005)\u0011G\f\u001c/a!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012!D:fiRC'/Z:i_2$7\u000fF\u0002S\u0003SAq\u0001VA\u0012\u0001\u0004\tY\u0003\u0005\u00031\u0003[)\u0016bAA\u0018c\t)\u0011I\u001d:bs\"\"\u00111E\u001d\u0000\u0011\u001d\t)\u0004\u0001C!\u0003o\tQbZ3u)\"\u0014Xm\u001d5pY\u0012\u001cXCAA\u0016Q\u0011\t\u0019$O@\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005\u00192/\u001a;BO\u001e\u0014XmZ1uS>tG)\u001a9uQR\u0019!+!\u0011\t\rQ\u000bY\u00041\u0001cQ\u0011\tY$\u000f=\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J\u0005a2/\u001a;M_^,'OQ8v]\u0012\u001cxJ\\\"pK\u001a4\u0017nY5f]R\u001cHc\u0001*\u0002L!9A+!\u0012A\u0002\u00055\u0003cA\n\u0002P%\u0019\u0011\u0011\u000b\u000b\u0003\r5\u000bGO]5yQ\u0015\t)%OA+C\t\t9&A\u00033]Ir\u0003\u0007C\u0004\u0002\\\u0001!\t!!\u0018\u00029M,G/\u00169qKJ\u0014u.\u001e8eg>s7i\\3gM&\u001c\u0017.\u001a8ugR\u0019!+a\u0018\t\u000fQ\u000bI\u00061\u0001\u0002N!*\u0011\u0011L\u001d\u0002V!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014AG:fi2{w/\u001a:C_VtGm](o\u0013:$XM]2faR\u001cHc\u0001*\u0002j!1A+a\u0019A\u0002IAS!a\u0019:\u0003+Bq!a\u001c\u0001\t\u0003\t\t(\u0001\u000etKR,\u0006\u000f]3s\u0005>,h\u000eZ:P]&sG/\u001a:dKB$8\u000fF\u0002S\u0003gBa\u0001VA7\u0001\u0004\u0011\u0002&BA7s\u0005U\u0003bBA=\u0001\u0011%\u00111P\u0001.CN\u001cXM\u001d;C_VtGmQ8ogR\u0014\u0018-\u001b8fI>\u0003H/[7ju\u0006$\u0018n\u001c8QCJ\fWn\u001d,bY&$GCBA?\u0003\u0007\u000b9\tE\u00021\u0003\u007fJ1!!!2\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015\u0015q\u000fa\u0001E\u0006\u0011b.^7D_\u00164g-[2jK:$8+\u001a;t\u0011\u001d\tI)a\u001eA\u0002\t\f1B\\;n\r\u0016\fG/\u001e:fg\"I\u0011Q\u0012\u0001A\u0002\u0013%\u0011qR\u0001\u0010_B$\u0018J\\5uS\u0006dWj\u001c3fYV\u0011\u0011\u0011\u0013\t\u0005a\u0005M\u0015$C\u0002\u0002\u0016F\u0012aa\u00149uS>t\u0007\"CAM\u0001\u0001\u0007I\u0011BAN\u0003My\u0007\u000f^%oSRL\u0017\r\\'pI\u0016dw\fJ3r)\u0011\ti(!(\t\u0015\u0005}\u0015qSA\u0001\u0002\u0004\t\t*A\u0002yIEB\u0001\"a)\u0001A\u0003&\u0011\u0011S\u0001\u0011_B$\u0018J\\5uS\u0006dWj\u001c3fY\u0002B\u0001\"a*\u0001\t\u00031\u0011\u0011V\u0001\u0010g\u0016$\u0018J\\5uS\u0006dWj\u001c3fYR\u0019!+a+\t\u000f\u00055\u0016Q\u0015a\u00013\u0005)Qn\u001c3fY\"A\u0011\u0011\u0017\u0001\u0005R\u0019\t\u0019,A\u0003ue\u0006Lg\u000eF\u0002\u001a\u0003kC\u0001\"a.\u00020\u0002\u0007\u0011\u0011X\u0001\bI\u0006$\u0018m]3ua\u0011\tY,a3\u0011\r\u0005u\u00161YAd\u001b\t\tyLC\u0002\u0002B\u001a\t1a]9m\u0013\u0011\t)-a0\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011ZAf\u0019\u0001!A\"!4\u00026\u0006\u0005\t\u0011!B\u0001\u0003\u001f\u00141a\u0018\u00132#\u0011\t\t.a6\u0011\u0007A\n\u0019.C\u0002\u0002VF\u0012qAT8uQ&tw\rE\u00021\u00033L1!a72\u0005\r\te.\u001f\u0005\t\u0003c\u0003A\u0011\u0003\u0004\u0002`R)\u0011$!9\u0002n\"A\u0011qWAo\u0001\u0004\t\u0019\u000f\r\u0003\u0002f\u0006%\bCBA_\u0003\u0007\f9\u000f\u0005\u0003\u0002J\u0006%H\u0001DAv\u0003C\f\t\u0011!A\u0003\u0002\u0005='aA0%e!9\u0011q^Ao\u0001\u0004y\u0017!\u00055b]\u0012dW\rU3sg&\u001cH/\u001a8dK\"9\u00111\u001f\u0001\u0005B\u0005U\u0018\u0001B2paf$2\u0001GA|\u0011!\tI0!=A\u0002\u0005m\u0018!B3yiJ\f\u0007\u0003BA\u007f\u0005\u0007i!!a@\u000b\u0007\t\u0005A!A\u0003qCJ\fW.\u0003\u0003\u0003\u0006\u0005}(\u0001\u0003)be\u0006lW*\u00199)\t\u0005E\u0018h\u0010\u0015\u0004\u0001eRua\u0002B\u0007\u0005!\u0005!qB\u0001\u0013\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000eE\u0002\u0010\u0005#1a!\u0001\u0002\t\u0002\tM1\u0003\u0003B\t\u0005+\u0011YB!\t\u0011\u0007A\u00129\"C\u0002\u0003\u001aE\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0011\u0003\u001eaI1Aa\b\"\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042\u0001\rB\u0012\u0013\r\u0011)#\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u000b\nEA\u0011\u0001B\u0015)\t\u0011y\u0001\u0003\u0005\u0003.\tEA\u0011\tB\u0018\u0003\u0011aw.\u00193\u0015\u0007a\u0011\t\u0004C\u0004\u00034\t-\u0002\u0019\u0001\u0018\u0002\tA\fG\u000f\u001b\u0015\u0006\u0005WI\u0014q\u0004\u0005\f\u0005s\u0011\tB1A\u0005\u0002\t\u0011Y$\u0001\u000btkB\u0004xN\u001d;fI\u001a\u000bW.\u001b7z\u001d\u0006lWm]\u000b\u0003\u0005{\u0001R\u0001MA\u0017\u0005\u007f\u0001BA!\u0011\u0003L5\u0011!1\t\u0006\u0005\u0005\u000b\u00129%\u0001\u0003mC:<'B\u0001B%\u0003\u0011Q\u0017M^1\n\u0007Y\u0012\u0019\u0005C\u0005\u0003P\tE\u0001\u0015!\u0003\u0003>\u0005)2/\u001e9q_J$X\r\u001a$b[&d\u0017PT1nKN\u0004\u0003B\u0003B*\u0005#\t\t\u0011\"\u0003\u0003V\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u0006\u0005\u0003\u0003B\te\u0013\u0002\u0002B.\u0005\u0007\u0012aa\u00142kK\u000e$\b&\u0002B\ts\u0005}\u0001&\u0002B\u0006s\u0005}\u0001")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable,
Logging {
    private final String uid;
    private Option<LogisticRegressionModel> optInitialModel;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    public static LogisticRegression load(String string) {
        return LogisticRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams$class.getFamily(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams$class.getLowerBoundsOnCoefficients(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams$class.getUpperBoundsOnCoefficients(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams$class.getLowerBoundsOnIntercepts(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams$class.getUpperBoundsOnIntercepts(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams$class.usingBoundConstrainedOptimization(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth$class.getAggregationDepth(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setFamily(String value) {
        return (LogisticRegression)this.set(this.family(), value);
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    public LogisticRegression setAggregationDepth(int value) {
        return (LogisticRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setLowerBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnCoefficients(), value);
    }

    public LogisticRegression setUpperBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.upperBoundsOnCoefficients(), value);
    }

    public LogisticRegression setLowerBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnIntercepts(), value);
    }

    public LogisticRegression setUpperBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.upperBoundsOnIntercepts(), value);
    }

    private void assertBoundConstrainedOptimizationParamsValid(int numCoefficientSets, int numFeatures) {
        if (this.isSet(this.lowerBoundsOnCoefficients())) {
            Predef$.MODULE$.require(this.$(this.lowerBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.lowerBoundsOnCoefficients()).numCols() == numFeatures, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegression $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"The shape of LowerBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.getLowerBoundsOnCoefficients().numRows()), BoxesRunTime.boxToInteger((int)this.$outer.getLowerBoundsOnCoefficients().numCols())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.isSet(this.upperBoundsOnCoefficients())) {
            Predef$.MODULE$.require(this.$(this.upperBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.upperBoundsOnCoefficients()).numCols() == numFeatures, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegression $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"The shape of upperBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.getUpperBoundsOnCoefficients().numRows()), BoxesRunTime.boxToInteger((int)this.$outer.getUpperBoundsOnCoefficients().numCols())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.isSet(this.lowerBoundsOnIntercepts())) {
            Predef$.MODULE$.require(this.$(this.lowerBoundsOnIntercepts()).size() == numCoefficientSets, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegression $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"The size of lowerBoundsOnIntercepts must be equal with 1 for binomial regression, or the number of ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"classes for multinomial regression, but found: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.getLowerBoundsOnIntercepts().size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.isSet(this.upperBoundsOnIntercepts())) {
            Predef$.MODULE$.require(this.$(this.upperBoundsOnIntercepts()).size() == numCoefficientSets, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegression $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"The size of upperBoundsOnIntercepts must be equal with 1 for binomial regression, or the number of ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"classes for multinomial regression, but found: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.getUpperBoundsOnIntercepts().size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.isSet(this.lowerBoundsOnCoefficients()) && this.isSet(this.upperBoundsOnCoefficients())) {
            Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnCoefficients()).toArray()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnCoefficients()).toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x) {
                    return x._1$mcD$sp() <= x._2$mcD$sp();
                }
            }), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegression $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"LowerBoundsOnCoefficients should always be less than or equal to upperBoundsOnCoefficients, but found: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lowerBoundsOnCoefficients = ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getLowerBoundsOnCoefficients()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upperBoundsOnCoefficients = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getUpperBoundsOnCoefficients()}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.isSet(this.lowerBoundsOnIntercepts()) && this.isSet(this.upperBoundsOnIntercepts())) {
            Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnIntercepts()).toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> x) {
                    return x._1$mcD$sp() <= x._2$mcD$sp();
                }
            }), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegression $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"LowerBoundsOnIntercepts should always be less than or equal to upperBoundsOnIntercepts, but found: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lowerBoundsOnIntercepts = ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getLowerBoundsOnIntercepts()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"upperBoundsOnIntercepts = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getUpperBoundsOnIntercepts()}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    private Option<LogisticRegressionModel> optInitialModel() {
        return this.optInitialModel;
    }

    private void optInitialModel_$eq(Option<LogisticRegressionModel> x$1) {
        this.optInitialModel = x$1;
    }

    public LogisticRegression setInitialModel(LogisticRegressionModel model) {
        this.optInitialModel_$eq((Option<LogisticRegressionModel>)new Some((Object)model));
        return this;
    }

    @Override
    public LogisticRegressionModel train(Dataset<?> dataset) {
        StorageLevel storageLevel = dataset.storageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.train(dataset, handlePersistence);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public LogisticRegressionModel train(Dataset<?> dataset, boolean handlePersistence) {
        block31: {
            block34: {
                block38: {
                    block41: {
                        block46: {
                            block47: {
                                block50: {
                                    block49: {
                                        block48: {
                                            block40: {
                                                block45: {
                                                    block44: {
                                                        block43: {
                                                            block42: {
                                                                block39: {
                                                                    block36: {
                                                                        block37: {
                                                                            block35: {
                                                                                block33: {
                                                                                    block32: {
                                                                                        w = this.isDefined(this.weightCol()) != false && this.$(this.weightCol()).isEmpty() == false ? functions$.MODULE$.col(this.$(this.weightCol())) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
                                                                                        instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
                                                                                            public static final long serialVersionUID = 0L;

                                                                                            public final Instance apply(Row x0$1) {
                                                                                                Row row = x0$1;
                                                                                                Some some = Row$.MODULE$.unapplySeq(row);
                                                                                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                                                                                                    Object label = ((SeqLike)some.get()).apply(0);
                                                                                                    Object weight = ((SeqLike)some.get()).apply(1);
                                                                                                    Object features = ((SeqLike)some.get()).apply(2);
                                                                                                    if (label instanceof Double) {
                                                                                                        double d = BoxesRunTime.unboxToDouble((Object)label);
                                                                                                        if (weight instanceof Double) {
                                                                                                            double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                                                                                                            if (features instanceof Vector) {
                                                                                                                Vector vector = (Vector)features;
                                                                                                                Instance instance = new Instance(d, d2, vector);
                                                                                                                return instance;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                                throw new MatchError((Object)row);
                                                                                            }
                                                                                        }, ClassTag$.MODULE$.apply(Instance.class));
                                                                                        v0 /* !! */  = handlePersistence != false ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
                                                                                        instr = Instrumentation$.MODULE$.create(this, instances);
                                                                                        instr.logParams((Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.regParam(), this.elasticNetParam(), this.standardization(), this.threshold(), this.maxIter(), this.tol(), this.fitIntercept()}));
                                                                                        seqOp = new Serializable(this){
                                                                                            public static final long serialVersionUID = 0L;

                                                                                            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c, Instance instance) {
                                                                                                return new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight()));
                                                                                            }
                                                                                        };
                                                                                        combOp = new Serializable(this){
                                                                                            public static final long serialVersionUID = 0L;

                                                                                            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c2) {
                                                                                                return new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2()));
                                                                                            }
                                                                                        };
                                                                                        var8_8 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer()), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
                                                                                        if (var8_8 == null) break block31;
                                                                                        summarizer = (MultivariateOnlineSummarizer)var8_8._1();
                                                                                        labelSummarizer = (MultiClassSummarizer)var8_8._2();
                                                                                        var12_12 = var11_11 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
                                                                                        summarizer = (MultivariateOnlineSummarizer)var12_12._1();
                                                                                        labelSummarizer = (MultiClassSummarizer)var12_12._2();
                                                                                        histogram = labelSummarizer.histogram();
                                                                                        numInvalid = labelSummarizer.countInvalid();
                                                                                        numFeatures = summarizer.mean().size();
                                                                                        numFeaturesPlusIntercept = this.getFitIntercept() != false ? numFeatures + 1 : numFeatures;
                                                                                        var20_19 = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
                                                                                        if (!(var20_19 instanceof Some)) break block32;
                                                                                        var21_20 = (Some)var20_19;
                                                                                        n = BoxesRunTime.unboxToInt((Object)var21_20.x());
                                                                                        var23_22 = n;
                                                                                        Predef$.MODULE$.require(var23_22 >= histogram.length, (Function0)new Serializable(this, histogram, var23_22){
                                                                                            public static final long serialVersionUID = 0L;
                                                                                            private final double[] histogram$1;
                                                                                            private final int x3$1;

                                                                                            public final String apply() {
                                                                                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified number of classes ", " was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x3$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"less than the number of unique labels ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.histogram$1.length)}))).toString();
                                                                                            }
                                                                                            {
                                                                                                this.histogram$1 = histogram$1;
                                                                                                this.x3$1 = x3$1;
                                                                                            }
                                                                                        });
                                                                                        var24_23 = var23_22;
                                                                                        break block33;
                                                                                    }
                                                                                    v1 = None$.MODULE$;
                                                                                    var25_24 = var20_19;
                                                                                    if (v1 != null ? v1.equals(var25_24) == false : var25_24 != null) break block34;
                                                                                    var24_23 = histogram.length;
                                                                                }
                                                                                numClasses = var24_23;
                                                                                var28_27 = var27_26 = this.getFamily().toLowerCase(Locale.ROOT);
                                                                                if ("binomial" != null ? "binomial".equals(var28_27) == false : var28_27 != null) break block35;
                                                                                Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0)new Serializable(this, numClasses){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final int numClasses$1;

                                                                                    public final String apply() {
                                                                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Binomial family only supports 1 or 2 "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"outcome classes but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1)}))).toString();
                                                                                    }
                                                                                    {
                                                                                        this.numClasses$1 = numClasses$1;
                                                                                    }
                                                                                });
                                                                                var29_28 = false;
                                                                                break block36;
                                                                            }
                                                                            var30_29 = var27_26;
                                                                            if ("multinomial" != null ? "multinomial".equals(var30_29) == false : var30_29 != null) break block37;
                                                                            var29_28 = true;
                                                                            break block36;
                                                                        }
                                                                        var31_30 = var27_26;
                                                                        if ("auto" != null ? "auto".equals(var31_30) == false : var31_30 != null) break block38;
                                                                        var29_28 = numClasses > 2;
                                                                    }
                                                                    isMultinomial = var29_28;
                                                                    v2 = numCoefficientSets = isMultinomial != false ? numClasses : 1;
                                                                    if (this.usingBoundConstrainedOptimization()) {
                                                                        this.assertBoundConstrainedOptimizationParamsValid(numCoefficientSets, numFeatures);
                                                                    }
                                                                    if (this.isDefined(this.thresholds())) {
                                                                        Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0)new Serializable(this, numClasses){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final /* synthetic */ LogisticRegression $outer;
                                                                            private final int numClasses$1;

                                                                            public final String apply() {
                                                                                return new StringBuilder().append((Object)this.$outer.getClass().getSimpleName()).append((Object)".train() called with non-matching numClasses and thresholds.length.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numClasses=", ", but thresholds has length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1), BoxesRunTime.boxToInteger((int)this.$outer.$(this.$outer.thresholds()).length)}))).toString();
                                                                            }
                                                                            {
                                                                                if ($outer == null) {
                                                                                    throw new NullPointerException();
                                                                                }
                                                                                this.$outer = $outer;
                                                                                this.numClasses$1 = numClasses$1;
                                                                            }
                                                                        });
                                                                    }
                                                                    instr.logNumClasses(numClasses);
                                                                    instr.logNumFeatures(numFeatures);
                                                                    if (numInvalid != 0L) {
                                                                        msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in [0 to ", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numClasses - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numInvalid)}))).toString();
                                                                        this.logError((Function0<String>)new $anonfun$19(this, msg));
                                                                        throw new SparkException(msg);
                                                                    }
                                                                    v3 = isConstantLabel = Predef$.MODULE$.doubleArrayOps(histogram).count((Function1)new Serializable(this){
                                                                        public static final long serialVersionUID = 0L;

                                                                        public final boolean apply(double x$2) {
                                                                            return this.apply$mcZD$sp(x$2);
                                                                        }

                                                                        public boolean apply$mcZD$sp(double x$2) {
                                                                            return x$2 != 0.0;
                                                                        }
                                                                    }) == 1;
                                                                    if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || !isConstantLabel || this.usingBoundConstrainedOptimization()) break block39;
                                                                    this.logWarning((Function0<String>)new $anonfun$20(this));
                                                                    constantLabelIndex = Vectors$.MODULE$.dense(histogram).argmax();
                                                                    coefMatrix = new SparseMatrix(numCoefficientSets, numFeatures, new int[numCoefficientSets + 1], (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), true).compressed();
                                                                    interceptVec = isMultinomial != false ? Vectors$.MODULE$.sparse(numClasses, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(constantLabelIndex, Infinity)}))) : Vectors$.MODULE$.dense(numClasses == 2 ? Infinity : -Infinity, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                                                                    v4 = new Tuple3((Object)coefMatrix, (Object)interceptVec, Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                                                                    break block40;
                                                                }
                                                                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel) {
                                                                    this.logWarning((Function0<String>)new $anonfun$21(this));
                                                                }
                                                                featuresMean = summarizer.mean().toArray();
                                                                featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(summarizer.variance().toArray()).map((Function1)new Serializable(this){
                                                                    public static final long serialVersionUID = 0L;

                                                                    public final double apply(double x) {
                                                                        return this.apply$mcDD$sp(x);
                                                                    }

                                                                    public double apply$mcDD$sp(double x) {
                                                                        return package$.MODULE$.sqrt(x);
                                                                    }
                                                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                                                                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)new $anonfun$3(this, featuresMean, featuresStd))) {
                                                                    this.logWarning((Function0<String>)new $anonfun$22(this));
                                                                }
                                                                regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                                                                regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                                                                bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                                                                costFun = new LogisticCostFun((RDD<Instance>)instances, numClasses, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), (Broadcast<double[]>)bcFeaturesStd, regParamL2, isMultinomial, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())));
                                                                numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
                                                                if (this.usingBoundConstrainedOptimization()) {
                                                                    lowerBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)new Serializable(this){
                                                                        public static final long serialVersionUID = 0L;

                                                                        public final double apply() {
                                                                            return this.apply$mcD$sp();
                                                                        }

                                                                        public double apply$mcD$sp() {
                                                                            return Double.NEGATIVE_INFINITY;
                                                                        }
                                                                    }, ClassTag$.MODULE$.Double());
                                                                    upperBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)new Serializable(this){
                                                                        public static final long serialVersionUID = 0L;

                                                                        public final double apply() {
                                                                            return this.apply$mcD$sp();
                                                                        }

                                                                        public double apply$mcD$sp() {
                                                                            return Double.POSITIVE_INFINITY;
                                                                        }
                                                                    }, ClassTag$.MODULE$.Double());
                                                                    isSetLowerBoundsOnCoefficients = this.isSet(this.lowerBoundsOnCoefficients());
                                                                    isSetUpperBoundsOnCoefficients = this.isSet(this.upperBoundsOnCoefficients());
                                                                    isSetLowerBoundsOnIntercepts = this.isSet(this.lowerBoundsOnIntercepts());
                                                                    isSetUpperBoundsOnIntercepts = this.isSet(this.upperBoundsOnIntercepts());
                                                                    for (i = 0; i < numCoeffsPlusIntercepts; ++i) {
                                                                        coefficientSetIndex = i % numCoefficientSets;
                                                                        featureIndex = i / numCoefficientSets;
                                                                        if (featureIndex < numFeatures) {
                                                                            if (isSetLowerBoundsOnCoefficients) {
                                                                                lowerBounds[i] = this.$(this.lowerBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex) * featuresStd[featureIndex];
                                                                            }
                                                                            if (!isSetUpperBoundsOnCoefficients) continue;
                                                                            upperBounds[i] = this.$(this.upperBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex) * featuresStd[featureIndex];
                                                                            continue;
                                                                        }
                                                                        if (isSetLowerBoundsOnIntercepts) {
                                                                            lowerBounds[i] = this.$(this.lowerBoundsOnIntercepts()).apply(coefficientSetIndex);
                                                                        }
                                                                        if (!isSetUpperBoundsOnIntercepts) continue;
                                                                        upperBounds[i] = this.$(this.upperBoundsOnIntercepts()).apply(coefficientSetIndex);
                                                                    }
                                                                    v5 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                                                                } else {
                                                                    v5 = var57_54 = new Tuple2(null, null);
                                                                }
                                                                if (var57_54 == null) break block41;
                                                                lowerBounds = (double[])var57_54._1();
                                                                upperBounds = (double[])var57_54._2();
                                                                var61_58 = var60_57 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                                                                lowerBounds = (double[])var61_58._1();
                                                                upperBounds = (double[])var61_58._2();
                                                                if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) != 0.0 && BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) != 0.0) break block42;
                                                                if (lowerBounds == null) ** GOTO lbl-1000
                                                                if (upperBounds != null) {
                                                                    v6 = new LBFGSB(DenseVector$.MODULE$.apply$mDc$sp(lowerBounds), DenseVector$.MODULE$.apply$mDc$sp(upperBounds), BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7());
                                                                } else lbl-1000:
                                                                // 2 sources

                                                                {
                                                                    v6 = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
                                                                }
                                                                break block43;
                                                            }
                                                            standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
                                                            v6 = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, numCoefficientSets, featuresStd, regParamL1, standardizationParam), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
                                                        }
                                                        optimizer = v6;
                                                        initialCoefWithInterceptMatrix = Matrices$.MODULE$.zeros(numCoefficientSets, numFeaturesPlusIntercept);
                                                        var67_64 = this.optInitialModel();
                                                        if (!(var67_64 instanceof Some)) break block44;
                                                        var68_65 = (Some)var67_64;
                                                        _initialModel = (LogisticRegressionModel)var68_65.x();
                                                        providedCoefs = _initialModel.coefficientMatrix();
                                                        v7 = modelIsValid = providedCoefs.numRows() == numCoefficientSets && providedCoefs.numCols() == numFeatures && _initialModel.interceptVector().size() == numCoefficientSets && _initialModel.getFitIntercept() == BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()));
                                                        if (!modelIsValid) {
                                                            this.logWarning((Function0<String>)new Serializable(this, numFeatures, numCoefficientSets, providedCoefs){
                                                                public static final long serialVersionUID = 0L;
                                                                private final int numFeatures$1;
                                                                private final int numCoefficientSets$1;
                                                                private final Matrix providedCoefs$1;

                                                                public final String apply() {
                                                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial coefficients will be ignored! Its dimensions "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", ") did not match the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.providedCoefs$1.numRows()), BoxesRunTime.boxToInteger((int)this.providedCoefs$1.numCols())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected size (", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numCoefficientSets$1), BoxesRunTime.boxToInteger((int)this.numFeatures$1)}))).toString();
                                                                }
                                                                {
                                                                    this.numFeatures$1 = numFeatures$1;
                                                                    this.numCoefficientSets$1 = numCoefficientSets$1;
                                                                    this.providedCoefs$1 = providedCoefs$1;
                                                                }
                                                            });
                                                        }
                                                        var72_69 = modelIsValid;
                                                        break block45;
                                                    }
                                                    v8 = None$.MODULE$;
                                                    var73_70 = var67_64;
                                                    if (v8 != null ? v8.equals(var73_70) == false : var73_70 != null) break block46;
                                                    var72_69 = false;
                                                }
                                                initialModelIsValid = var72_69;
                                                if (initialModelIsValid) {
                                                    providedCoef = ((LogisticRegressionModel)this.optInitialModel().get()).coefficientMatrix();
                                                    providedCoef.foreachActive((Function3)new $anonfun$24(this, featuresStd, initialCoefWithInterceptMatrix));
                                                    if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                                                        ((LogisticRegressionModel)this.optInitialModel().get()).interceptVector().foreachActive((Function2)new $anonfun$6(this, numFeatures, initialCoefWithInterceptMatrix));
                                                    }
                                                } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial) {
                                                    rawIntercepts = (double[])Predef$.MODULE$.doubleArrayOps(histogram).map((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final double apply(double c) {
                                                            return this.apply$mcDD$sp(c);
                                                        }

                                                        public double apply$mcDD$sp(double c) {
                                                            return package$.MODULE$.log(c + 1.0);
                                                        }
                                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                                                    rawMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(rawIntercepts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rawIntercepts.length;
                                                    Predef$.MODULE$.doubleArrayOps(rawIntercepts).indices().foreach$mVc$sp((Function1)new $anonfun$8(this, numFeatures, initialCoefWithInterceptMatrix, rawIntercepts, rawMean));
                                                } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                                                    initialCoefWithInterceptMatrix.update(0, numFeatures, package$.MODULE$.log(histogram[1] / histogram[0]));
                                                }
                                                if (this.usingBoundConstrainedOptimization()) {
                                                    for (i = 0; i < numCoeffsPlusIntercepts; ++i) {
                                                        coefficientSetIndex = i % numCoefficientSets;
                                                        featureIndex = i / numCoefficientSets;
                                                        if (initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex) < lowerBounds[i]) {
                                                            initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex, lowerBounds[i]);
                                                            continue;
                                                        }
                                                        if (!(initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex) > upperBounds[i])) continue;
                                                        initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex, upperBounds[i]);
                                                    }
                                                }
                                                states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialCoefWithInterceptMatrix.toArray()));
                                                arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                                                state = null;
                                                while (states.hasNext()) {
                                                    state = (FirstOrderMinimizer.State)states.next();
                                                    arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
                                                }
                                                bcFeaturesStd.destroy(false);
                                                if (state == null) {
                                                    msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                                                    this.logError((Function0<String>)new $anonfun$25(this, msg));
                                                    throw new SparkException(msg);
                                                }
                                                allCoefficients = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
                                                allCoefMatrix = new DenseMatrix(numCoefficientSets, numFeaturesPlusIntercept, allCoefficients);
                                                denseCoefficientMatrix = new DenseMatrix(numCoefficientSets, numFeatures, new double[numCoefficientSets * numFeatures], true);
                                                interceptVec = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) == false && isMultinomial != false ? Vectors$.MODULE$.sparse(numCoefficientSets, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)) : Vectors$.MODULE$.zeros(numCoefficientSets);
                                                allCoefMatrix.foreachActive((Function3)new $anonfun$26(this, numFeatures, featuresStd, denseCoefficientMatrix, interceptVec));
                                                if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                                                    centers = (double[])Array$.MODULE$.fill(numFeatures, (Function0)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final double apply() {
                                                            return this.apply$mcD$sp();
                                                        }

                                                        public double apply$mcD$sp() {
                                                            return 0.0;
                                                        }
                                                    }, ClassTag$.MODULE$.Double());
                                                    denseCoefficientMatrix.foreachActive((Function3)new $anonfun$27(this, centers));
                                                    Predef$.MODULE$.wrapDoubleArray(centers).transform((Function1)new $anonfun$10(this, numCoefficientSets));
                                                    denseCoefficientMatrix.foreachActive((Function3)new $anonfun$28(this, denseCoefficientMatrix, centers));
                                                }
                                                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                                                    interceptArray = interceptVec.toArray();
                                                    interceptMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(interceptArray).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)interceptArray.length;
                                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), interceptVec.size()).foreach$mVc$sp((Function1)new $anonfun$11(this, interceptArray, interceptMean));
                                                }
                                                v4 = var94_89 = new Tuple3((Object)denseCoefficientMatrix.compressed(), (Object)interceptVec.compressed(), arrayBuilder.result());
                                            }
                                            if (var94_89 == null) break block47;
                                            coefficientMatrix = (Matrix)var94_89._1();
                                            interceptVector = (Vector)var94_89._2();
                                            objectiveHistory = (double[])var94_89._3();
                                            var99_94 = var98_93 = new Tuple3((Object)coefficientMatrix, (Object)interceptVector, (Object)objectiveHistory);
                                            coefficientMatrix = (Matrix)var99_94._1();
                                            interceptVector = (Vector)var99_94._2();
                                            objectiveHistory = (double[])var99_94._3();
                                            v9 /* !! */  = handlePersistence != false ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                                            model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial), this.copyValues$default$2());
                                            if (!isMultinomial) break block48;
                                            v10 = model;
                                            break block49;
                                        }
                                        var104_99 = model.findSummaryModelAndProbabilityCol();
                                        if (var104_99 == null) break block50;
                                        summaryModel = (LogisticRegressionModel)var104_99._1();
                                        probabilityColName = (String)var104_99._2();
                                        var108_103 = var107_102 = new Tuple2((Object)summaryModel, (Object)probabilityColName);
                                        summaryModel = (LogisticRegressionModel)var108_103._1();
                                        probabilityColName = (String)var108_103._2();
                                        logRegSummary = new BinaryLogisticRegressionTrainingSummary(summaryModel.transform(dataset), probabilityColName, this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory);
                                        v10 = model.setSummary((Option<LogisticRegressionTrainingSummary>)new Some((Object)logRegSummary));
                                    }
                                    m = v10;
                                    instr.logSuccess(m);
                                    return m;
                                }
                                throw new MatchError(var104_99);
                            }
                            throw new MatchError((Object)var94_89);
                        }
                        throw new MatchError(var67_64);
                    }
                    throw new MatchError((Object)var57_54);
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported family: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var27_26})));
            }
            throw new MatchError(var20_19);
        }
        throw new MatchError((Object)var8_8);
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    private final Function1 regParamL1Fun$1(int numFeatures$1, int numCoefficientSets$1, double[] featuresStd$1, double regParamL1$1, boolean standardizationParam$1) {
        return new Serializable(this, numFeatures$1, numCoefficientSets$1, featuresStd$1, regParamL1$1, standardizationParam$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegression $outer;
            private final int numFeatures$1;
            private final int numCoefficientSets$1;
            private final double[] featuresStd$1;
            private final double regParamL1$1;
            private final boolean standardizationParam$1;

            public final double apply(int index2) {
                return this.apply$mcDI$sp(index2);
            }

            public double apply$mcDI$sp(int index2) {
                int featureIndex;
                boolean isIntercept;
                boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.fitIntercept())) && index2 >= this.numFeatures$1 * this.numCoefficientSets$1;
                return isIntercept ? 0.0 : (this.standardizationParam$1 ? this.regParamL1$1 : (this.featuresStd$1[featureIndex = index2 / this.numCoefficientSets$1] != 0.0 ? this.regParamL1$1 / this.featuresStd$1[featureIndex] : 0.0));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numFeatures$1 = numFeatures$1;
                this.numCoefficientSets$1 = numCoefficientSets$1;
                this.featuresStd$1 = featuresStd$1;
                this.regParamL1$1 = regParamL1$1;
                this.standardizationParam$1 = standardizationParam$1;
            }
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        HasAggregationDepth$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.family().$minus$greater("auto")}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
        this.optInitialModel = None$.MODULE$;
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

