/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public abstract class AFTSurvivalRegressionParams$class {
    public static String getCensorCol(AFTSurvivalRegressionParams $this) {
        return $this.$($this.censorCol());
    }

    public static double[] getQuantileProbabilities(AFTSurvivalRegressionParams $this) {
        return $this.$($this.quantileProbabilities());
    }

    public static String getQuantilesCol(AFTSurvivalRegressionParams $this) {
        return $this.$($this.quantilesCol());
    }

    public static boolean hasQuantilesCol(AFTSurvivalRegressionParams $this) {
        return $this.isDefined($this.quantilesCol()) && new StringOps(Predef$.MODULE$.augmentString($this.$($this.quantilesCol()))).nonEmpty();
    }

    public static StructType validateAndTransformSchema(AFTSurvivalRegressionParams $this, StructType schema, boolean fitting) {
        SchemaUtils$.MODULE$.checkColumnType(schema, $this.$($this.featuresCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
        if (fitting) {
            SchemaUtils$.MODULE$.checkNumericType(schema, $this.$($this.censorCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
            SchemaUtils$.MODULE$.checkNumericType(schema, (String)$this.$($this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        }
        StructType schemaWithQuantilesCol = $this.hasQuantilesCol() ? SchemaUtils$.MODULE$.appendColumn(schema, $this.$($this.quantilesCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.appendColumn$default$4()) : schema;
        return SchemaUtils$.MODULE$.appendColumn(schemaWithQuantilesCol, (String)$this.$($this.predictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public static void $init$(AFTSurvivalRegressionParams $this) {
        $this.org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(new Param($this, "censorCol", "censor column name"));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.censorCol().$minus$greater("censor")}));
        $this.org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(new DoubleArrayParam($this, "quantileProbabilities", "quantile probabilities array", (Function1<double[], Object>)new AFTSurvivalRegressionParams$.anonfun.4($this)));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.quantileProbabilities().$minus$greater(new double[]{0.01, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 0.99})}));
        $this.org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(new Param($this, "quantilesCol", "quantiles column name"));
    }
}

