/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.util.Locale;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5h\u0001B\u0001\u0003\u00015\u00111\u0001\u0014#B\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017BA\r\u0017\u0005\u001daunZ4j]\u001eD\u0001b\u0007\u0001\u0003\u0002\u0004%I\u0001H\u0001\u0002WV\tQ\u0004\u0005\u0002\u0010=%\u0011q\u0004\u0005\u0002\u0004\u0013:$\b\u0002C\u0011\u0001\u0005\u0003\u0007I\u0011\u0002\u0012\u0002\u000b-|F%Z9\u0015\u0005\r2\u0003CA\b%\u0013\t)\u0003C\u0001\u0003V]&$\bbB\u0014!\u0003\u0003\u0005\r!H\u0001\u0004q\u0012\n\u0004\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0015B\u000f\u0002\u0005-\u0004\u0003\u0002C\u0016\u0001\u0005\u0003\u0007I\u0011\u0002\u000f\u0002\u001b5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t\u0011!i\u0003A!a\u0001\n\u0013q\u0013!E7bq&#XM]1uS>t7o\u0018\u0013fcR\u00111e\f\u0005\bO1\n\t\u00111\u0001\u001e\u0011!\t\u0004A!A!B\u0013i\u0012AD7bq&#XM]1uS>t7\u000f\t\u0005\tg\u0001\u0011\t\u0019!C\u0005i\u0005\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001\bB\u0001\u0007Y&t\u0017\r\\4\n\u0005i:$A\u0002,fGR|'\u000f\u0003\u0005=\u0001\t\u0005\r\u0011\"\u0003>\u0003Q!wnY\"p]\u000e,g\u000e\u001e:bi&|gn\u0018\u0013fcR\u00111E\u0010\u0005\bOm\n\t\u00111\u00016\u0011!\u0001\u0005A!A!B\u0013)\u0014!\u00053pG\u000e{gnY3oiJ\fG/[8oA!A!\t\u0001BA\u0002\u0013%1)\u0001\nu_BL7mQ8oG\u0016tGO]1uS>tW#\u0001#\u0011\u0005=)\u0015B\u0001$\u0011\u0005\u0019!u.\u001e2mK\"A\u0001\n\u0001BA\u0002\u0013%\u0011*\u0001\fu_BL7mQ8oG\u0016tGO]1uS>tw\fJ3r)\t\u0019#\nC\u0004(\u000f\u0006\u0005\t\u0019\u0001#\t\u00111\u0003!\u0011!Q!\n\u0011\u000b1\u0003^8qS\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002B\u0001B\u0014\u0001\u0003\u0002\u0004%IaT\u0001\u0005g\u0016,G-F\u0001Q!\ty\u0011+\u0003\u0002S!\t!Aj\u001c8h\u0011!!\u0006A!a\u0001\n\u0013)\u0016\u0001C:fK\u0012|F%Z9\u0015\u0005\r2\u0006bB\u0014T\u0003\u0003\u0005\r\u0001\u0015\u0005\t1\u0002\u0011\t\u0011)Q\u0005!\u0006)1/Z3eA!A!\f\u0001BA\u0002\u0013%A$\u0001\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0007\u0002\u0003/\u0001\u0005\u0003\u0007I\u0011B/\u0002-\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\0%KF$\"a\t0\t\u000f\u001dZ\u0016\u0011!a\u0001;!A\u0001\r\u0001B\u0001B\u0003&Q$A\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0007\u0005\u0003\u0005c\u0001\t\u0005\r\u0011\"\u0003d\u00031aG-Y(qi&l\u0017N_3s+\u0005!\u0007CA3g\u001b\u0005\u0011\u0011BA4\u0003\u00051aE)Q(qi&l\u0017N_3s\u0011!I\u0007A!a\u0001\n\u0013Q\u0017\u0001\u00057eC>\u0003H/[7ju\u0016\u0014x\fJ3r)\t\u00193\u000eC\u0004(Q\u0006\u0005\t\u0019\u00013\t\u00115\u0004!\u0011!Q!\n\u0011\fQ\u0002\u001c3b\u001fB$\u0018.\\5{KJ\u0004\u0003\"B8\u0001\t\u0013\u0001\u0018A\u0002\u001fj]&$h\b\u0006\u0005reN$XO^<y!\t)\u0007\u0001C\u0003\u001c]\u0002\u0007Q\u0004C\u0003,]\u0002\u0007Q\u0004C\u00034]\u0002\u0007Q\u0007C\u0003C]\u0002\u0007A\tC\u0003O]\u0002\u0007\u0001\u000bC\u0003[]\u0002\u0007Q\u0004C\u0003c]\u0002\u0007A\rC\u0003p\u0001\u0011\u0005!\u0010F\u0001rQ\u0011IH0!\u0002\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyh!\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001\u007f\u0005\u0015\u0019\u0016N\\2fC\t\t9!A\u00032]Mr\u0003\u0007\u0003\u0004\u0002\f\u0001!\t\u0001H\u0001\u0005O\u0016$8\nK\u0003\u0002\nq\f)\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\tM,Go\u0013\u000b\u0005\u0003+\t9\"D\u0001\u0001\u0011\u0019Y\u0012q\u0002a\u0001;!*\u0011q\u0002?\u0002\u0006!1\u0011Q\u0004\u0001\u0005\u0002Q\nQdZ3u\u0003NLX.\\3ue&\u001cGi\\2D_:\u001cWM\u001c;sCRLwN\u001c\u0015\u0006\u00037a\u0018\u0011E\u0011\u0003\u0003G\tQ!\r\u00186]ABa!a\n\u0001\t\u0003\u0019\u0015aE4fi\u0012{7mQ8oG\u0016tGO]1uS>t\u0007&BA\u0013y\u0006\u0015\u0001bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0014g\u0016$Hi\\2D_:\u001cWM\u001c;sCRLwN\u001c\u000b\u0005\u0003+\t\t\u0004\u0003\u00044\u0003W\u0001\r!\u000e\u0015\u0006\u0003Wa\u0018\u0011\u0005\u0005\b\u0003[\u0001A\u0011AA\u001c)\u0011\t)\"!\u000f\t\rM\n)\u00041\u0001EQ\u0015\t)\u0004`A\u0003\u0011\u0019\ty\u0004\u0001C\u0001i\u0005\u0011r-\u001a;BgflW.\u001a;sS\u000e\fE\u000e\u001d5bQ\u0015\ti\u0004`A\u0011\u0011\u0019\t)\u0005\u0001C\u0001\u0007\u0006Aq-\u001a;BYBD\u0017\rK\u0003\u0002Dq\f)\u0001C\u0004\u0002L\u0001!\t!!\u0014\u0002\u0011M,G/\u00117qQ\u0006$B!!\u0006\u0002P!9\u0011\u0011KA%\u0001\u0004)\u0014!B1ma\"\f\u0007&BA%y\u0006\u0005\u0002bBA&\u0001\u0011\u0005\u0011q\u000b\u000b\u0005\u0003+\tI\u0006C\u0004\u0002R\u0005U\u0003\u0019\u0001#)\u000b\u0005UC0!\u0002\t\r\u0005}\u0003\u0001\"\u0001D\u0003U9W\r\u001e+pa&\u001c7i\u001c8dK:$(/\u0019;j_:DS!!\u0018}\u0003\u000bAq!!\u001a\u0001\t\u0003\t9'A\u000btKR$v\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\u0015\t\u0005U\u0011\u0011\u000e\u0005\u0007\u0005\u0006\r\u0004\u0019\u0001#)\u000b\u0005\rD0!\u0002\t\r\u0005=\u0004\u0001\"\u0001D\u0003\u001d9W\r\u001e\"fi\u0006DS!!\u001c}\u0003\u000bAq!!\u001e\u0001\t\u0003\t9(A\u0004tKR\u0014U\r^1\u0015\t\u0005U\u0011\u0011\u0010\u0005\b\u0003w\n\u0019\b1\u0001E\u0003\u0011\u0011W\r^1)\u000b\u0005MD0!\u0002\t\r\u0005\u0005\u0005\u0001\"\u0001\u001d\u0003A9W\r^'bq&#XM]1uS>t7\u000fK\u0003\u0002\u0000q\f)\u0001C\u0004\u0002\b\u0002!\t!!#\u0002!M,G/T1y\u0013R,'/\u0019;j_:\u001cH\u0003BA\u000b\u0003\u0017CaaKAC\u0001\u0004i\u0002&BACy\u0006\u0015\u0001BBAI\u0001\u0011\u0005q*A\u0004hKR\u001cV-\u001a3)\u000b\u0005=E0!\u0002\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u000691/\u001a;TK\u0016$G\u0003BA\u000b\u00037CaATAK\u0001\u0004\u0001\u0006&BAKy\u0006\u0015\u0001BBAQ\u0001\u0011\u0005A$A\u000bhKR\u001c\u0005.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197)\u000b\u0005}E0!\u0002\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u0006)2/\u001a;DQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dG\u0003BA\u000b\u0003WCaAWAS\u0001\u0004i\u0002&BASy\u0006\u0015\u0001BBAY\u0001\u0011\u00051-\u0001\u0007hKR|\u0005\u000f^5nSj,'\u000f\u000b\u0003\u00020\u0006U\u0006cA?\u00028&\u0019\u0011\u0011\u0018@\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5)\u000b\u0005=F0!0\"\u0005\u0005}\u0016!B\u0019/i9\u0002\u0004bBAb\u0001\u0011\u0005\u0011QY\u0001\rg\u0016$x\n\u001d;j[&TXM\u001d\u000b\u0005\u0003+\t9\rC\u0004\u0002J\u0006\u0005\u0007\u0019\u00013\u0002\u0013=\u0004H/[7ju\u0016\u0014\b\u0006BAa\u0003kCS!!1}\u0003{Cq!a1\u0001\t\u0003\t\t\u000e\u0006\u0003\u0002\u0016\u0005M\u0007\u0002CAk\u0003\u001f\u0004\r!a6\u0002\u001b=\u0004H/[7ju\u0016\u0014h*Y7f!\u0011\tI.a8\u000f\u0007=\tY.C\u0002\u0002^B\ta\u0001\u0015:fI\u00164\u0017\u0002BAq\u0003G\u0014aa\u0015;sS:<'bAAo!!*\u0011q\u001a?\u0002>\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\u0018a\u0001:v]R!\u0011Q^Az!\r)\u0017q^\u0005\u0004\u0003c\u0014!\u0001\u0003'E\u00036{G-\u001a7\t\u0011\u0005U\u0018q\u001da\u0001\u0003o\f\u0011\u0002Z8dk6,g\u000e^:\u0011\r\u0005e\u0018q B\u0002\u001b\t\tYPC\u0002\u0002~\u001a\t1A\u001d3e\u0013\u0011\u0011\t!a?\u0003\u0007I#E\tE\u0003\u0010\u0005\u000b\u0001V'C\u0002\u0003\bA\u0011a\u0001V;qY\u0016\u0014\u0004&BAty\u0006\u0015\u0001bBAu\u0001\u0011\u0005!Q\u0002\u000b\u0005\u0003[\u0014y\u0001\u0003\u0005\u0002v\n-\u0001\u0019\u0001B\t!\u001d\u0011\u0019B!\b\u0003\"Uj!A!\u0006\u000b\t\t]!\u0011D\u0001\u0005U\u00064\u0018MC\u0002\u0003\u001c\u0019\t1!\u00199j\u0013\u0011\u0011yB!\u0006\u0003\u0017)\u000bg/\u0019)bSJ\u0014F\t\u0012\t\u0005\u0005G\u0011Y#\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003\u0011a\u0017M\\4\u000b\u0005\t]\u0011b\u0001*\u0003&!*!1\u0002?\u0002\u0006!\"\u0001\u0001`A\u0003\u000f!\u0011\u0019D\u0001E\u0001\u0005\tU\u0012a\u0001'E\u0003B\u0019QMa\u000e\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0003:M\u0019!q\u0007\b\t\u000f=\u00149\u0004\"\u0001\u0003>Q\u0011!QG\u0003\t\u0005\u0003\u00129\u0004\u0001\u0002\u0003D\tYAk\u001c9jG\u000e{WO\u001c;t!\u0015\u0011)E!\u0014E\u001b\t\u00119EC\u00029\u0005\u0013R!Aa\u0013\u0002\r\t\u0014X-\u001a>f\u0013\u0011\u0011yEa\u0012\u0003\u0017\u0011+gn]3WK\u000e$xN]\u0003\b\u0005'\u00129\u0004\u0001\u0002E\u0005)!vn[3o\u0007>,h\u000e\u001e\u0005\n\u0005/\u00129\u0004\"\u0001\u0003\u00053\n!\u0002^3s[JJg\u000eZ3y)\r\u0001&1\f\u0005\b\u0005;\u0012)\u00061\u0001\u001e\u0003\u0011!XM]7\t\u0013\t\u0005$q\u0007C\u0001\u0005\t\r\u0014AC5oI\u0016D(\u0007^3s[R\u0019QD!\u001a\t\u000f\t\u001d$q\fa\u0001!\u0006IA/\u001a:n\u0013:$W\r\u001f\u0005\n\u0005W\u00129\u0004\"\u0001\u0003\u0005[\n\u0001#[:E_\u000e,X.\u001a8u-\u0016\u0014H/\u001a=\u0015\t\t=$Q\u000f\t\u0004\u001f\tE\u0014b\u0001B:!\t9!i\\8mK\u0006t\u0007\u0002\u0003B<\u0005S\u0002\rA!\u001f\u0002\u0003Y\u0004DAa\u001f\u0003*B9qB!\u0002\u0003~\t\u0015\u0006\u0003\u0002B@\u0005?sAA!!\u0003\u001a:!!1\u0011BK\u001d\u0011\u0011)Ia%\u000f\t\t\u001d%\u0011\u0013\b\u0005\u0005\u0013\u0013y)\u0004\u0002\u0003\f*\u0019!Q\u0012\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u0003\u0018\u001a\taa\u001a:ba\"D\u0018\u0002\u0002BN\u0005;\u000bq\u0001]1dW\u0006<WMC\u0002\u0003\u0018\u001aIAA!)\u0003$\nAa+\u001a:uKbLEM\u0003\u0003\u0003\u001c\nu\u0005\u0003\u0002BT\u0005Sc\u0001\u0001\u0002\u0007\u0003,\nU\u0014\u0011!A\u0001\u0006\u0003\u0011iKA\u0002`IE\nBAa,\u00036B\u0019qB!-\n\u0007\tM\u0006CA\u0004O_RD\u0017N\\4\u0011\u0007=\u00119,C\u0002\u0003:B\u00111!\u00118z\u0011%\u0011iLa\u000e\u0005\u0002\t\u0011y,\u0001\u0007jgR+'/\u001c,feR,\u0007\u0010\u0006\u0003\u0003p\t\u0005\u0007\u0002\u0003B<\u0005w\u0003\rAa11\t\t\u0015'\u0011\u001a\t\b\u001f\t\u0015!Q\u0010Bd!\u0011\u00119K!3\u0005\u0019\t-'\u0011YA\u0001\u0002\u0003\u0015\tA!,\u0003\u0007}##\u0007C\u0005\u0003P\n]B\u0011\u0001\u0002\u0003R\u0006i1m\\7qkR,\u0007\u000bV8qS\u000e$bBa5\u0003X\nm'q\u001cBr\u0005O\u0014Y\u000f\u0005\u0003\u0003V\n}RB\u0001B\u001c\u0011!\u0011IN!4A\u0002\tM\u0017A\u00043pGR{\u0007/[2D_VtGo\u001d\u0005\t\u0005;\u0014i\r1\u0001\u0003T\u0006yA/\u001a:n)>\u0004\u0018nY\"pk:$8\u000f\u0003\u0005\u0003b\n5\u0007\u0019\u0001Bj\u0003A!x\u000e^1m)>\u0004\u0018nY\"pk:$8\u000fC\u0004\u0003f\n5\u0007\u0019A\u000f\u0002\u0013Y|7-\u00192TSj,\u0007b\u0002Bu\u0005\u001b\u0004\r\u0001R\u0001\u0004KR\f\u0007bBA)\u0005\u001b\u0004\r\u0001\u0012")
public class LDA
implements Logging {
    private int org$apache$spark$mllib$clustering$LDA$$k;
    private int maxIterations;
    private Vector docConcentration;
    private double topicConcentration;
    private long seed;
    private int checkpointInterval;
    private LDAOptimizer ldaOptimizer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int org$apache$spark$mllib$clustering$LDA$$k() {
        return this.org$apache$spark$mllib$clustering$LDA$$k;
    }

    private void org$apache$spark$mllib$clustering$LDA$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$LDA$$k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private Vector docConcentration() {
        return this.docConcentration;
    }

    private void docConcentration_$eq(Vector x$1) {
        this.docConcentration = x$1;
    }

    private double topicConcentration() {
        return this.topicConcentration;
    }

    private void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int checkpointInterval() {
        return this.checkpointInterval;
    }

    private void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    private LDAOptimizer ldaOptimizer() {
        return this.ldaOptimizer;
    }

    private void ldaOptimizer_$eq(LDAOptimizer x$1) {
        this.ldaOptimizer = x$1;
    }

    public int getK() {
        return this.org$apache$spark$mllib$clustering$LDA$$k();
    }

    public LDA setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA k (number of clusters) must be > 0, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.org$apache$spark$mllib$clustering$LDA$$k_$eq(k);
        return this;
    }

    public Vector getAsymmetricDocConcentration() {
        return this.docConcentration();
    }

    public double getDocConcentration() {
        double d;
        double parameter = this.docConcentration().apply(0);
        if (this.docConcentration().size() == 1) {
            d = parameter;
        } else {
            Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps(this.docConcentration().toArray()).forall((Function1)new Serializable(this, parameter){
                public static final long serialVersionUID = 0L;
                private final double parameter$1;

                public final boolean apply(double x$1) {
                    return this.apply$mcZD$sp(x$1);
                }

                public boolean apply$mcZD$sp(double x$1) {
                    return x$1 == this.parameter$1;
                }
                {
                    this.parameter$1 = parameter$1;
                }
            }));
            d = parameter;
        }
        return d;
    }

    public LDA setDocConcentration(Vector docConcentration) {
        Predef$.MODULE$.require(docConcentration.size() == 1 || docConcentration.size() == this.org$apache$spark$mllib$clustering$LDA$$k(), (Function0)new Serializable(this, docConcentration){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDA $outer;
            private final Vector docConcentration$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size of docConcentration must be 1 or ", " but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$clustering$LDA$$k()), BoxesRunTime.boxToInteger((int)this.docConcentration$1.size())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.docConcentration$1 = docConcentration$1;
            }
        });
        this.docConcentration_$eq(docConcentration);
        return this;
    }

    public LDA setDocConcentration(double docConcentration) {
        this.docConcentration_$eq(Vectors$.MODULE$.dense(docConcentration, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])));
        return this;
    }

    public Vector getAsymmetricAlpha() {
        return this.getAsymmetricDocConcentration();
    }

    public double getAlpha() {
        return this.getDocConcentration();
    }

    public LDA setAlpha(Vector alpha) {
        return this.setDocConcentration(alpha);
    }

    public LDA setAlpha(double alpha) {
        return this.setDocConcentration(alpha);
    }

    public double getTopicConcentration() {
        return this.topicConcentration();
    }

    public LDA setTopicConcentration(double topicConcentration) {
        this.topicConcentration_$eq(topicConcentration);
        return this;
    }

    public double getBeta() {
        return this.getTopicConcentration();
    }

    public LDA setBeta(double beta) {
        return this.setTopicConcentration(beta);
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public LDA setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0)new Serializable(this, maxIterations){
            public static final long serialVersionUID = 0L;
            private final int maxIterations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum of iterations must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}));
            }
            {
                this.maxIterations$1 = maxIterations$1;
            }
        });
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public LDA setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public int getCheckpointInterval() {
        return this.checkpointInterval();
    }

    public LDA setCheckpointInterval(int checkpointInterval) {
        Predef$.MODULE$.require(checkpointInterval == -1 || checkpointInterval > 0, (Function0)new Serializable(this, checkpointInterval){
            public static final long serialVersionUID = 0L;
            private final int checkpointInterval$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Period between checkpoints must be -1 or positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.checkpointInterval$1)}));
            }
            {
                this.checkpointInterval$1 = checkpointInterval$1;
            }
        });
        this.checkpointInterval_$eq(checkpointInterval);
        return this;
    }

    @DeveloperApi
    public LDAOptimizer getOptimizer() {
        return this.ldaOptimizer();
    }

    @DeveloperApi
    public LDA setOptimizer(LDAOptimizer optimizer) {
        this.ldaOptimizer_$eq(optimizer);
        return this;
    }

    public LDA setOptimizer(String optimizerName) {
        String string;
        block4: {
            LDAOptimizer lDAOptimizer;
            block3: {
                block2: {
                    String string2 = string = optimizerName.toLowerCase(Locale.ROOT);
                    if ("em" != null ? !"em".equals(string2) : string2 != null) break block2;
                    lDAOptimizer = new EMLDAOptimizer();
                    break block3;
                }
                String string3 = string;
                if ("online" != null ? !"online".equals(string3) : string3 != null) break block4;
                lDAOptimizer = new OnlineLDAOptimizer();
            }
            this.ldaOptimizer_$eq(lDAOptimizer);
            return this;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only em, online are supported but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public LDAModel run(RDD<Tuple2<Object, Vector>> documents) {
        LDAOptimizer state = this.ldaOptimizer().initialize(documents, this);
        double[] iterationTimes = (double[])Array$.MODULE$.fill(this.maxIterations(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        for (int iter = 0; iter < this.maxIterations(); ++iter) {
            double elapsedSeconds;
            long start2 = System.nanoTime();
            state.next();
            iterationTimes[iter] = elapsedSeconds = (double)(System.nanoTime() - start2) / 1.0E9;
        }
        return state.getLDAModel(iterationTimes);
    }

    public LDAModel run(JavaPairRDD<Long, Vector> documents) {
        return this.run((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private LDA(int k, int maxIterations, Vector docConcentration, double topicConcentration, long seed, int checkpointInterval, LDAOptimizer ldaOptimizer) {
        this.org$apache$spark$mllib$clustering$LDA$$k = k;
        this.maxIterations = maxIterations;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.seed = seed;
        this.checkpointInterval = checkpointInterval;
        this.ldaOptimizer = ldaOptimizer;
        Logging.class.$init$((Logging)this);
    }

    public LDA() {
        this(10, 20, Vectors$.MODULE$.dense(-1.0, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])), -1.0, Utils$.MODULE$.random().nextLong(), 10, new EMLDAOptimizer());
    }
}

