/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

public final class LocalKMeans$
implements Logging {
    public static final LocalKMeans$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new LocalKMeans$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public VectorWithNorm[] kMeansPlusPlus(int seed, VectorWithNorm[] points, double[] weights, int k, int maxIterations) {
        Random rand2 = new Random(seed);
        int dimensions = points[0].vector().size();
        VectorWithNorm[] centers = new VectorWithNorm[k];
        centers[0] = ((VectorWithNorm)this.pickWeighted(rand2, points, weights)).toDense();
        double[] costArray = (double[])Predef$.MODULE$.refArrayOps((Object[])points).map((Function1)new Serializable(centers){
            public static final long serialVersionUID = 0L;
            private final VectorWithNorm[] centers$1;

            public final double apply(VectorWithNorm x$1) {
                return KMeans$.MODULE$.fastSquaredDistance(x$1, this.centers$1[0]);
            }
            {
                this.centers$1 = centers$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), k).foreach$mVc$sp((Function1)new Serializable(points, weights, rand2, centers, costArray){
            public static final long serialVersionUID = 0L;
            public final VectorWithNorm[] points$1;
            private final double[] weights$1;
            private final Random rand$1;
            public final VectorWithNorm[] centers$1;
            public final double[] costArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int j;
                double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(this.costArray$1).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.weights$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> p) {
                        return p._1$mcD$sp() * p._2$mcD$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double r = this.rand$1.nextDouble() * sum;
                double cumulativeScore = 0.0;
                for (j = 0; j < this.points$1.length && cumulativeScore < r; cumulativeScore += this.weights$1[j] * this.costArray$1[j], ++j) {
                }
                if (j == 0) {
                    LocalKMeans$.MODULE$.logWarning((Function0<String>)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final int i$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"kMeansPlusPlus initialization ran out of distinct points for centers.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Using duplicate point for center k = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1)}))).toString();
                        }
                        {
                            this.i$1 = i$1;
                        }
                    });
                    this.centers$1[i] = this.points$1[0].toDense();
                } else {
                    this.centers$1[i] = this.points$1[j - 1].toDense();
                }
                Predef$.MODULE$.refArrayOps((Object[])this.points$1).indices().foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.kMeansPlusPlus.1 $outer;
                    private final int i$1;

                    public final void apply(int p) {
                        this.apply$mcVI$sp(p);
                    }

                    public void apply$mcVI$sp(int p) {
                        this.$outer.costArray$1[p] = package$.MODULE$.min(KMeans$.MODULE$.fastSquaredDistance(this.$outer.points$1[p], this.$outer.centers$1[this.i$1]), this.$outer.costArray$1[p]);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }
            {
                this.points$1 = points$1;
                this.weights$1 = weights$1;
                this.rand$1 = rand$1;
                this.centers$1 = centers$1;
                this.costArray$1 = costArray$1;
            }
        });
        int[] oldClosest = (int[])Array$.MODULE$.fill(points.length, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }, ClassTag$.MODULE$.Int());
        IntRef iteration = new IntRef(0);
        boolean moved = true;
        while (moved && iteration.elem < maxIterations) {
            moved = false;
            double[] counts = (double[])Array$.MODULE$.fill(k, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return 0.0;
                }
            }, ClassTag$.MODULE$.Double());
            Vector[] sums = (Vector[])Array$.MODULE$.fill(k, (Function0)new Serializable(dimensions){
                public static final long serialVersionUID = 0L;
                private final int dimensions$1;

                public final Vector apply() {
                    return Vectors$.MODULE$.zeros(this.dimensions$1);
                }
                {
                    this.dimensions$1 = dimensions$1;
                }
            }, ClassTag$.MODULE$.apply(Vector.class));
            for (int i = 0; i < points.length; ++i) {
                VectorWithNorm p = points[i];
                int index2 = KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)Predef$.MODULE$.refArrayOps((Object[])centers), p)._1$mcI$sp();
                BLAS$.MODULE$.axpy(weights[i], p.vector(), sums[index2]);
                counts[index2] = counts[index2] + weights[i];
                if (index2 == oldClosest[i]) continue;
                moved = true;
                oldClosest[i] = index2;
            }
            for (int j = 0; j < k; ++j) {
                if (counts[j] == 0.0) {
                    centers[j] = points[rand2.nextInt(points.length)].toDense();
                    continue;
                }
                BLAS$.MODULE$.scal(1.0 / counts[j], sums[j]);
                centers[j] = new VectorWithNorm(sums[j]);
            }
            ++iteration.elem;
        }
        if (iteration.elem == maxIterations) {
            this.logInfo((Function0<String>)new Serializable(maxIterations){
                public static final long serialVersionUID = 0L;
                private final int maxIterations$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local KMeans++ reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}));
                }
                {
                    this.maxIterations$1 = maxIterations$1;
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(iteration){
                public static final long serialVersionUID = 0L;
                private final IntRef iteration$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local KMeans++ converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                }
                {
                    this.iteration$1 = iteration$1;
                }
            });
        }
        return centers;
    }

    private <T> T pickWeighted(Random rand2, Object data, double[] weights) {
        double r = rand2.nextDouble() * BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(weights).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        int i = 0;
        for (double curWeight = 0.0; i < ScalaRunTime$.MODULE$.array_length(data) && curWeight < r; curWeight += weights[i], ++i) {
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(data, i - 1);
    }

    private LocalKMeans$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

