/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.stat.KernelDensity$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u00015\u0011QbS3s]\u0016dG)\u001a8tSRL(BA\u0002\u0005\u0003\u0011\u0019H/\u0019;\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mK\")\u0001\u0004\u0001C\u00013\u00051A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011A\u0001\u0005\b;\u0001\u0001\r\u0011\"\u0003\u001f\u0003%\u0011\u0017M\u001c3xS\u0012$\b.F\u0001 !\ty\u0001%\u0003\u0002\"!\t1Ai\\;cY\u0016Dqa\t\u0001A\u0002\u0013%A%A\u0007cC:$w/\u001b3uQ~#S-\u001d\u000b\u0003K!\u0002\"a\u0004\u0014\n\u0005\u001d\u0002\"\u0001B+oSRDq!\u000b\u0012\u0002\u0002\u0003\u0007q$A\u0002yIEBaa\u000b\u0001!B\u0013y\u0012A\u00032b]\u0012<\u0018\u000e\u001a;iA!IQ\u0006\u0001a\u0001\u0002\u0004%IAL\u0001\u0007g\u0006l\u0007\u000f\\3\u0016\u0003=\u00022\u0001M\u001a \u001b\u0005\t$B\u0001\u001a\u0007\u0003\r\u0011H\rZ\u0005\u0003iE\u00121A\u0015#E\u0011%1\u0004\u00011AA\u0002\u0013%q'\u0001\u0006tC6\u0004H.Z0%KF$\"!\n\u001d\t\u000f%*\u0014\u0011!a\u0001_!1!\b\u0001Q!\n=\nqa]1na2,\u0007\u0005C\u0003=\u0001\u0011\u0005Q(\u0001\u0007tKR\u0014\u0015M\u001c3xS\u0012$\b\u000e\u0006\u0002?\u007f5\t\u0001\u0001C\u0003\u001ew\u0001\u0007q\u0004K\u0002<\u0003\u001e\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002G\u0007\n)1+\u001b8dK\u0006\n\u0001*A\u00032]Qr\u0003\u0007C\u0003K\u0001\u0011\u00051*A\u0005tKR\u001c\u0016-\u001c9mKR\u0011a\b\u0014\u0005\u0006[%\u0003\ra\f\u0015\u0004\u0013\u0006;\u0005\"\u0002&\u0001\t\u0003yEC\u0001 Q\u0011\u0015ic\n1\u0001R!\r\u0011v+W\u0007\u0002'*\u0011A+V\u0001\u0005U\u00064\u0018M\u0003\u0002W\r\u0005\u0019\u0011\r]5\n\u0005a\u001b&a\u0002&bm\u0006\u0014F\t\u0012\t\u00035zk\u0011a\u0017\u0006\u00039v\u000bA\u0001\\1oO*\tA+\u0003\u0002\"7\"\u001aa*Q$\t\u000b\u0005\u0004A\u0011\u00012\u0002\u0011\u0015\u001cH/[7bi\u0016$\"a\u00194\u0011\u0007=!w$\u0003\u0002f!\t)\u0011I\u001d:bs\")q\r\u0019a\u0001G\u00061\u0001o\\5oiND3\u0001Y!HQ\r\u0001\u0011iR\u0004\u0006W\nAI\u0001\\\u0001\u000e\u0017\u0016\u0014h.\u001a7EK:\u001c\u0018\u000e^=\u0011\u0005mig!B\u0001\u0003\u0011\u0013q7cA7\u000f)!)\u0001$\u001cC\u0001aR\tA\u000eC\u0003s[\u0012\u00051/A\u0004o_Jl\u0007\u000b\u001a4\u0015\u000b}!h\u000f\u001f>\t\u000bU\f\b\u0019A\u0010\u0002\t5,\u0017M\u001c\u0005\u0006oF\u0004\raH\u0001\u0012gR\fg\u000eZ1sI\u0012+g/[1uS>t\u0007\"B=r\u0001\u0004y\u0012A\t7pON#\u0018M\u001c3be\u0012$UM^5bi&|g\u000e\u00157vg\"\u000bGN\u001a'pOJ\u0002\u0016\u000eC\u0003|c\u0002\u0007q$A\u0001y\u0011\u001diX.!A\u0005\ny\f1B]3bIJ+7o\u001c7wKR\tq\u0010E\u0002[\u0003\u0003I1!a\u0001\\\u0005\u0019y%M[3di\u0002")
public class KernelDensity
implements Serializable {
    private double bandwidth = 1.0;
    private RDD<Object> sample;

    public static double normPdf(double d, double d2, double d3, double d4) {
        return KernelDensity$.MODULE$.normPdf(d, d2, d3, d4);
    }

    private double bandwidth() {
        return this.bandwidth;
    }

    private void bandwidth_$eq(double x$1) {
        this.bandwidth = x$1;
    }

    private RDD<Object> sample() {
        return this.sample;
    }

    private void sample_$eq(RDD<Object> x$1) {
        this.sample = x$1;
    }

    public KernelDensity setBandwidth(double bandwidth) {
        Predef$.MODULE$.require(bandwidth > 0.0, (Function0)new Serializable(this, bandwidth){
            public static final long serialVersionUID = 0L;
            private final double bandwidth$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bandwidth must be positive, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.bandwidth$1)}));
            }
            {
                this.bandwidth$1 = bandwidth$1;
            }
        });
        this.bandwidth_$eq(bandwidth);
        return this;
    }

    public KernelDensity setSample(RDD<Object> sample) {
        this.sample_$eq(sample);
        return this;
    }

    public KernelDensity setSample(JavaRDD<Double> sample) {
        this.sample_$eq((RDD<Object>)sample.rdd());
        return this;
    }

    public double[] estimate(double[] points) {
        RDD<Object> sample = this.sample();
        double bandwidth = this.bandwidth();
        Predef$.MODULE$.require(sample != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Must set sample before calling estimate.";
            }
        });
        int n = points.length;
        double logStandardDeviationPlusHalfLog2Pi = package$.MODULE$.log(bandwidth) + 0.5 * package$.MODULE$.log((double)2 * package$.MODULE$.Pi());
        Tuple2 tuple2 = (Tuple2)sample.aggregate((Object)new Tuple2((Object)new double[n], (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)new $anonfun$1(this, points, bandwidth, n, logStandardDeviationPlusHalfLog2Pi), (Function2)new $anonfun$2(this, n), ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            double[] densities = (double[])tuple2._1();
            long count = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)densities, (Object)BoxesRunTime.boxToLong((long)count));
            double[] densities2 = (double[])tuple23._1();
            long count2 = tuple23._2$mcJ$sp();
            BLAS.getInstance().dscal(n, 1.0 / (double)count2, densities2, 1);
            return densities2;
        }
        throw new MatchError((Object)tuple2);
    }
}

