/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.AFTSurvivalRegressionWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.regression.AFTSurvivalRegression;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class AFTSurvivalRegressionWrapper$
implements MLReadable<AFTSurvivalRegressionWrapper> {
    public static final AFTSurvivalRegressionWrapper$ MODULE$;

    static {
        new AFTSurvivalRegressionWrapper$();
    }

    private Tuple2<String, String> formulaRewrite(String formula) {
        String string;
        block4: {
            String rewritedFormula = null;
            String censorCol = null;
            Regex regex = new StringOps(Predef$.MODULE$.augmentString("Surv\\(([^,]+), ([^,]+)\\) ~ (.+)")).r();
            try {
                Tuple3 tuple3;
                string = formula;
                Option option = regex.unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) break block4;
                String label = (String)((LinearSeqOptimized)option.get()).apply(0);
                String censor = (String)((LinearSeqOptimized)option.get()).apply(1);
                String features = (String)((LinearSeqOptimized)option.get()).apply(2);
                Tuple3 tuple32 = tuple3 = new Tuple3((Object)label, (Object)censor, (Object)features);
                String label2 = (String)tuple32._1();
                String censor2 = (String)tuple32._2();
                String features2 = (String)tuple32._3();
                if (features2.contains(".")) {
                    throw new UnsupportedOperationException("Terms of survreg formula can not support dot operator.");
                }
                rewritedFormula = new StringBuilder().append((Object)label2.trim()).append((Object)"~").append((Object)features2.trim()).toString();
                censorCol = censor2.trim();
            }
            catch (MatchError matchError) {
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not parse formula: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formula})));
            }
            return new Tuple2((Object)rewritedFormula, (Object)censorCol);
        }
        throw new MatchError((Object)string);
    }

    public AFTSurvivalRegressionWrapper fit(String formula, Dataset<Row> data, int aggregationDepth) {
        Tuple2<String, String> tuple2 = this.formulaRewrite(formula);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String rewritedFormula = (String)tuple2._1();
            String censorCol = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rewritedFormula, (Object)censorCol);
            String rewritedFormula2 = (String)tuple23._1();
            String censorCol2 = (String)tuple23._2();
            RFormula rFormula = new RFormula().setFormula(rewritedFormula2);
            RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
            Model rFormulaModel = rFormula.fit((Dataset)data);
            StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
            Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(rFormula.getFeaturesCol())).attributes().get();
            String[] features = (String[])Predef$.MODULE$.refArrayOps((Object[])featureAttrs).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Attribute x$3) {
                    return (String)x$3.name().get();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            AFTSurvivalRegression aft = new AFTSurvivalRegression().setCensorCol(censorCol2).setFitIntercept(rFormula.hasIntercept()).setFeaturesCol(rFormula.getFeaturesCol()).setAggregationDepth(aggregationDepth);
            Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, aft})).fit((Dataset)data);
            return new AFTSurvivalRegressionWrapper((PipelineModel)pipeline, features);
        }
        throw new MatchError(tuple2);
    }

    @Override
    public MLReader<AFTSurvivalRegressionWrapper> read() {
        return new AFTSurvivalRegressionWrapper.AFTSurvivalRegressionWrapperReader();
    }

    @Override
    public AFTSurvivalRegressionWrapper load(String path) {
        return (AFTSurvivalRegressionWrapper)MLReadable$class.load(this, path);
    }

    private AFTSurvivalRegressionWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
    }
}

