/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u00015\u0011!BT1jm\u0016\u0014\u0015-_3t\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001H\r\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001BA\u0002\u0013%q$\u0001\u0004mC6\u0014G-Y\u000b\u0002AA\u0011q\"I\u0005\u0003EA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0007I\u0011B\u0013\u0002\u00151\fWN\u00193b?\u0012*\u0017\u000f\u0006\u0002'SA\u0011qbJ\u0005\u0003QA\u0011A!\u00168ji\"9!fIA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!AA\u0006\u0001B\u0001B\u0003&\u0001%A\u0004mC6\u0014G-\u0019\u0011\t\u00119\u0002!\u00111A\u0005\n=\n\u0011\"\\8eK2$\u0016\u0010]3\u0016\u0003A\u0002\"!\r\u001b\u000f\u0005=\u0011\u0014BA\u001a\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0002\u0002\u0002\u0003\u001d\u0001\u0005\u0003\u0007I\u0011B\u001d\u0002\u001b5|G-\u001a7UsB,w\fJ3r)\t1#\bC\u0004+o\u0005\u0005\t\u0019\u0001\u0019\t\u0011q\u0002!\u0011!Q!\nA\n!\"\\8eK2$\u0016\u0010]3!\u0011\u0015q\u0004\u0001\"\u0003@\u0003\u0019a\u0014N\\5u}Q\u0019\u0001IQ\"\u0011\u0005\u0005\u0003Q\"\u0001\u0002\t\u000byi\u0004\u0019\u0001\u0011\t\u000b9j\u0004\u0019\u0001\u0019\t\u000by\u0002A\u0011A#\u0015\u0005\u00013\u0005\"\u0002\u0010E\u0001\u0004\u0001\u0003f\u0001#I\u001dB\u0011\u0011\nT\u0007\u0002\u0015*\u00111JB\u0001\u000bC:tw\u000e^1uS>t\u0017BA'K\u0005\u0015\u0019\u0016N\\2fC\u0005y\u0015!B\u0019/i9\u0002\u0004\"\u0002 \u0001\t\u0003\tF#\u0001!)\u0007AC5+I\u0001U\u0003\u0015\u0001d&\u000f\u00181\u0011\u00151\u0006\u0001\"\u0001X\u0003%\u0019X\r\u001e'b[\n$\u0017\r\u0006\u0002A1\")a$\u0016a\u0001A!\u001aQ\u000bS*\t\u000bm\u0003A\u0011A\u0010\u0002\u0013\u001d,G\u000fT1nE\u0012\f\u0007f\u0001.I\u001d\")a\f\u0001C\u0001?\u0006a1/\u001a;N_\u0012,G\u000eV=qKR\u0011\u0001\t\u0019\u0005\u0006]u\u0003\r\u0001\r\u0015\u0004;\"s\u0005\"B2\u0001\t\u0003y\u0013\u0001D4fi6{G-\u001a7UsB,\u0007f\u00012I\u001d\")a\r\u0001C\u0001O\u0006\u0019!/\u001e8\u0015\u0005!\\\u0007CA!j\u0013\tQ'AA\bOC&4XMQ1zKNlu\u000eZ3m\u0011\u0015aW\r1\u0001n\u0003\u0011!\u0017\r^1\u0011\u00079\f8/D\u0001p\u0015\t\u0001h!A\u0002sI\u0012L!A]8\u0003\u0007I#E\t\u0005\u0002uo6\tQO\u0003\u0002w\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\n\u0005a,(\u0001\u0004'bE\u0016dW\r\u001a)pS:$\bfA3I'\"\u001a\u0001\u0001S*\b\u000bq\u0014\u0001\u0012A?\u0002\u00159\u000b\u0017N^3CCf,7\u000f\u0005\u0002B}\u001a)\u0011A\u0001E\u0001\u007fN\u0019aP\u0004\u000b\t\ryrH\u0011AA\u0002)\u0005i\b\"CA\u0004}\n\u0007I\u0011\u0001\u00020\u0003-iU\u000f\u001c;j]>l\u0017.\u00197\t\u000f\u0005-a\u0010)A\u0005a\u0005aQ*\u001e7uS:|W.[1mA!I\u0011q\u0002@C\u0002\u0013\u0005!aL\u0001\n\u0005\u0016\u0014hn\\;mY&Dq!a\u0005\u007fA\u0003%\u0001'\u0001\u0006CKJtw.\u001e7mS\u0002B!\"a\u0006\u007f\u0005\u0004%\tAAA\r\u0003M\u0019X\u000f\u001d9peR,G-T8eK2$\u0016\u0010]3t+\t\tY\u0002E\u0003\u0002\u001e\u0005\u001d\u0002'\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003%IW.\\;uC\ndWMC\u0002\u0002&A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\b\u0003\u0007M+G\u000f\u0003\u0005\u0002.y\u0004\u000b\u0011BA\u000e\u0003Q\u0019X\u000f\u001d9peR,G-T8eK2$\u0016\u0010]3tA!9\u0011\u0011\u0007@\u0005\u0002\u0005M\u0012!\u0002;sC&tGc\u00015\u00026!9\u0011qGA\u0018\u0001\u0004i\u0017!B5oaV$\b\u0006BA\u0018\u0011NCq!!\r\u007f\t\u0003\ti\u0004F\u0003i\u0003\u007f\t\t\u0005C\u0004\u00028\u0005m\u0002\u0019A7\t\ry\tY\u00041\u0001!Q\u0011\tY\u0004S*\t\u000f\u0005Eb\u0010\"\u0001\u0002HQ9\u0001.!\u0013\u0002L\u00055\u0003bBA\u001c\u0003\u000b\u0002\r!\u001c\u0005\u0007=\u0005\u0015\u0003\u0019\u0001\u0011\t\r9\n)\u00051\u00011Q\u0011\t)\u0005\u0013(\t\u0013\u0005Mc0!A\u0005\n\u0005U\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!A.\u00198h\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA3\u00037\u0012aa\u00142kK\u000e$\bf\u0001@I'\"\u001a1\u0010S*")
public class NaiveBayes
implements Serializable,
Logging {
    private double lambda;
    private String modelType;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d, String string) {
        return NaiveBayes$.MODULE$.train(rDD, d, string);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD, double d) {
        return NaiveBayes$.MODULE$.train(rDD, d);
    }

    public static NaiveBayesModel train(RDD<LabeledPoint> rDD) {
        return NaiveBayes$.MODULE$.train(rDD);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private double lambda() {
        return this.lambda;
    }

    private void lambda_$eq(double x$1) {
        this.lambda = x$1;
    }

    private String modelType() {
        return this.modelType;
    }

    private void modelType_$eq(String x$1) {
        this.modelType = x$1;
    }

    public NaiveBayes setLambda(double lambda) {
        Predef$.MODULE$.require(lambda >= 0.0, (Function0)new Serializable(this, lambda){
            public static final long serialVersionUID = 0L;
            private final double lambda$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Smoothing parameter must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.lambda$1)}));
            }
            {
                this.lambda$1 = lambda$1;
            }
        });
        this.lambda_$eq(lambda);
        return this;
    }

    public double getLambda() {
        return this.lambda();
    }

    public NaiveBayes setModelType(String modelType) {
        Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0)new Serializable(this, modelType){
            public static final long serialVersionUID = 0L;
            private final String modelType$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NaiveBayes was created with an unknown modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.modelType$2}));
            }
            {
                this.modelType$2 = modelType$2;
            }
        });
        this.modelType_$eq(modelType);
        return this;
    }

    public String getModelType() {
        return this.modelType();
    }

    public NaiveBayesModel run(RDD<LabeledPoint> data) {
        SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(data.context()).getOrCreate();
        org.apache.spark.ml.classification.NaiveBayes nb = new org.apache.spark.ml.classification.NaiveBayes().setModelType(this.modelType()).setSmoothing(this.lambda());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        public final class Org_apache_spark_mllib_classification_NaiveBayes$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor(), $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_mllib_classification_NaiveBayes$$typecreator7$1(NaiveBayes $outer) {
            }
        }
        Dataset dataset = spark.implicits().rddToDatasetHolder(data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint x0$1) {
                LabeledPoint labeledPoint = x0$1;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    org.apache.spark.mllib.linalg.Vector features = labeledPoint.features();
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)label), (Object)features.asML());
                    return tuple2;
                }
                throw new MatchError((Object)labeledPoint);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_classification_NaiveBayes$$typecreator7$1(this)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"}));
        org.apache.spark.ml.classification.NaiveBayesModel newModel = nb.trainWithLabelCheck(dataset, false);
        double[] pi = newModel.pi().toArray();
        double[][] theta = (double[][])Array$.MODULE$.fill(newModel.numClasses(), newModel.numFeatures(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        newModel.theta().foreachActive((Function3)new Serializable(this, theta){
            public static final long serialVersionUID = 0L;
            private final double[][] theta$1;

            public final void apply(int x0$2, int x1$1, double x2$1) {
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
                if (tuple3 != null) {
                    double v;
                    int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    this.theta$1[i][j] = v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)tuple3);
            }
            {
                this.theta$1 = theta$1;
            }
        });
        Predef$.MODULE$.assert(newModel.oldLabels() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The underlying ML NaiveBayes training does not produce labels.";
            }
        });
        return new NaiveBayesModel(newModel.oldLabels(), pi, theta, this.modelType());
    }

    public NaiveBayes(double lambda, String modelType) {
        this.lambda = lambda;
        this.modelType = modelType;
        Logging.class.$init$((Logging)this);
    }

    public NaiveBayes(double lambda) {
        this(lambda, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayes() {
        this(1.0, NaiveBayes$.MODULE$.Multinomial());
    }
}

