/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.IOException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.LearningNode;
import org.apache.spark.ml.tree.LearningNode$;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.impl.BaggedPoint;
import org.apache.spark.ml.tree.impl.BaggedPoint$;
import org.apache.spark.ml.tree.impl.DTStatsAggregator;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.tree.impl.NodeIdCache;
import org.apache.spark.ml.tree.impl.NodeIdCache$;
import org.apache.spark.ml.tree.impl.NodeIndexUpdater;
import org.apache.spark.ml.tree.impl.RandomForest;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.tree.impl.TimeTracker;
import org.apache.spark.ml.tree.impl.TreePoint;
import org.apache.spark.ml.tree.impl.TreePoint$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.model.ImpurityStats;
import org.apache.spark.mllib.tree.model.ImpurityStats$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.SamplingUtils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.IndexedSeqView$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

public final class RandomForest$
implements Logging {
    public static final RandomForest$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RandomForest$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public DecisionTreeModel[] run(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, long seed, Option<Instrumentation<?>> instr, Option<String> parentUID) {
        Option<String> option;
        block14: {
            DecisionTreeModel[] decisionTreeModelArray;
            block13: {
                int numFeatures;
                LearningNode[] topNodes;
                block12: {
                    DecisionTreeMetadata metadata;
                    block11: {
                        Option<Instrumentation<?>> option2;
                        block10: {
                            RDD retaggedInput;
                            TimeTracker timer;
                            block9: {
                                BoxedUnit boxedUnit;
                                block8: {
                                    timer = new TimeTracker();
                                    timer.start("total");
                                    timer.start("init");
                                    retaggedInput = input.retag(LabeledPoint.class);
                                    metadata = DecisionTreeMetadata$.MODULE$.buildMetadata((RDD<LabeledPoint>)retaggedInput, strategy, numTrees, featureSubsetStrategy);
                                    option2 = instr;
                                    if (!(option2 instanceof Some)) break block8;
                                    Some some = (Some)option2;
                                    Instrumentation instrumentation = (Instrumentation)some.x();
                                    instrumentation.logNumFeatures(metadata.numFeatures());
                                    instrumentation.logNumClasses(metadata.numClasses());
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block9;
                                }
                                if (!None$.MODULE$.equals(option2)) break block10;
                                this.logInfo((Function0<String>)new Serializable(metadata){
                                    public static final long serialVersionUID = 0L;
                                    private final DecisionTreeMetadata metadata$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"numFeatures: ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.numFeatures())).toString();
                                    }
                                    {
                                        this.metadata$1 = metadata$1;
                                    }
                                });
                                this.logInfo((Function0<String>)new Serializable(metadata){
                                    public static final long serialVersionUID = 0L;
                                    private final DecisionTreeMetadata metadata$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"numClasses: ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.numClasses())).toString();
                                    }
                                    {
                                        this.metadata$1 = metadata$1;
                                    }
                                });
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            timer.start("findSplits");
                            Split[][] splits = this.findSplits((RDD<LabeledPoint>)retaggedInput, metadata, seed);
                            timer.stop("findSplits");
                            this.logDebug((Function0<String>)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "numBins: feature: number of bins";
                                }
                            });
                            this.logDebug((Function0<String>)new Serializable(metadata){
                                public static final long serialVersionUID = 0L;
                                public final DecisionTreeMetadata metadata$1;

                                public final String apply() {
                                    return ((TraversableOnce)scala.package$.MODULE$.Range().apply(0, this.metadata$1.numFeatures()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun.run.4 $outer;

                                        public final String apply(int featureIndex) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureIndex), BoxesRunTime.boxToInteger((int)this.$outer.metadata$1.numBins()[featureIndex])}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n");
                                }
                                {
                                    this.metadata$1 = metadata$1;
                                }
                            });
                            RDD<TreePoint> treeInput = TreePoint$.MODULE$.convertToTreeRDD((RDD<LabeledPoint>)retaggedInput, splits, metadata);
                            boolean withReplacement = numTrees > 1;
                            RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, strategy.subsamplingRate(), numTrees, withReplacement, seed).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                            int maxDepth = strategy.maxDepth();
                            Predef$.MODULE$.require(maxDepth <= 30, (Function0)new Serializable(maxDepth){
                                public static final long serialVersionUID = 0L;
                                private final int maxDepth$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree currently only supports maxDepth <= 30, but was given maxDepth = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxDepth$1)}));
                                }
                                {
                                    this.maxDepth$1 = maxDepth$1;
                                }
                            });
                            long maxMemoryUsage = (long)strategy.maxMemoryInMB() * 1024L * 1024L;
                            this.logDebug((Function0<String>)new Serializable(maxMemoryUsage){
                                public static final long serialVersionUID = 0L;
                                private final long maxMemoryUsage$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"max memory usage for aggregates = ").append((Object)BoxesRunTime.boxToLong((long)this.maxMemoryUsage$1)).append((Object)" bytes.").toString();
                                }
                                {
                                    this.maxMemoryUsage$1 = maxMemoryUsage$1;
                                }
                            });
                            None$ nodeIdCache = strategy.useNodeIdCache() ? new Some((Object)NodeIdCache$.MODULE$.init((RDD<BaggedPoint<TreePoint>>)baggedInput, numTrees, strategy.checkpointInterval(), 1)) : None$.MODULE$;
                            Stack nodeStack = new Stack();
                            Random rng = new Random();
                            rng.setSeed(seed);
                            topNodes = (LearningNode[])Array$.MODULE$.fill(numTrees, (Function0)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final LearningNode apply() {
                                    return LearningNode$.MODULE$.emptyNode(1);
                                }
                            }, ClassTag$.MODULE$.apply(LearningNode.class));
                            scala.package$.MODULE$.Range().apply(0, numTrees).foreach((Function1)new Serializable(nodeStack, topNodes){
                                public static final long serialVersionUID = 0L;
                                private final Stack nodeStack$1;
                                private final LearningNode[] topNodes$1;

                                public final Stack<Tuple2<Object, LearningNode>> apply(int treeIndex) {
                                    return this.nodeStack$1.push((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)this.topNodes$1[treeIndex]));
                                }
                                {
                                    this.nodeStack$1 = nodeStack$1;
                                    this.topNodes$1 = topNodes$1;
                                }
                            });
                            timer.stop("init");
                            while (nodeStack.nonEmpty()) {
                                Tuple2<scala.collection.immutable.Map<Object, LearningNode[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>> tuple2 = this.selectNodesToSplit((Stack<Tuple2<Object, LearningNode>>)nodeStack, maxMemoryUsage, metadata, rng);
                                if (tuple2 != null) {
                                    Tuple2 tuple22;
                                    scala.collection.immutable.Map nodesForGroup = (scala.collection.immutable.Map)tuple2._1();
                                    scala.collection.immutable.Map treeToNodeToIndexInfo = (scala.collection.immutable.Map)tuple2._2();
                                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
                                    scala.collection.immutable.Map nodesForGroup2 = (scala.collection.immutable.Map)tuple23._1();
                                    scala.collection.immutable.Map treeToNodeToIndexInfo2 = (scala.collection.immutable.Map)tuple23._2();
                                    Predef$.MODULE$.assert(nodesForGroup2.nonEmpty(), (Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest selected empty nodesForGroup.  Error for unknown reason."})).s((Seq)Nil$.MODULE$);
                                        }
                                    });
                                    scala.collection.immutable.Map topNodesForGroup = ((TraversableOnce)nodesForGroup2.keys().map((Function1)new Serializable(topNodes){
                                        public static final long serialVersionUID = 0L;
                                        private final LearningNode[] topNodes$1;

                                        public final Tuple2<Object, LearningNode> apply(int treeIdx) {
                                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)treeIdx)), (Object)this.topNodes$1[treeIdx]);
                                        }
                                        {
                                            this.topNodes$1 = topNodes$1;
                                        }
                                    }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                                    timer.start("findBestSplits");
                                    this.findBestSplits((RDD<BaggedPoint<TreePoint>>)baggedInput, metadata, (scala.collection.immutable.Map<Object, LearningNode>)topNodesForGroup, (scala.collection.immutable.Map<Object, LearningNode[]>)nodesForGroup2, (scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>)treeToNodeToIndexInfo2, splits, (Stack<Tuple2<Object, LearningNode>>)nodeStack, timer, (Option<NodeIdCache>)nodeIdCache);
                                    timer.stop("findBestSplits");
                                    continue;
                                }
                                throw new MatchError(tuple2);
                            }
                            baggedInput.unpersist(baggedInput.unpersist$default$1());
                            timer.stop("total");
                            this.logInfo((Function0<String>)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Internal timing for DecisionTree:";
                                }
                            });
                            this.logInfo((Function0<String>)new Serializable(timer){
                                public static final long serialVersionUID = 0L;
                                private final TimeTracker timer$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timer$1}));
                                }
                                {
                                    this.timer$1 = timer$1;
                                }
                            });
                            if (!nodeIdCache.nonEmpty()) break block11;
                            try {
                                ((NodeIdCache)nodeIdCache.get()).deleteAllCheckpoints();
                            }
                            catch (IOException iOException) {
                                this.logWarning((Function0<String>)new Serializable(iOException){
                                    public static final long serialVersionUID = 0L;
                                    private final IOException e$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete all checkpoints failed. Error reason: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                                    }
                                    {
                                        this.e$1 = e$1;
                                    }
                                });
                            }
                        }
                        throw new MatchError(option2);
                    }
                    numFeatures = metadata.numFeatures();
                    option = parentUID;
                    if (!(option instanceof Some)) break block12;
                    Some some = (Some)option;
                    String uid = (String)some.x();
                    Enumeration.Value value = strategy.algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Classification();
                    decisionTreeModelArray = !(value != null ? !value.equals(value2) : value2 != null) ? (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])topNodes).map((Function1)new Serializable(strategy, numFeatures, uid){
                        public static final long serialVersionUID = 0L;
                        private final Strategy strategy$1;
                        private final int numFeatures$1;
                        private final String uid$1;

                        public final DecisionTreeClassificationModel apply(LearningNode rootNode) {
                            return new DecisionTreeClassificationModel(this.uid$1, rootNode.toNode(), this.numFeatures$1, this.strategy$1.getNumClasses());
                        }
                        {
                            this.strategy$1 = strategy$1;
                            this.numFeatures$1 = numFeatures$1;
                            this.uid$1 = uid$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))) : (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])topNodes).map((Function1)new Serializable(numFeatures, uid){
                        public static final long serialVersionUID = 0L;
                        private final int numFeatures$1;
                        private final String uid$1;

                        public final DecisionTreeRegressionModel apply(LearningNode rootNode) {
                            return new DecisionTreeRegressionModel(this.uid$1, rootNode.toNode(), this.numFeatures$1);
                        }
                        {
                            this.numFeatures$1 = numFeatures$1;
                            this.uid$1 = uid$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
                    break block13;
                }
                if (!None$.MODULE$.equals(option)) break block14;
                Enumeration.Value value = strategy.algo();
                Enumeration.Value value3 = Algo$.MODULE$.Classification();
                decisionTreeModelArray = !(value != null ? !value.equals(value3) : value3 != null) ? (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])topNodes).map((Function1)new Serializable(strategy, numFeatures){
                    public static final long serialVersionUID = 0L;
                    private final Strategy strategy$1;
                    private final int numFeatures$1;

                    public final DecisionTreeClassificationModel apply(LearningNode rootNode) {
                        return new DecisionTreeClassificationModel(rootNode.toNode(), this.numFeatures$1, this.strategy$1.getNumClasses());
                    }
                    {
                        this.strategy$1 = strategy$1;
                        this.numFeatures$1 = numFeatures$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))) : (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])topNodes).map((Function1)new Serializable(numFeatures){
                    public static final long serialVersionUID = 0L;
                    private final int numFeatures$1;

                    public final DecisionTreeRegressionModel apply(LearningNode rootNode) {
                        return new DecisionTreeRegressionModel(rootNode.toNode(), this.numFeatures$1);
                    }
                    {
                        this.numFeatures$1 = numFeatures$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
            }
            return decisionTreeModelArray;
        }
        throw new MatchError(option);
    }

    public Option<String> run$default$7() {
        return None$.MODULE$;
    }

    private void mixedBinSeqOp(DTStatsAggregator agg, TreePoint treePoint, Split[][] splits, Set<Object> unorderedFeatures, double instanceWeight, Option<int[]> featuresForNode) {
        int numFeaturesPerNode = featuresForNode.nonEmpty() ? ((int[])featuresForNode.get()).length : agg.metadata().numFeatures();
        for (int featureIndexIdx = 0; featureIndexIdx < numFeaturesPerNode; ++featureIndexIdx) {
            int featureIndex;
            int n = featureIndex = featuresForNode.nonEmpty() ? ((int[])featuresForNode.get())[featureIndexIdx] : featureIndexIdx;
            if (unorderedFeatures.contains((Object)BoxesRunTime.boxToInteger((int)featureIndex))) {
                int featureValue = treePoint.binnedFeatures()[featureIndex];
                int leftNodeFeatureOffset = agg.getFeatureOffset(featureIndexIdx);
                int numSplits = agg.metadata().numSplits(featureIndex);
                Split[] featureSplits = splits[featureIndex];
                for (int splitIndex = 0; splitIndex < numSplits; ++splitIndex) {
                    if (!featureSplits[splitIndex].shouldGoLeft(featureValue, featureSplits)) continue;
                    agg.featureUpdate(leftNodeFeatureOffset, splitIndex, treePoint.label(), instanceWeight);
                }
                continue;
            }
            int binIndex = treePoint.binnedFeatures()[featureIndex];
            agg.update(featureIndexIdx, binIndex, treePoint.label(), instanceWeight);
        }
    }

    private void orderedBinSeqOp(DTStatsAggregator agg, TreePoint treePoint, double instanceWeight, Option<int[]> featuresForNode) {
        double label = treePoint.label();
        if (featuresForNode.nonEmpty()) {
            for (int featureIndexIdx = 0; featureIndexIdx < ((int[])featuresForNode.get()).length; ++featureIndexIdx) {
                int binIndex = treePoint.binnedFeatures()[((int[])featuresForNode.get())[featureIndexIdx]];
                agg.update(featureIndexIdx, binIndex, label, instanceWeight);
            }
        } else {
            int numFeatures = agg.metadata().numFeatures();
            for (int featureIndex = 0; featureIndex < numFeatures; ++featureIndex) {
                int binIndex = treePoint.binnedFeatures()[featureIndex];
                agg.update(featureIndex, binIndex, label, instanceWeight);
            }
        }
    }

    public void findBestSplits(RDD<BaggedPoint<TreePoint>> input, DecisionTreeMetadata metadata, scala.collection.immutable.Map<Object, LearningNode> topNodesForGroup, scala.collection.immutable.Map<Object, LearningNode[]> nodesForGroup, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> treeToNodeToIndexInfo, Split[][] splits, Stack<Tuple2<Object, LearningNode>> nodeStack, TimeTracker timer, Option<NodeIdCache> nodeIdCache) {
        RDD rDD;
        int numNodes = BoxesRunTime.unboxToInt((Object)((TraversableOnce)nodesForGroup.values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(LearningNode[] x$2) {
                return x$2.length;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.logDebug((Function0<String>)new Serializable(numNodes){
            public static final long serialVersionUID = 0L;
            private final int numNodes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numNodes = ").append((Object)BoxesRunTime.boxToInteger((int)this.numNodes$1)).toString();
            }
            {
                this.numNodes$1 = numNodes$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$3;

            public final String apply() {
                return new StringBuilder().append((Object)"numFeatures = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$3.numFeatures())).toString();
            }
            {
                this.metadata$3 = metadata$3;
            }
        });
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$3;

            public final String apply() {
                return new StringBuilder().append((Object)"numClasses = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$3.numClasses())).toString();
            }
            {
                this.metadata$3 = metadata$3;
            }
        });
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$3;

            public final String apply() {
                return new StringBuilder().append((Object)"isMulticlass = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.metadata$3.isMulticlass())).toString();
            }
            {
                this.metadata$3 = metadata$3;
            }
        });
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$3;

            public final String apply() {
                return new StringBuilder().append((Object)"isMulticlassWithCategoricalFeatures = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.metadata$3.isMulticlassWithCategoricalFeatures())).toString();
            }
            {
                this.metadata$3 = metadata$3;
            }
        });
        this.logDebug((Function0<String>)new Serializable(nodeIdCache){
            public static final long serialVersionUID = 0L;
            private final Option nodeIdCache$1;

            public final String apply() {
                return new StringBuilder().append((Object)"using nodeIdCache = ").append((Object)((Object)BoxesRunTime.boxToBoolean((boolean)this.nodeIdCache$1.nonEmpty())).toString()).toString();
            }
            {
                this.nodeIdCache$1 = nodeIdCache$1;
            }
        });
        LearningNode[] nodes = new LearningNode[numNodes];
        nodesForGroup.foreach((Function1)new Serializable(treeToNodeToIndexInfo, nodes){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map treeToNodeToIndexInfo$1;
            public final LearningNode[] nodes$1;

            public final void apply(Tuple2<Object, LearningNode[]> x0$3) {
                Tuple2<Object, LearningNode[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    int treeIndex = tuple2._1$mcI$sp();
                    LearningNode[] nodesForTree = (LearningNode[])tuple2._2();
                    Predef$.MODULE$.refArrayOps((Object[])nodesForTree).foreach((Function1)new Serializable(this, treeIndex){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.findBestSplits.7 $outer;
                        private final int treeIndex$1;

                        public final void apply(LearningNode node) {
                            this.$outer.nodes$1[((RandomForest.NodeIndexInfo)((MapLike)this.$outer.treeToNodeToIndexInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)this.treeIndex$1))).apply((Object)BoxesRunTime.boxToInteger((int)node.id()))).nodeIndexInGroup()] = node;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.treeIndex$1 = treeIndex$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.treeToNodeToIndexInfo$1 = treeToNodeToIndexInfo$1;
                this.nodes$1 = nodes$1;
            }
        });
        timer.start("chooseSplits");
        Option nodeToFeatures = this.getNodeToFeatures$1(treeToNodeToIndexInfo, metadata);
        Broadcast nodeToFeaturesBc = input.sparkContext().broadcast((Object)nodeToFeatures, ClassTag$.MODULE$.apply(Option.class));
        if (nodeIdCache.nonEmpty()) {
            RDD qual$1 = input.zip(((NodeIdCache)nodeIdCache.get()).nodeIdsForInstances(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
            Serializable x$28 = new Serializable(metadata, treeToNodeToIndexInfo, splits, numNodes, nodeToFeaturesBc){
                public static final long serialVersionUID = 0L;
                public final DecisionTreeMetadata metadata$3;
                public final scala.collection.immutable.Map treeToNodeToIndexInfo$1;
                public final Split[][] splits$1;
                private final int numNodes$1;
                public final Broadcast nodeToFeaturesBc$1;

                public final Iterator<Tuple2<Object, DTStatsAggregator>> apply(Iterator<Tuple2<BaggedPoint<TreePoint>, int[]>> points) {
                    DTStatsAggregator[] nodeStatsAggregators = (DTStatsAggregator[])Array$.MODULE$.tabulate(this.numNodes$1, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.8 $outer;

                        public final DTStatsAggregator apply(int nodeIndex) {
                            Option featuresForNode = ((Option)this.$outer.nodeToFeaturesBc$1.value()).map((Function1)new Serializable(this, nodeIndex){
                                public static final long serialVersionUID = 0L;
                                private final int nodeIndex$2;

                                public final int[] apply(scala.collection.immutable.Map<Object, int[]> nodeToFeatures) {
                                    return (int[])nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)this.nodeIndex$2));
                                }
                                {
                                    this.nodeIndex$2 = nodeIndex$2;
                                }
                            });
                            return new DTStatsAggregator(this.$outer.metadata$3, (Option<int[]>)featuresForNode);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.apply(DTStatsAggregator.class));
                    points.foreach((Function1)new Serializable(this, nodeStatsAggregators){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.8 $outer;
                        private final DTStatsAggregator[] nodeStatsAggregators$1;

                        public final DTStatsAggregator[] apply(Tuple2<BaggedPoint<TreePoint>, int[]> x$3) {
                            return RandomForest$.MODULE$.org$apache$spark$ml$tree$impl$RandomForest$$binSeqOpWithNodeIdCache$1(this.nodeStatsAggregators$1, x$3, this.$outer.metadata$3, this.$outer.treeToNodeToIndexInfo$1, this.$outer.splits$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.nodeStatsAggregators$1 = nodeStatsAggregators$1;
                        }
                    });
                    return ((IterableLike)((TraversableViewLike)Predef$.MODULE$.refArrayOps((Object[])nodeStatsAggregators).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, DTStatsAggregator> apply(Tuple2<DTStatsAggregator, Object> x$4) {
                            return x$4.swap();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).iterator();
                }
                {
                    this.metadata$3 = metadata$3;
                    this.treeToNodeToIndexInfo$1 = treeToNodeToIndexInfo$1;
                    this.splits$1 = splits$1;
                    this.numNodes$1 = numNodes$1;
                    this.nodeToFeaturesBc$1 = nodeToFeaturesBc$1;
                }
            };
            boolean x$29 = qual$1.mapPartitions$default$2();
            rDD = qual$1.mapPartitions((Function1)x$28, x$29, ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            rDD = input.mapPartitions((Function1)new Serializable(metadata, topNodesForGroup, treeToNodeToIndexInfo, splits, numNodes, nodeToFeaturesBc){
                public static final long serialVersionUID = 0L;
                public final DecisionTreeMetadata metadata$3;
                public final scala.collection.immutable.Map topNodesForGroup$1;
                public final scala.collection.immutable.Map treeToNodeToIndexInfo$1;
                public final Split[][] splits$1;
                private final int numNodes$1;
                public final Broadcast nodeToFeaturesBc$1;

                public final Iterator<Tuple2<Object, DTStatsAggregator>> apply(Iterator<BaggedPoint<TreePoint>> points) {
                    DTStatsAggregator[] nodeStatsAggregators = (DTStatsAggregator[])Array$.MODULE$.tabulate(this.numNodes$1, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.11 $outer;

                        public final DTStatsAggregator apply(int nodeIndex) {
                            Option featuresForNode = ((Option)this.$outer.nodeToFeaturesBc$1.value()).flatMap((Function1)new Serializable(this, nodeIndex){
                                public static final long serialVersionUID = 0L;
                                private final int nodeIndex$3;

                                public final Some<int[]> apply(scala.collection.immutable.Map<Object, int[]> nodeToFeatures) {
                                    return new Some(nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)this.nodeIndex$3)));
                                }
                                {
                                    this.nodeIndex$3 = nodeIndex$3;
                                }
                            });
                            return new DTStatsAggregator(this.$outer.metadata$3, (Option<int[]>)featuresForNode);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.apply(DTStatsAggregator.class));
                    points.foreach((Function1)new Serializable(this, nodeStatsAggregators){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.11 $outer;
                        private final DTStatsAggregator[] nodeStatsAggregators$2;

                        public final DTStatsAggregator[] apply(BaggedPoint<TreePoint> x$5) {
                            return RandomForest$.MODULE$.org$apache$spark$ml$tree$impl$RandomForest$$binSeqOp$1(this.nodeStatsAggregators$2, x$5, this.$outer.metadata$3, this.$outer.topNodesForGroup$1, this.$outer.treeToNodeToIndexInfo$1, this.$outer.splits$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.nodeStatsAggregators$2 = nodeStatsAggregators$2;
                        }
                    });
                    return ((IterableLike)((TraversableViewLike)Predef$.MODULE$.refArrayOps((Object[])nodeStatsAggregators).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, DTStatsAggregator> apply(Tuple2<DTStatsAggregator, Object> x$6) {
                            return x$6.swap();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).iterator();
                }
                {
                    this.metadata$3 = metadata$3;
                    this.topNodesForGroup$1 = topNodesForGroup$1;
                    this.treeToNodeToIndexInfo$1 = treeToNodeToIndexInfo$1;
                    this.splits$1 = splits$1;
                    this.numNodes$1 = numNodes$1;
                    this.nodeToFeaturesBc$1 = nodeToFeaturesBc$1;
                }
            }, input.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        }
        RDD partitionAggregates = rDD;
        Map nodeToBestSplits = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(partitionAggregates, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(DTStatsAggregator.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DTStatsAggregator apply(DTStatsAggregator a, DTStatsAggregator b) {
                return a.merge(b);
            }
        }).map((Function1)new Serializable(splits, nodes, nodeToFeaturesBc){
            public static final long serialVersionUID = 0L;
            private final Split[][] splits$1;
            private final LearningNode[] nodes$1;
            private final Broadcast nodeToFeaturesBc$1;

            public final Tuple2<Object, Tuple2<Split, ImpurityStats>> apply(Tuple2<Object, DTStatsAggregator> x0$4) {
                Tuple2<Object, DTStatsAggregator> tuple2 = x0$4;
                if (tuple2 != null) {
                    Option featuresForNode;
                    int nodeIndex = tuple2._1$mcI$sp();
                    DTStatsAggregator aggStats = (DTStatsAggregator)tuple2._2();
                    Tuple2<Split, ImpurityStats> tuple22 = RandomForest$.MODULE$.binsToBestSplit(aggStats, this.splits$1, (Option<int[]>)(featuresForNode = ((Option)this.nodeToFeaturesBc$1.value()).flatMap((Function1)new Serializable(this, nodeIndex){
                        public static final long serialVersionUID = 0L;
                        private final int nodeIndex$1;

                        public final Some<int[]> apply(scala.collection.immutable.Map<Object, int[]> nodeToFeatures) {
                            return new Some(nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)this.nodeIndex$1)));
                        }
                        {
                            this.nodeIndex$1 = nodeIndex$1;
                        }
                    })), this.nodes$1[nodeIndex]);
                    if (tuple22 != null) {
                        Split split = (Split)tuple22._1();
                        ImpurityStats stats = (ImpurityStats)tuple22._2();
                        if (split != null) {
                            Split split2 = split;
                            if (stats != null) {
                                Tuple2 tuple23;
                                ImpurityStats impurityStats = stats;
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)split2, (Object)impurityStats);
                                Split split3 = (Split)tuple24._1();
                                ImpurityStats stats2 = (ImpurityStats)tuple24._2();
                                Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Object)new Tuple2((Object)split3, (Object)stats2));
                                return tuple25;
                            }
                        }
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                this.splits$1 = splits$1;
                this.nodes$1 = nodes$1;
                this.nodeToFeaturesBc$1 = nodeToFeaturesBc$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
        timer.stop("chooseSplits");
        scala.collection.mutable.Map[] nodeIdUpdaters = nodeIdCache.nonEmpty() ? (scala.collection.mutable.Map[])Array$.MODULE$.fill(metadata.numTrees(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<Object, NodeIndexUpdater> apply() {
                return (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        }, ClassTag$.MODULE$.apply(scala.collection.mutable.Map.class)) : null;
        nodesForGroup.foreach((Function1)new Serializable(metadata, treeToNodeToIndexInfo, nodeStack, nodeIdCache, nodeToBestSplits, nodeIdUpdaters){
            public static final long serialVersionUID = 0L;
            public final DecisionTreeMetadata metadata$3;
            public final scala.collection.immutable.Map treeToNodeToIndexInfo$1;
            public final Stack nodeStack$2;
            public final Option nodeIdCache$1;
            public final Map nodeToBestSplits$1;
            public final scala.collection.mutable.Map[] nodeIdUpdaters$1;

            public final void apply(Tuple2<Object, LearningNode[]> x0$5) {
                Tuple2<Object, LearningNode[]> tuple2 = x0$5;
                if (tuple2 != null) {
                    int treeIndex = tuple2._1$mcI$sp();
                    LearningNode[] nodesForTree = (LearningNode[])tuple2._2();
                    Predef$.MODULE$.refArrayOps((Object[])nodesForTree).foreach((Function1)new Serializable(this, treeIndex){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.findBestSplits.8 $outer;
                        private final int treeIndex$2;

                        public final void apply(LearningNode node) {
                            int nodeIndex = node.id();
                            RandomForest.NodeIndexInfo nodeInfo = (RandomForest.NodeIndexInfo)((MapLike)this.$outer.treeToNodeToIndexInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)this.treeIndex$2))).apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex));
                            int aggNodeIndex = nodeInfo.nodeIndexInGroup();
                            Tuple2 tuple2 = (Tuple2)this.$outer.nodeToBestSplits$1.apply((Object)BoxesRunTime.boxToInteger((int)aggNodeIndex));
                            if (tuple2 != null) {
                                Split split = (Split)tuple2._1();
                                ImpurityStats stats = (ImpurityStats)tuple2._2();
                                if (split != null) {
                                    Split split2 = split;
                                    if (stats != null) {
                                        Tuple2 tuple22;
                                        ImpurityStats impurityStats = stats;
                                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)split2, (Object)impurityStats);
                                        Split split3 = (Split)tuple23._1();
                                        ImpurityStats stats2 = (ImpurityStats)tuple23._2();
                                        RandomForest$.MODULE$.logDebug((Function0<String>)new Serializable(this, split3){
                                            public static final long serialVersionUID = 0L;
                                            private final Split split$1;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"best split = ").append((Object)this.split$1).toString();
                                            }
                                            {
                                                this.split$1 = split$1;
                                            }
                                        });
                                        boolean isLeaf = stats2.gain() <= 0.0 || LearningNode$.MODULE$.indexToLevel(nodeIndex) == this.$outer.metadata$3.maxDepth();
                                        node.isLeaf_$eq(isLeaf);
                                        node.stats_$eq(stats2);
                                        RandomForest$.MODULE$.logDebug((Function0<String>)new Serializable(this, node){
                                            public static final long serialVersionUID = 0L;
                                            private final LearningNode node$1;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"Node = ").append((Object)this.node$1).toString();
                                            }
                                            {
                                                this.node$1 = node$1;
                                            }
                                        });
                                        if (!isLeaf) {
                                            BoxedUnit boxedUnit;
                                            node.split_$eq((Option<Split>)new Some((Object)split3));
                                            boolean childIsLeaf = LearningNode$.MODULE$.indexToLevel(nodeIndex) + 1 == this.$outer.metadata$3.maxDepth();
                                            boolean leftChildIsLeaf = childIsLeaf || stats2.leftImpurity() == 0.0;
                                            boolean rightChildIsLeaf = childIsLeaf || stats2.rightImpurity() == 0.0;
                                            node.leftChild_$eq((Option<LearningNode>)new Some((Object)LearningNode$.MODULE$.apply(LearningNode$.MODULE$.leftChildIndex(nodeIndex), leftChildIsLeaf, ImpurityStats$.MODULE$.getEmptyImpurityStats(stats2.leftImpurityCalculator()))));
                                            node.rightChild_$eq((Option<LearningNode>)new Some((Object)LearningNode$.MODULE$.apply(LearningNode$.MODULE$.rightChildIndex(nodeIndex), rightChildIsLeaf, ImpurityStats$.MODULE$.getEmptyImpurityStats(stats2.rightImpurityCalculator()))));
                                            if (this.$outer.nodeIdCache$1.nonEmpty()) {
                                                NodeIndexUpdater nodeIndexUpdater = new NodeIndexUpdater(split3, nodeIndex);
                                                boxedUnit = this.$outer.nodeIdUpdaters$1[this.treeIndex$2].put((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Object)nodeIndexUpdater);
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            Object object = leftChildIsLeaf ? BoxedUnit.UNIT : this.$outer.nodeStack$2.push((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.treeIndex$2), node.leftChild().get()));
                                            Object object2 = rightChildIsLeaf ? BoxedUnit.UNIT : this.$outer.nodeStack$2.push((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.treeIndex$2), node.rightChild().get()));
                                            RandomForest$.MODULE$.logDebug((Function0<String>)new Serializable(this, stats2, node){
                                                public static final long serialVersionUID = 0L;
                                                private final ImpurityStats stats$1;
                                                private final LearningNode node$1;

                                                public final String apply() {
                                                    return new StringBuilder().append((Object)"leftChildIndex = ").append((Object)BoxesRunTime.boxToInteger((int)((LearningNode)this.node$1.leftChild().get()).id())).append((Object)", impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.stats$1.leftImpurity())).toString();
                                                }
                                                {
                                                    this.stats$1 = stats$1;
                                                    this.node$1 = node$1;
                                                }
                                            });
                                            RandomForest$.MODULE$.logDebug((Function0<String>)new Serializable(this, stats2, node){
                                                public static final long serialVersionUID = 0L;
                                                private final ImpurityStats stats$1;
                                                private final LearningNode node$1;

                                                public final String apply() {
                                                    return new StringBuilder().append((Object)"rightChildIndex = ").append((Object)BoxesRunTime.boxToInteger((int)((LearningNode)this.node$1.rightChild().get()).id())).append((Object)", impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.stats$1.rightImpurity())).toString();
                                                }
                                                {
                                                    this.stats$1 = stats$1;
                                                    this.node$1 = node$1;
                                                }
                                            });
                                        }
                                        return;
                                    }
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.treeIndex$2 = treeIndex$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$3 = metadata$3;
                this.treeToNodeToIndexInfo$1 = treeToNodeToIndexInfo$1;
                this.nodeStack$2 = nodeStack$2;
                this.nodeIdCache$1 = nodeIdCache$1;
                this.nodeToBestSplits$1 = nodeToBestSplits$1;
                this.nodeIdUpdaters$1 = nodeIdUpdaters$1;
            }
        });
        if (nodeIdCache.nonEmpty()) {
            ((NodeIdCache)nodeIdCache.get()).updateNodeIndices(input, nodeIdUpdaters, splits);
        }
    }

    public TimeTracker findBestSplits$default$8() {
        return new TimeTracker();
    }

    public Option<NodeIdCache> findBestSplits$default$9() {
        return None$.MODULE$;
    }

    public ImpurityStats org$apache$spark$ml$tree$impl$RandomForest$$calculateImpurityStats(ImpurityStats stats, ImpurityCalculator leftImpurityCalculator, ImpurityCalculator rightImpurityCalculator, DecisionTreeMetadata metadata) {
        double rightImpurity;
        double rightWeight;
        ImpurityCalculator parentImpurityCalculator = stats == null ? leftImpurityCalculator.copy().add(rightImpurityCalculator) : stats.impurityCalculator();
        double impurity = stats == null ? parentImpurityCalculator.calculate() : stats.impurity();
        long leftCount = leftImpurityCalculator.count();
        long rightCount = rightImpurityCalculator.count();
        long totalCount = leftCount + rightCount;
        if (leftCount < (long)metadata.minInstancesPerNode() || rightCount < (long)metadata.minInstancesPerNode()) {
            return ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator);
        }
        double leftWeight = (double)leftCount / (double)totalCount;
        double leftImpurity = leftImpurityCalculator.calculate();
        double gain = impurity - leftWeight * leftImpurity - (rightWeight = (double)rightCount / (double)totalCount) * (rightImpurity = rightImpurityCalculator.calculate());
        if (gain < metadata.minInfoGain()) {
            return ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator);
        }
        return new ImpurityStats(gain, impurity, parentImpurityCalculator, leftImpurityCalculator, rightImpurityCalculator, ImpurityStats$.MODULE$.$lessinit$greater$default$6());
    }

    public Tuple2<Split, ImpurityStats> binsToBestSplit(DTStatsAggregator binAggregates, Split[][] splits, Option<int[]> featuresForNode, LearningNode node) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        int level = LearningNode$.MODULE$.indexToLevel(node.id());
        ObjectRef gainAndImpurityStats = ObjectRef.create((Object)(level == 0 ? null : node.stats()));
        SeqView validFeatureSplits = (SeqView)((TraversableViewLike)scala.package$.MODULE$.Range().apply(0, binAggregates.metadata().numFeaturesPerNode()).view().map((Function1)new Serializable(featuresForNode){
            public static final long serialVersionUID = 0L;
            private final Option featuresForNode$1;

            public final Tuple2<Object, Object> apply(int featureIndexIdx) {
                return (Tuple2)this.featuresForNode$1.map((Function1)new Serializable(this, featureIndexIdx){
                    public static final long serialVersionUID = 0L;
                    private final int featureIndexIdx$1;

                    public final Tuple2<Object, Object> apply(int[] features) {
                        return new Tuple2.mcII.sp(this.featureIndexIdx$1, features[this.featureIndexIdx$1]);
                    }
                    {
                        this.featureIndexIdx$1 = featureIndexIdx$1;
                    }
                }).getOrElse((Function0)new Serializable(this, featureIndexIdx){
                    public static final long serialVersionUID = 0L;
                    private final int featureIndexIdx$1;

                    public final Tuple2<Object, Object> apply() {
                        return new Tuple2.mcII.sp(this.featureIndexIdx$1, this.featureIndexIdx$1);
                    }
                    {
                        this.featureIndexIdx$1 = featureIndexIdx$1;
                    }
                });
            }
            {
                this.featuresForNode$1 = featuresForNode$1;
            }
        }, SeqView$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(binAggregates){
            public static final long serialVersionUID = 0L;
            private final DTStatsAggregator binAggregates$1;

            public final boolean apply(Tuple2<Object, Object> x0$6) {
                Tuple2<Object, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    int featureIndex = tuple2._2$mcI$sp();
                    boolean bl = this.binAggregates$1.metadata().numSplits(featureIndex) != 0;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.binAggregates$1 = binAggregates$1;
            }
        });
        SeqView splitsAndImpurityInfo = (SeqView)validFeatureSplits.map((Function1)new Serializable(binAggregates, splits, gainAndImpurityStats){
            public static final long serialVersionUID = 0L;
            public final DTStatsAggregator binAggregates$1;
            private final Split[][] splits$2;
            public final ObjectRef gainAndImpurityStats$1;

            public final Tuple2<Split, ImpurityStats> apply(Tuple2<Object, Object> x0$7) {
                Tuple2<Object, Object> tuple2;
                block4: {
                    Tuple2 tuple22;
                    block10: {
                        Tuple2 tuple23;
                        block7: {
                            Tuple2 tuple24;
                            int numSplits;
                            int featureIndex;
                            int featureIndexIdx;
                            block8: {
                                Tuple2 tuple25;
                                block9: {
                                    Tuple2 tuple26;
                                    block5: {
                                        Tuple2 tuple27;
                                        block6: {
                                            Tuple2 tuple28;
                                            tuple2 = x0$7;
                                            if (tuple2 == null) break block4;
                                            featureIndexIdx = tuple2._1$mcI$sp();
                                            featureIndex = tuple2._2$mcI$sp();
                                            numSplits = this.binAggregates$1.metadata().numSplits(featureIndex);
                                            if (!this.binAggregates$1.metadata().isContinuous(featureIndex)) break block5;
                                            int nodeFeatureOffset = this.binAggregates$1.getFeatureOffset(featureIndexIdx);
                                            for (int splitIndex = 0; splitIndex < numSplits; ++splitIndex) {
                                                this.binAggregates$1.mergeForFeature(nodeFeatureOffset, splitIndex + 1, splitIndex);
                                            }
                                            tuple27 = (Tuple2)((TraversableOnce)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1)new Serializable(this, numSplits, nodeFeatureOffset){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun.20 $outer;
                                                private final int numSplits$1;
                                                private final int nodeFeatureOffset$1;

                                                public final Tuple2<Object, ImpurityStats> apply(int x0$8) {
                                                    int n = x0$8;
                                                    ImpurityCalculator leftChildStats = this.$outer.binAggregates$1.getImpurityCalculator(this.nodeFeatureOffset$1, n);
                                                    ImpurityCalculator rightChildStats = this.$outer.binAggregates$1.getImpurityCalculator(this.nodeFeatureOffset$1, this.numSplits$1);
                                                    rightChildStats.subtract(leftChildStats);
                                                    this.$outer.gainAndImpurityStats$1.elem = RandomForest$.MODULE$.org$apache$spark$ml$tree$impl$RandomForest$$calculateImpurityStats((ImpurityStats)this.$outer.gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, this.$outer.binAggregates$1.metadata());
                                                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)n), (Object)((ImpurityStats)this.$outer.gainAndImpurityStats$1.elem));
                                                    return tuple2;
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.numSplits$1 = numSplits$1;
                                                    this.nodeFeatureOffset$1 = nodeFeatureOffset$1;
                                                }
                                            }, IndexedSeq$.MODULE$.canBuildFrom())).maxBy((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final double apply(Tuple2<Object, ImpurityStats> x$9) {
                                                    return ((ImpurityStats)x$9._2()).gain();
                                                }
                                            }, (Ordering)Ordering.Double$.MODULE$);
                                            if (tuple27 == null) break block6;
                                            int bestFeatureSplitIndex = tuple27._1$mcI$sp();
                                            ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple27._2();
                                            Tuple2 tuple29 = tuple28 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                                            int bestFeatureSplitIndex2 = tuple29._1$mcI$sp();
                                            ImpurityStats bestFeatureGainStats2 = (ImpurityStats)tuple29._2();
                                            tuple23 = new Tuple2((Object)this.splits$2[featureIndex][bestFeatureSplitIndex2], (Object)bestFeatureGainStats2);
                                            break block7;
                                        }
                                        throw new MatchError((Object)tuple27);
                                    }
                                    if (!this.binAggregates$1.metadata().isUnordered(featureIndex)) break block8;
                                    int leftChildOffset = this.binAggregates$1.getFeatureOffset(featureIndexIdx);
                                    tuple25 = (Tuple2)((TraversableOnce)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1)new Serializable(this, leftChildOffset){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun.20 $outer;
                                        private final int leftChildOffset$1;

                                        public final Tuple2<Object, ImpurityStats> apply(int splitIndex) {
                                            ImpurityCalculator leftChildStats = this.$outer.binAggregates$1.getImpurityCalculator(this.leftChildOffset$1, splitIndex);
                                            ImpurityCalculator rightChildStats = this.$outer.binAggregates$1.getParentImpurityCalculator().subtract(leftChildStats);
                                            this.$outer.gainAndImpurityStats$1.elem = RandomForest$.MODULE$.org$apache$spark$ml$tree$impl$RandomForest$$calculateImpurityStats((ImpurityStats)this.$outer.gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, this.$outer.binAggregates$1.metadata());
                                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)splitIndex), (Object)((ImpurityStats)this.$outer.gainAndImpurityStats$1.elem));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.leftChildOffset$1 = leftChildOffset$1;
                                        }
                                    }, IndexedSeq$.MODULE$.canBuildFrom())).maxBy((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final double apply(Tuple2<Object, ImpurityStats> x$11) {
                                            return ((ImpurityStats)x$11._2()).gain();
                                        }
                                    }, (Ordering)Ordering.Double$.MODULE$);
                                    if (tuple25 == null) break block9;
                                    int bestFeatureSplitIndex = tuple25._1$mcI$sp();
                                    ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple25._2();
                                    Tuple2 tuple210 = tuple26 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                                    int bestFeatureSplitIndex3 = tuple210._1$mcI$sp();
                                    ImpurityStats bestFeatureGainStats3 = (ImpurityStats)tuple210._2();
                                    tuple23 = new Tuple2((Object)this.splits$2[featureIndex][bestFeatureSplitIndex3], (Object)bestFeatureGainStats3);
                                    break block7;
                                }
                                throw new MatchError((Object)tuple25);
                            }
                            int nodeFeatureOffset = this.binAggregates$1.getFeatureOffset(featureIndexIdx);
                            int numCategories = this.binAggregates$1.metadata().numBins()[featureIndex];
                            scala.collection.immutable.IndexedSeq centroidForCategories = (scala.collection.immutable.IndexedSeq)scala.package$.MODULE$.Range().apply(0, numCategories).map((Function1)new Serializable(this, nodeFeatureOffset){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.20 $outer;
                                private final int nodeFeatureOffset$2;

                                public final Tuple2<Object, Object> apply(int x0$9) {
                                    int n = x0$9;
                                    ImpurityCalculator categoryStats = this.$outer.binAggregates$1.getImpurityCalculator(this.nodeFeatureOffset$2, n);
                                    double centroid = categoryStats.count() != 0L ? (this.$outer.binAggregates$1.metadata().isMulticlass() ? categoryStats.calculate() : (this.$outer.binAggregates$1.metadata().isClassification() ? categoryStats.stats()[1] : categoryStats.predict())) : Double.MAX_VALUE;
                                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(n, centroid);
                                    return sp2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.nodeFeatureOffset$2 = nodeFeatureOffset$2;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                            RandomForest$.MODULE$.logDebug((Function0<String>)new Serializable(this, centroidForCategories){
                                public static final long serialVersionUID = 0L;
                                private final scala.collection.immutable.IndexedSeq centroidForCategories$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Centroids for categorical variable: ").append((Object)this.centroidForCategories$1.mkString(",")).toString();
                                }
                                {
                                    this.centroidForCategories$1 = centroidForCategories$1;
                                }
                            });
                            List categoriesSortedByCentroid = (List)centroidForCategories.toList().sortBy((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(Tuple2<Object, Object> x$13) {
                                    return x$13._2$mcD$sp();
                                }
                            }, (Ordering)Ordering.Double$.MODULE$);
                            RandomForest$.MODULE$.logDebug((Function0<String>)new Serializable(this, categoriesSortedByCentroid){
                                public static final long serialVersionUID = 0L;
                                private final List categoriesSortedByCentroid$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Sorted centroids for categorical variable = ").append((Object)this.categoriesSortedByCentroid$1.mkString(",")).toString();
                                }
                                {
                                    this.categoriesSortedByCentroid$1 = categoriesSortedByCentroid$1;
                                }
                            });
                            for (int splitIndex = 0; splitIndex < numSplits; ++splitIndex) {
                                int currentCategory = ((Tuple2)categoriesSortedByCentroid.apply(splitIndex))._1$mcI$sp();
                                int nextCategory = ((Tuple2)categoriesSortedByCentroid.apply(splitIndex + 1))._1$mcI$sp();
                                this.binAggregates$1.mergeForFeature(nodeFeatureOffset, nextCategory, currentCategory);
                            }
                            int lastCategory = ((Tuple2)categoriesSortedByCentroid.last())._1$mcI$sp();
                            tuple22 = (Tuple2)((TraversableOnce)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1)new Serializable(this, nodeFeatureOffset, categoriesSortedByCentroid, lastCategory){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.20 $outer;
                                private final int nodeFeatureOffset$2;
                                private final List categoriesSortedByCentroid$1;
                                private final int lastCategory$1;

                                public final Tuple2<Object, ImpurityStats> apply(int splitIndex) {
                                    int featureValue = ((Tuple2)this.categoriesSortedByCentroid$1.apply(splitIndex))._1$mcI$sp();
                                    ImpurityCalculator leftChildStats = this.$outer.binAggregates$1.getImpurityCalculator(this.nodeFeatureOffset$2, featureValue);
                                    ImpurityCalculator rightChildStats = this.$outer.binAggregates$1.getImpurityCalculator(this.nodeFeatureOffset$2, this.lastCategory$1);
                                    rightChildStats.subtract(leftChildStats);
                                    this.$outer.gainAndImpurityStats$1.elem = RandomForest$.MODULE$.org$apache$spark$ml$tree$impl$RandomForest$$calculateImpurityStats((ImpurityStats)this.$outer.gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, this.$outer.binAggregates$1.metadata());
                                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)splitIndex), (Object)((ImpurityStats)this.$outer.gainAndImpurityStats$1.elem));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.nodeFeatureOffset$2 = nodeFeatureOffset$2;
                                    this.categoriesSortedByCentroid$1 = categoriesSortedByCentroid$1;
                                    this.lastCategory$1 = lastCategory$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom())).maxBy((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(Tuple2<Object, ImpurityStats> x$14) {
                                    return ((ImpurityStats)x$14._2()).gain();
                                }
                            }, (Ordering)Ordering.Double$.MODULE$);
                            if (tuple22 == null) break block10;
                            int bestFeatureSplitIndex = tuple22._1$mcI$sp();
                            ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple22._2();
                            Tuple2 tuple211 = tuple24 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                            int bestFeatureSplitIndex4 = tuple211._1$mcI$sp();
                            ImpurityStats bestFeatureGainStats4 = (ImpurityStats)tuple211._2();
                            List categoriesForSplit = ((List)categoriesSortedByCentroid.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(Tuple2<Object, Object> x$16) {
                                    return x$16._1$mcI$sp();
                                }
                            }, List$.MODULE$.canBuildFrom())).slice(0, bestFeatureSplitIndex4 + 1);
                            CategoricalSplit bestFeatureSplit = new CategoricalSplit(featureIndex, (double[])categoriesForSplit.toArray(ClassTag$.MODULE$.Double()), numCategories);
                            tuple23 = new Tuple2((Object)bestFeatureSplit, (Object)bestFeatureGainStats4);
                        }
                        Tuple2 tuple212 = tuple23;
                        return tuple212;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                this.binAggregates$1 = binAggregates$1;
                this.splits$2 = splits$2;
                this.gainAndImpurityStats$1 = gainAndImpurityStats$1;
            }
        }, SeqView$.MODULE$.canBuildFrom());
        if (splitsAndImpurityInfo.isEmpty()) {
            int dummyFeatureIndex = BoxesRunTime.unboxToInt((Object)featuresForNode.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(int[] x$17) {
                    return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(x$17).head());
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 0;
                }
            }));
            ImpurityCalculator parentImpurityCalculator = binAggregates.getParentImpurityCalculator();
            if (binAggregates.metadata().isContinuous(dummyFeatureIndex)) {
                tuple22 = new Tuple2((Object)new ContinuousSplit(dummyFeatureIndex, 0.0), (Object)ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator));
            } else {
                int numCategories = BoxesRunTime.unboxToInt((Object)binAggregates.metadata().featureArity().apply((Object)BoxesRunTime.boxToInteger((int)dummyFeatureIndex)));
                tuple22 = new Tuple2((Object)new CategoricalSplit(dummyFeatureIndex, (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()), numCategories), (Object)ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator));
            }
        } else {
            tuple22 = tuple2 = (Tuple2)splitsAndImpurityInfo.maxBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Split, ImpurityStats> x$18) {
                    return ((ImpurityStats)x$18._2()).gain();
                }
            }, (Ordering)Ordering.Double$.MODULE$);
        }
        if (tuple2 != null) {
            Tuple2 tuple23;
            Split bestSplit = (Split)tuple2._1();
            ImpurityStats bestSplitStats = (ImpurityStats)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)bestSplit, (Object)bestSplitStats);
            Split bestSplit2 = (Split)tuple24._1();
            ImpurityStats bestSplitStats2 = (ImpurityStats)tuple24._2();
            return new Tuple2((Object)bestSplit2, (Object)bestSplitStats2);
        }
        throw new MatchError((Object)tuple2);
    }

    public Split[][] findSplits(RDD<LabeledPoint> input, DecisionTreeMetadata metadata, long seed) {
        RDD rDD;
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$2;

            public final String apply() {
                return new StringBuilder().append((Object)"isMulticlass = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.metadata$2.isMulticlass())).toString();
            }
            {
                this.metadata$2 = metadata$2;
            }
        });
        int numFeatures = metadata.numFeatures();
        scala.collection.immutable.IndexedSeq continuousFeatures = (scala.collection.immutable.IndexedSeq)scala.package$.MODULE$.Range().apply(0, numFeatures).filter((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$2;

            public final boolean apply(int featureIndex) {
                return this.apply$mcZI$sp(featureIndex);
            }

            public boolean apply$mcZI$sp(int featureIndex) {
                return this.metadata$2.isContinuous(featureIndex);
            }
            {
                this.metadata$2 = metadata$2;
            }
        });
        if (continuousFeatures.nonEmpty()) {
            int requiredSamples = package$.MODULE$.max(metadata.maxBins() * metadata.maxBins(), 10000);
            double fraction = (long)requiredSamples < metadata.numExamples() ? (double)requiredSamples / (double)metadata.numExamples() : 1.0;
            this.logDebug((Function0<String>)new Serializable(fraction){
                public static final long serialVersionUID = 0L;
                private final double fraction$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"fraction of data used for calculating quantiles = ").append((Object)BoxesRunTime.boxToDouble((double)this.fraction$1)).toString();
                }
                {
                    this.fraction$1 = fraction$1;
                }
            });
            rDD = input.sample(false, fraction, (long)new XORShiftRandom(seed).nextInt());
        } else {
            rDD = input.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(LabeledPoint.class));
        }
        RDD sampledInput = rDD;
        return this.findSplitsBySorting((RDD<LabeledPoint>)sampledInput, metadata, (IndexedSeq<Object>)continuousFeatures);
    }

    private Split[][] findSplitsBySorting(RDD<LabeledPoint> input, DecisionTreeMetadata metadata, IndexedSeq<Object> continuousFeatures) {
        int numPartitions = package$.MODULE$.min(continuousFeatures.length(), input.partitions().length);
        Map continuousSplits = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(input.flatMap((Function1)new Serializable(continuousFeatures){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq continuousFeatures$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(LabeledPoint point) {
                return (IndexedSeq)this.continuousFeatures$1.map((Function1)new Serializable(this, point){
                    public static final long serialVersionUID = 0L;
                    private final LabeledPoint point$1;

                    public final Tuple2<Object, Object> apply(int idx) {
                        return new Tuple2.mcID.sp(idx, this.point$1.features().apply(idx));
                    }
                    {
                        this.point$1 = point$1;
                    }
                }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.continuousFeatures$1 = continuousFeatures$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Int$.MODULE$).groupByKey(numPartitions).map((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$4;

            public final Tuple2<Object, Split[]> apply(Tuple2<Object, Iterable<Object>> x0$10) {
                Tuple2<Object, Iterable<Object>> tuple2 = x0$10;
                if (tuple2 != null) {
                    int idx = tuple2._1$mcI$sp();
                    Iterable samples = (Iterable)tuple2._2();
                    double[] thresholds2 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable<Object>)samples, this.metadata$4, idx);
                    Split[] splits = (Split[])Predef$.MODULE$.doubleArrayOps(thresholds2).map((Function1)new Serializable(this, idx){
                        public static final long serialVersionUID = 0L;
                        private final int idx$1;

                        public final ContinuousSplit apply(double thresh) {
                            return new ContinuousSplit(this.idx$1, thresh);
                        }
                        {
                            this.idx$1 = idx$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Split.class)));
                    RandomForest$.MODULE$.logDebug((Function0<String>)new Serializable(this, idx, splits){
                        public static final long serialVersionUID = 0L;
                        private final int idx$1;
                        private final Split[] splits$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"featureIndex = ", ", numSplits = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.idx$1), BoxesRunTime.boxToInteger((int)this.splits$3.length)}));
                        }
                        {
                            this.idx$1 = idx$1;
                            this.splits$3 = splits$3;
                        }
                    });
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)idx), (Object)splits);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$4 = metadata$4;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Split.class)), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
        int numFeatures = metadata.numFeatures();
        Split[][] splits = (Split[][])Array$.MODULE$.tabulate(numFeatures, (Function1)new Serializable(metadata, continuousSplits){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$4;
            private final Map continuousSplits$1;

            /*
             * WARNING - void declaration
             */
            public final Split[] apply(int x0$11) {
                int n;
                block7: {
                    Split[] splitArray;
                    block5: {
                        block6: {
                            block4: {
                                void var3_3;
                                n = x0$11;
                                switch (n) {
                                    default: 
                                }
                                if (!this.metadata$4.isContinuous(n)) break block4;
                                Split[] split = (Split[])this.continuousSplits$1.apply((Object)BoxesRunTime.boxToInteger((int)n));
                                this.metadata$4.setNumSplits(n, split.length);
                                splitArray = var3_3;
                                break block5;
                            }
                            if (!this.metadata$4.isCategorical(n) || !this.metadata$4.isUnordered(n)) break block6;
                            int featureArity = BoxesRunTime.unboxToInt((Object)this.metadata$4.featureArity().apply((Object)BoxesRunTime.boxToInteger((int)n)));
                            splitArray = (Split[])Array$.MODULE$.tabulate(this.metadata$4.numSplits(n), (Function1)new Serializable(this, featureArity, n){
                                public static final long serialVersionUID = 0L;
                                private final int featureArity$1;
                                private final int x1$2;

                                public final CategoricalSplit apply(int splitIndex) {
                                    List<Object> categories = RandomForest$.MODULE$.extractMultiClassCategories(splitIndex + 1, this.featureArity$1);
                                    return new CategoricalSplit(this.x1$2, (double[])categories.toArray(ClassTag$.MODULE$.Double()), this.featureArity$1);
                                }
                                {
                                    this.featureArity$1 = featureArity$1;
                                    this.x1$2 = x1$2;
                                }
                            }, ClassTag$.MODULE$.apply(Split.class));
                            break block5;
                        }
                        if (!this.metadata$4.isCategorical(n)) break block7;
                        splitArray = (Split[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Split.class));
                    }
                    return splitArray;
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            {
                this.metadata$4 = metadata$4;
                this.continuousSplits$1 = continuousSplits$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Split.class)));
        return splits;
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> extractMultiClassCategories(int input, int maxFeatureValue) {
        void var3_3;
        Nil$ categories = Nil$.MODULE$;
        int bitShiftedInput = input;
        for (int j = 0; j < maxFeatureValue; ++j) {
            if (bitShiftedInput % 2 != 0) {
                double d = j;
                categories = categories.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d));
            }
            bitShiftedInput >>= 1;
        }
        return var3_3;
    }

    public double[] findSplitsForContinuousFeature(Iterable<Object> featureSamples, DecisionTreeMetadata metadata, int featureIndex) {
        Tuple2 tuple2;
        block8: {
            double[] dArray;
            block7: {
                Tuple2 tuple22;
                block6: {
                    Predef$.MODULE$.require(metadata.isContinuous(featureIndex), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "findSplitsForContinuousFeature can only be used to find splits for a continuous feature.";
                        }
                    });
                    if (!featureSamples.isEmpty()) break block6;
                    dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
                    break block7;
                }
                int numSplits = metadata.numSplits(featureIndex);
                tuple2 = (Tuple2)featureSamples.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<scala.collection.immutable.Map<Object, Object>, Object> apply(Tuple2<scala.collection.immutable.Map<Object, Object>, Object> x0$12, double x1$1) {
                        Tuple2 tuple2 = new Tuple2(x0$12, (Object)BoxesRunTime.boxToDouble((double)x1$1));
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            double x = tuple2._2$mcD$sp();
                            if (tuple22 != null) {
                                scala.collection.immutable.Map m = (scala.collection.immutable.Map)tuple22._1();
                                int cnt = tuple22._2$mcI$sp();
                                Tuple2 tuple23 = new Tuple2((Object)m.$plus((Tuple2)new Tuple2.mcDI.sp(x, BoxesRunTime.unboxToInt((Object)m.getOrElse((Object)BoxesRunTime.boxToDouble((double)x), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return 0;
                                    }
                                })) + 1)), (Object)BoxesRunTime.boxToInteger((int)(cnt + 1)));
                                return tuple23;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                });
                if (tuple2 == null) break block8;
                scala.collection.immutable.Map valueCountMap = (scala.collection.immutable.Map)tuple2._1();
                int numSamples = tuple2._2$mcI$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)valueCountMap, (Object)BoxesRunTime.boxToInteger((int)numSamples));
                scala.collection.immutable.Map valueCountMap2 = (scala.collection.immutable.Map)tuple23._1();
                int numSamples2 = tuple23._2$mcI$sp();
                Tuple2[] valueCounts = (Tuple2[])((TraversableOnce)valueCountMap2.toSeq().sortBy((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$22) {
                        return x$22._1$mcD$sp();
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                int possibleSplits = valueCounts.length - 1;
                if (possibleSplits <= numSplits) {
                    dArray = (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])valueCounts).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple2<Object, Object> x$23) {
                            return x$23._1$mcD$sp();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).init();
                } else {
                    double stride = (double)numSamples2 / (double)(numSplits + 1);
                    this.logDebug((Function0<String>)new Serializable(stride){
                        public static final long serialVersionUID = 0L;
                        private final double stride$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"stride = ").append((Object)BoxesRunTime.boxToDouble((double)this.stride$1)).toString();
                        }
                        {
                            this.stride$1 = stride$1;
                        }
                    });
                    ArrayBuilder splitsBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                    int currentCount = valueCounts[0]._2$mcI$sp();
                    double targetCount = stride;
                    for (int index2 = 1; index2 < valueCounts.length; ++index2) {
                        double currentGap;
                        int previousCount = currentCount;
                        currentCount += valueCounts[index2]._2$mcI$sp();
                        double previousGap = package$.MODULE$.abs((double)previousCount - targetCount);
                        if (!(previousGap < (currentGap = package$.MODULE$.abs((double)currentCount - targetCount)))) continue;
                        splitsBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)valueCounts[index2 - 1]._1$mcD$sp()));
                        targetCount += stride;
                    }
                    dArray = (double[])splitsBuilder.result();
                }
            }
            double[] splits = dArray;
            return splits;
        }
        throw new MatchError((Object)tuple2);
    }

    public Tuple2<scala.collection.immutable.Map<Object, LearningNode[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>> selectNodesToSplit(Stack<Tuple2<Object, LearningNode>> nodeStack, long maxMemoryUsage, DecisionTreeMetadata metadata, Random rng) {
        HashMap mutableNodesForGroup = new HashMap();
        HashMap mutableTreeToNodeToIndexInfo = new HashMap();
        LongRef memUsage = LongRef.create((long)0L);
        IntRef numNodesInGroup = IntRef.create((int)0);
        while (nodeStack.nonEmpty() && (memUsage.elem < maxMemoryUsage || memUsage.elem == 0L)) {
            Tuple2 tuple2 = (Tuple2)nodeStack.top();
            if (tuple2 != null) {
                Tuple2 tuple22;
                int treeIndex = tuple2._1$mcI$sp();
                LearningNode node = (LearningNode)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)node);
                int treeIndex2 = tuple23._1$mcI$sp();
                LearningNode node2 = (LearningNode)tuple23._2();
                Object featureSubset = metadata.subsamplingFeatures() ? new Some(SamplingUtils$.MODULE$.reservoirSampleAndCount(scala.package$.MODULE$.Range().apply(0, metadata.numFeatures()).iterator(), metadata.numFeaturesPerNode(), rng.nextLong(), ClassTag$.MODULE$.Int())._1()) : None$.MODULE$;
                long nodeMemUsage = this.aggregateSizeForNode(metadata, (Option<int[]>)featureSubset) * 8L;
                if (memUsage.elem + nodeMemUsage <= maxMemoryUsage || memUsage.elem == 0L) {
                    nodeStack.pop();
                    ((ArrayBuffer)mutableNodesForGroup.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)treeIndex2), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final ArrayBuffer<LearningNode> apply() {
                            return new ArrayBuffer();
                        }
                    })).$plus$eq((Object)node2);
                    ((HashMap)mutableTreeToNodeToIndexInfo.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)treeIndex2), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final HashMap<Object, RandomForest.NodeIndexInfo> apply() {
                            return new HashMap();
                        }
                    })).update((Object)BoxesRunTime.boxToInteger((int)node2.id()), (Object)new RandomForest.NodeIndexInfo(numNodesInGroup.elem, (Option<int[]>)featureSubset));
                }
                ++numNodesInGroup.elem;
                memUsage.elem += nodeMemUsage;
                continue;
            }
            throw new MatchError((Object)tuple2);
        }
        if (memUsage.elem > maxMemoryUsage) {
            this.logWarning((Function0<String>)new Serializable(maxMemoryUsage, memUsage, numNodesInGroup){
                public static final long serialVersionUID = 0L;
                private final long maxMemoryUsage$2;
                private final LongRef memUsage$1;
                private final IntRef numNodesInGroup$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tree learning is using approximately ", " bytes per iteration, which"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.memUsage$1.elem)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" exceeds requested limit maxMemoryUsage=", ". This allows splitting"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxMemoryUsage$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " nodes in this iteration."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numNodesInGroup$1.elem)}))).toString();
                }
                {
                    this.maxMemoryUsage$2 = maxMemoryUsage$2;
                    this.memUsage$1 = memUsage$1;
                    this.numNodesInGroup$1 = numNodesInGroup$1;
                }
            });
        }
        scala.collection.immutable.Map nodesForGroup = mutableNodesForGroup.mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LearningNode[] apply(ArrayBuffer<LearningNode> x$25) {
                return (LearningNode[])x$25.toArray(ClassTag$.MODULE$.apply(LearningNode.class));
            }
        }).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map treeToNodeToIndexInfo = mutableTreeToNodeToIndexInfo.mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo> apply(HashMap<Object, RandomForest.NodeIndexInfo> x$26) {
                return x$26.toMap(Predef$.MODULE$.$conforms());
            }
        }).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
    }

    private long aggregateSizeForNode(DecisionTreeMetadata metadata, Option<int[]> featureSubset) {
        long totalBins = featureSubset.nonEmpty() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.intArrayOps((int[])featureSubset.get()).map((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$5;

            public final long apply(int featureIndex) {
                return this.apply$mcJI$sp(featureIndex);
            }

            public long apply$mcJI$sp(int featureIndex) {
                return this.metadata$5.numBins()[featureIndex];
            }
            {
                this.metadata$5 = metadata$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.intArrayOps(metadata.numBins()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(int x$27) {
                return this.apply$mcJI$sp(x$27);
            }

            public long apply$mcJI$sp(int x$27) {
                return x$27;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return metadata.isClassification() ? (long)metadata.numClasses() * totalBins : 3L * totalBins;
    }

    public final void org$apache$spark$ml$tree$impl$RandomForest$$nodeBinSeqOp$1(int treeIndex, RandomForest.NodeIndexInfo nodeInfo, DTStatsAggregator[] agg, BaggedPoint baggedPoint, DecisionTreeMetadata metadata$3, Split[][] splits$1) {
        if (nodeInfo != null) {
            int aggNodeIndex = nodeInfo.nodeIndexInGroup();
            Option<int[]> featuresForNode = nodeInfo.featureSubset();
            double instanceWeight = baggedPoint.subsampleWeights()[treeIndex];
            if (metadata$3.unorderedFeatures().isEmpty()) {
                this.orderedBinSeqOp(agg[aggNodeIndex], (TreePoint)baggedPoint.datum(), instanceWeight, featuresForNode);
            } else {
                this.mixedBinSeqOp(agg[aggNodeIndex], (TreePoint)baggedPoint.datum(), splits$1, metadata$3.unorderedFeatures(), instanceWeight, featuresForNode);
            }
            agg[aggNodeIndex].updateParent(((TreePoint)baggedPoint.datum()).label(), instanceWeight);
        }
    }

    public final DTStatsAggregator[] org$apache$spark$ml$tree$impl$RandomForest$$binSeqOp$1(DTStatsAggregator[] agg, BaggedPoint baggedPoint, DecisionTreeMetadata metadata$3, scala.collection.immutable.Map topNodesForGroup$1, scala.collection.immutable.Map treeToNodeToIndexInfo$1, Split[][] splits$1) {
        treeToNodeToIndexInfo$1.foreach((Function1)new Serializable(metadata$3, topNodesForGroup$1, splits$1, agg, baggedPoint){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$3;
            private final scala.collection.immutable.Map topNodesForGroup$1;
            private final Split[][] splits$1;
            private final DTStatsAggregator[] agg$1;
            private final BaggedPoint baggedPoint$1;

            public final void apply(Tuple2<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> x0$1) {
                Tuple2<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int treeIndex = tuple2._1$mcI$sp();
                    scala.collection.immutable.Map nodeIndexToInfo = (scala.collection.immutable.Map)tuple2._2();
                    int nodeIndex = ((LearningNode)this.topNodesForGroup$1.apply((Object)BoxesRunTime.boxToInteger((int)treeIndex))).predictImpl(((TreePoint)this.baggedPoint$1.datum()).binnedFeatures(), this.splits$1);
                    RandomForest$.MODULE$.org$apache$spark$ml$tree$impl$RandomForest$$nodeBinSeqOp$1(treeIndex, (RandomForest.NodeIndexInfo)nodeIndexToInfo.getOrElse((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), this.agg$1, this.baggedPoint$1, this.metadata$3, this.splits$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$3 = metadata$3;
                this.topNodesForGroup$1 = topNodesForGroup$1;
                this.splits$1 = splits$1;
                this.agg$1 = agg$1;
                this.baggedPoint$1 = baggedPoint$1;
            }
        });
        return agg;
    }

    public final DTStatsAggregator[] org$apache$spark$ml$tree$impl$RandomForest$$binSeqOpWithNodeIdCache$1(DTStatsAggregator[] agg, Tuple2 dataPoint, DecisionTreeMetadata metadata$3, scala.collection.immutable.Map treeToNodeToIndexInfo$1, Split[][] splits$1) {
        treeToNodeToIndexInfo$1.foreach((Function1)new Serializable(metadata$3, splits$1, agg, dataPoint){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$3;
            private final Split[][] splits$1;
            private final DTStatsAggregator[] agg$2;
            private final Tuple2 dataPoint$1;

            public final void apply(Tuple2<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> x0$2) {
                Tuple2<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int treeIndex = tuple2._1$mcI$sp();
                    scala.collection.immutable.Map nodeIndexToInfo = (scala.collection.immutable.Map)tuple2._2();
                    BaggedPoint baggedPoint = (BaggedPoint)this.dataPoint$1._1();
                    int[] nodeIdCache = (int[])this.dataPoint$1._2();
                    int nodeIndex = nodeIdCache[treeIndex];
                    RandomForest$.MODULE$.org$apache$spark$ml$tree$impl$RandomForest$$nodeBinSeqOp$1(treeIndex, (RandomForest.NodeIndexInfo)nodeIndexToInfo.getOrElse((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), this.agg$2, baggedPoint, this.metadata$3, this.splits$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$3 = metadata$3;
                this.splits$1 = splits$1;
                this.agg$2 = agg$2;
                this.dataPoint$1 = dataPoint$1;
            }
        });
        return agg;
    }

    private final Option getNodeToFeatures$1(scala.collection.immutable.Map treeToNodeToIndexInfo, DecisionTreeMetadata metadata$3) {
        None$ none$;
        if (metadata$3.subsamplingFeatures()) {
            HashMap mutableNodeToFeatures = new HashMap();
            treeToNodeToIndexInfo.values().foreach((Function1)new Serializable(mutableNodeToFeatures){
                public static final long serialVersionUID = 0L;
                public final HashMap mutableNodeToFeatures$1;

                public final void apply(scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo> nodeIdToNodeInfo) {
                    nodeIdToNodeInfo.values().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getNodeToFeatures.1.1 $outer;

                        public final void apply(RandomForest.NodeIndexInfo nodeIndexInfo) {
                            Predef$.MODULE$.assert(nodeIndexInfo.featureSubset().isDefined());
                            this.$outer.mutableNodeToFeatures$1.update((Object)BoxesRunTime.boxToInteger((int)nodeIndexInfo.nodeIndexInGroup()), nodeIndexInfo.featureSubset().get());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.mutableNodeToFeatures$1 = mutableNodeToFeatures$1;
                }
            });
            none$ = new Some((Object)mutableNodeToFeatures.toMap(Predef$.MODULE$.$conforms()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private RandomForest$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

