/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.SparkException;
import org.apache.spark.ml.feature.FeatureHasher;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.DefaultParamsReadable$class;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.mllib.feature.HashingTF$;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class FeatureHasher$
implements DefaultParamsReadable<FeatureHasher>,
Serializable {
    public static final FeatureHasher$ MODULE$;
    private final int seed;

    static {
        new FeatureHasher$();
    }

    @Override
    public MLReader<FeatureHasher> read() {
        return DefaultParamsReadable$class.read(this);
    }

    @Override
    public FeatureHasher load(String path) {
        return (FeatureHasher)MLReadable$class.load(this, path);
    }

    private int seed() {
        return this.seed;
    }

    public int murmur3Hash(Object term) {
        block11: {
            int n;
            block3: {
                Object object;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                object = term;
                                                if (object != null) break block2;
                                                n = this.seed();
                                                break block3;
                                            }
                                            if (!(object instanceof Boolean)) break block4;
                                            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                                            n = Murmur3_x86_32.hashInt((int)(bl ? 1 : 0), (int)this.seed());
                                            break block3;
                                        }
                                        if (!(object instanceof Byte)) break block5;
                                        byte by = BoxesRunTime.unboxToByte((Object)object);
                                        n = Murmur3_x86_32.hashInt((int)by, (int)this.seed());
                                        break block3;
                                    }
                                    if (!(object instanceof Short)) break block6;
                                    short s = BoxesRunTime.unboxToShort((Object)object);
                                    n = Murmur3_x86_32.hashInt((int)s, (int)this.seed());
                                    break block3;
                                }
                                if (!(object instanceof Integer)) break block7;
                                int n2 = BoxesRunTime.unboxToInt((Object)object);
                                n = Murmur3_x86_32.hashInt((int)n2, (int)this.seed());
                                break block3;
                            }
                            if (!(object instanceof Long)) break block8;
                            long l = BoxesRunTime.unboxToLong((Object)object);
                            n = Murmur3_x86_32.hashLong((long)l, (int)this.seed());
                            break block3;
                        }
                        if (!(object instanceof Float)) break block9;
                        float f = BoxesRunTime.unboxToFloat((Object)object);
                        n = Murmur3_x86_32.hashInt((int)Float.floatToIntBits(f), (int)this.seed());
                        break block3;
                    }
                    if (!(object instanceof Double)) break block10;
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    n = Murmur3_x86_32.hashLong((long)Double.doubleToLongBits(d), (int)this.seed());
                    break block3;
                }
                if (!(object instanceof String)) break block11;
                String string = (String)object;
                UTF8String utf8 = UTF8String.fromString((String)string);
                n = Murmur3_x86_32.hashUnsafeBytes2((Object)utf8.getBaseObject(), (long)utf8.getBaseOffset(), (int)utf8.numBytes(), (int)this.seed());
            }
            return n;
        }
        throw new SparkException(new StringBuilder().append((Object)"FeatureHasher with murmur3 algorithm does not ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"support type ", " of input data."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term.getClass().getCanonicalName()}))).toString());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FeatureHasher$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
        DefaultParamsReadable$class.$init$(this);
        this.seed = HashingTF$.MODULE$.seed();
    }
}

