/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.clustering.GaussianMixture$;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\t5\u0011Q#\u0012=qK\u000e$\u0018\r^5p]\u0006;wM]3hCR|'O\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t1\u0001\u0011\t\u0011)A\u00053\u0005Ya.^7GK\u0006$XO]3t!\ty!$\u0003\u0002\u001c!\t\u0019\u0011J\u001c;\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0011BY2XK&<\u0007\u000e^:\u0011\u0007}\u0011C%D\u0001!\u0015\t\tc!A\u0005ce>\fGmY1ti&\u00111\u0005\t\u0002\n\u0005J|\u0017\rZ2bgR\u00042aD\u0013(\u0013\t1\u0003CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0010Q%\u0011\u0011\u0006\u0005\u0002\u0007\t>,(\r\\3\t\u0011-\u0002!\u0011!Q\u0001\n1\n1BY2HCV\u001c8/[1ogB\u0019qDI\u0017\u0011\u0007=)c\u0006\u0005\u0003\u0010_E\n\u0014B\u0001\u0019\u0011\u0005\u0019!V\u000f\u001d7feA\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\u0007Y&t\u0017\r\\4\n\u0005Y\u001a$a\u0003#f]N,g+Z2u_JDQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtD\u0003\u0002\u001e={y\u0002\"a\u000f\u0001\u000e\u0003\tAQ\u0001G\u001cA\u0002eAQ!H\u001cA\u0002yAQaK\u001cA\u00021Bq\u0001\u0011\u0001C\u0002\u0013%\u0011)A\u0001l+\u0005I\u0002BB\"\u0001A\u0003%\u0011$\u0001\u0002lA!9Q\t\u0001a\u0001\n\u00131\u0015\u0001\u0003;pi\u0006d7I\u001c;\u0016\u0003\u001d\u0003\"a\u0004%\n\u0005%\u0003\"\u0001\u0002'p]\u001eDqa\u0013\u0001A\u0002\u0013%A*\u0001\u0007u_R\fGn\u00118u?\u0012*\u0017\u000f\u0006\u0002N!B\u0011qBT\u0005\u0003\u001fB\u0011A!\u00168ji\"9\u0011KSA\u0001\u0002\u00049\u0015a\u0001=%c!11\u000b\u0001Q!\n\u001d\u000b\u0011\u0002^8uC2\u001ce\u000e\u001e\u0011\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006\u0001b.Z<M_\u001ed\u0015n[3mS\"|w\u000eZ\u000b\u0002O!9\u0001\f\u0001a\u0001\n\u0013I\u0016\u0001\u00068fo2{w\rT5lK2L\u0007n\\8e?\u0012*\u0017\u000f\u0006\u0002N5\"9\u0011kVA\u0001\u0002\u00049\u0003B\u0002/\u0001A\u0003&q%A\toK^dun\u001a'jW\u0016d\u0017\u000e[8pI\u0002B\u0001B\u0018\u0001\t\u0006\u0004%IaX\u0001\u000b]\u0016<x+Z5hQR\u001cX#\u0001\u0013\t\u0011\u0005\u0004\u0001\u0012!Q!\n\u0011\n1B\\3x/\u0016Lw\r\u001b;tA!A1\r\u0001EC\u0002\u0013%A-\u0001\u0005oK^lU-\u00198t+\u0005)\u0007cA\b&c!Aq\r\u0001E\u0001B\u0003&Q-A\u0005oK^lU-\u00198tA!A\u0011\u000e\u0001EC\u0002\u0013%A-A\u0004oK^\u001cuN^:\t\u0011-\u0004\u0001\u0012!Q!\n\u0015\f\u0001B\\3x\u0007>48\u000f\t\u0005\t[\u0002A)\u0019!C\u0005]\u0006aq\u000e\u001c3HCV\u001c8/[1ogV\tq\u000eE\u0002\u0010KA\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u000b\u0005U$\u0011\u0001B:uCRL!a\u001e:\u0003)5+H\u000e^5wCJL\u0017\r^3HCV\u001c8/[1o\u0011!I\b\u0001#A!B\u0013y\u0017!D8mI\u001e\u000bWo]:jC:\u001c\b\u0005\u000b\u0002ywB\u0011q\u0002`\u0005\u0003{B\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000b}\u0004A\u0011\u0001$\u0002\u000b\r|WO\u001c;\t\r\u0005\r\u0001\u0001\"\u0001W\u00035awn\u001a'jW\u0016d\u0017\u000e[8pI\"1\u0011q\u0001\u0001\u0005\u0002}\u000bqa^3jO\"$8\u000f\u0003\u0004\u0002\f\u0001!\t\u0001Z\u0001\u0006[\u0016\fgn\u001d\u0005\u0007\u0003\u001f\u0001A\u0011\u00013\u0002\t\r|go\u001d\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003\r\tG\r\u001a\u000b\u0005\u0003/\tI\"D\u0001\u0001\u0011!\tY\"!\u0005A\u0002\u0005u\u0011\u0001C5ogR\fgnY3\u0011\u0007I\ny\"C\u0002\u0002\"M\u0012aAV3di>\u0014\bbBA\u0013\u0001\u0011\u0005\u0011qE\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0005\u0003/\tI\u0003C\u0004\u0002,\u0005\r\u0002\u0019\u0001\u001e\u0002\u000b=$\b.\u001a:")
public class ExpectationAggregator
implements Serializable {
    public final int org$apache$spark$ml$clustering$ExpectationAggregator$$numFeatures;
    private final Broadcast<double[]> bcWeights;
    private final Broadcast<Tuple2<DenseVector, DenseVector>[]> bcGaussians;
    private final int k;
    private long totalCnt;
    private double newLogLikelihood;
    private double[] newWeights;
    private DenseVector[] newMeans;
    private DenseVector[] newCovs;
    private transient MultivariateGaussian[] oldGaussians;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private double[] newWeights$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.newWeights = new double[this.k()];
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.newWeights;
        }
    }

    private DenseVector[] newMeans$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.newMeans = (DenseVector[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExpectationAggregator $outer;

                    public final DenseVector apply() {
                        return new DenseVector((double[])Array$.MODULE$.fill(this.$outer.org$apache$spark$ml$clustering$ExpectationAggregator$$numFeatures, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        }, ClassTag$.MODULE$.Double()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(DenseVector.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.newMeans;
        }
    }

    private DenseVector[] newCovs$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.newCovs = (DenseVector[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExpectationAggregator $outer;

                    public final DenseVector apply() {
                        return new DenseVector((double[])Array$.MODULE$.fill(this.$outer.org$apache$spark$ml$clustering$ExpectationAggregator$$numFeatures * (this.$outer.org$apache$spark$ml$clustering$ExpectationAggregator$$numFeatures + 1) / 2, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        }, ClassTag$.MODULE$.Double()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(DenseVector.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.newCovs;
        }
    }

    private MultivariateGaussian[] oldGaussians$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if (!this.bitmap$trans$0) {
                this.oldGaussians = (MultivariateGaussian[])Predef$.MODULE$.refArrayOps((Object[])this.bcGaussians.value()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExpectationAggregator $outer;

                    public final MultivariateGaussian apply(Tuple2<DenseVector, DenseVector> x0$7) {
                        Tuple2<DenseVector, DenseVector> tuple2 = x0$7;
                        if (tuple2 != null) {
                            DenseVector mean2 = (DenseVector)tuple2._1();
                            DenseVector covVec = (DenseVector)tuple2._2();
                            DenseMatrix cov = GaussianMixture$.MODULE$.unpackUpperTriangularMatrix(this.$outer.org$apache$spark$ml$clustering$ExpectationAggregator$$numFeatures, covVec.values());
                            MultivariateGaussian multivariateGaussian = new MultivariateGaussian((Vector)mean2, (Matrix)cov);
                            return multivariateGaussian;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
                this.bitmap$trans$0 = true;
            }
            return this.oldGaussians;
        }
    }

    private int k() {
        return this.k;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double newLogLikelihood() {
        return this.newLogLikelihood;
    }

    private void newLogLikelihood_$eq(double x$1) {
        this.newLogLikelihood = x$1;
    }

    private double[] newWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.newWeights$lzycompute() : this.newWeights;
    }

    private DenseVector[] newMeans() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.newMeans$lzycompute() : this.newMeans;
    }

    private DenseVector[] newCovs() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.newCovs$lzycompute() : this.newCovs;
    }

    private MultivariateGaussian[] oldGaussians() {
        return this.bitmap$trans$0 ? this.oldGaussians : this.oldGaussians$lzycompute();
    }

    public long count() {
        return this.totalCnt();
    }

    public double logLikelihood() {
        return this.newLogLikelihood();
    }

    public double[] weights() {
        return this.newWeights();
    }

    public DenseVector[] means() {
        return this.newMeans();
    }

    public DenseVector[] covs() {
        return this.newCovs();
    }

    public ExpectationAggregator add(Vector instance) {
        int i;
        double[] localWeights = (double[])this.bcWeights.value();
        MultivariateGaussian[] localOldGaussians = this.oldGaussians();
        double[] prob2 = new double[this.k()];
        double probSum = 0.0;
        for (i = 0; i < this.k(); ++i) {
            double p;
            prob2[i] = p = Utils$.MODULE$.EPSILON() + localWeights[i] * localOldGaussians[i].pdf(instance);
            probSum += p;
        }
        this.newLogLikelihood_$eq(this.newLogLikelihood() + package$.MODULE$.log(probSum));
        double[] localNewWeights = this.newWeights();
        DenseVector[] localNewMeans = this.newMeans();
        DenseVector[] localNewCovs = this.newCovs();
        for (i = 0; i < this.k(); ++i) {
            int n = i;
            prob2[n] = prob2[n] / probSum;
            int n2 = i;
            localNewWeights[n2] = localNewWeights[n2] + prob2[i];
            BLAS$.MODULE$.axpy(prob2[i], instance, (Vector)localNewMeans[i]);
            BLAS$.MODULE$.spr(prob2[i], instance, localNewCovs[i]);
        }
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public ExpectationAggregator merge(ExpectationAggregator other) {
        if (other.count() != 0L) {
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            double[] localThisNewWeights = this.newWeights();
            double[] localOtherNewWeights = other.newWeights();
            DenseVector[] localThisNewMeans = this.newMeans();
            DenseVector[] localOtherNewMeans = other.newMeans();
            DenseVector[] localThisNewCovs = this.newCovs();
            DenseVector[] localOtherNewCovs = other.newCovs();
            for (int i = 0; i < this.k(); ++i) {
                int n = i;
                localThisNewWeights[n] = localThisNewWeights[n] + localOtherNewWeights[i];
                BLAS$.MODULE$.axpy(1.0, (Vector)localOtherNewMeans[i], (Vector)localThisNewMeans[i]);
                BLAS$.MODULE$.axpy(1.0, (Vector)localOtherNewCovs[i], (Vector)localThisNewCovs[i]);
            }
            this.newLogLikelihood_$eq(this.newLogLikelihood() + other.newLogLikelihood());
        }
        return this;
    }

    public ExpectationAggregator(int numFeatures, Broadcast<double[]> bcWeights, Broadcast<Tuple2<DenseVector, DenseVector>[]> bcGaussians) {
        this.org$apache$spark$ml$clustering$ExpectationAggregator$$numFeatures = numFeatures;
        this.bcWeights = bcWeights;
        this.bcGaussians = bcGaussians;
        this.k = ((double[])bcWeights.value()).length;
        this.totalCnt = 0L;
        this.newLogLikelihood = 0.0;
    }
}

