/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import org.apache.spark.SparkException;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.DefaultParamsReadable$class;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Bucketizer$
implements DefaultParamsReadable<Bucketizer>,
Serializable {
    public static final Bucketizer$ MODULE$;
    private final String SKIP_INVALID;
    private final String ERROR_INVALID;
    private final String KEEP_INVALID;
    private final String[] supportedHandleInvalids;

    static {
        new Bucketizer$();
    }

    @Override
    public MLReader<Bucketizer> read() {
        return DefaultParamsReadable$class.read(this);
    }

    public String SKIP_INVALID() {
        return this.SKIP_INVALID;
    }

    public String ERROR_INVALID() {
        return this.ERROR_INVALID;
    }

    public String KEEP_INVALID() {
        return this.KEEP_INVALID;
    }

    public String[] supportedHandleInvalids() {
        return this.supportedHandleInvalids;
    }

    public boolean checkSplits(double[] splits) {
        boolean bl;
        if (splits.length < 3) {
            bl = false;
        } else {
            int n = splits.length - 1;
            for (int i = 0; i < n; ++i) {
                if (!(splits[i] >= splits[i + 1]) && !Predef$.MODULE$.double2Double(splits[i]).isNaN()) continue;
                return false;
            }
            bl = !Predef$.MODULE$.double2Double(splits[n]).isNaN();
        }
        return bl;
    }

    public boolean checkSplitsArray(double[][] splitsArray) {
        return Predef$.MODULE$.refArrayOps((Object[])splitsArray).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double[] x$3) {
                return Bucketizer$.MODULE$.checkSplits(x$3);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double binarySearchForBuckets(double[] splits, double feature, boolean keepInvalid) {
        double d;
        if (Predef$.MODULE$.double2Double(feature).isNaN()) {
            if (!keepInvalid) throw new SparkException("Bucketizer encountered NaN value. To handle or skip NaNs, try setting Bucketizer.handleInvalid.");
            d = splits.length - 1;
            return d;
        } else if (feature == BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(splits).last())) {
            d = splits.length - 2;
            return d;
        } else {
            int idx = Arrays.binarySearch(splits, feature);
            if (idx >= 0) {
                d = idx;
                return d;
            } else {
                int insertPos = -idx - 1;
                if (insertPos == 0 || insertPos == splits.length) {
                    throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature value ", " out of Bucketizer bounds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)feature)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" [", ", ", "].  Check your features, or loosen "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.doubleArrayOps(splits).head(), Predef$.MODULE$.doubleArrayOps(splits).last()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the lower/upper bound constraints."})).s((Seq)Nil$.MODULE$)).toString());
                }
                d = insertPos - 1;
            }
        }
        return d;
    }

    @Override
    public Bucketizer load(String path) {
        return (Bucketizer)MLReadable$class.load(this, path);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Bucketizer$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
        DefaultParamsReadable$class.$init$(this);
        this.SKIP_INVALID = "skip";
        this.ERROR_INVALID = "error";
        this.KEEP_INVALID = "keep";
        this.supportedHandleInvalids = (String[])((Object[])new String[]{this.SKIP_INVALID(), this.ERROR_INVALID(), this.KEEP_INVALID()});
    }
}

