/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.util.Arrays;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.fpm.FPGrowth$;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.apache.spark.mllib.fpm.FPTree;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001B\u0001\u0003\u00015\u0011\u0001B\u0012)He><H\u000f\u001b\u0006\u0003\u0007\u0011\t1A\u001a9n\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00155A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oOB\u0011qbG\u0005\u00039A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0002\u0004%IaH\u0001\u000b[&t7+\u001e9q_J$X#\u0001\u0011\u0011\u0005=\t\u0013B\u0001\u0012\u0011\u0005\u0019!u.\u001e2mK\"AA\u0005\u0001BA\u0002\u0013%Q%\u0001\bnS:\u001cV\u000f\u001d9peR|F%Z9\u0015\u0005\u0019J\u0003CA\b(\u0013\tA\u0003C\u0001\u0003V]&$\bb\u0002\u0016$\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0011\u0002\u00175LgnU;qa>\u0014H\u000f\t\u0005\t]\u0001\u0011\t\u0019!C\u0005_\u0005ia.^7QCJ$\u0018\u000e^5p]N,\u0012\u0001\r\t\u0003\u001fEJ!A\r\t\u0003\u0007%sG\u000f\u0003\u00055\u0001\t\u0005\r\u0011\"\u00036\u0003EqW/\u001c)beRLG/[8og~#S-\u001d\u000b\u0003MYBqAK\u001a\u0002\u0002\u0003\u0007\u0001\u0007\u0003\u00059\u0001\t\u0005\t\u0015)\u00031\u00039qW/\u001c)beRLG/[8og\u0002BaA\u000f\u0001\u0005\u0002\u0019Y\u0014A\u0002\u001fj]&$h\bF\u0002=}}\u0002\"!\u0010\u0001\u000e\u0003\tAQAH\u001dA\u0002\u0001BQAL\u001dA\u0002ABQA\u000f\u0001\u0005\u0002\u0005#\u0012\u0001\u0010\u0015\u0004\u0001\u000eK\u0005C\u0001#H\u001b\u0005)%B\u0001$\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0011\u0016\u0013QaU5oG\u0016\f\u0013AS\u0001\u0006c9\u001ad\u0006\r\u0005\u0006\u0019\u0002!\t!T\u0001\u000eg\u0016$X*\u001b8TkB\u0004xN\u001d;\u0015\u00059{U\"\u0001\u0001\t\u000byY\u0005\u0019\u0001\u0011)\u0007-\u001b\u0015\nC\u0003S\u0001\u0011\u00051+\u0001\ttKRtU/\u001c)beRLG/[8ogR\u0011a\n\u0016\u0005\u0006]E\u0003\r\u0001\r\u0015\u0004#\u000eK\u0005\"B,\u0001\t\u0003A\u0016a\u0001:v]V\u0011\u0011\f\u0019\u000b\u00035F$\"aW5\u0011\u0007ubf,\u0003\u0002^\u0005\tia\tU$s_^$\b.T8eK2\u0004\"a\u00181\r\u0001\u0011)\u0011M\u0016b\u0001E\n!\u0011\n^3n#\t\u0019g\r\u0005\u0002\u0010I&\u0011Q\r\u0005\u0002\b\u001d>$\b.\u001b8h!\tyq-\u0003\u0002i!\t\u0019\u0011I\\=\t\u000f)4\u0016\u0011!a\u0002W\u0006QQM^5eK:\u001cW\r\n\u001b\u0011\u00071|g,D\u0001n\u0015\tq\u0007#A\u0004sK\u001adWm\u0019;\n\u0005Al'\u0001C\"mCN\u001cH+Y4\t\u000bI4\u0006\u0019A:\u0002\t\u0011\fG/\u0019\t\u0004i^LX\"A;\u000b\u0005Y4\u0011a\u0001:eI&\u0011\u00010\u001e\u0002\u0004%\u0012#\u0005cA\b{=&\u00111\u0010\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0004-\u000eK\u0005\"B,\u0001\t\u0003qX#B@\u0002\u0006\u0005mA\u0003BA\u0001\u0003\u000f\u0001B!\u0010/\u0002\u0004A\u0019q,!\u0002\u0005\u000b\u0005l(\u0019\u00012\t\rIl\b\u0019AA\u0005!\u0019\tY!!\u0006\u0002\u001a5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0003kCZ\f'bAA\n\r\u0005\u0019\u0011\r]5\n\t\u0005]\u0011Q\u0002\u0002\b\u0015\u00064\u0018M\u0015#E!\ry\u00161\u0004\u0003\b\u0003;i(\u0019AA\u0010\u0005\u0019\u0011\u0015m]6fiF\u00191-!\t\u0011\r\u0005\r\u00121FA\u0002\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001\u00027b]\u001eT!!a\u0004\n\t\u00055\u0012Q\u0005\u0002\t\u0013R,'/\u00192mK\"\u001aQpQ%\t\u000f\u0005M\u0002\u0001\"\u0003\u00026\u0005aq-\u001a8Ge\u0016\f\u0018\n^3ngV!\u0011qGA#)!\tI$a\u0015\u0002Z\u0005uC\u0003BA\u001e\u0003\u001b\u0002Ba\u0004>\u0002>A9q\"a\u0010\u0002D\u0005\u001d\u0013bAA!!\t1A+\u001e9mKJ\u00022aXA#\t\u0019\t\u0017\u0011\u0007b\u0001EB\u0019q\"!\u0013\n\u0007\u0005-\u0003C\u0001\u0003M_:<\u0007BCA(\u0003c\t\t\u0011q\u0001\u0002R\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\t1|\u00171\t\u0005\be\u0006E\u0002\u0019AA+!\u0011!x/a\u0016\u0011\t=Q\u00181\t\u0005\t\u00037\n\t\u00041\u0001\u0002H\u0005AQ.\u001b8D_VtG\u000f\u0003\u0005\u0002`\u0005E\u0002\u0019AA1\u0003-\u0001\u0018M\u001d;ji&|g.\u001a:\u0011\t\u0005\r\u0014QM\u0007\u0002\r%\u0019\u0011q\r\u0004\u0003\u0017A\u000b'\u000f^5uS>tWM\u001d\u0005\b\u0003W\u0002A\u0011BA7\u0003=9WM\u001c$sKFLE/Z7tKR\u001cX\u0003BA8\u00053!\"\"!\u001d\u0003\"\t\u001d\"\u0011\u0006B\u0017)\u0011\t\u0019Ha\u0007\u0011\tQ<\u0018Q\u000f\t\u0007\u0003o\n\tKa\u0006\u000f\t\u0005e\u00141\u0013\b\u0005\u0003w\n\tJ\u0004\u0003\u0002~\u0005=e\u0002BA@\u0003\u001bsA!!!\u0002\f:!\u00111QAE\u001b\t\t)IC\u0002\u0002\b2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d9\u0011Q\u0013\u0002\t\u0002\u0005]\u0015\u0001\u0003$Q\u000fJ|w\u000f\u001e5\u0011\u0007u\nIJ\u0002\u0004\u0002\u0005!\u0005\u00111T\n\u0005\u00033s!\u0004C\u0004;\u00033#\t!a(\u0015\u0005\u0005]eaBAR\u00033\u0003\u0011Q\u0015\u0002\f\rJ,\u0017/\u0013;f[N,G/\u0006\u0003\u0002(\u0006M6\u0003BAQ\u001diA1\"a+\u0002\"\n\u0015\r\u0011\"\u0001\u0002.\u0006)\u0011\u000e^3ngV\u0011\u0011q\u0016\t\u0005\u001fi\f\t\fE\u0002`\u0003g#a!YAQ\u0005\u0004\u0011\u0007\u0006BAU\u0007&C1\"!/\u0002\"\n\u0005\t\u0015!\u0003\u00020\u00061\u0011\u000e^3ng\u0002BC!a.D\u0013\"Y\u0011qXAQ\u0005\u000b\u0007I\u0011AAa\u0003\u00111'/Z9\u0016\u0005\u0005\u001d\u0003\u0006BA_\u0007&C1\"a2\u0002\"\n\u0005\t\u0015!\u0003\u0002H\u0005)aM]3rA!\"\u0011QY\"J\u0011\u001dQ\u0014\u0011\u0015C\u0001\u0003\u001b$b!a4\u0002T\u0006]\u0007CBAi\u0003C\u000b\t,\u0004\u0002\u0002\u001a\"A\u00111VAf\u0001\u0004\ty\u000b\u000b\u0003\u0002T\u000eK\u0005\u0002CA`\u0003\u0017\u0004\r!a\u0012)\t\u0005]7)\u0013\u0015\u0005\u0003\u0017\u001c\u0015\n\u0003\u0005\u0002`\u0006\u0005F\u0011AAq\u0003%Q\u0017M^1Ji\u0016l7/\u0006\u0002\u0002dB1\u0011Q]Av\u0003ck!!a:\u000b\t\u0005%\u0018\u0011F\u0001\u0005kRLG.\u0003\u0003\u0002n\u0006\u001d(\u0001\u0002'jgRDC!!8D\u0013\"A\u00111_AQ\t\u0003\n)0\u0001\u0005u_N#(/\u001b8h)\t\t9\u0010\u0005\u0003\u0002z\u0006}hbA\b\u0002|&\u0019\u0011Q \t\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\tAa\u0001\u0003\rM#(/\u001b8h\u0015\r\ti\u0010\u0005\u0015\u0005\u0003C\u001b\u0015\n\u0003\u0006\u0003\n\u0005e\u0015\u0011!C\u0005\u0005\u0017\t1B]3bIJ+7o\u001c7wKR\u0011!Q\u0002\t\u0005\u0003G\u0011y!\u0003\u0003\u0003\u0012\u0005\u0015\"AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002\u001a\u000eK\u0005\u0006BAJ\u0007&\u00032a\u0018B\r\t\u0019\t\u0017\u0011\u000eb\u0001E\"Q!QDA5\u0003\u0003\u0005\u001dAa\b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007\u0005\u0003m_\n]\u0001b\u0002:\u0002j\u0001\u0007!1\u0005\t\u0005i^\u0014)\u0003\u0005\u0003\u0010u\n]\u0001\u0002CA.\u0003S\u0002\r!a\u0012\t\u0011\t-\u0012\u0011\u000ea\u0001\u0005K\t\u0011B\u001a:fc&#X-\\:\t\u0011\u0005}\u0013\u0011\u000ea\u0001\u0003CBqA!\r\u0001\t\u0013\u0011\u0019$A\nhK:\u001cuN\u001c3Ue\u0006t7/Y2uS>t7/\u0006\u0003\u00036\tMC\u0003\u0003B\u001c\u0005+\u0012YFa\u0019\u0015\t\te\"1\n\t\b\u0005w\u0011)\u0005\rB%\u001b\t\u0011iD\u0003\u0003\u0003@\t\u0005\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0005\u0007\u0002\u0012AC2pY2,7\r^5p]&!!q\tB\u001f\u0005\ri\u0015\r\u001d\t\u0004\u001fi\u0004\u0004B\u0003B'\u0005_\t\t\u0011q\u0001\u0003P\u0005QQM^5eK:\u001cW\rJ\u001c\u0011\t1|'\u0011\u000b\t\u0004?\nMCAB1\u00030\t\u0007!\r\u0003\u0005\u0003X\t=\u0002\u0019\u0001B-\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u0011\t=Q(\u0011\u000b\u0005\t\u0005;\u0012y\u00031\u0001\u0003`\u0005Q\u0011\u000e^3n)>\u0014\u0016M\\6\u0011\u000f\u0005e(\u0011\rB)a%!!q\tB\u0002\u0011!\tyFa\fA\u0002\u0005\u0005\u0004f\u0001\u0001D\u0013\u0002")
public class FPGrowth
implements Logging,
Serializable {
    private double minSupport;
    private int numPartitions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private double minSupport() {
        return this.minSupport;
    }

    private void minSupport_$eq(double x$1) {
        this.minSupport = x$1;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(int x$1) {
        this.numPartitions = x$1;
    }

    public FPGrowth setMinSupport(double minSupport) {
        Predef$.MODULE$.require(minSupport >= 0.0 && minSupport <= 1.0, (Function0)new Serializable(this, minSupport){
            public static final long serialVersionUID = 0L;
            private final double minSupport$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Minimal support level must be in range [0, 1] but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minSupport$1)}));
            }
            {
                this.minSupport$1 = minSupport$1;
            }
        });
        this.minSupport_$eq(minSupport);
        return this;
    }

    public FPGrowth setNumPartitions(int numPartitions) {
        Predef$.MODULE$.require(numPartitions > 0, (Function0)new Serializable(this, numPartitions){
            public static final long serialVersionUID = 0L;
            private final int numPartitions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of partitions must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numPartitions$1)}));
            }
            {
                this.numPartitions$1 = numPartitions$1;
            }
        });
        this.numPartitions_$eq(numPartitions);
        return this;
    }

    public <Item> FPGrowthModel<Item> run(RDD<Object> data, ClassTag<Item> evidence$4) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Input data is not cached.";
                }
            });
        }
        long count = data.count();
        long minCount = (long)package$.MODULE$.ceil(this.minSupport() * (double)count);
        int numParts = this.numPartitions() > 0 ? this.numPartitions() : data.partitions().length;
        HashPartitioner partitioner = new HashPartitioner(numParts);
        Tuple2<Item, Object>[] freqItemsCount = this.genFreqItems(data, minCount, (Partitioner)partitioner, evidence$4);
        RDD<FreqItemset<Item>> freqItemsets = this.genFreqItemsets(data, minCount, Predef$.MODULE$.refArrayOps((Object[])freqItemsCount).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Item apply(Tuple2<Item, Object> x$2) {
                return (Item)x$2._1();
            }
        }, Array$.MODULE$.canBuildFrom(evidence$4)), (Partitioner)partitioner, evidence$4);
        Map itemSupport = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])freqItemsCount).map((Function1)new Serializable(this, count){
            public static final long serialVersionUID = 0L;
            private final long count$1;

            public final Tuple2<Item, Object> apply(Tuple2<Item, Object> x0$1) {
                Tuple2<Item, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object item = tuple2._1();
                    long cnt = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(item), (Object)BoxesRunTime.boxToDouble((double)((double)cnt / (double)this.count$1)));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.count$1 = count$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        return new FPGrowthModel<Item>(freqItemsets, itemSupport, evidence$4);
    }

    public <Item, Basket extends java.lang.Iterable<Item>> FPGrowthModel<Item> run(JavaRDD<Basket> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return this.run((RDD<Object>)data.rdd().map((Function1)new Serializable(this, tag){
            public static final long serialVersionUID = 0L;
            private final ClassTag tag$1;

            public final Object apply(Basket x$3) {
                return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$3).asScala()).toArray(this.tag$1);
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass()))), tag);
    }

    private <Item> Tuple2<Item, Object>[] genFreqItems(RDD<Object> data, long minCount, Partitioner partitioner, ClassTag<Item> evidence$5) {
        RDD x$10 = data.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Item> apply(Object t) {
                Set uniq = Predef$.MODULE$.genericArrayOps(t).toSet();
                if (ScalaRunTime$.MODULE$.array_length(t) != uniq.size()) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Items in a transaction must be unique but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps(t).toSeq()})));
                }
                return Predef$.MODULE$.genericArrayOps(t);
            }
        }, evidence$5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Item, Object> apply(Item v) {
                return new Tuple2(v, (Object)BoxesRunTime.boxToLong((long)1L));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag<Item> x$11 = evidence$5;
        ClassTag x$12 = ClassTag$.MODULE$.Long();
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$10);
        Object x$13 = null;
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(x$10, x$11, x$12, null).reduceByKey(partitioner, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$4, long x$5) {
                return this.apply$mcJJJ$sp(x$4, x$5);
            }

            public long apply$mcJJJ$sp(long x$4, long x$5) {
                return x$4 + x$5;
            }
        }).filter((Function1)new Serializable(this, minCount){
            public static final long serialVersionUID = 0L;
            private final long minCount$1;

            public final boolean apply(Tuple2<Item, Object> x$6) {
                return x$6._2$mcJ$sp() >= this.minCount$1;
            }
            {
                this.minCount$1 = minCount$1;
            }
        }).collect()).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Item, Object> x$7) {
                return -x$7._2$mcJ$sp();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    private <Item> RDD<FreqItemset<Item>> genFreqItemsets(RDD<Object> data, long minCount, Object freqItems, Partitioner partitioner, ClassTag<Item> evidence$6) {
        Map itemToRank = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(freqItems).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        return RDD$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(this, partitioner, evidence$6, itemToRank){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FPGrowth $outer;
            private final Partitioner partitioner$1;
            private final ClassTag evidence$6$1;
            private final Map itemToRank$1;

            public final scala.collection.mutable.Map<Object, int[]> apply(Object transaction) {
                return this.$outer.org$apache$spark$mllib$fpm$FPGrowth$$genCondTransactions(transaction, this.itemToRank$1, this.partitioner$1, this.evidence$6$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitioner$1 = partitioner$1;
                this.evidence$6$1 = evidence$6$1;
                this.itemToRank$1 = itemToRank$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)), (Ordering)Ordering.Int$.MODULE$).aggregateByKey(new FPTree(), partitioner.numPartitions(), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FPTree<Object> apply(FPTree<Object> tree, int[] transaction) {
                return tree.add((Iterable<Object>)Predef$.MODULE$.wrapIntArray(transaction), 1L);
            }
        }, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FPTree<Object> apply(FPTree<Object> tree1, FPTree<Object> tree2) {
                return tree1.merge(tree2);
            }
        }, ClassTag$.MODULE$.apply(FPTree.class)).flatMap((Function1)new Serializable(this, minCount, partitioner){
            public static final long serialVersionUID = 0L;
            private final long minCount$2;
            public final Partitioner partitioner$1;

            public final Iterator<Tuple2<List<Object>, Object>> apply(Tuple2<Object, FPTree<Object>> x0$2) {
                Tuple2<Object, FPTree<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int part = tuple2._1$mcI$sp();
                    FPTree tree = (FPTree)tuple2._2();
                    Iterator<Tuple2<List<T>, Object>> iterator = tree.extract(this.minCount$2, new Serializable(this, part){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$genFreqItemsets$4 $outer;
                        private final int part$1;

                        public final boolean apply(int x) {
                            return this.apply$mcZI$sp(x);
                        }

                        public boolean apply$mcZI$sp(int x) {
                            return this.$outer.partitioner$1.getPartition((Object)BoxesRunTime.boxToInteger((int)x)) == this.part$1;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.part$1 = part$1;
                        }
                    });
                    return iterator;
                }
                throw new MatchError(tuple2);
            }
            {
                this.minCount$2 = minCount$2;
                this.partitioner$1 = partitioner$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this, freqItems, evidence$6){
            public static final long serialVersionUID = 0L;
            public final Object freqItems$1;
            private final ClassTag evidence$6$1;

            public final FreqItemset<Item> apply(Tuple2<List<Object>, Object> x0$3) {
                Tuple2<List<Object>, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    List ranks = (List)tuple2._1();
                    long count = tuple2._2$mcJ$sp();
                    FreqItemset<Item> freqItemset = new FreqItemset<Item>(((TraversableOnce)ranks.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$genFreqItemsets$5 $outer;

                        public final Item apply(int i) {
                            return (Item)ScalaRunTime$.MODULE$.array_apply(this.$outer.freqItems$1, i);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, List$.MODULE$.canBuildFrom())).toArray(this.evidence$6$1), count);
                    return freqItemset;
                }
                throw new MatchError(tuple2);
            }
            {
                this.freqItems$1 = freqItems$1;
                this.evidence$6$1 = evidence$6$1;
            }
        }, ClassTag$.MODULE$.apply(FreqItemset.class));
    }

    public <Item> scala.collection.mutable.Map<Object, int[]> org$apache$spark$mllib$fpm$FPGrowth$$genCondTransactions(Object transaction, Map<Item, Object> itemToRank, Partitioner partitioner, ClassTag<Item> evidence$7) {
        scala.collection.mutable.Map output = Map$.MODULE$.empty();
        int[] filtered = (int[])Predef$.MODULE$.genericArrayOps(transaction).flatMap((Function1)new Serializable(this, itemToRank){
            public static final long serialVersionUID = 0L;
            private final Map itemToRank$2;

            public final Iterable<Object> apply(Item key) {
                return Option$.MODULE$.option2Iterable(this.itemToRank$2.get(key));
            }
            {
                this.itemToRank$2 = itemToRank$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Arrays.sort(filtered);
        int n = filtered.length;
        for (int i = n - 1; i >= 0; --i) {
            int item = filtered[i];
            int part = partitioner.getPartition((Object)BoxesRunTime.boxToInteger((int)item));
            if (output.contains((Object)BoxesRunTime.boxToInteger((int)part))) continue;
            output.update((Object)BoxesRunTime.boxToInteger((int)part), Predef$.MODULE$.intArrayOps(filtered).slice(0, i + 1));
        }
        return output;
    }

    public FPGrowth(double minSupport, int numPartitions) {
        this.minSupport = minSupport;
        this.numPartitions = numPartitions;
        Logging.class.$init$((Logging)this);
    }

    public FPGrowth() {
        this(0.3, -1);
    }

    public static class FreqItemset<Item>
    implements Serializable {
        private final Object items;
        private final long freq;

        public Object items() {
            return this.items;
        }

        public long freq() {
            return this.freq;
        }

        public java.util.List<Item> javaItems() {
            return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps(this.items()).toList()).asJava();
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.genericArrayOps(this.items()).mkString("{", ",", "}"), BoxesRunTime.boxToLong((long)this.freq())}));
        }

        public FreqItemset(Object items, long freq) {
            this.items = items;
            this.freq = freq;
        }
    }
}

