/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.util.Locale;
import org.apache.spark.ml.clustering.LDAParams;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class LDAParams$class {
    public static int getK(LDAParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.k()));
    }

    public static double[] getDocConcentration(LDAParams $this) {
        return $this.$($this.docConcentration());
    }

    public static Vector getOldDocConcentration(LDAParams $this) {
        return $this.isSet($this.docConcentration()) ? Vectors$.MODULE$.dense($this.getDocConcentration()) : Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
    }

    public static double getTopicConcentration(LDAParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$($this.topicConcentration()));
    }

    public static double getOldTopicConcentration(LDAParams $this) {
        return $this.isSet($this.topicConcentration()) ? $this.getTopicConcentration() : -1.0;
    }

    public static String getOptimizer(LDAParams $this) {
        return $this.$($this.optimizer());
    }

    public static String getTopicDistributionCol(LDAParams $this) {
        return $this.$($this.topicDistributionCol());
    }

    public static double getLearningOffset(LDAParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$($this.learningOffset()));
    }

    public static double getLearningDecay(LDAParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$($this.learningDecay()));
    }

    public static double getSubsamplingRate(LDAParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$($this.subsamplingRate()));
    }

    public static boolean getOptimizeDocConcentration(LDAParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$($this.optimizeDocConcentration()));
    }

    public static boolean getKeepLastCheckpoint(LDAParams $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$($this.keepLastCheckpoint()));
    }

    public static StructType validateAndTransformSchema(LDAParams $this, StructType schema) {
        if ($this.isSet($this.docConcentration())) {
            String string;
            if ($this.getDocConcentration().length != 1) {
                Predef$.MODULE$.require($this.getDocConcentration().length == $this.getK(), (Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LDAParams $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA docConcentration was of length"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ", but k = ", ".  docConcentration must be an array of"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.getDocConcentration().length), BoxesRunTime.boxToInteger((int)this.$outer.getK())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" length either 1 (scalar) or k (num topics)."})).s((Seq)Nil$.MODULE$)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if ("online".equals(string = $this.getOptimizer().toLowerCase(Locale.ROOT))) {
                Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps($this.getDocConcentration()).forall((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$2) {
                        return this.apply$mcZD$sp(x$2);
                    }

                    public boolean apply$mcZD$sp(double x$2) {
                        return x$2 >= 0.0;
                    }
                }), (Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LDAParams $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"For Online LDA optimizer, docConcentration values must be >= 0.  Found values: ").append((Object)Predef$.MODULE$.doubleArrayOps(this.$outer.getDocConcentration()).mkString(",")).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("em".equals(string)) {
                Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps($this.getDocConcentration()).forall((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$3) {
                        return this.apply$mcZD$sp(x$3);
                    }

                    public boolean apply$mcZD$sp(double x$3) {
                        return x$3 >= 0.0;
                    }
                }), (Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LDAParams $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"For EM optimizer, docConcentration values must be >= 1.  Found values: ").append((Object)Predef$.MODULE$.doubleArrayOps(this.$outer.getDocConcentration()).mkString(",")).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)string);
            }
        }
        if ($this.isSet($this.topicConcentration())) {
            String string = $this.getOptimizer().toLowerCase(Locale.ROOT);
            if ("online".equals(string)) {
                Predef$.MODULE$.require($this.getTopicConcentration() >= 0.0, (Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LDAParams $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For Online LDA optimizer, topicConcentration"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" must be >= 0.  Found value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.getTopicConcentration())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("em".equals(string)) {
                Predef$.MODULE$.require($this.getTopicConcentration() >= 0.0, (Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LDAParams $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For EM optimizer, topicConcentration"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" must be >= 1.  Found value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.getTopicConcentration())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)string);
            }
        }
        SchemaUtils$.MODULE$.validateVectorCompatibleColumn(schema, $this.getFeaturesCol());
        return SchemaUtils$.MODULE$.appendColumn(schema, $this.$($this.topicDistributionCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public static LDAOptimizer getOldOptimizer(LDAParams $this) {
        String string;
        block4: {
            LDAOptimizer lDAOptimizer;
            block3: {
                block2: {
                    string = $this.getOptimizer().toLowerCase(Locale.ROOT);
                    if (!"online".equals(string)) break block2;
                    lDAOptimizer = new OnlineLDAOptimizer().setTau0(BoxesRunTime.unboxToDouble((Object)$this.$($this.learningOffset()))).setKappa(BoxesRunTime.unboxToDouble((Object)$this.$($this.learningDecay()))).setMiniBatchFraction(BoxesRunTime.unboxToDouble((Object)$this.$($this.subsamplingRate()))).setOptimizeDocConcentration(BoxesRunTime.unboxToBoolean((Object)$this.$($this.optimizeDocConcentration())));
                    break block3;
                }
                if (!"em".equals(string)) break block4;
                lDAOptimizer = new EMLDAOptimizer().setKeepLastCheckpoint(BoxesRunTime.unboxToBoolean((Object)$this.$($this.keepLastCheckpoint())));
            }
            return lDAOptimizer;
        }
        throw new MatchError((Object)string);
    }

    public static void $init$(LDAParams $this) {
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(new IntParam((Identifiable)$this, "k", "The number of topics (clusters) to infer. Must be > 1.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(1.0)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(new DoubleArrayParam($this, "docConcentration", "Concentration parameter (commonly named \"alpha\") for the prior placed on documents' distributions over topics (\"theta\").", (Function1<double[], Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double[] alpha) {
                return Predef$.MODULE$.doubleArrayOps(alpha).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$1) {
                        return this.apply$mcZD$sp(x$1);
                    }

                    public boolean apply$mcZD$sp(double x$1) {
                        return x$1 >= 0.0;
                    }
                });
            }
        }));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(new DoubleParam((Identifiable)$this, "topicConcentration", "Concentration parameter (commonly named \"beta\" or \"eta\") for the prior placed on topic' distributions over terms.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq((String[])((Object[])new String[]{"online", "em"}));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(new Param($this, "optimizer", new StringBuilder().append((Object)"Optimizer or inference algorithm used to estimate the LDA model. Supported: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])$this.supportedOptimizers()).mkString(", ")).toString(), new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDAParams $outer;

            public final boolean apply(String value) {
                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.supportedOptimizers()).contains((Object)value.toLowerCase(Locale.ROOT));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(new Param($this, "topicDistributionCol", "Output column with estimates of the topic mixture distribution for each document (often called \"theta\" in the literature).  Returns a vector of zeros for an empty document."));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.topicDistributionCol().$minus$greater("topicDistribution")}));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(new DoubleParam((Identifiable)$this, "learningOffset", "(For online optimizer) A (positive) learning parameter that downweights early iterations. Larger values make early iterations count less.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(new DoubleParam((Identifiable)$this, "learningDecay", "(For online optimizer) Learning rate, set as an exponential decay rate. This should be between (0.5, 1.0] to guarantee asymptotic convergence.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(new DoubleParam((Identifiable)$this, "subsamplingRate", "(For online optimizer) Fraction of the corpus to be sampled and used in each iteration of mini-batch gradient descent, in range (0, 1].", (Function1<Object, Object>)ParamValidators$.MODULE$.inRange(0.0, 1.0, false, true)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(new BooleanParam($this, "optimizeDocConcentration", "(For online optimizer only, currently) Indicates whether the docConcentration (Dirichlet parameter for document-topic distribution) will be optimized during training."));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(new BooleanParam($this, "keepLastCheckpoint", "(For EM optimizer) If using checkpointing, this indicates whether to keep the last checkpoint. If false, then the checkpoint will be deleted. Deleting the checkpoint can cause failures if a data partition is lost, so set this bit with care."));
    }
}

