/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.clustering.GaussianMixture$;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\r\u001a\t\u0011B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003L\u0001\u0011\u0005A\nC\u0004S\u0001\t\u0007I\u0011B*\t\rQ\u0003\u0001\u0015!\u00030\u0011\u001d)\u0006\u00011A\u0005\nYCqA\u0017\u0001A\u0002\u0013%1\f\u0003\u0004b\u0001\u0001\u0006Ka\u0016\u0005\bE\u0002\u0001\r\u0011\"\u0003d\u0011\u001d!\u0007\u00011A\u0005\n\u0015Daa\u001a\u0001!B\u0013a\u0004\u0002\u00035\u0001\u0011\u000b\u0007I\u0011B5\t\u0011)\u0004\u0001R1A\u0005\n-D\u0001\"\u001c\u0001\t\u0006\u0004%Ia\u001b\u0005\t]\u0002A)\u0019!C\u0005_\")Q\u0010\u0001C\u0001-\")a\u0010\u0001C\u0001G\")q\u0010\u0001C\u0001S\"1\u0011\u0011\u0001\u0001\u0005\u0002-Da!a\u0001\u0001\t\u0003Y\u0007bBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u00033\u0001A\u0011AA\u000e\u0005U)\u0005\u0010]3di\u0006$\u0018n\u001c8BO\u001e\u0014XmZ1u_JT!AG\u000e\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u001d;\u0005\u0011Q\u000e\u001c\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011c\u0001\u0001&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"A\n\u0017\n\u00055:#\u0001D*fe&\fG.\u001b>bE2,\u0017a\u00038v[\u001a+\u0017\r^;sKN\u0004\"A\n\u0019\n\u0005E:#aA%oi\u0006I!mY,fS\u001eDGo\u001d\t\u0004i]JT\"A\u001b\u000b\u0005Yj\u0012!\u00032s_\u0006$7-Y:u\u0013\tATGA\u0005Ce>\fGmY1tiB\u0019aE\u000f\u001f\n\u0005m:#!B!se\u0006L\bC\u0001\u0014>\u0013\tqtE\u0001\u0004E_V\u0014G.Z\u0001\fE\u000e<\u0015-^:tS\u0006t7\u000fE\u00025o\u0005\u00032A\n\u001eC!\u001113)R#\n\u0005\u0011;#A\u0002+va2,'\u0007\u0005\u0002G\u00136\tqI\u0003\u0002I7\u00051A.\u001b8bY\u001eL!AS$\u0003\u0017\u0011+gn]3WK\u000e$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5{\u0005+\u0015\t\u0003\u001d\u0002i\u0011!\u0007\u0005\u0006]\u0011\u0001\ra\f\u0005\u0006e\u0011\u0001\ra\r\u0005\u0006\u007f\u0011\u0001\r\u0001Q\u0001\u0002WV\tq&\u0001\u0002lA\u0005AAo\u001c;bY\u000esG/F\u0001X!\t1\u0003,\u0003\u0002ZO\t!Aj\u001c8h\u00031!x\u000e^1m\u0007:$x\fJ3r)\tav\f\u0005\u0002';&\u0011al\n\u0002\u0005+:LG\u000fC\u0004a\u0011\u0005\u0005\t\u0019A,\u0002\u0007a$\u0013'A\u0005u_R\fGn\u00118uA\u0005\u0001b.Z<M_\u001ed\u0015n[3mS\"|w\u000eZ\u000b\u0002y\u0005!b.Z<M_\u001ed\u0015n[3mS\"|w\u000eZ0%KF$\"\u0001\u00184\t\u000f\u0001\\\u0011\u0011!a\u0001y\u0005\tb.Z<M_\u001ed\u0015n[3mS\"|w\u000e\u001a\u0011\u0002\u00159,woV3jO\"$8/F\u0001:\u0003!qWm^'fC:\u001cX#\u00017\u0011\u0007\u0019RT)A\u0004oK^\u001cuN^:\u0002\u0019=dGmR1vgNL\u0017M\\:\u0016\u0003A\u00042A\n\u001er!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002w7\u0005!1\u000f^1u\u0013\tA8O\u0001\u000bNk2$\u0018N^1sS\u0006$XmR1vgNL\u0017M\u001c\u0015\u0003!i\u0004\"AJ>\n\u0005q<#!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u0015\u0019w.\u001e8u\u00035awn\u001a'jW\u0016d\u0017\u000e[8pI\u00069q/Z5hQR\u001c\u0018!B7fC:\u001c\u0018\u0001B2pmN\f1!\u00193e)\u0019\tI!a\u0003\u0002\u00165\t\u0001\u0001C\u0004\u0002\u000eY\u0001\r!a\u0004\u0002\u0011%t7\u000f^1oG\u0016\u00042ARA\t\u0013\r\t\u0019b\u0012\u0002\u0007-\u0016\u001cGo\u001c:\t\r\u0005]a\u00031\u0001=\u0003\u00199X-[4ii\u0006)Q.\u001a:hKR!\u0011\u0011BA\u000f\u0011\u0019\tyb\u0006a\u0001\u001b\u0006)q\u000e\u001e5fe\u0002")
public class ExpectationAggregator
implements Serializable {
    private double[] newWeights;
    private DenseVector[] newMeans;
    private DenseVector[] newCovs;
    private transient MultivariateGaussian[] oldGaussians;
    private final int numFeatures;
    private final Broadcast<double[]> bcWeights;
    private final Broadcast<Tuple2<DenseVector, DenseVector>[]> bcGaussians;
    private final int k;
    private long totalCnt;
    private double newLogLikelihood;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    private int k() {
        return this.k;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double newLogLikelihood() {
        return this.newLogLikelihood;
    }

    private void newLogLikelihood_$eq(double x$1) {
        this.newLogLikelihood = x$1;
    }

    private double[] newWeights$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.newWeights = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.newWeights;
    }

    private double[] newWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.newWeights$lzycompute() : this.newWeights;
    }

    private DenseVector[] newMeans$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.newMeans = (DenseVector[])Array$.MODULE$.fill(this.k(), (Function0 & java.io.Serializable & Serializable)() -> new DenseVector((double[])Array$.MODULE$.ofDim($this.numFeatures, ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(DenseVector.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.newMeans;
    }

    private DenseVector[] newMeans() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.newMeans$lzycompute() : this.newMeans;
    }

    private DenseVector[] newCovs$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.newCovs = (DenseVector[])Array$.MODULE$.fill(this.k(), (Function0 & java.io.Serializable & Serializable)() -> new DenseVector((double[])Array$.MODULE$.ofDim($this.numFeatures * ($this.numFeatures + 1) / 2, ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(DenseVector.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.newCovs;
    }

    private DenseVector[] newCovs() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.newCovs$lzycompute() : this.newCovs;
    }

    private MultivariateGaussian[] oldGaussians$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if (!this.bitmap$trans$0) {
                this.oldGaussians = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bcGaussians.value())).map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    DenseVector mean = (DenseVector)tuple2._1();
                    DenseVector covVec = (DenseVector)tuple2._2();
                    DenseMatrix cov = GaussianMixture$.MODULE$.unpackUpperTriangularMatrix($this.numFeatures, covVec.values());
                    MultivariateGaussian multivariateGaussian = new MultivariateGaussian((Vector)mean, (Matrix)cov);
                    return multivariateGaussian;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
                this.bitmap$trans$0 = true;
            }
        }
        return this.oldGaussians;
    }

    private MultivariateGaussian[] oldGaussians() {
        return !this.bitmap$trans$0 ? this.oldGaussians$lzycompute() : this.oldGaussians;
    }

    public long count() {
        return this.totalCnt();
    }

    public double logLikelihood() {
        return this.newLogLikelihood();
    }

    public double[] weights() {
        return this.newWeights();
    }

    public DenseVector[] means() {
        return this.newMeans();
    }

    public DenseVector[] covs() {
        return this.newCovs();
    }

    public ExpectationAggregator add(Vector instance, double weight) {
        int i;
        double[] localWeights = (double[])this.bcWeights.value();
        MultivariateGaussian[] localOldGaussians = this.oldGaussians();
        double[] prob = new double[this.k()];
        double probSum = 0.0;
        for (i = 0; i < this.k(); ++i) {
            double p;
            prob[i] = p = Utils$.MODULE$.EPSILON() + localWeights[i] * localOldGaussians[i].pdf(instance);
            probSum += p;
        }
        this.newLogLikelihood_$eq(this.newLogLikelihood() + package$.MODULE$.log(probSum) * weight);
        double[] localNewWeights = this.newWeights();
        DenseVector[] localNewMeans = this.newMeans();
        DenseVector[] localNewCovs = this.newCovs();
        for (i = 0; i < this.k(); ++i) {
            double w = prob[i] / probSum * weight;
            int n = i;
            localNewWeights[n] = localNewWeights[n] + w;
            BLAS$.MODULE$.axpy(w, instance, (Vector)localNewMeans[i]);
            BLAS$.MODULE$.spr(w, instance, localNewCovs[i]);
        }
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public ExpectationAggregator merge(ExpectationAggregator other) {
        block1: {
            if (other.count() == 0L) break block1;
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            double[] localThisNewWeights = this.newWeights();
            double[] localOtherNewWeights = other.newWeights();
            DenseVector[] localThisNewMeans = this.newMeans();
            DenseVector[] localOtherNewMeans = other.newMeans();
            DenseVector[] localThisNewCovs = this.newCovs();
            DenseVector[] localOtherNewCovs = other.newCovs();
            for (int i = 0; i < this.k(); ++i) {
                int n = i;
                localThisNewWeights[n] = localThisNewWeights[n] + localOtherNewWeights[i];
                BLAS$.MODULE$.axpy(1.0, (Vector)localOtherNewMeans[i], (Vector)localThisNewMeans[i]);
                BLAS$.MODULE$.axpy(1.0, (Vector)localOtherNewCovs[i], (Vector)localThisNewCovs[i]);
            }
            this.newLogLikelihood_$eq(this.newLogLikelihood() + other.newLogLikelihood());
        }
        return this;
    }

    public ExpectationAggregator(int numFeatures, Broadcast<double[]> bcWeights, Broadcast<Tuple2<DenseVector, DenseVector>[]> bcGaussians) {
        this.numFeatures = numFeatures;
        this.bcWeights = bcWeights;
        this.bcGaussians = bcGaussians;
        this.k = ((double[])bcWeights.value()).length;
        this.totalCnt = 0L;
        this.newLogLikelihood = 0.0;
    }
}

