/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import org.apache.spark.ml.evaluation.ClusteringEvaluator$;
import org.apache.spark.ml.evaluation.CosineSilhouette$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001\u0002\r\u001a\u0001\u0011B\u0001B\u000f\u0001\u0003\u0006\u0004%\te\u000f\u0005\t%\u0002\u0011\t\u0011)A\u0005y!)A\u000b\u0001C\u0001+\")A\u000b\u0001C\u00015\")A\f\u0001C!;\")Q\r\u0001C!M\")A\u000e\u0001C\u0001[\")!\u000f\u0001C\u0001g\"9a\u000f\u0001b\u0001\n\u00039\bB\u0002?\u0001A\u0003%\u0001\u0010C\u0003\u007f\u0001\u0011\u00051\bC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u0011\u0005%\u0001A1A\u0005\u0002]Dq!!\u0005\u0001A\u0003%\u0001\u0010\u0003\u0004\u0002\u0016\u0001!\ta\u000f\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!!\u0016\u0001\t\u0003\n9fB\u0004\u0002beA\t!a\u0019\u0007\raI\u0002\u0012AA3\u0011\u0019!F\u0003\"\u0001\u0002z!9\u00111\u0010\u000b\u0005B\u0005u\u0004\"CAC)\u0005\u0005I\u0011BAD\u0005M\u0019E.^:uKJLgnZ#wC2,\u0018\r^8s\u0015\tQ2$\u0001\u0006fm\u0006dW/\u0019;j_:T!\u0001H\u000f\u0002\u00055d'B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M)\u0001!J\u00152iA\u0011aeJ\u0007\u00023%\u0011\u0001&\u0007\u0002\n\u000bZ\fG.^1u_J\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\rMD\u0017M]3e\u0015\tq3$A\u0003qCJ\fW.\u0003\u00021W\t\u0001\u0002*Y:Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\t\u0003UIJ!aM\u0016\u0003\u001d!\u000b7OR3biV\u0014Xm]\"pYB\u0011Q\u0007O\u0007\u0002m)\u0011qgG\u0001\u0005kRLG.\u0003\u0002:m\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0017aA;jIV\tA\b\u0005\u0002>\r:\u0011a\b\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u000e\na\u0001\u0010:p_Rt$\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013\u0015A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\")\u0007\u0005Q\u0005\u000b\u0005\u0002L\u001d6\tAJ\u0003\u0002N;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005=c%!B*j]\u000e,\u0017%A)\u0002\u000bIr3G\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005)\u0003\u0016A\u0002\u001fj]&$h\b\u0006\u0002W/B\u0011a\u0005\u0001\u0005\u0006u\r\u0001\r\u0001\u0010\u0015\u0004/*\u0003\u0006fA\u0002K!R\ta\u000bK\u0002\u0005\u0015B\u000bAaY8qsR\u0011aK\u0018\u0005\u0006?\u0016\u0001\r\u0001Y\u0001\u0005a6\u000b\u0007\u000f\u0005\u0002bE6\tQ&\u0003\u0002d[\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\u0006\u0015B\u000ba\"[:MCJ<WM\u001d\"fiR,'/F\u0001h!\tA\u0017.D\u0001C\u0013\tQ'IA\u0004C_>dW-\u00198)\u0007\u0019Q\u0005+\u0001\ttKR\u0004&/\u001a3jGRLwN\\\"pYR\u0011an\\\u0007\u0002\u0001!)\u0001o\u0002a\u0001y\u0005)a/\u00197vK\"\u001aqA\u0013)\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011a\u000e\u001e\u0005\u0006a\"\u0001\r\u0001\u0010\u0015\u0004\u0011)\u0003\u0016AC7fiJL7MT1nKV\t\u0001\u0010E\u0002bsrJ!A_\u0017\u0003\u000bA\u000b'/Y7)\u0007%Q\u0005+A\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\u0003f\u0001\u0006K!\u0006iq-\u001a;NKR\u0014\u0018n\u0019(b[\u0016D3a\u0003&Q\u00035\u0019X\r^'fiJL7MT1nKR\u0019a.!\u0002\t\u000bAd\u0001\u0019\u0001\u001f)\u00071Q\u0005+A\beSN$\u0018M\\2f\u001b\u0016\f7/\u001e:fQ\u0011i!*!\u0004\"\u0005\u0005=\u0011!\u0002\u001a/i9\u0002\u0014\u0001\u00053jgR\fgnY3NK\u0006\u001cXO]3!Q\u0011q!*!\u0004\u0002%\u001d,G\u000fR5ti\u0006t7-Z'fCN,(/\u001a\u0015\u0005\u001f)\u000bi!\u0001\ntKR$\u0015n\u001d;b]\u000e,W*Z1tkJ,Gc\u00018\u0002\u001e!)\u0001\u000f\u0005a\u0001y!\"\u0001CSA\u0007\u0003!)g/\u00197vCR,G\u0003BA\u0013\u0003W\u00012\u0001[A\u0014\u0013\r\tIC\u0011\u0002\u0007\t>,(\r\\3\t\u000f\u00055\u0012\u00031\u0001\u00020\u00059A-\u0019;bg\u0016$\b\u0007BA\u0019\u0003\u0003\u0002b!a\r\u0002:\u0005uRBAA\u001b\u0015\r\t9$H\u0001\u0004gFd\u0017\u0002BA\u001e\u0003k\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002@\u0005\u0005C\u0002\u0001\u0003\r\u0003\u0007\nY#!A\u0001\u0002\u000b\u0005\u0011Q\t\u0002\u0004?\u0012\n\u0014\u0003BA$\u0003\u001b\u00022\u0001[A%\u0013\r\tYE\u0011\u0002\b\u001d>$\b.\u001b8h!\rA\u0017qJ\u0005\u0004\u0003#\u0012%aA!os\"\u001a\u0011C\u0013)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u0010\u0015\u0005%)\u000bY&\t\u0002\u0002^\u0005)1G\f\u0019/a!\u001a\u0001A\u0013)\u0002'\rcWo\u001d;fe&tw-\u0012<bYV\fGo\u001c:\u0011\u0005\u0019\"2c\u0002\u000b\u0002h\u00055\u00141\u000f\t\u0004Q\u0006%\u0014bAA6\u0005\n1\u0011I\\=SK\u001a\u0004B!NA8-&\u0019\u0011\u0011\u000f\u001c\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019\u0001.!\u001e\n\u0007\u0005]$I\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002d\u0005!An\\1e)\r1\u0016q\u0010\u0005\u0007\u0003\u00033\u0002\u0019\u0001\u001f\u0002\tA\fG\u000f\u001b\u0015\u0004-)\u0003\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!#\u0011\t\u0005-\u0015QS\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006!A.\u00198h\u0015\t\t\u0019*\u0001\u0003kCZ\f\u0017\u0002BAL\u0003\u001b\u0013aa\u00142kK\u000e$\bf\u0001\u000bK!\"\u001a1C\u0013)")
public class ClusteringEvaluator
extends Evaluator
implements HasPredictionCol,
HasFeaturesCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> distanceMeasure;
    private final Param<String> featuresCol;
    private final Param<String> predictionCol;

    public static ClusteringEvaluator load(String string) {
        return ClusteringEvaluator$.MODULE$.load(string);
    }

    public static MLReader<ClusteringEvaluator> read() {
        return ClusteringEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public ClusteringEvaluator copy(ParamMap pMap) {
        return (ClusteringEvaluator)this.defaultCopy(pMap);
    }

    @Override
    public boolean isLargerBetter() {
        return true;
    }

    public ClusteringEvaluator setPredictionCol(String value) {
        return (ClusteringEvaluator)this.set(this.predictionCol(), value);
    }

    public ClusteringEvaluator setFeaturesCol(String value) {
        return (ClusteringEvaluator)this.set(this.featuresCol(), value);
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public ClusteringEvaluator setMetricName(String value) {
        return (ClusteringEvaluator)this.set(this.metricName(), value);
    }

    public Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    public String getDistanceMeasure() {
        return this.$(this.distanceMeasure());
    }

    public ClusteringEvaluator setDistanceMeasure(String value) {
        return (ClusteringEvaluator)this.set(this.distanceMeasure(), value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double evaluate(Dataset<?> dataset) {
        SchemaUtils$.MODULE$.validateVectorCompatibleColumn(dataset.schema(), this.$(this.featuresCol()));
        SchemaUtils$.MODULE$.checkNumericType(dataset.schema(), this.$(this.predictionCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        Column vectorCol = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()));
        Dataset df = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), vectorCol.as(this.$(this.featuresCol()), dataset.schema().apply(this.$(this.featuresCol())).metadata())}));
        Tuple2 tuple2 = new Tuple2((Object)this.$(this.metricName()), (Object)this.$(this.distanceMeasure()));
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            if ("silhouette".equals(string) && "squaredEuclidean".equals(string2)) {
                return SquaredEuclideanSilhouette$.MODULE$.computeSilhouetteScore(df, this.$(this.predictionCol()), this.$(this.featuresCol()));
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string3 = (String)tuple2._2();
            if ("silhouette".equals(string) && "cosine".equals(string3)) {
                return CosineSilhouette$.MODULE$.computeSilhouetteScore(df, this.$(this.predictionCol()), this.$(this.featuresCol()));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String mn = (String)tuple2._1();
        String dm = (String)tuple2._2();
        throw new IllegalArgumentException(new StringBuilder(33).append("No support for metric ").append(mn).append(", distance ").append(dm).toString());
    }

    @Override
    public String toString() {
        return new StringBuilder(56).append("ClusteringEvaluator: uid=").append(this.uid()).append(", metricName=").append((Object)this.$(this.metricName())).append(", ").append("distanceMeasure=").append((Object)this.$(this.distanceMeasure())).toString();
    }

    public ClusteringEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasFeaturesCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"silhouette"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (silhouette)", allowedParams);
        String[] availableValues = (String[])((Object[])new String[]{"squaredEuclidean", "cosine"});
        Function1 allowedParams2 = ParamValidators$.MODULE$.inArray(availableValues);
        this.distanceMeasure = new Param(this, "distanceMeasure", new StringBuilder(51).append("distance measure in evaluation. Supported options: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])availableValues)).mkString("'", "', '", "'")).toString(), allowedParams2);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("silhouette"), this.distanceMeasure().$minus$greater("squaredEuclidean")}));
    }

    public ClusteringEvaluator() {
        this(Identifiable$.MODULE$.randomUID("cluEval"));
    }
}

