/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.config.Kryo$;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.feature.Word2VecModel$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelReader$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelWriter$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.VersionUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r]c\u0001B\u001f?\u0001%C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tE\u0017\u0005\tc\u0002\u0011\t\u0011)A\u00057\"A1\u000f\u0001BC\u0002\u0013%A\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003v\u0011!\t\u0019\u0001\u0001C\u0001\u0001\u0006\u0015\u0001BCA\u0007\u0001!\u0015\r\u0011\"\u0001\u0002\u0010!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA\u001e\u0001\u0011\u0005\u0011q\n\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\tI\u0007\u0001C\u0001\u0003\u0013Cq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\"9\u0011q\u001a\u0001\u0005B\u0005E\u0007bBAs\u0001\u0011\u0005\u0013q\u001d\u0005\b\u0003\u007f\u0004A\u0011\tB\u0001\u0011\u001d\u0011y\u0001\u0001C!\u0005#9qAa\u0007?\u0011\u0003\u0011iB\u0002\u0004>}!\u0005!q\u0004\u0005\b\u0003\u0007\u0019B\u0011\u0001B\u001a\r\u0019\u0011)d\u0005#\u00038!I\u0011\u0011I\u000b\u0003\u0016\u0004%\tA\u0017\u0005\n\u0005\u007f)\"\u0011#Q\u0001\nmC!B!\u0011\u0016\u0005+\u0007I\u0011\u0001B\"\u0011)\u0011i%\u0006B\tB\u0003%!Q\t\u0005\b\u0003\u0007)B\u0011\u0001B(\u0011%\t)/FA\u0001\n\u0003\u0011I\u0006C\u0005\u0003`U\t\n\u0011\"\u0001\u0003b!I!QO\u000b\u0012\u0002\u0013\u0005!q\u000f\u0005\n\u0005w*\u0012\u0011!C!\u0005{B\u0011B!$\u0016\u0003\u0003%\tAa$\t\u0013\tEU#!A\u0005\u0002\tM\u0005\"\u0003BM+\u0005\u0005I\u0011\tBN\u0011%\u0011I+FA\u0001\n\u0003\u0011Y\u000bC\u0005\u00036V\t\t\u0011\"\u0011\u00038\"I!qB\u000b\u0002\u0002\u0013\u0005#\u0011\u0018\u0005\n\u0005w+\u0012\u0011!C!\u0005{;\u0011B!1\u0014\u0003\u0003EIAa1\u0007\u0013\tU2#!A\t\n\t\u0015\u0007bBA\u0002O\u0011\u0005!1\u001b\u0005\n\u0005\u001f9\u0013\u0011!C#\u0005sC\u0011B!6(\u0003\u0003%\tIa6\t\u0013\tuw%!A\u0005\u0002\n}\u0007\"\u0003BwO\u0005\u0005I\u0011\u0002Bx\r\u001d\u00119p\u0005\u0001\u0014\u0005sD\u0011Ba?.\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000f\u0005\rQ\u0006\"\u0001\u0003~\"911A\u0017\u0005R\r\u0015q\u0001CB\t'!\u0005aha\u0005\u0007\u0011\t]8\u0003#\u0001?\u0007+Aq!a\u00013\t\u0003\u00199\u0002C\u0004\u0004\u001aI\"\taa\u0007\u0007\r\r=2\u0003BB\u0019\u0011\u001d\t\u0019!\u000eC\u0001\u0007sA\u0011b!\u00106\u0005\u0004%IA! \t\u0011\r}R\u0007)A\u0005\u0005\u007fBqa!\u00116\t\u0003\u001a\u0019\u0005C\u0004\u0004HM!\te!\u0013\t\u000f\r\u00053\u0003\"\u0011\u0004N!I!Q^\n\u0002\u0002\u0013%!q\u001e\u0002\u000e/>\u0014HM\r,fG6{G-\u001a7\u000b\u0005}\u0002\u0015a\u00024fCR,(/\u001a\u0006\u0003\u0003\n\u000b!!\u001c7\u000b\u0005\r#\u0015!B:qCJ\\'BA#G\u0003\u0019\t\u0007/Y2iK*\tq)A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0015B\u001b\u0006cA&M\u001d6\t\u0001)\u0003\u0002N\u0001\n)Qj\u001c3fYB\u0011q\nA\u0007\u0002}A\u0011q*U\u0005\u0003%z\u0012AbV8sIJ2Vm\u0019\"bg\u0016\u0004\"\u0001V,\u000e\u0003US!A\u0016!\u0002\tU$\u0018\u000e\\\u0005\u00031V\u0013!\"\u0014'Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u00027B\u0011A,\u001a\b\u0003;\u000e\u0004\"AX1\u000e\u0003}S!\u0001\u0019%\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0017!B:dC2\f\u0017B\u00013b\u0003\u0019\u0001&/\u001a3fM&\u0011am\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0011\f\u0007fA\u0001j_B\u0011!.\\\u0007\u0002W*\u0011ANQ\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00018l\u0005\u0015\u0019\u0016N\\2fC\u0005\u0001\u0018!B\u0019/i9\u0002\u0014\u0001B;jI\u0002B3AA5p\u0003-9xN\u001d3WK\u000e$xN]:\u0016\u0003U\u0004\"A\u001e>\u000e\u0003]T!a\u0010=\u000b\u0005e\u0014\u0015!B7mY&\u0014\u0017BA\u001fx\u000319xN\u001d3WK\u000e$xN]:!Q\t!Q\u0010\u0005\u0002\u007f\u007f6\t\u0011-C\u0002\u0002\u0002\u0005\u0014\u0011\u0002\u001e:b]NLWM\u001c;\u0002\rqJg.\u001b;?)\u0015q\u0015qAA\u0006\u0011\u0015IV\u00011\u0001\\Q\u0011\t9![8\t\u000bM,\u0001\u0019A;\u0002\u0015\u001d,GOV3di>\u00148/\u0006\u0002\u0002\u0012A!\u00111CA\u0017\u001d\u0011\t)\"a\n\u000f\t\u0005]\u00111\u0005\b\u0005\u00033\t\tC\u0004\u0003\u0002\u001c\u0005}ab\u00010\u0002\u001e%\tq)\u0003\u0002F\r&\u00111\tR\u0005\u0004\u0003K\u0011\u0015aA:rY&!\u0011\u0011FA\u0016\u0003\u001d\u0001\u0018mY6bO\u0016T1!!\nC\u0013\u0011\ty#!\r\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA\u0015\u0003WA#AB?)\t\u0019I\u0017qG\u0011\u0003\u0003s\tQ!\r\u00186]A\nABZ5oINKhn\u001c8z[N$b!!\u0005\u0002@\u0005\r\u0003BBA!\u000f\u0001\u00071,\u0001\u0003x_J$\u0007bBA#\u000f\u0001\u0007\u0011qI\u0001\u0004]Vl\u0007c\u0001@\u0002J%\u0019\u00111J1\u0003\u0007%sG\u000f\u000b\u0003\bS\u0006]BCBA\t\u0003#\n\t\u0007C\u0004\u0002T!\u0001\r!!\u0016\u0002\u0007Y,7\r\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006Q\u0001\u0007Y&t\u0017\r\\4\n\t\u0005}\u0013\u0011\f\u0002\u0007-\u0016\u001cGo\u001c:\t\u000f\u0005\u0015\u0003\u00021\u0001\u0002H!\"\u0001\"[A3C\t\t9'A\u00033]Ar\u0003'A\tgS:$7+\u001f8p]fl7/\u0011:sCf$b!!\u001c\u0002\u0000\u0005\u0005\u0005#\u0002@\u0002p\u0005M\u0014bAA9C\n)\u0011I\u001d:bsB1a0!\u001e\\\u0003sJ1!a\u001eb\u0005\u0019!V\u000f\u001d7feA\u0019a0a\u001f\n\u0007\u0005u\u0014M\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003'J\u0001\u0019AA+\u0011\u001d\t)%\u0003a\u0001\u0003\u000fBC!C5\u0002\u0006\u0006\u0012\u0011qQ\u0001\u0006e9\u0012d\u0006\r\u000b\u0007\u0003[\nY)!$\t\r\u0005\u0005#\u00021\u0001\\\u0011\u001d\t)E\u0003a\u0001\u0003\u000fBCAC5\u0002\u0006\u0006Y1/\u001a;J]B,HoQ8m)\u0011\t)*a&\u000e\u0003\u0001Aa!!'\f\u0001\u0004Y\u0016!\u0002<bYV,\u0007fA\u0006j_\u0006a1/\u001a;PkR\u0004X\u000f^\"pYR!\u0011QSAQ\u0011\u0019\tI\n\u0004a\u00017\"\u001aA\"[8\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA\t\u0003SCq!a+\u000e\u0001\u0004\ti+A\u0004eCR\f7/\u001a;1\t\u0005=\u00161\u0018\t\u0007\u0003c\u000b\u0019,a.\u000e\u0005\u0005-\u0012\u0002BA[\u0003W\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002:\u0006mF\u0002\u0001\u0003\r\u0003{\u000bI+!A\u0001\u0002\u000b\u0005\u0011q\u0018\u0002\u0004?\u0012\u0012\u0014\u0003BAa\u0003\u000f\u00042A`Ab\u0013\r\t)-\u0019\u0002\b\u001d>$\b.\u001b8h!\rq\u0018\u0011Z\u0005\u0004\u0003\u0017\f'aA!os\"\"Q\"[A3\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BAj\u0003?\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0005\u00033\fY#A\u0003usB,7/\u0003\u0003\u0002^\u0006]'AC*ueV\u001cG\u000fV=qK\"9\u0011\u0011\u001d\bA\u0002\u0005M\u0017AB:dQ\u0016l\u0017\rK\u0002\u000fS>\fAaY8qsR\u0019a*!;\t\u000f\u0005-x\u00021\u0001\u0002n\u0006)Q\r\u001f;sCB!\u0011q^A{\u001b\t\t\tPC\u0002\u0002t\u0002\u000bQ\u0001]1sC6LA!a>\u0002r\nA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0010S\u0006m\u0018EAA\u007f\u0003\u0015\td\u0006\u000e\u00182\u0003\u00159(/\u001b;f+\t\u0011\u0019\u0001E\u0002U\u0005\u000bI1Aa\u0002V\u0005!iEj\u0016:ji\u0016\u0014\b\u0006\u0002\tj\u0005\u0017\t#A!\u0004\u0002\u000bErcG\f\u0019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0017\u0015\u0005#%\u0014)\"\t\u0002\u0003\u0018\u0005)1G\f\u0019/a!\u001a\u0001![8\u0002\u001b]{'\u000f\u001a\u001aWK\u000elu\u000eZ3m!\ty5cE\u0004\u0014\u0005C\u00119C!\f\u0011\u0007y\u0014\u0019#C\u0002\u0003&\u0005\u0014a!\u00118z%\u00164\u0007\u0003\u0002+\u0003*9K1Aa\u000bV\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0004}\n=\u0012b\u0001B\u0019C\na1+\u001a:jC2L'0\u00192mKR\u0011!Q\u0004\u0002\u0005\t\u0006$\u0018mE\u0004\u0016\u0005C\u0011ID!\f\u0011\u0007y\u0014Y$C\u0002\u0003>\u0005\u0014q\u0001\u0015:pIV\u001cG/A\u0003x_J$\u0007%\u0001\u0004wK\u000e$xN]\u000b\u0003\u0005\u000b\u0002RA`A8\u0005\u000f\u00022A B%\u0013\r\u0011Y%\u0019\u0002\u0006\r2|\u0017\r^\u0001\bm\u0016\u001cGo\u001c:!)\u0019\u0011\tF!\u0016\u0003XA\u0019!1K\u000b\u000e\u0003MAa!!\u0011\u001b\u0001\u0004Y\u0006b\u0002B!5\u0001\u0007!Q\t\u000b\u0007\u0005#\u0012YF!\u0018\t\u0011\u0005\u00053\u0004%AA\u0002mC\u0011B!\u0011\u001c!\u0003\u0005\rA!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\r\u0016\u00047\n\u00154F\u0001B4!\u0011\u0011IG!\u001d\u000e\u0005\t-$\u0002\u0002B7\u0005_\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00051\f\u0017\u0002\u0002B:\u0005W\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u001f+\t\t\u0015#QM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t}\u0004\u0003\u0002BA\u0005\u0017k!Aa!\u000b\t\t\u0015%qQ\u0001\u0005Y\u0006twM\u0003\u0002\u0003\n\u0006!!.\u0019<b\u0013\r1'1Q\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000f\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002H\nU\u0005\"\u0003BLA\u0005\u0005\t\u0019AA$\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0014\t\u0007\u0005?\u0013)+a2\u000e\u0005\t\u0005&b\u0001BRC\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u001d&\u0011\u0015\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003.\nM\u0006c\u0001@\u00030&\u0019!\u0011W1\u0003\u000f\t{w\u000e\\3b]\"I!q\u0013\u0012\u0002\u0002\u0003\u0007\u0011qY\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\t\u000b\u0003\u0005\u007f\na!Z9vC2\u001cH\u0003\u0002BW\u0005\u007fC\u0011Ba&&\u0003\u0003\u0005\r!a2\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005':3#B\u0014\u0003H\n5\u0002#\u0003Be\u0005\u001f\\&Q\tB)\u001b\t\u0011YMC\u0002\u0003N\u0006\fqA];oi&lW-\u0003\u0003\u0003R\n-'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!1Y\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005#\u0012INa7\t\r\u0005\u0005#\u00061\u0001\\\u0011\u001d\u0011\tE\u000ba\u0001\u0005\u000b\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003b\n%\b#\u0002@\u0003d\n\u001d\u0018b\u0001BsC\n1q\n\u001d;j_:\u0004bA`A;7\n\u0015\u0003\"\u0003BvW\u0005\u0005\t\u0019\u0001B)\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003rB!!\u0011\u0011Bz\u0013\u0011\u0011)Pa!\u0003\r=\u0013'.Z2u\u0005M9vN\u001d33-\u0016\u001cWj\u001c3fY^\u0013\u0018\u000e^3s'\ri#1A\u0001\tS:\u001cH/\u00198dKR!!q`B\u0001!\r\u0011\u0019&\f\u0005\u0007\u0005w|\u0003\u0019\u0001(\u0002\u0011M\fg/Z%na2$Baa\u0002\u0004\u000eA\u0019ap!\u0003\n\u0007\r-\u0011M\u0001\u0003V]&$\bBBB\ba\u0001\u00071,\u0001\u0003qCRD\u0017aE,pe\u0012\u0014d+Z2N_\u0012,Gn\u0016:ji\u0016\u0014\bc\u0001B*eM\u0019!G!\t\u0015\u0005\rM\u0011aG2bY\u000e,H.\u0019;f\u001dVl'-\u001a:PMB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0002H\ru1qEB\u0016\u0011\u001d\u0019y\u0002\u000ea\u0001\u0007C\t\u0011CY;gM\u0016\u00148+\u001b>f\u0013:\u0014\u0015\u0010^3t!\rq81E\u0005\u0004\u0007K\t'\u0001\u0002'p]\u001eDqa!\u000b5\u0001\u0004\t9%\u0001\u0005ok6<vN\u001d3t\u0011\u001d\u0019i\u0003\u000ea\u0001\u0003\u000f\n!B^3di>\u00148+\u001b>f\u0005M9vN\u001d33-\u0016\u001cWj\u001c3fYJ+\u0017\rZ3s'\r)41\u0007\t\u0005)\u000eUb*C\u0002\u00048U\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u000b\u0003\u0007w\u00012Aa\u00156\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\nA\u0001\\8bIR\u0019aj!\u0012\t\r\r=\u0011\b1\u0001\\\u0003\u0011\u0011X-\u00193\u0016\u0005\rM\u0002\u0006\u0002\u001ej\u0005\u0017!2ATB(\u0011\u0019\u0019ya\u000fa\u00017\"\"1(\u001bB\u0006Q\u0011\u0019\u0012Na\u0003)\tII'1\u0002")
public class Word2VecModel
extends Model<Word2VecModel>
implements Word2VecBase,
MLWritable {
    private transient Dataset<Row> getVectors;
    private final String uid;
    private final transient org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    private final IntParam vectorSize;
    private final IntParam windowSize;
    private final IntParam numPartitions;
    private final IntParam minCount;
    private final IntParam maxSentenceLength;
    private final LongParam seed;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final Param<String> outputCol;
    private final Param<String> inputCol;
    private volatile transient boolean bitmap$trans$0;

    public static Word2VecModel load(String string) {
        return Word2VecModel$.MODULE$.load(string);
    }

    public static MLReader<Word2VecModel> read() {
        return Word2VecModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getVectorSize() {
        return Word2VecBase.getVectorSize$(this);
    }

    @Override
    public int getWindowSize() {
        return Word2VecBase.getWindowSize$(this);
    }

    @Override
    public int getNumPartitions() {
        return Word2VecBase.getNumPartitions$(this);
    }

    @Override
    public int getMinCount() {
        return Word2VecBase.getMinCount$(this);
    }

    @Override
    public int getMaxSentenceLength() {
        return Word2VecBase.getMaxSentenceLength$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return Word2VecBase.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final IntParam vectorSize() {
        return this.vectorSize;
    }

    @Override
    public final IntParam windowSize() {
        return this.windowSize;
    }

    @Override
    public final IntParam numPartitions() {
        return this.numPartitions;
    }

    @Override
    public final IntParam minCount() {
        return this.minCount;
    }

    @Override
    public final IntParam maxSentenceLength() {
        return this.maxSentenceLength;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(IntParam x$1) {
        this.vectorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$windowSize_$eq(IntParam x$1) {
        this.windowSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(IntParam x$1) {
        this.numPartitions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(IntParam x$1) {
        this.minCount = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$maxSentenceLength_$eq(IntParam x$1) {
        this.maxSentenceLength = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors() {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    }

    private Dataset<Row> getVectors$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if (!this.bitmap$trans$0) {
                SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
                Map wordVec = this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().mapValues((Function1 & Serializable & scala.Serializable)vec -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vec)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$2 -> x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(Word2VecModel $outer) {
                    }
                }
                this.getVectors = spark.createDataFrame(wordVec.toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "vector"}));
                this.bitmap$trans$0 = true;
            }
        }
        return this.getVectors;
    }

    public Dataset<Row> getVectors() {
        return !this.bitmap$trans$0 ? this.getVectors$lzycompute() : this.getVectors;
    }

    public Dataset<Row> findSynonyms(String word, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.findSynonymsArray(word, num)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$2(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Dataset<Row> findSynonyms(Vector vec, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.findSynonymsArray(vec, num)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$3(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Tuple2<String, Object>[] findSynonymsArray(Vector vec, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(VectorImplicits$.MODULE$.mlVectorToMLlibVector(vec), num);
    }

    public Tuple2<String, Object>[] findSynonymsArray(String word, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(word, num);
    }

    public Word2VecModel setInputCol(String value) {
        return (Word2VecModel)this.set(this.inputCol(), value);
    }

    public Word2VecModel setOutputCol(String value) {
        return (Word2VecModel)this.set(this.outputCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(Word2VecModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(Word2VecModel $outer) {
            }
        }
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Map vectors = (Map)this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().mapValues((Function1 & Serializable & scala.Serializable)vv -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vv)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$3 -> x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom());
        Broadcast bVectors = dataset.sparkSession().sparkContext().broadcast((Object)vectors, ClassTag$.MODULE$.apply(Map.class));
        int d = BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize()));
        Vector emptyVec = Vectors$.MODULE$.sparse(d, Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        UserDefinedFunction word2Vec = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)sentence -> {
            Vector vector;
            if (sentence.isEmpty()) {
                vector = emptyVec;
            } else {
                Vector sum = Vectors$.MODULE$.zeros(d);
                sentence.foreach((Function1 & Serializable & scala.Serializable)word -> {
                    Word2VecModel.$anonfun$transform$5(bVectors, sum, word);
                    return BoxedUnit.UNIT;
                });
                BLAS$.MODULE$.scal(1.0 / (double)sentence.size(), sum);
                vector = sum;
            }
            return vector;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$4(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(null)));
        return dataset.withColumn(this.$(this.outputCol()), word2Vec.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})), outputSchema.apply(this.$(this.outputCol())).metadata());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = this.validateAndTransformSchema(schema);
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.outputCol()))).nonEmpty()) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.outputCol()), BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize())));
        }
        return var2_2;
    }

    @Override
    public Word2VecModel copy(ParamMap extra) {
        Word2VecModel copied = new Word2VecModel(this.uid(), this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors());
        return (Word2VecModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new Word2VecModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(43).append("Word2VecModel: uid=").append(this.uid()).append(", numWords=").append(this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size()).append(", ").append("vectorSize=").append(this.$(this.vectorSize())).toString();
    }

    public static final /* synthetic */ void $anonfun$transform$5(Broadcast bVectors$1, Vector sum$1, String word) {
        ((MapLike)bVectors$1.value()).get((Object)word).foreach((Function1 & Serializable & scala.Serializable)v -> {
            BLAS$.MODULE$.axpy(1.0, v, sum$1);
            return BoxedUnit.UNIT;
        });
    }

    public Word2VecModel(String uid, org.apache.spark.mllib.feature.Word2VecModel wordVectors) {
        this.uid = uid;
        this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors = wordVectors;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasSeed.$init$(this);
        Word2VecBase.$init$(this);
        MLWritable.$init$(this);
    }

    public static class Data
    implements Product,
    scala.Serializable {
        private final String word;
        private final float[] vector;

        public String word() {
            return this.word;
        }

        public float[] vector() {
            return this.vector;
        }

        public Data copy(String word, float[] vector) {
            return new Data(word, vector);
        }

        public String copy$default$1() {
            return this.word();
        }

        public float[] copy$default$2() {
            return this.vector();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.word();
                    break;
                }
                case 1: {
                    object = this.vector();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.word();
            String string2 = data.word();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.vector() != data.vector()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String word, float[] vector) {
            this.word = word;
            this.vector = vector;
            Product.$init$((Product)this);
        }
    }

    public static class Word2VecModelReader
    extends MLReader<Word2VecModel> {
        private final String className = Word2VecModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public Word2VecModel load(String path) {
            org.apache.spark.mllib.feature.Word2VecModel word2VecModel;
            SparkSession spark = this.sparkSession();
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int major = tuple2._1$mcI$sp();
            int minor = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
            Tuple2.mcII.sp sp3 = sp2;
            int major2 = sp3._1$mcI$sp();
            int minor2 = sp3._2$mcI$sp();
            String dataPath = new Path(path, "data").toString();
            if (major2 < 2 || major2 == 2 && minor2 < 2) {
                Row data = (Row)spark.read().parquet(dataPath).select("wordIndex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wordVectors"})).head();
                Map wordIndex = (Map)data.getAs(0);
                float[] wordVectors = (float[])((TraversableOnce)data.getAs(1)).toArray(ClassTag$.MODULE$.Float());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, Object>)wordIndex, wordVectors);
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator4$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator4$2(Word2VecModelReader $outer) {
                    }
                }
                Map wordVectorsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.read().parquet(dataPath).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator4$2(null)))).collect())).map((Function1 & Serializable & scala.Serializable)wordVector -> new Tuple2((Object)wordVector.word(), (Object)wordVector.vector()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, float[]>)wordVectorsMap);
            }
            org.apache.spark.mllib.feature.Word2VecModel oldModel = word2VecModel;
            Word2VecModel model = new Word2VecModel(metadata.uid(), oldModel);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class Word2VecModelWriter
    extends MLWriter {
        private final Word2VecModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1(Word2VecModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Map<String, float[]> wordVectors = this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors();
            String dataPath = new Path(path, "data").toString();
            long bufferSizeInBytes = Utils$.MODULE$.byteStringAsBytes(this.sc().conf().get(Kryo$.MODULE$.KRYO_SERIALIZER_MAX_BUFFER_SIZE().key(), "64m"));
            int numPartitions = Word2VecModel$Word2VecModelWriter$.MODULE$.calculateNumberOfPartitions(bufferSizeInBytes, this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size(), this.instance.getVectorSize());
            SparkSession spark = this.sparkSession();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator4$1(Word2VecModelWriter $outer) {
                }
            }
            spark.createDataset(wordVectors.toSeq(), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator4$1(null)))).repartition(numPartitions).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String word = (String)tuple2._1();
                float[] vector = (float[])tuple2._2();
                Data data = new Data(word, vector);
                return data;
            }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator5$1(null)))).toDF().write().parquet(dataPath);
        }

        public Word2VecModelWriter(Word2VecModel instance) {
            this.instance = instance;
        }
    }
}

