/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rma\u0001B\u001f?\u0001%C\u0001B\u0018\u0001\u0003\u0006\u0004%\te\u0018\u0005\tm\u0002\u0011\t\u0011)A\u0005A\"A\u0001\u0010\u0001BC\u0002\u0013\u0005\u0011\u0010\u0003\u0005~\u0001\t\u0005\t\u0015!\u0003O\u0011%y\bA!b\u0001\n\u0003\t\t\u0001\u0003\u0006\u0002\u000e\u0001\u0011\t\u0011)A\u0005\u0003\u0007A!\"!\u0005\u0001\u0005\u000b\u0007I\u0011AA\u0001\u0011)\t)\u0002\u0001B\u0001B\u0003%\u00111\u0001\u0005\t\u00033\u0001A\u0011\u0001!\u0002\u001c!9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002j\u0001!\t%a\u001b\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"9\u00111\u001a\u0001\u0005B\u00055\u0007bBAq\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003[\u0004A\u0011IAx\u000f\u001d\t)P\u0010E\u0001\u0003o4a!\u0010 \t\u0002\u0005e\bbBA\r+\u0011\u0005!Q\u0002\u0005\b\u0005\u001f)B\u0011\tB\t\u0011\u001d\u0011Y\"\u0006C!\u0005;1qA!\n\u0016\u0001U\u00119\u0003C\u0005\u00036e\u0011\t\u0011)A\u0005)\"9\u0011\u0011D\r\u0005\u0002\t]bA\u0002B 3\u0011\u0013\t\u0005\u0003\u0005y9\tU\r\u0011\"\u0001z\u0011!iHD!E!\u0002\u0013q\u0005\"C@\u001d\u0005+\u0007I\u0011AA\u0001\u0011)\ti\u0001\bB\tB\u0003%\u00111\u0001\u0005\u000b\u0003#a\"Q3A\u0005\u0002\u0005\u0005\u0001BCA\u000b9\tE\t\u0015!\u0003\u0002\u0004!9\u0011\u0011\u0004\u000f\u0005\u0002\t%\u0003\"CAf9\u0005\u0005I\u0011\u0001B+\u0011%\u0011i\u0006HI\u0001\n\u0003\u0011y\u0006C\u0005\u0003tq\t\n\u0011\"\u0001\u0003v!I!\u0011\u0010\u000f\u0012\u0002\u0013\u0005!Q\u000f\u0005\n\u0005wb\u0012\u0011!C!\u0005{B\u0011B!$\u001d\u0003\u0003%\t!a\f\t\u0013\t=E$!A\u0005\u0002\tE\u0005\"\u0003BL9\u0005\u0005I\u0011\tBM\u0011%\u00119\u000bHA\u0001\n\u0003\u0011I\u000bC\u0005\u00034r\t\t\u0011\"\u0011\u00036\"I\u0011Q\u001e\u000f\u0002\u0002\u0013\u0005#q\u0017\u0005\n\u0005sc\u0012\u0011!C!\u0005w;\u0011Ba0\u001a\u0003\u0003EIA!1\u0007\u0013\t}\u0012$!A\t\n\t\r\u0007bBA\rc\u0011\u0005!\u0011\u001b\u0005\n\u0003[\f\u0014\u0011!C#\u0005oC\u0011Ba52\u0003\u0003%\tI!6\t\u0013\tu\u0017'!A\u0005\u0002\n}\u0007b\u0002By3\u0011E#1\u001f\u0004\u0007\u0005{,BAa@\t\u000f\u0005eq\u0007\"\u0001\u0004\u0002!I1QA\u001cC\u0002\u0013%!Q\u0010\u0005\t\u0007\u000f9\u0004\u0015!\u0003\u0003\u0000!9!1D\u001c\u0005B\r%\u0001\"CB\u0007+\u0005\u0005I\u0011BB\b\u0005i\te\tV*veZLg/\u00197SK\u001e\u0014Xm]:j_:lu\u000eZ3m\u0015\ty\u0004)\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0011\"\u0002\u00055d'BA\"E\u0003\u0015\u0019\b/\u0019:l\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\u0004\u0001M!\u0001AS+Y!\u0011YEJ\u0014+\u000e\u0003yJ!!\u0014 \u0003\u001fI+wM]3tg&|g.T8eK2\u0004\"a\u0014*\u000e\u0003AS!!\u0015!\u0002\r1Lg.\u00197h\u0013\t\u0019\u0006K\u0001\u0004WK\u000e$xN\u001d\t\u0003\u0017\u0002\u0001\"a\u0013,\n\u0005]s$aG!G)N+(O^5wC2\u0014Vm\u001a:fgNLwN\u001c)be\u0006l7\u000f\u0005\u0002Z96\t!L\u0003\u0002\\\u0001\u0006!Q\u000f^5m\u0013\ti&L\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005\u0001\u0007CA1k\u001d\t\u0011\u0007\u000e\u0005\u0002dM6\tAM\u0003\u0002f\u0011\u00061AH]8pizR\u0011aZ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u001a\fa\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011N\u001a\u0015\u0004\u00039$\bCA8s\u001b\u0005\u0001(BA9C\u0003)\tgN\\8uCRLwN\\\u0005\u0003gB\u0014QaU5oG\u0016\f\u0013!^\u0001\u0006c92d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003]R\fAbY8fM\u001aL7-[3oiN,\u0012A\u0014\u0015\u0004\u00079\\\u0018%\u0001?\u0002\u000bIr\u0003G\f\u0019\u0002\u001b\r|WM\u001a4jG&,g\u000e^:!Q\r!an_\u0001\nS:$XM]2faR,\"!a\u0001\u0011\t\u0005\u0015\u0011qA\u0007\u0002M&\u0019\u0011\u0011\u00024\u0003\r\u0011{WO\u00197fQ\r)a\u000e^\u0001\u000bS:$XM]2faR\u0004\u0003f\u0001\u0004oi\u0006)1oY1mK\"\u001aqA\u001c;\u0002\rM\u001c\u0017\r\\3!Q\rAa\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013Q\u000bi\"!\t\u0002&\u0005%\u0002\"\u00020\n\u0001\u0004\u0001\u0007\u0006BA\u000f]RDQ\u0001_\u0005A\u00029CC!!\tow\"1q0\u0003a\u0001\u0003\u0007AC!!\noi\"9\u0011\u0011C\u0005A\u0002\u0005\r\u0001\u0006BA\u0015]R\f1B\\;n\r\u0016\fG/\u001e:fgV\u0011\u0011\u0011\u0007\t\u0005\u0003\u000b\t\u0019$C\u0002\u00026\u0019\u00141!\u00138uQ\u0011Qa.!\u000f\"\u0005\u0005m\u0012!B\u001a/a9\u0002\u0014\u0001G:fiF+\u0018M\u001c;jY\u0016\u0004&o\u001c2bE&d\u0017\u000e^5fgR!\u0011\u0011IA\"\u001b\u0005\u0001\u0001bBA#\u0017\u0001\u0007\u0011qI\u0001\u0006m\u0006dW/\u001a\t\u0007\u0003\u000b\tI%a\u0001\n\u0007\u0005-cMA\u0003BeJ\f\u0017\u0010K\u0002\f]R\fqb]3u#V\fg\u000e^5mKN\u001cu\u000e\u001c\u000b\u0005\u0003\u0003\n\u0019\u0006\u0003\u0004\u0002F1\u0001\r\u0001\u0019\u0015\u0004\u00199$\u0018\u0001\u00059sK\u0012L7\r^)vC:$\u0018\u000e\\3t)\rq\u00151\f\u0005\u0007\u0003;j\u0001\u0019\u0001(\u0002\u0011\u0019,\u0017\r^;sKND3!\u00048|\u0003\u001d\u0001(/\u001a3jGR$B!a\u0001\u0002f!1\u0011Q\f\bA\u00029C3A\u00048|\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002n\u0005=\u0005\u0003BA8\u0003\u0013sA!!\u001d\u0002\u0004:!\u00111OA@\u001d\u0011\t)(! \u000f\t\u0005]\u00141\u0010\b\u0004G\u0006e\u0014\"A$\n\u0005\u00153\u0015BA\"E\u0013\r\t\tIQ\u0001\u0004gFd\u0017\u0002BAC\u0003\u000f\u000bq\u0001]1dW\u0006<WMC\u0002\u0002\u0002\nKA!a#\u0002\u000e\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003\u000b\u000b9\tC\u0004\u0002\u0012>\u0001\r!a%\u0002\u000f\u0011\fG/Y:fiB\"\u0011QSAQ!\u0019\t9*!'\u0002\u001e6\u0011\u0011qQ\u0005\u0005\u00037\u000b9IA\u0004ECR\f7/\u001a;\u0011\t\u0005}\u0015\u0011\u0015\u0007\u0001\t1\t\u0019+a$\u0002\u0002\u0003\u0005)\u0011AAS\u0005\ryFeM\t\u0005\u0003O\u000bi\u000b\u0005\u0003\u0002\u0006\u0005%\u0016bAAVM\n9aj\u001c;iS:<\u0007\u0003BA\u0003\u0003_K1!!-g\u0005\r\te.\u001f\u0015\u0004\u001f9\\\u0018a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005e\u0016Q\u0019\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*!\u0011qXAD\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019-!0\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002HB\u0001\r!!/\u0002\rM\u001c\u0007.Z7bQ\r\u0001b\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0002U\u0003\u001fDq!!5\u0012\u0001\u0004\t\u0019.A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002V\u0006mWBAAl\u0015\r\tI\u000eQ\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003;\f9N\u0001\u0005QCJ\fW.T1qQ\r\tb\u000e^\u0001\u0006oJLG/Z\u000b\u0003\u0003K\u00042!WAt\u0013\r\tIO\u0017\u0002\t\u001b2;&/\u001b;fe\"\u001a!C\u001c;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u0019\u0015\u0005'9\fI\u0004K\u0002\u0001]R\f!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2\u0004\"aS\u000b\u0014\u000fU\tYP!\u0001\u0003\bA!\u0011QAA\u007f\u0013\r\tyP\u001a\u0002\u0007\u0003:L(+\u001a4\u0011\te\u0013\u0019\u0001V\u0005\u0004\u0005\u000bQ&AC'M%\u0016\fG-\u00192mKB!\u0011Q\u0001B\u0005\u0013\r\u0011YA\u001a\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003o\fAA]3bIV\u0011!1\u0003\t\u00053\nUA+C\u0002\u0003\u0018i\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u0004/9$\u0018\u0001\u00027pC\u0012$2\u0001\u0016B\u0010\u0011\u0019\u0011\t\u0003\u0007a\u0001A\u0006!\u0001/\u0019;iQ\rAb\u000e\u001e\u0002!\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\\,sSR,'oE\u0003\u001a\u0003K\u0014I\u0003\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\r\u0011yCQ\u0001\tS:$XM\u001d8bY&!!1\u0007B\u0017\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0005s\u0011i\u0004E\u0002\u0003<ei\u0011!\u0006\u0005\u0007\u0005kY\u0002\u0019\u0001+\u0003\t\u0011\u000bG/Y\n\b9\u0005m(1\tB\u0004!\u0011\t)A!\u0012\n\u0007\t\u001dcMA\u0004Qe>$Wo\u0019;\u0015\u0011\t-#q\nB)\u0005'\u00022A!\u0014\u001d\u001b\u0005I\u0002\"\u0002=$\u0001\u0004q\u0005BB@$\u0001\u0004\t\u0019\u0001C\u0004\u0002\u0012\r\u0002\r!a\u0001\u0015\u0011\t-#q\u000bB-\u00057Bq\u0001\u001f\u0013\u0011\u0002\u0003\u0007a\n\u0003\u0005\u0000IA\u0005\t\u0019AA\u0002\u0011%\t\t\u0002\nI\u0001\u0002\u0004\t\u0019!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0005$f\u0001(\u0003d-\u0012!Q\r\t\u0005\u0005O\u0012y'\u0004\u0002\u0003j)!!1\u000eB7\u0003%)hn\u00195fG.,GM\u0003\u0002rM&!!\u0011\u000fB5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119H\u000b\u0003\u0002\u0004\t\r\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t}\u0004\u0003\u0002BA\u0005\u0017k!Aa!\u000b\t\t\u0015%qQ\u0001\u0005Y\u0006twM\u0003\u0002\u0003\n\u0006!!.\u0019<b\u0013\rY'1Q\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tiKa%\t\u0013\tU%&!AA\u0002\u0005E\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u001cB1!Q\u0014BR\u0003[k!Aa(\u000b\u0007\t\u0005f-\u0001\u0006d_2dWm\u0019;j_:LAA!*\u0003 \nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YK!-\u0011\t\u0005\u0015!QV\u0005\u0004\u0005_3'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005+c\u0013\u0011!a\u0001\u0003[\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003c!\"Aa \u0002\r\u0015\fX/\u00197t)\u0011\u0011YK!0\t\u0013\tUu&!AA\u0002\u00055\u0016\u0001\u0002#bi\u0006\u00042A!\u00142'\u0015\t$Q\u0019B\u0004!-\u00119M!4O\u0003\u0007\t\u0019Aa\u0013\u000e\u0005\t%'b\u0001BfM\u00069!/\u001e8uS6,\u0017\u0002\u0002Bh\u0005\u0013\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0011\t-A\u0003baBd\u0017\u0010\u0006\u0005\u0003L\t]'\u0011\u001cBn\u0011\u0015AH\u00071\u0001O\u0011\u0019yH\u00071\u0001\u0002\u0004!9\u0011\u0011\u0003\u001bA\u0002\u0005\r\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0005C\u0014i\u000f\u0005\u0004\u0002\u0006\t\r(q]\u0005\u0004\u0005K4'AB(qi&|g\u000eE\u0005\u0002\u0006\t%h*a\u0001\u0002\u0004%\u0019!1\u001e4\u0003\rQ+\b\u000f\\34\u0011%\u0011y/NA\u0001\u0002\u0004\u0011Y%A\u0002yIA\n\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0005k\u0014Y\u0010\u0005\u0003\u0002\u0006\t]\u0018b\u0001B}M\n!QK\\5u\u0011\u0019\u0011\tC\u000ea\u0001A\n\u0001\u0013I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>tWj\u001c3fYJ+\u0017\rZ3s'\r9$1\u0003\u000b\u0003\u0007\u0007\u00012Aa\u000f8\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\"2\u0001VB\u0006\u0011\u0019\u0011\tc\u000fa\u0001A\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019\t\u0002\u0005\u0003\u0003\u0002\u000eM\u0011\u0002BB\u000b\u0005\u0007\u0013aa\u00142kK\u000e$\bfA\u000boi\"\u001aAC\u001c;")
public class AFTSurvivalRegressionModel
extends RegressionModel<Vector, AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final IntParam aggregationDepth;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;

    public static AFTSurvivalRegressionModel load(String string) {
        return AFTSurvivalRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public int numFeatures() {
        return this.coefficients().size();
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
        double k = 1.0 / this.scale();
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)q -> lambda * scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log1p(-q)) / k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return Vectors$.MODULE$.dense(quantiles);
    }

    @Override
    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)Seq$.MODULE$.empty();
        Seq predictionColumns = (Seq)Seq$.MODULE$.empty();
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (this.hasQuantilesCol()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictQuantilesUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictQuantiles((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.quantilesCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictQuantilesUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.quantilesCol()), outputSchema.apply(this.$(this.quantilesCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append(this.uid()).append(": AFTSurvivalRegressionModel.transform() does nothing").append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block1: {
            StructType outputSchema = this.validateAndTransformSchema(schema, false);
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.predictionCol()));
            }
            if (!this.isDefined(this.quantilesCol()) || !new StringOps(Predef$.MODULE$.augmentString(this.$(this.quantilesCol()))).nonEmpty()) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.quantilesCol()), this.$(this.quantileProbabilities()).length);
        }
        return var2_2;
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(46).append("AFTSurvivalRegressionModel: uid=").append(this.uid()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
    }

    public static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            double d;
            Vector vector;
            Object scale;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().parquet(dataPath);
                    row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object coefficients = ((SeqLike)some.get()).apply(0);
                    Object intercept = ((SeqLike)some.get()).apply(1);
                    scale = ((SeqLike)some.get()).apply(2);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (!(intercept instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                    if (scale instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)scale);
            Tuple3 tuple3 = new Tuple3((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
            Tuple3 tuple32 = tuple3;
            Vector coefficients = (Vector)tuple32._1();
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data$module;
        private final AFTSurvivalRegressionModel instance;

        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                }
            }
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.coefficients();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients, double intercept, double scale) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

