/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.EuclideanDistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001a4Q\u0001D\u0007\u0001#]AQ\u0001\b\u0001\u0005\u0002yAQ\u0001\t\u0001\u0005B\u0005BQ!\u0011\u0001\u0005B\tCQ\u0001\u0014\u0001\u0005B5CQA\u0015\u0001\u0005BMCQ\u0001\u0018\u0001\u0005Bu;a\u0001Y\u0007\t\u0002E\tgA\u0002\u0007\u000e\u0011\u0003\t\"\rC\u0003\u001d\u0011\u0011\u0005\u0011\u000e\u0003\u0004k\u0011\u0011\u0005Qb\u001b\u0005\b]\"\t\t\u0011\"\u0003p\u0005a)Uo\u00197jI\u0016\fg\u000eR5ti\u0006t7-Z'fCN,(/\u001a\u0006\u0003\u001d=\t!b\u00197vgR,'/\u001b8h\u0015\t\u0001\u0012#A\u0003nY2L'M\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h'\t\u0001\u0001\u0004\u0005\u0002\u001a55\tQ\"\u0003\u0002\u001c\u001b\tyA)[:uC:\u001cW-T3bgV\u0014X-\u0001\u0004=S:LGOP\u0002\u0001)\u0005y\u0002CA\r\u0001\u0003-1\u0017N\u001c3DY>\u001cXm\u001d;\u0015\u0007\trs\b\u0005\u0003$M!ZS\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\rQ+\b\u000f\\33!\t\u0019\u0013&\u0003\u0002+I\t\u0019\u0011J\u001c;\u0011\u0005\rb\u0013BA\u0017%\u0005\u0019!u.\u001e2mK\")qF\u0001a\u0001a\u000591-\u001a8uKJ\u001c\bcA\u0019:y9\u0011!g\u000e\b\u0003gYj\u0011\u0001\u000e\u0006\u0003ku\ta\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005a\"\u0013a\u00029bG.\fw-Z\u0005\u0003um\u0012q\u0002\u0016:bm\u0016\u00148/\u00192mK>s7-\u001a\u0006\u0003q\u0011\u0002\"!G\u001f\n\u0005yj!A\u0004,fGR|'oV5uQ:{'/\u001c\u0005\u0006\u0001\n\u0001\r\u0001P\u0001\u0006a>Lg\u000e^\u0001\u0012SN\u001cUM\u001c;fe\u000e{gN^3sO\u0016$G\u0003B\"G\u0011*\u0003\"a\t#\n\u0005\u0015##a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u000f\u000e\u0001\r\u0001P\u0001\n_2$7)\u001a8uKJDQ!S\u0002A\u0002q\n\u0011B\\3x\u0007\u0016tG/\u001a:\t\u000b-\u001b\u0001\u0019A\u0016\u0002\u000f\u0015\u00048/\u001b7p]\u0006AA-[:uC:\u001cW\rF\u0002,\u001dBCQa\u0014\u0003A\u0002q\n!A^\u0019\t\u000bE#\u0001\u0019\u0001\u001f\u0002\u0005Y\u0014\u0014aC2mkN$XM]\"pgR$Ra\u000b+W1jCQ!V\u0003A\u0002q\n\u0001bY3oiJ|\u0017\u000e\u001a\u0005\u0006/\u0016\u0001\r\u0001P\u0001\na>Lg\u000e^:Tk6DQ!W\u0003A\u0002-\n\u0011b^3jO\"$8+^7\t\u000bm+\u0001\u0019A\u0016\u0002#A|\u0017N\u001c;t'F,\u0018M]3e\u001d>\u0014X.\u0001\u0003d_N$HcA\u0016_?\")\u0001I\u0002a\u0001y!)QK\u0002a\u0001y\u0005AR)^2mS\u0012,\u0017M\u001c#jgR\fgnY3NK\u0006\u001cXO]3\u0011\u0005eA1c\u0001\u0005dMB\u00111\u0005Z\u0005\u0003K\u0012\u0012a!\u00118z%\u00164\u0007CA\u0012h\u0013\tAGE\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001b\u0003M1\u0017m\u001d;TcV\f'/\u001a3ESN$\u0018M\\2f)\rYC.\u001c\u0005\u0006\u001f*\u0001\r\u0001\u0010\u0005\u0006#*\u0001\r\u0001P\u0001\fe\u0016\fGMU3t_24X\rF\u0001q!\t\th/D\u0001s\u0015\t\u0019H/\u0001\u0003mC:<'\"A;\u0002\t)\fg/Y\u0005\u0003oJ\u0014aa\u00142kK\u000e$\b")
public class EuclideanDistanceMeasure
extends DistanceMeasure {
    @Override
    public Tuple2<Object, Object> findClosest(TraversableOnce<VectorWithNorm> centers, VectorWithNorm point) {
        DoubleRef bestDistance = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        IntRef bestIndex = IntRef.create((int)0);
        IntRef i = IntRef.create((int)0);
        centers.foreach((Function1 & java.io.Serializable & Serializable)center -> {
            EuclideanDistanceMeasure.$anonfun$findClosest$2(point, bestDistance, bestIndex, i, center);
            return BoxedUnit.UNIT;
        });
        return new Tuple2.mcID.sp(bestIndex.elem, bestDistance.elem);
    }

    @Override
    public boolean isCenterConverged(VectorWithNorm oldCenter, VectorWithNorm newCenter, double epsilon) {
        return EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(newCenter, oldCenter) <= epsilon * epsilon;
    }

    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        return Math.sqrt(EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(v1, v2));
    }

    @Override
    public double clusterCost(VectorWithNorm centroid, VectorWithNorm pointsSum, double weightSum, double pointsSquaredNorm) {
        return package$.MODULE$.max(pointsSquaredNorm - weightSum * centroid.norm() * centroid.norm(), 0.0);
    }

    @Override
    public double cost(VectorWithNorm point, VectorWithNorm centroid) {
        return EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(point, centroid);
    }

    public static final /* synthetic */ void $anonfun$findClosest$2(VectorWithNorm point$2, DoubleRef bestDistance$2, IntRef bestIndex$2, IntRef i$2, VectorWithNorm center) {
        double distance;
        double lowerBoundOfSqDist = center.norm() - point$2.norm();
        if ((lowerBoundOfSqDist *= lowerBoundOfSqDist) < bestDistance$2.elem && (distance = EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(center, point$2)) < bestDistance$2.elem) {
            bestDistance$2.elem = distance;
            bestIndex$2.elem = i$2.elem;
        }
        ++i$2.elem;
    }
}

