/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.GradientDescent$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\u0014(\u0001IB\u0001b\u0011\u0001\u0003\u0002\u0004%I\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0019!C\u0005\u0013\"Aq\n\u0001B\u0001B\u0003&Q\t\u0003\u0005Q\u0001\t\u0005\r\u0011\"\u0003R\u0011!)\u0006A!a\u0001\n\u00131\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0015\u0002*\t\re\u0003A\u0011A\u0016[\u0011\u001dq\u0006\u00011A\u0005\n}Cqa\u0019\u0001A\u0002\u0013%A\r\u0003\u0004g\u0001\u0001\u0006K\u0001\u0019\u0005\bO\u0002\u0001\r\u0011\"\u0003i\u0011\u001da\u0007\u00011A\u0005\n5Daa\u001c\u0001!B\u0013I\u0007b\u00029\u0001\u0001\u0004%Ia\u0018\u0005\bc\u0002\u0001\r\u0011\"\u0003s\u0011\u0019!\b\u0001)Q\u0005A\"9Q\u000f\u0001a\u0001\n\u0013y\u0006b\u0002<\u0001\u0001\u0004%Ia\u001e\u0005\u0007s\u0002\u0001\u000b\u0015\u00021\t\u000fi\u0004\u0001\u0019!C\u0005?\"91\u0010\u0001a\u0001\n\u0013a\bB\u0002@\u0001A\u0003&\u0001\r\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001a\u0001\u0011\u0005\u0011QG\u0004\b\u0003;:\u0003\u0012AA0\r\u00191s\u0005#\u0001\u0002b!1\u0011\f\tC\u0001\u0003SBq!a\u001b!\t\u0003\ti\u0007C\u0004\u0002l\u0001\"\t!!#\t\u000f\u0005m\u0005\u0005\"\u0003\u0002\u001e\"I\u0011q\u0016\u0011\u0002\u0002\u0013%\u0011\u0011\u0017\u0002\u0010\u000fJ\fG-[3oi\u0012+7oY3oi*\u0011\u0001&K\u0001\r_B$\u0018.\\5{CRLwN\u001c\u0006\u0003U-\nQ!\u001c7mS\nT!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\u0011\u00011'O\u001f\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g!\tQ4(D\u0001(\u0013\tatEA\u0005PaRLW.\u001b>feB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iK\u0001\tS:$XM\u001d8bY&\u0011!i\u0010\u0002\b\u0019><w-\u001b8h\u0003!9'/\u00193jK:$X#A#\u0011\u0005i2\u0015BA$(\u0005!9%/\u00193jK:$\u0018\u0001D4sC\u0012LWM\u001c;`I\u0015\fHC\u0001&N!\t!4*\u0003\u0002Mk\t!QK\\5u\u0011\u001dq%!!AA\u0002\u0015\u000b1\u0001\u001f\u00132\u0003%9'/\u00193jK:$\b%A\u0004va\u0012\fG/\u001a:\u0016\u0003I\u0003\"AO*\n\u0005Q;#aB+qI\u0006$XM]\u0001\fkB$\u0017\r^3s?\u0012*\u0017\u000f\u0006\u0002K/\"9a*BA\u0001\u0002\u0004\u0011\u0016\u0001C;qI\u0006$XM\u001d\u0011\u0002\rqJg.\u001b;?)\rYF,\u0018\t\u0003u\u0001AQaQ\u0004A\u0002\u0015CQ\u0001U\u0004A\u0002I\u000b\u0001b\u001d;faNK'0Z\u000b\u0002AB\u0011A'Y\u0005\u0003EV\u0012a\u0001R8vE2,\u0017\u0001D:uKB\u001c\u0016N_3`I\u0015\fHC\u0001&f\u0011\u001dq\u0015\"!AA\u0002\u0001\f\u0011b\u001d;faNK'0\u001a\u0011\u0002\u001b9,X.\u0013;fe\u0006$\u0018n\u001c8t+\u0005I\u0007C\u0001\u001bk\u0013\tYWGA\u0002J]R\f\u0011C\\;n\u0013R,'/\u0019;j_:\u001cx\fJ3r)\tQe\u000eC\u0004O\u0019\u0005\u0005\t\u0019A5\u0002\u001d9,X.\u0013;fe\u0006$\u0018n\u001c8tA\u0005A!/Z4QCJ\fW.\u0001\u0007sK\u001e\u0004\u0016M]1n?\u0012*\u0017\u000f\u0006\u0002Kg\"9ajDA\u0001\u0002\u0004\u0001\u0017!\u0003:fOB\u000b'/Y7!\u0003Ei\u0017N\\5CCR\u001c\u0007N\u0012:bGRLwN\\\u0001\u0016[&t\u0017NQ1uG\"4%/Y2uS>tw\fJ3r)\tQ\u0005\u0010C\u0004O%\u0005\u0005\t\u0019\u00011\u0002%5Lg.\u001b\"bi\u000eDgI]1di&|g\u000eI\u0001\u000fG>tg/\u001a:hK:\u001cW\rV8m\u0003I\u0019wN\u001c<fe\u001e,gnY3U_2|F%Z9\u0015\u0005)k\bb\u0002(\u0016\u0003\u0003\u0005\r\u0001Y\u0001\u0010G>tg/\u001a:hK:\u001cW\rV8mA\u0005Y1/\u001a;Ti\u0016\u00048+\u001b>f)\u0011\t\u0019!!\u0002\u000e\u0003\u0001Aa!a\u0002\u0018\u0001\u0004\u0001\u0017\u0001B:uKB\fAc]3u\u001b&t\u0017NQ1uG\"4%/Y2uS>tG\u0003BA\u0002\u0003\u001bAa!a\u0004\u0019\u0001\u0004\u0001\u0017\u0001\u00034sC\u000e$\u0018n\u001c8\u0002!M,GOT;n\u0013R,'/\u0019;j_:\u001cH\u0003BA\u0002\u0003+Aa!a\u0006\u001a\u0001\u0004I\u0017!B5uKJ\u001c\u0018aC:fiJ+w\rU1sC6$B!a\u0001\u0002\u001e!)\u0001O\u0007a\u0001A\u0006\t2/\u001a;D_:4XM]4f]\u000e,Gk\u001c7\u0015\t\u0005\r\u00111\u0005\u0005\u0007\u0003KY\u0002\u0019\u00011\u0002\u0013Q|G.\u001a:b]\u000e,\u0017aC:fi\u001e\u0013\u0018\rZ5f]R$B!a\u0001\u0002,!)1\t\ba\u0001\u000b\u0006Q1/\u001a;Va\u0012\fG/\u001a:\u0015\t\u0005\r\u0011\u0011\u0007\u0005\u0006!v\u0001\rAU\u0001\t_B$\u0018.\\5{KR1\u0011qGA\"\u00033\u0002B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{I\u0013A\u00027j]\u0006dw-\u0003\u0003\u0002B\u0005m\"A\u0002,fGR|'\u000fC\u0004\u0002Fy\u0001\r!a\u0012\u0002\t\u0011\fG/\u0019\t\u0007\u0003\u0013\ny%a\u0015\u000e\u0005\u0005-#bAA'W\u0005\u0019!\u000f\u001a3\n\t\u0005E\u00131\n\u0002\u0004%\u0012#\u0005C\u0002\u001b\u0002V\u0001\f9$C\u0002\u0002XU\u0012a\u0001V;qY\u0016\u0014\u0004bBA.=\u0001\u0007\u0011qG\u0001\u000fS:LG/[1m/\u0016Lw\r\u001b;t\u0003=9%/\u00193jK:$H)Z:dK:$\bC\u0001\u001e!'\u0015\u00013'PA2!\r!\u0014QM\u0005\u0004\u0003O*$\u0001D*fe&\fG.\u001b>bE2,GCAA0\u0003=\u0011XO\\'j]&\u0014\u0015\r^2i'\u001e#E\u0003FA8\u0003o\nI(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b\u000b9\tE\u00045\u0003+\n9$!\u001d\u0011\tQ\n\u0019\bY\u0005\u0004\u0003k*$!B!se\u0006L\bbBA#E\u0001\u0007\u0011q\t\u0005\u0006\u0007\n\u0002\r!\u0012\u0005\u0006!\n\u0002\rA\u0015\u0005\u0006=\n\u0002\r\u0001\u0019\u0005\u0006O\n\u0002\r!\u001b\u0005\u0006a\n\u0002\r\u0001\u0019\u0005\u0006k\n\u0002\r\u0001\u0019\u0005\b\u00037\u0012\u0003\u0019AA\u001c\u0011\u0015Q(\u00051\u0001a)I\ty'a#\u0002\u000e\u0006=\u0015\u0011SAJ\u0003+\u000b9*!'\t\u000f\u0005\u00153\u00051\u0001\u0002H!)1i\ta\u0001\u000b\")\u0001k\ta\u0001%\")al\ta\u0001A\")qm\ta\u0001S\")\u0001o\ta\u0001A\")Qo\ta\u0001A\"9\u00111L\u0012A\u0002\u0005]\u0012aC5t\u0007>tg/\u001a:hK\u0012$\u0002\"a(\u0002&\u0006%\u0016Q\u0016\t\u0004i\u0005\u0005\u0016bAARk\t9!i\\8mK\u0006t\u0007bBATI\u0001\u0007\u0011qG\u0001\u0010aJ,g/[8vg^+\u0017n\u001a5ug\"9\u00111\u0016\u0013A\u0002\u0005]\u0012AD2veJ,g\u000e^,fS\u001eDGo\u001d\u0005\u0006u\u0012\u0002\r\u0001Y\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00024B!\u0011QWA`\u001b\t\t9L\u0003\u0003\u0002:\u0006m\u0016\u0001\u00027b]\u001eT!!!0\u0002\t)\fg/Y\u0005\u0005\u0003\u0003\f9L\u0001\u0004PE*,7\r\u001e")
public class GradientDescent
implements Optimizer,
Logging {
    private Gradient gradient;
    private Updater updater;
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private double convergenceTol;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Tuple2<Vector, double[]> runMiniBatchSGD(RDD<Tuple2<Object, Vector>> rDD, Gradient gradient, Updater updater, double d, int n, double d2, double d3, Vector vector) {
        return GradientDescent$.MODULE$.runMiniBatchSGD(rDD, gradient, updater, d, n, d2, d3, vector);
    }

    public static Tuple2<Vector, double[]> runMiniBatchSGD(RDD<Tuple2<Object, Vector>> rDD, Gradient gradient, Updater updater, double d, int n, double d2, double d3, Vector vector, double d4) {
        return GradientDescent$.MODULE$.runMiniBatchSGD(rDD, gradient, updater, d, n, d2, d3, vector, d4);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Gradient gradient() {
        return this.gradient;
    }

    private void gradient_$eq(Gradient x$1) {
        this.gradient = x$1;
    }

    private Updater updater() {
        return this.updater;
    }

    private void updater_$eq(Updater x$1) {
        this.updater = x$1;
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    public GradientDescent setStepSize(double step) {
        Predef$.MODULE$.require(step > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(43).append("Initial step size must be positive but got ").append(step).toString());
        this.stepSize_$eq(step);
        return this;
    }

    public GradientDescent setMiniBatchFraction(double fraction) {
        Predef$.MODULE$.require(fraction > 0.0 && fraction <= 1.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(60).append("Fraction for mini-batch SGD must be in range (0, 1] but got ").append(fraction).toString());
        this.miniBatchFraction_$eq(fraction);
        return this;
    }

    public GradientDescent setNumIterations(int iters) {
        Predef$.MODULE$.require(iters >= 0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(49).append("Number of iterations must be nonnegative but got ").append(iters).toString());
        this.numIterations_$eq(iters);
        return this;
    }

    public GradientDescent setRegParam(double regParam) {
        Predef$.MODULE$.require(regParam >= 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(53).append("Regularization parameter must be nonnegative but got ").append(regParam).toString());
        this.regParam_$eq(regParam);
        return this;
    }

    public GradientDescent setConvergenceTol(double tolerance) {
        Predef$.MODULE$.require(tolerance >= 0.0 && tolerance <= 1.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(54).append("Convergence tolerance must be in range [0, 1] but got ").append(tolerance).toString());
        this.convergenceTol_$eq(tolerance);
        return this;
    }

    public GradientDescent setGradient(Gradient gradient) {
        this.gradient_$eq(gradient);
        return this;
    }

    public GradientDescent setUpdater(Updater updater) {
        this.updater_$eq(updater);
        return this;
    }

    @Override
    public Vector optimize(RDD<Tuple2<Object, Vector>> data, Vector initialWeights) {
        Vector weights;
        Tuple2<Vector, double[]> tuple2 = GradientDescent$.MODULE$.runMiniBatchSGD(data, this.gradient(), this.updater(), this.stepSize(), this.numIterations(), this.regParam(), this.miniBatchFraction(), initialWeights, this.convergenceTol());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector vector = weights = (Vector)tuple2._1();
        Vector weights2 = vector;
        return weights2;
    }

    public GradientDescent(Gradient gradient, Updater updater) {
        this.gradient = gradient;
        this.updater = updater;
        Logging.$init$((Logging)this);
        this.stepSize = 1.0;
        this.numIterations = 100;
        this.regParam = 0.0;
        this.miniBatchFraction = 1.0;
        this.convergenceTol = 0.001;
    }
}

