/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.operators.OpAdd$;
import breeze.linalg.operators.OpAnd$;
import breeze.linalg.operators.OpDiv$;
import breeze.linalg.operators.OpEq$;
import breeze.linalg.operators.OpGT$;
import breeze.linalg.operators.OpGTE$;
import breeze.linalg.operators.OpLT$;
import breeze.linalg.operators.OpLTE$;
import breeze.linalg.operators.OpMod$;
import breeze.linalg.operators.OpMulInner$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.operators.OpMulScalar$;
import breeze.linalg.operators.OpNe$;
import breeze.linalg.operators.OpNeg$;
import breeze.linalg.operators.OpNot$;
import breeze.linalg.operators.OpOr$;
import breeze.linalg.operators.OpPow$;
import breeze.linalg.operators.OpSolveMatrixBy$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.operators.OpXor$;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanSlice;
import breeze.linalg.support.CanSlice2;
import breeze.linalg.support.CanTranspose;
import breeze.optimize.DiffFunction;
import breeze.optimize.StochasticDiffFunction;
import breeze.util.Isomorphism;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.LBFGS$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001\u0002\u0017.\u0001aB\u0001\"\u0013\u0001\u0003\u0002\u0004%IA\u0013\u0005\t\u001d\u0002\u0011\t\u0019!C\u0005\u001f\"AQ\u000b\u0001B\u0001B\u0003&1\n\u0003\u0005W\u0001\t\u0005\r\u0011\"\u0003X\u0011!Y\u0006A!a\u0001\n\u0013a\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0015\u0002-\t\u000b}\u0003A\u0011\u00011\t\u000f\u0011\u0004\u0001\u0019!C\u0005K\"9\u0011\u000e\u0001a\u0001\n\u0013Q\u0007B\u00027\u0001A\u0003&a\rC\u0004n\u0001\u0001\u0007I\u0011\u00028\t\u000fI\u0004\u0001\u0019!C\u0005g\"1Q\u000f\u0001Q!\n=DqA\u001e\u0001A\u0002\u0013%Q\rC\u0004x\u0001\u0001\u0007I\u0011\u0002=\t\ri\u0004\u0001\u0015)\u0003g\u0011\u001dY\b\u00011A\u0005\n9Dq\u0001 \u0001A\u0002\u0013%Q\u0010\u0003\u0004\u0000\u0001\u0001\u0006Ka\u001c\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bA\u0001\"a\u0005\u0001\t\u0003y\u0013Q\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0011!\ty\u0002\u0001C\u0001_\u0005\u0005\u0002bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\t\u0003S\u0001A\u0011A\u0018\u0002\u0016!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\t\u0003o\u0001A\u0011A\u0018\u0002:!9\u00111\b\u0001\u0005B\u0005uraBA3[!\u0005\u0011q\r\u0004\u0007Y5B\t!!\u001b\t\r}\u0003C\u0011AA9\u0011\u001d\t\u0019\b\tC\u0001\u0003k2a!a$!\t\u0005E\u0005BCA'G\t\u0005\t\u0015!\u0003\u0002P!A\u0011j\tB\u0001B\u0003%1\n\u0003\u0005WG\t\u0005\t\u0015!\u0003Y\u0011!Y8E!A!\u0002\u0013y\u0007BCAVG\t\u0005\t\u0015!\u0003\u0002.\"1ql\tC\u0001\u0003gCq!a1$\t\u0003\n)\rC\u0005\u0002N\u0002\n\t\u0011\"\u0003\u0002P\n)AJ\u0011$H'*\u0011afL\u0001\r_B$\u0018.\\5{CRLwN\u001c\u0006\u0003aE\nQ!\u001c7mS\nT!AM\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011hP\"\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0015)D\u0001.\u0013\t\u0011UFA\u0005PaRLW.\u001b>feB\u0011AiR\u0007\u0002\u000b*\u0011a)M\u0001\tS:$XM\u001d8bY&\u0011\u0001*\u0012\u0002\b\u0019><w-\u001b8h\u0003!9'/\u00193jK:$X#A&\u0011\u0005\u0001c\u0015BA'.\u0005!9%/\u00193jK:$\u0018\u0001D4sC\u0012LWM\u001c;`I\u0015\fHC\u0001)T!\tQ\u0014+\u0003\u0002Sw\t!QK\\5u\u0011\u001d!&!!AA\u0002-\u000b1\u0001\u001f\u00132\u0003%9'/\u00193jK:$\b%A\u0004va\u0012\fG/\u001a:\u0016\u0003a\u0003\"\u0001Q-\n\u0005ik#aB+qI\u0006$XM]\u0001\fkB$\u0017\r^3s?\u0012*\u0017\u000f\u0006\u0002Q;\"9A+BA\u0001\u0002\u0004A\u0016\u0001C;qI\u0006$XM\u001d\u0011\u0002\rqJg.\u001b;?)\r\t'm\u0019\t\u0003\u0001\u0002AQ!S\u0004A\u0002-CQAV\u0004A\u0002a\u000baB\\;n\u0007>\u0014(/Z2uS>t7/F\u0001g!\tQt-\u0003\u0002iw\t\u0019\u0011J\u001c;\u0002%9,XnQ8se\u0016\u001cG/[8og~#S-\u001d\u000b\u0003!.Dq\u0001V\u0005\u0002\u0002\u0003\u0007a-A\bok6\u001cuN\u001d:fGRLwN\\:!\u00039\u0019wN\u001c<fe\u001e,gnY3U_2,\u0012a\u001c\t\u0003uAL!!]\u001e\u0003\r\u0011{WO\u00197f\u0003I\u0019wN\u001c<fe\u001e,gnY3U_2|F%Z9\u0015\u0005A#\bb\u0002+\r\u0003\u0003\u0005\ra\\\u0001\u0010G>tg/\u001a:hK:\u001cW\rV8mA\u0005\u0001R.\u0019=Ok6LE/\u001a:bi&|gn]\u0001\u0015[\u0006Dh*^7Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005AK\bb\u0002+\u0010\u0003\u0003\u0005\rAZ\u0001\u0012[\u0006Dh*^7Ji\u0016\u0014\u0018\r^5p]N\u0004\u0013\u0001\u0003:fOB\u000b'/Y7\u0002\u0019I,w\rU1sC6|F%Z9\u0015\u0005As\bb\u0002+\u0013\u0003\u0003\u0005\ra\\\u0001\ne\u0016<\u0007+\u0019:b[\u0002\n\u0011c]3u\u001dVl7i\u001c:sK\u000e$\u0018n\u001c8t)\u0011\t)!a\u0002\u000e\u0003\u0001Aa!!\u0003\u0015\u0001\u00041\u0017aC2peJ,7\r^5p]N\f\u0011c]3u\u0007>tg/\u001a:hK:\u001cW\rV8m)\u0011\t)!a\u0004\t\r\u0005EQ\u00031\u0001p\u0003%!x\u000e\\3sC:\u001cW-A\thKR\u001cuN\u001c<fe\u001e,gnY3U_2$\u0012a\\\u0001\u0011g\u0016$h*^7Ji\u0016\u0014\u0018\r^5p]N$B!!\u0002\u0002\u001c!1\u0011QD\fA\u0002\u0019\fQ!\u001b;feN\f\u0001cZ3u\u001dVl\u0017\n^3sCRLwN\\:\u0015\u0003\u0019\f1b]3u%\u0016<\u0007+\u0019:b[R!\u0011QAA\u0014\u0011\u0015Y\u0018\u00041\u0001p\u0003-9W\r\u001e*fOB\u000b'/Y7\u0002\u0017M,Go\u0012:bI&,g\u000e\u001e\u000b\u0005\u0003\u000b\ty\u0003C\u0003J7\u0001\u00071*\u0001\u0006tKR,\u0006\u000fZ1uKJ$B!!\u0002\u00026!)a\u000b\ba\u00011\u0006Qq-\u001a;Va\u0012\fG/\u001a:\u0015\u0003a\u000b\u0001b\u001c9uS6L'0\u001a\u000b\u0007\u0003\u007f\tY%!\u0019\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u00120\u0003\u0019a\u0017N\\1mO&!\u0011\u0011JA\"\u0005\u00191Vm\u0019;pe\"9\u0011Q\n\u0010A\u0002\u0005=\u0013\u0001\u00023bi\u0006\u0004b!!\u0015\u0002X\u0005mSBAA*\u0015\r\t)&M\u0001\u0004e\u0012$\u0017\u0002BA-\u0003'\u00121A\u0015#E!\u0019Q\u0014QL8\u0002@%\u0019\u0011qL\u001e\u0003\rQ+\b\u000f\\33\u0011\u001d\t\u0019G\ba\u0001\u0003\u007f\ta\"\u001b8ji&\fGnV3jO\"$8/A\u0003M\u0005\u001a;5\u000b\u0005\u0002AAM)\u0001%O\"\u0002lA\u0019!(!\u001c\n\u0007\u0005=4H\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002h\u0005A!/\u001e8M\u0005\u001a;5\u000b\u0006\n\u0002x\u0005}\u0014\u0011QAB\u0003\u000b\u000b9)!#\u0002\f\u00065\u0005c\u0002\u001e\u0002^\u0005}\u0012\u0011\u0010\t\u0005u\u0005mt.C\u0002\u0002~m\u0012Q!\u0011:sCfDq!!\u0014#\u0001\u0004\ty\u0005C\u0003JE\u0001\u00071\nC\u0003WE\u0001\u0007\u0001\fC\u0003eE\u0001\u0007a\rC\u0003nE\u0001\u0007q\u000eC\u0003wE\u0001\u0007a\rC\u0003|E\u0001\u0007q\u000eC\u0004\u0002d\t\u0002\r!a\u0010\u0003\u000f\r{7\u000f\u001e$v]N!1%OAJ!\u0019\t)*!(\u0002\"6\u0011\u0011q\u0013\u0006\u0005\u0003w\tIJ\u0003\u0002\u0002\u001c\u00061!M]3fu\u0016LA!a(\u0002\u0018\naA)\u001b4g\rVt7\r^5p]B)\u00111UAT_6\u0011\u0011Q\u0015\u0006\u0005\u0003\u000b\nI*\u0003\u0003\u0002*\u0006\u0015&a\u0003#f]N,g+Z2u_J\f1B\\;n\u000bb\fW\u000e\u001d7fgB\u0019!(a,\n\u0007\u0005E6H\u0001\u0003M_:<G\u0003DA[\u0003s\u000bY,!0\u0002@\u0006\u0005\u0007cAA\\G5\t\u0001\u0005C\u0004\u0002N%\u0002\r!a\u0014\t\u000b%K\u0003\u0019A&\t\u000bYK\u0003\u0019\u0001-\t\u000bmL\u0003\u0019A8\t\u000f\u0005-\u0016\u00061\u0001\u0002.\u0006I1-\u00197dk2\fG/\u001a\u000b\u0005\u0003\u000f\fI\r\u0005\u0004;\u0003;z\u0017\u0011\u0015\u0005\b\u0003\u0017T\u0003\u0019AAQ\u0003\u001d9X-[4iiN\f1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u001b\t\u0005\u0003'\fi.\u0004\u0002\u0002V*!\u0011q[Am\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0017\u0001\u00026bm\u0006LA!a8\u0002V\n1qJ\u00196fGR\u0004")
public class LBFGS
implements Optimizer,
Logging {
    private Gradient gradient;
    private Updater updater;
    private int numCorrections;
    private double convergenceTol;
    private int maxNumIterations;
    private double regParam;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Tuple2<Vector, double[]> runLBFGS(RDD<Tuple2<Object, Vector>> rDD, Gradient gradient, Updater updater, int n, double d, int n2, double d2, Vector vector) {
        return LBFGS$.MODULE$.runLBFGS(rDD, gradient, updater, n, d, n2, d2, vector);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Gradient gradient() {
        return this.gradient;
    }

    private void gradient_$eq(Gradient x$1) {
        this.gradient = x$1;
    }

    private Updater updater() {
        return this.updater;
    }

    private void updater_$eq(Updater x$1) {
        this.updater = x$1;
    }

    private int numCorrections() {
        return this.numCorrections;
    }

    private void numCorrections_$eq(int x$1) {
        this.numCorrections = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    private int maxNumIterations() {
        return this.maxNumIterations;
    }

    private void maxNumIterations_$eq(int x$1) {
        this.maxNumIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    public LBFGS setNumCorrections(int corrections) {
        Predef$.MODULE$.require(corrections > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Number of corrections must be positive but got ").append(corrections).toString());
        this.numCorrections_$eq(corrections);
        return this;
    }

    public LBFGS setConvergenceTol(double tolerance) {
        Predef$.MODULE$.require(tolerance >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Convergence tolerance must be nonnegative but got ").append(tolerance).toString());
        this.convergenceTol_$eq(tolerance);
        return this;
    }

    public double getConvergenceTol() {
        return this.convergenceTol();
    }

    public LBFGS setNumIterations(int iters) {
        Predef$.MODULE$.require(iters >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(iters).toString());
        this.maxNumIterations_$eq(iters);
        return this;
    }

    public int getNumIterations() {
        return this.maxNumIterations();
    }

    public LBFGS setRegParam(double regParam) {
        Predef$.MODULE$.require(regParam >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Regularization parameter must be nonnegative but got ").append(regParam).toString());
        this.regParam_$eq(regParam);
        return this;
    }

    public double getRegParam() {
        return this.regParam();
    }

    public LBFGS setGradient(Gradient gradient) {
        this.gradient_$eq(gradient);
        return this;
    }

    public LBFGS setUpdater(Updater updater) {
        this.updater_$eq(updater);
        return this;
    }

    public Updater getUpdater() {
        return this.updater();
    }

    @Override
    public Vector optimize(RDD<Tuple2<Object, Vector>> data, Vector initialWeights) {
        Vector weights;
        Tuple2<Vector, double[]> tuple2 = LBFGS$.MODULE$.runLBFGS(data, this.gradient(), this.updater(), this.numCorrections(), this.convergenceTol(), this.maxNumIterations(), this.regParam(), initialWeights);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector vector = weights = (Vector)tuple2._1();
        Vector weights2 = vector;
        return weights2;
    }

    public LBFGS(Gradient gradient, Updater updater) {
        this.gradient = gradient;
        this.updater = updater;
        Logging.$init$((Logging)this);
        this.numCorrections = 10;
        this.convergenceTol = 1.0E-6;
        this.maxNumIterations = 100;
        this.regParam = 0.0;
    }

    public static class CostFun
    implements DiffFunction<breeze.linalg.DenseVector<Object>> {
        private final RDD<Tuple2<Object, Vector>> data;
        private final Gradient gradient;
        private final Updater updater;
        private final double regParam;
        private final long numExamples;

        public DiffFunction<breeze.linalg.DenseVector<Object>> repr() {
            return DiffFunction.repr$((DiffFunction)this);
        }

        public DiffFunction<breeze.linalg.DenseVector<Object>> cached(CanCopy<breeze.linalg.DenseVector<Object>> copy) {
            return DiffFunction.cached$((DiffFunction)this, copy);
        }

        public <U> DiffFunction<U> throughLens(Isomorphism<breeze.linalg.DenseVector<Object>, U> l) {
            return DiffFunction.throughLens$((DiffFunction)this, l);
        }

        public Object gradientAt(Object x) {
            return StochasticDiffFunction.gradientAt$((StochasticDiffFunction)this, (Object)x);
        }

        public double valueAt(Object x) {
            return StochasticDiffFunction.valueAt$((StochasticDiffFunction)this, (Object)x);
        }

        public final double apply(Object x) {
            return StochasticDiffFunction.apply$((StochasticDiffFunction)this, (Object)x);
        }

        public final <TT, B, C, That> That $plus(B b, UFunc.UImpl2<OpAdd$, TT, B, That> op) {
            return (That)NumericOps.$plus$((NumericOps)this, b, op);
        }

        public final Object $colon$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$plus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$plus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$times$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$times$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $plus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$plus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $times$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$times$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$minus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$minus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$percent$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$percent$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $percent$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$percent$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $minus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$minus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$div$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$div$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $div$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$div$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final <TT, B, That> That $less$colon$less(B b, UFunc.UImpl2<OpLT$, TT, B, That> op) {
            return (That)NumericOps.$less$colon$less$((NumericOps)this, b, op);
        }

        public final <TT, B, That> That $less$colon$eq(B b, UFunc.UImpl2<OpLTE$, TT, B, That> op) {
            return (That)NumericOps.$less$colon$eq$((NumericOps)this, b, op);
        }

        public final <TT, B, That> That $greater$colon$greater(B b, UFunc.UImpl2<OpGT$, TT, B, That> op) {
            return (That)NumericOps.$greater$colon$greater$((NumericOps)this, b, op);
        }

        public final <TT, B, That> That $greater$colon$eq(B b, UFunc.UImpl2<OpGTE$, TT, B, That> op) {
            return (That)NumericOps.$greater$colon$eq$((NumericOps)this, b, op);
        }

        public final Object $colon$amp$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$amp$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$bar$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$bar$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$up$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$up$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $amp$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$amp$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $bar$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$bar$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $up$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$up$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final <TT, B, That> That $plus$colon$plus(B b, UFunc.UImpl2<OpAdd$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$plus$colon$plus$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $times$colon$times(B b, UFunc.UImpl2<OpMulScalar$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$times$colon$times$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $colon$eq$eq(B b, UFunc.UImpl2<OpEq$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$colon$eq$eq$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $colon$bang$eq(B b, UFunc.UImpl2<OpNe$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$colon$bang$eq$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, That> That unary_$minus(UFunc.UImpl<OpNeg$, TT, That> op) {
            return (That)ImmutableNumericOps.unary_$minus$((ImmutableNumericOps)this, op);
        }

        public final <TT, B, That> That $minus$colon$minus(B b, UFunc.UImpl2<OpSub$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$minus$colon$minus$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $minus(B b, UFunc.UImpl2<OpSub$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$minus$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $percent$colon$percent(B b, UFunc.UImpl2<OpMod$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$percent$colon$percent$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $percent(B b, UFunc.UImpl2<OpMod$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$percent$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $div$colon$div(B b, UFunc.UImpl2<OpDiv$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$div$colon$div$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $div(B b, UFunc.UImpl2<OpDiv$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$div$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $up$colon$up(B b, UFunc.UImpl2<OpPow$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$up$colon$up$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, BB, That> That dot(B b, UFunc.UImpl2<OpMulInner$, TT, BB, That> op) {
            return (That)ImmutableNumericOps.dot$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, That> That unary_$bang(UFunc.UImpl<OpNot$, TT, That> op) {
            return (That)ImmutableNumericOps.unary_$bang$((ImmutableNumericOps)this, op);
        }

        public final <TT, B, That> That $amp$colon$amp(B b, UFunc.UImpl2<OpAnd$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$amp$colon$amp$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $bar$colon$bar(B b, UFunc.UImpl2<OpOr$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$bar$colon$bar$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $up$up$colon$up$up(B b, UFunc.UImpl2<OpXor$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$up$up$colon$up$up$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $amp(B b, UFunc.UImpl2<OpAnd$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$amp$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $bar(B b, UFunc.UImpl2<OpOr$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$bar$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $up$up(B b, UFunc.UImpl2<OpXor$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$up$up$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $times(B b, UFunc.UImpl2<OpMulMatrix$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$times$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, That> That t(CanTranspose<TT, That> op) {
            return (That)ImmutableNumericOps.t$((ImmutableNumericOps)this, op);
        }

        public <TT, B, That> That $bslash(B b, UFunc.UImpl2<OpSolveMatrixBy$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$bslash$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, That, Slice1, Slice2, Result> Result t(Slice1 a, Slice2 b, CanTranspose<TT, That> op, CanSlice2<That, Slice1, Slice2, Result> canSlice) {
            return (Result)ImmutableNumericOps.t$((ImmutableNumericOps)this, a, b, op, canSlice);
        }

        public final <TT, That, Slice1, Result> Result t(Slice1 a, CanTranspose<TT, That> op, CanSlice<That, Slice1, Result> canSlice) {
            return (Result)ImmutableNumericOps.t$((ImmutableNumericOps)this, a, op, canSlice);
        }

        public boolean apply$mcZD$sp(double v1) {
            return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
        }

        public double apply$mcDD$sp(double v1) {
            return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
        }

        public float apply$mcFD$sp(double v1) {
            return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
        }

        public int apply$mcID$sp(double v1) {
            return Function1.apply$mcID$sp$((Function1)this, (double)v1);
        }

        public long apply$mcJD$sp(double v1) {
            return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
        }

        public void apply$mcVD$sp(double v1) {
            Function1.apply$mcVD$sp$((Function1)this, (double)v1);
        }

        public boolean apply$mcZF$sp(float v1) {
            return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
        }

        public double apply$mcDF$sp(float v1) {
            return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
        }

        public float apply$mcFF$sp(float v1) {
            return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
        }

        public int apply$mcIF$sp(float v1) {
            return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
        }

        public long apply$mcJF$sp(float v1) {
            return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
        }

        public void apply$mcVF$sp(float v1) {
            Function1.apply$mcVF$sp$((Function1)this, (float)v1);
        }

        public boolean apply$mcZI$sp(int v1) {
            return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
        }

        public double apply$mcDI$sp(int v1) {
            return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
        }

        public float apply$mcFI$sp(int v1) {
            return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
        }

        public int apply$mcII$sp(int v1) {
            return Function1.apply$mcII$sp$((Function1)this, (int)v1);
        }

        public long apply$mcJI$sp(int v1) {
            return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
        }

        public void apply$mcVI$sp(int v1) {
            Function1.apply$mcVI$sp$((Function1)this, (int)v1);
        }

        public boolean apply$mcZJ$sp(long v1) {
            return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
        }

        public double apply$mcDJ$sp(long v1) {
            return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
        }

        public float apply$mcFJ$sp(long v1) {
            return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
        }

        public int apply$mcIJ$sp(long v1) {
            return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
        }

        public long apply$mcJJ$sp(long v1) {
            return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
        }

        public void apply$mcVJ$sp(long v1) {
            Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
        }

        public <A> Function1<A, Object> compose(Function1<A, breeze.linalg.DenseVector<Object>> g) {
            return Function1.compose$((Function1)this, g);
        }

        public <A> Function1<breeze.linalg.DenseVector<Object>, A> andThen(Function1<Object, A> g) {
            return Function1.andThen$((Function1)this, g);
        }

        public String toString() {
            return Function1.toString$((Function1)this);
        }

        public Tuple2<Object, breeze.linalg.DenseVector<Object>> calculate(breeze.linalg.DenseVector<Object> weights) {
            int x$4;
            Function2 & Serializable & scala.Serializable x$3;
            Function2 & Serializable & scala.Serializable x$2;
            Vector w = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)weights);
            int n = w.size();
            Broadcast bcW = this.data.context().broadcast((Object)w, ClassTag$.MODULE$.apply(Vector.class));
            Gradient localGradient = this.gradient;
            Function2 & Serializable & scala.Serializable seqOp = (Function2 & Serializable & scala.Serializable)(c, v) -> {
                double loss;
                Vector grad;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(c, v);
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        grad = (Vector)tuple23._1();
                        loss = tuple23._2$mcD$sp();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                double label = tuple2._1$mcD$sp();
                Vector features = (Vector)tuple2._2();
                DenseVector denseGrad = grad.toDense();
                double l = localGradient.compute(features, label, (Vector)bcW.value(), denseGrad);
                Tuple2 tuple24 = new Tuple2((Object)denseGrad, (Object)BoxesRunTime.boxToDouble((double)(loss + l)));
                return tuple24;
            };
            Function2 & Serializable & scala.Serializable combOp = (Function2 & Serializable & scala.Serializable)(c1, c2) -> {
                double loss1;
                Vector grad1;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(c1, c2);
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        grad1 = (Vector)tuple23._1();
                        loss1 = tuple23._2$mcD$sp();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Vector grad2 = (Vector)tuple2._1();
                double loss2 = tuple2._2$mcD$sp();
                DenseVector denseGrad1 = grad1.toDense();
                DenseVector denseGrad2 = grad2.toDense();
                BLAS$.MODULE$.axpy(1.0, (Vector)denseGrad2, (Vector)denseGrad1);
                Tuple2 tuple24 = new Tuple2((Object)denseGrad1, (Object)BoxesRunTime.boxToDouble((double)(loss1 + loss2)));
                return tuple24;
            };
            Vector zeroSparseVector = Vectors$.MODULE$.sparse(n, (Seq<Tuple2<Object, Object>>)((Seq)Seq$.MODULE$.empty()));
            Tuple2 x$1 = new Tuple2((Object)zeroSparseVector, (Object)BoxesRunTime.boxToDouble((double)0.0));
            Tuple2 tuple2 = (Tuple2)this.data.treeAggregate((Object)x$1, (Function2)(x$2 = seqOp), (Function2)(x$3 = combOp), x$4 = this.data.treeAggregate$default$4((Object)x$1), ClassTag$.MODULE$.apply(Tuple2.class));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector gradientSum = (Vector)tuple2._1();
            double lossSum = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)gradientSum, (Object)BoxesRunTime.boxToDouble((double)lossSum));
            Tuple2 tuple23 = tuple22;
            Vector gradientSum2 = (Vector)tuple23._1();
            double lossSum2 = tuple23._2$mcD$sp();
            bcW.destroy();
            double regVal = this.updater.compute(w, Vectors$.MODULE$.zeros(n), 0.0, 1, this.regParam)._2$mcD$sp();
            double loss = lossSum2 / (double)this.numExamples + regVal;
            Vector gradientTotal = w.copy();
            BLAS$.MODULE$.axpy(-1.0, (Vector)this.updater.compute(w, Vectors$.MODULE$.zeros(n), 1.0, 1, this.regParam)._1(), gradientTotal);
            BLAS$.MODULE$.axpy(1.0 / (double)this.numExamples, gradientSum2, gradientTotal);
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)loss), (Object)((breeze.linalg.DenseVector)gradientTotal.asBreeze()));
        }

        public CostFun(RDD<Tuple2<Object, Vector>> data, Gradient gradient, Updater updater, double regParam, long numExamples) {
            this.data = data;
            this.gradient = gradient;
            this.updater = updater;
            this.regParam = regParam;
            this.numExamples = numExamples;
            Function1.$init$((Function1)this);
            ImmutableNumericOps.$init$((ImmutableNumericOps)this);
            NumericOps.$init$((NumericOps)this);
            StochasticDiffFunction.$init$((StochasticDiffFunction)this);
            DiffFunction.$init$((DiffFunction)this);
        }
    }
}

