/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.support.CanZipMapValues;
import breeze.math.Semiring$;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.ExpectationAggregator;
import org.apache.spark.ml.clustering.GaussianMixture$;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u0010 \u0001)B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t%\u0010\u0005\t)\u0002\u0011\t\u0011)A\u0005}!)a\u000b\u0001C\u0001/\")A\f\u0001C!;\")a\u000b\u0001C\u0001O\")\u0011\u000e\u0001C\u0001U\")q\u000e\u0001C\u0001a\")1\u000f\u0001C\u0001i\")q\u000f\u0001C\u0001q\")Q\u0010\u0001C\u0001}\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\ty\u0003\u0001C\u0001\u0003cA\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\t\u0011\u0005m\u0002\u0001)A\u0005\u0003\u0003Aq!!\u0010\u0001\t\u0003\ny\u0004C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\u001e9\u00111Y\u0010\t\u0002\u0005\u0015gA\u0002\u0010 \u0011\u0003\t9\r\u0003\u0004W+\u0011\u0005\u00111\u001c\u0005\u000b\u0003;,\"\u0019!C\u0001?\u0005e\u0002\u0002CAp+\u0001\u0006I!!\u0001\t\u000f\u0005\u0005X\u0003\"\u0011\u0002d\"A\u00111^\u000b\u0005\u0002}\ti\u000f\u0003\u0005\u0002zV!\taHA~\u0011!\u0011Y!\u0006C\u0001?\t5\u0001\"\u0003B\u0011+\u0005\u0005I\u0011\u0002B\u0012\u0005=9\u0015-^:tS\u0006tW*\u001b=ukJ,'B\u0001\u0011\"\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003E\r\n!!\u001c7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001WM2\u0004c\u0001\u0017._5\t\u0011%\u0003\u0002/C\tIQi\u001d;j[\u0006$xN\u001d\t\u0003aEj\u0011aH\u0005\u0003e}\u0011AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d\u0007C\u0001\u00195\u0013\t)tDA\u000bHCV\u001c8/[1o\u001b&DH/\u001e:f!\u0006\u0014\u0018-\\:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\n\u0013\u0001B;uS2L!a\u000f\u001d\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mK\u0006\u0019Q/\u001b3\u0016\u0003y\u0002\"a\u0010%\u000f\u0005\u00013\u0005CA!E\u001b\u0005\u0011%BA\"*\u0003\u0019a$o\\8u})\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\u00061\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9E\tK\u0002\u0002\u0019J\u0003\"!\u0014)\u000e\u00039S!aT\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002R\u001d\n)1+\u001b8dK\u0006\n1+A\u00033]Ar\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002M%\u00061A(\u001b8jiz\"\"\u0001W-\u0011\u0005A\u0002\u0001\"\u0002\u001f\u0004\u0001\u0004q\u0004fA-M%\"\u001a1\u0001\u0014*\u0002\t\r|\u0007/\u001f\u000b\u00031zCQa\u0018\u0003A\u0002\u0001\fQ!\u001a=ue\u0006\u0004\"!\u00193\u000e\u0003\tT!aY\u0011\u0002\u000bA\f'/Y7\n\u0005\u0015\u0014'\u0001\u0003)be\u0006lW*\u00199)\u0007\u0011a%\u000bF\u0001YQ\r)AJU\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\tYG.D\u0001\u0001\u0011\u0015ig\u00011\u0001?\u0003\u00151\u0018\r\\;fQ\r1AJU\u0001\u0011g\u0016$\bK]3eS\u000e$\u0018n\u001c8D_2$\"a[9\t\u000b5<\u0001\u0019\u0001 )\u0007\u001da%+A\ttKR\u0004&o\u001c2bE&d\u0017\u000e^=D_2$\"a[;\t\u000b5D\u0001\u0019\u0001 )\u0007!a%+\u0001\u0007tKR<V-[4ii\u000e{G\u000e\u0006\u0002ls\")Q.\u0003a\u0001}!\u001a\u0011\u0002T>\"\u0003q\fQa\r\u00181]A\nAa]3u\u0017R\u00111n \u0005\u0007[*\u0001\r!!\u0001\u0011\t\u0005\r\u0011QA\u0007\u0002\t&\u0019\u0011q\u0001#\u0003\u0007%sG\u000fK\u0002\u000b\u0019J\u000b!b]3u\u001b\u0006D\u0018\n^3s)\rY\u0017q\u0002\u0005\u0007[.\u0001\r!!\u0001)\u0007-a%+\u0001\u0004tKR$v\u000e\u001c\u000b\u0004W\u0006]\u0001BB7\r\u0001\u0004\tI\u0002\u0005\u0003\u0002\u0004\u0005m\u0011bAA\u000f\t\n1Ai\\;cY\u0016D3\u0001\u0004'S\u0003\u001d\u0019X\r^*fK\u0012$2a[A\u0013\u0011\u0019iW\u00021\u0001\u0002(A!\u00111AA\u0015\u0013\r\tY\u0003\u0012\u0002\u0005\u0019>tw\rK\u0002\u000e\u0019J\u000b1c]3u\u0003\u001e<'/Z4bi&|g\u000eR3qi\"$2a[A\u001a\u0011\u0019ig\u00021\u0001\u0002\u0002!\u001aa\u0002T>\u0002\u00159,XnU1na2,7/\u0006\u0002\u0002\u0002\u0005Ya.^7TC6\u0004H.Z:!\u0003\r1\u0017\u000e\u001e\u000b\u0004_\u0005\u0005\u0003bBA\"#\u0001\u0007\u0011QI\u0001\bI\u0006$\u0018m]3ua\u0011\t9%a\u0016\u0011\r\u0005%\u0013qJA*\u001b\t\tYEC\u0002\u0002N\r\n1a]9m\u0013\u0011\t\t&a\u0013\u0003\u000f\u0011\u000bG/Y:fiB!\u0011QKA,\u0019\u0001!A\"!\u0017\u0002B\u0005\u0005\t\u0011!B\u0001\u00037\u00121a\u0018\u00133#\u0011\ti&a\u0019\u0011\t\u0005\r\u0011qL\u0005\u0004\u0003C\"%a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u0007\t)'C\u0002\u0002h\u0011\u00131!\u00118zQ\r\tBJU\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011qNA>!\u0011\t\t(a\u001e\u000e\u0005\u0005M$\u0002BA;\u0003\u0017\nQ\u0001^=qKNLA!!\u001f\u0002t\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005u$\u00031\u0001\u0002p\u000511o\u00195f[\u0006D3A\u0005'S\u0003)Ig.\u001b;SC:$w.\u001c\u000b\t\u0003\u000b\u000b\t+!/\u0002>BA\u00111AAD\u0003\u0017\u000b\t*C\u0002\u0002\n\u0012\u0013a\u0001V;qY\u0016\u0014\u0004CBA\u0002\u0003\u001b\u000bI\"C\u0002\u0002\u0010\u0012\u0013Q!\u0011:sCf\u0004b!a\u0001\u0002\u000e\u0006M\u0005\u0003CA\u0002\u0003\u000f\u000b)*!&\u0011\t\u0005]\u0015QT\u0007\u0003\u00033S1!a'\"\u0003\u0019a\u0017N\\1mO&!\u0011qTAM\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u000f\u0005\r6\u00031\u0001\u0002&\u0006I\u0011N\\:uC:\u001cWm\u001d\t\u0007\u0003O\u000bi+!-\u000e\u0005\u0005%&bAAVG\u0005\u0019!\u000f\u001a3\n\t\u0005=\u0016\u0011\u0016\u0002\u0004%\u0012#\u0005\u0003CA\u0002\u0003\u000f\u000b\u0019,!\u0007\u0011\t\u0005]\u0015QW\u0005\u0005\u0003o\u000bIJ\u0001\u0004WK\u000e$xN\u001d\u0005\b\u0003w\u001b\u0002\u0019AA\u0001\u0003-qW/\\\"mkN$XM]:\t\u000f\u0005}6\u00031\u0001\u0002\u0002\u0005Ya.^7GK\u0006$XO]3tQ\r\u0001AJU\u0001\u0010\u000f\u0006,8o]5b]6K\u0007\u0010^;sKB\u0011\u0001'F\n\b+\u0005%\u0017qZAk!\u0011\t\u0019!a3\n\u0007\u00055GI\u0001\u0004B]f\u0014VM\u001a\t\u0005o\u0005E\u0007,C\u0002\u0002Tb\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\r\u0005\u0003\u0002\u0004\u0005]\u0017bAAm\t\na1+\u001a:jC2L'0\u00192mKR\u0011\u0011QY\u0001\u0011\u001b\u0006CvLT+N?\u001a+\u0015\tV+S\u000bN\u000b\u0011#T!Y?:+Vj\u0018$F\u0003R+&+R*!\u0003\u0011aw.\u00193\u0015\u0007a\u000b)\u000f\u0003\u0004\u0002hf\u0001\rAP\u0001\u0005a\u0006$\b\u000eK\u0002\u001a\u0019J\u000b\u0011d\u001d5pk2$G)[:ue&\u0014W\u000f^3HCV\u001c8/[1ogR1\u0011q^A{\u0003o\u0004B!a\u0001\u0002r&\u0019\u00111\u001f#\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0018\u000eA\u0002\u0005\u0005\u0001bBA`5\u0001\u0007\u0011\u0011A\u0001\u001ck:\u0004\u0018mY6VaB,'\u000f\u0016:jC:<W\u000f\\1s\u001b\u0006$(/\u001b=\u0015\r\u0005u(1\u0001B\u0004!\u0011\t9*a@\n\t\t\u0005\u0011\u0011\u0014\u0002\f\t\u0016t7/Z'biJL\u0007\u0010C\u0004\u0003\u0006m\u0001\r!!\u0001\u0002\u00039DqA!\u0003\u001c\u0001\u0004\tY)\u0001\tue&\fgnZ;mCJ4\u0016\r\\;fg\u0006IR\u000f\u001d3bi\u0016<V-[4iiN\fe\u000eZ$bkN\u001c\u0018.\u00198t))\u0011yA!\u0005\u0003\u0016\te!Q\u0004\t\t\u0003\u0007\t9)!\u0007\u0002\u0014\"9!1\u0003\u000fA\u0002\u0005U\u0015\u0001B7fC:DqAa\u0006\u001d\u0001\u0004\t)*A\u0002d_ZDqAa\u0007\u001d\u0001\u0004\tI\"\u0001\u0004xK&<\u0007\u000e\u001e\u0005\b\u0005?a\u0002\u0019AA\r\u0003)\u0019X/\\,fS\u001eDGo]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003&A!!q\u0005B\u0019\u001b\t\u0011IC\u0003\u0003\u0003,\t5\u0012\u0001\u00027b]\u001eT!Aa\f\u0002\t)\fg/Y\u0005\u0005\u0005g\u0011IC\u0001\u0004PE*,7\r\u001e\u0015\u0004+1\u0013\u0006f\u0001\u000bM%\u0002")
public class GaussianMixture
extends Estimator<GaussianMixtureModel>
implements GaussianMixtureParams,
DefaultParamsWritable {
    private final String uid;
    private final int numSamples;
    private final IntParam k;
    private final IntParam aggregationDepth;
    private final DoubleParam tol;
    private final Param<String> probabilityCol;
    private final Param<String> weightCol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static GaussianMixture load(String string) {
        return GaussianMixture$.MODULE$.load(string);
    }

    public static MLReader<GaussianMixture> read() {
        return GaussianMixture$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GaussianMixture copy(ParamMap extra) {
        return (GaussianMixture)this.defaultCopy(extra);
    }

    public GaussianMixture setFeaturesCol(String value) {
        return (GaussianMixture)this.set(this.featuresCol(), value);
    }

    public GaussianMixture setPredictionCol(String value) {
        return (GaussianMixture)this.set(this.predictionCol(), value);
    }

    public GaussianMixture setProbabilityCol(String value) {
        return (GaussianMixture)this.set(this.probabilityCol(), value);
    }

    public GaussianMixture setWeightCol(String value) {
        return (GaussianMixture)this.set(this.weightCol(), value);
    }

    public GaussianMixture setK(int value) {
        return (GaussianMixture)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public GaussianMixture setMaxIter(int value) {
        return (GaussianMixture)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public GaussianMixture setTol(double value) {
        return (GaussianMixture)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public GaussianMixture setSeed(long value) {
        return (GaussianMixture)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public GaussianMixture setAggregationDepth(int value) {
        return (GaussianMixture)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    private int numSamples() {
        return this.numSamples;
    }

    @Override
    public GaussianMixtureModel fit(Dataset<?> dataset) {
        return (GaussianMixtureModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            int iter;
            this.transformSchema(dataset.schema(), true);
            SparkSession spark = dataset.sparkSession();
            int numFeatures = MetadataUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
            Predef$.MODULE$.require(numFeatures < GaussianMixture$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(131).append("GaussianMixture cannot handle more ").append("than ").append(GaussianMixture$.MODULE$.MAX_NUM_FEATURES()).append(" features because the size of the covariance").append(" matrix is quadratic in the number of features.").toString());
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            Column w = this.isDefined(this.weightCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.weightCol()))).nonEmpty() ? functions$.MODULE$.col(this.$(this.weightCol())).cast((DataType)DoubleType$.MODULE$) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixture.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_GaussianMixture$$typecreator4$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_clustering_GaussianMixture$$typecreator4$2(GaussianMixture $outer) {
                }
            }
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol())), w})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixture$$typecreator4$2(null)))).rdd();
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            SparkContext sc = spark.sparkContext();
            int numClusters = BoxesRunTime.unboxToInt((Object)this.$(this.k()));
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.probabilityCol(), this.weightCol(), this.k(), this.maxIter(), this.seed(), this.tol(), this.aggregationDepth()}));
            instr.logNumFeatures(numFeatures);
            boolean shouldDistributeGaussians = GaussianMixture$.MODULE$.shouldDistributeGaussians(numClusters, numFeatures);
            Tuple2<double[], Tuple2<DenseVector, DenseVector>[]> tuple2 = this.initRandom((RDD<Tuple2<org.apache.spark.ml.linalg.Vector, Object>>)instances, numClusters, numFeatures);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            double[] weights = (double[])tuple2._1();
            Tuple2[] gaussians = (Tuple2[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)weights, (Object)gaussians);
            Tuple2 tuple23 = tuple22;
            double[] weights2 = (double[])tuple23._1();
            Tuple2[] gaussians2 = (Tuple2[])tuple23._2();
            double logLikelihood = Double$.MODULE$.MinValue();
            double logLikelihoodPrev = 0.0;
            for (iter = 0; iter < BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())) && scala.math.package$.MODULE$.abs(logLikelihood - logLikelihoodPrev) > BoxesRunTime.unboxToDouble((Object)this.$(this.tol())); ++iter) {
                Broadcast bcWeights = sc.broadcast((Object)weights2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                Broadcast bcGaussians = sc.broadcast((Object)gaussians2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                ExpectationAggregator sums = (ExpectationAggregator)instances.treeAggregate((Object)new ExpectationAggregator(numFeatures, (Broadcast<double[]>)bcWeights, (Broadcast<Tuple2<DenseVector, DenseVector>[]>)bcGaussians), (Function2 & Serializable & scala.Serializable)(c, v) -> c.add((org.apache.spark.ml.linalg.Vector)v._1(), v._2$mcD$sp()), (Function2 & Serializable & scala.Serializable)(c1, c2) -> c1.merge((ExpectationAggregator)c2), BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(ExpectationAggregator.class));
                bcWeights.destroy();
                bcGaussians.destroy();
                if (iter == 0) {
                    instr.logNumExamples(sums.count());
                    instr.logSumOfWeights(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sums.weights())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                }
                double sumWeights = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sums.weights())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                if (shouldDistributeGaussians) {
                    int numPartitions = scala.math.package$.MODULE$.min(numClusters, 1024);
                    Seq tuples = (Seq)Seq$.MODULE$.tabulate(numClusters, (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$fit$5(sums, BoxesRunTime.unboxToInt((Object)i)));
                    Tuple2 tuple24 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sc.parallelize(tuples, numPartitions, ClassTag$.MODULE$.apply(Tuple3.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple3 tuple3 = x0$1;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        DenseVector mean = (DenseVector)tuple3._1();
                        DenseVector cov = (DenseVector)tuple3._2();
                        double weight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        Tuple2<Object, Tuple2<DenseVector, DenseVector>> tuple2 = GaussianMixture$.MODULE$.updateWeightsAndGaussians(mean, cov, weight, sumWeights);
                        return tuple2;
                    }, ClassTag$.MODULE$.apply(Tuple2.class)).collect())).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class));
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    double[] ws = (double[])tuple24._1();
                    Tuple2[] gs = (Tuple2[])tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)ws, (Object)gs);
                    Tuple2 tuple26 = tuple25;
                    double[] ws2 = (double[])tuple26._1();
                    Tuple2[] gs2 = (Tuple2[])tuple26._2();
                    Array$.MODULE$.copy((Object)ws2, 0, (Object)weights2, 0, ws2.length);
                    Array$.MODULE$.copy((Object)gs2, 0, (Object)gaussians2, 0, gs2.length);
                } else {
                    for (int i2 = 0; i2 < numClusters; ++i2) {
                        Tuple2<Object, Tuple2<DenseVector, DenseVector>> tuple27 = GaussianMixture$.MODULE$.updateWeightsAndGaussians(sums.means()[i2], sums.covs()[i2], sums.weights()[i2], sumWeights);
                        if (tuple27 == null) {
                            throw new MatchError(tuple27);
                        }
                        double weight = tuple27._1$mcD$sp();
                        Tuple2 gaussian = (Tuple2)tuple27._2();
                        Tuple2 tuple28 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)weight), (Object)gaussian);
                        Tuple2 tuple29 = tuple28;
                        double weight2 = tuple29._1$mcD$sp();
                        Tuple2 gaussian2 = (Tuple2)tuple29._2();
                        weights2[i2] = weight2;
                        gaussians2[i2] = gaussian2;
                    }
                }
                logLikelihoodPrev = logLikelihood;
                logLikelihood = sums.logLikelihood();
            }
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            MultivariateGaussian[] gaussianDists = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians2)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DenseVector mean = (DenseVector)tuple2._1();
                DenseVector covVec = (DenseVector)tuple2._2();
                DenseMatrix cov = GaussianMixture$.MODULE$.unpackUpperTriangularMatrix(numFeatures, covVec.values());
                MultivariateGaussian multivariateGaussian = new MultivariateGaussian((org.apache.spark.ml.linalg.Vector)mean, (Matrix)cov);
                return multivariateGaussian;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            GaussianMixtureModel model = ((Model)this.copyValues(new GaussianMixtureModel(this.uid(), weights2, gaussianDists), this.copyValues$default$2())).setParent(this);
            GaussianMixtureSummary summary = new GaussianMixtureSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.probabilityCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), logLikelihood, iter);
            instr.logNamedValue("logLikelihood", logLikelihood);
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            return (GaussianMixtureModel)model.setSummary((Option<GaussianMixtureSummary>)new Some((Object)summary));
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    private Tuple2<double[], Tuple2<DenseVector, DenseVector>[]> initRandom(RDD<Tuple2<org.apache.spark.ml.linalg.Vector, Object>> instances, int numClusters, int numFeatures) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instances.takeSample(true, numClusters * this.numSamples(), BoxesRunTime.unboxToLong((Object)this.$(this.seed()))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        org.apache.spark.ml.linalg.Vector[] samples = (org.apache.spark.ml.linalg.Vector[])tuple2._1();
        double[] sampleWeights = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)samples, (Object)sampleWeights);
        Tuple2 tuple23 = tuple22;
        org.apache.spark.ml.linalg.Vector[] samples2 = (org.apache.spark.ml.linalg.Vector[])tuple23._1();
        double[] sampleWeights2 = (double[])tuple23._2();
        double[] weights = new double[numClusters];
        double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sampleWeights2)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        Tuple2[] gaussians = (Tuple2[])Array$.MODULE$.tabulate(numClusters, (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$initRandom$1(this, samples2, sampleWeights2, weights, weightSum, numFeatures, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2((Object)weights, (Object)gaussians);
    }

    public static final /* synthetic */ Tuple3 $anonfun$fit$5(ExpectationAggregator sums$1, int i) {
        return new Tuple3((Object)sums$1.means()[i], (Object)sums$1.covs()[i], (Object)BoxesRunTime.boxToDouble((double)sums$1.weights()[i]));
    }

    public static final /* synthetic */ void $anonfun$initRandom$2(DenseVector covVec$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._1$mcD$sp();
        int i = tuple2._2$mcI$sp();
        double d = v;
        int n = i;
        covVec$1.values()[n + n * (n + 1) / 2] = d;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$initRandom$1(GaussianMixture $this, org.apache.spark.ml.linalg.Vector[] samples$1, double[] sampleWeights$1, double[] weights$1, double weightSum$1, int numFeatures$2, int i) {
        int start = i * $this.numSamples();
        int end = start + $this.numSamples();
        IndexedSeqView sampleSlice = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])samples$1)).view(start, end);
        IndexedSeqView weightSlice = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sampleWeights$1)).view(start, end);
        double localWeightSum = BoxesRunTime.unboxToDouble((Object)weightSlice.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        weights$1[i] = localWeightSum / weightSum$1;
        DenseVector v = new DenseVector(new double[numFeatures$2]);
        for (int j = 0; j < $this.numSamples(); ++j) {
            BLAS$.MODULE$.axpy(BoxesRunTime.unboxToDouble((Object)weightSlice.apply(j)), (org.apache.spark.ml.linalg.Vector)sampleSlice.apply(j), (org.apache.spark.ml.linalg.Vector)v);
        }
        BLAS$.MODULE$.scal(1.0 / localWeightSum, (org.apache.spark.ml.linalg.Vector)v);
        DenseVector mean = v;
        Vector ss = new DenseVector(new double[numFeatures$2]).asBreeze();
        for (int j = 0; j < $this.numSamples(); ++j) {
            Vector v2 = (Vector)((org.apache.spark.ml.linalg.Vector)sampleSlice.apply(j)).asBreeze().$minus((Object)mean.asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub());
            ss.$plus$eq(((ImmutableNumericOps)v2.$times((Object)v2, OpMulMatrix$.MODULE$.canZipMapValuesImpl(Vector$.MODULE$.scalarOf(), OpMulMatrix$.MODULE$.opMulMatrixFromSemiring(Semiring$.MODULE$.semiringD()), (CanZipMapValues)Vector$.MODULE$.zipMap_d()))).$times(weightSlice.apply(j), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()), (UFunc.InPlaceImpl2)Vector$.MODULE$.v_v_Idempotent_UpdateOp_Double_OpAdd());
        }
        org.apache.spark.ml.linalg.Vector diagVec = Vectors$.MODULE$.fromBreeze(ss);
        BLAS$.MODULE$.scal(1.0 / localWeightSum, diagVec);
        DenseVector covVec = new DenseVector((double[])Array$.MODULE$.ofDim(numFeatures$2 * (numFeatures$2 + 1) / 2, ClassTag$.MODULE$.Double()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(diagVec.toArray())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GaussianMixture.$anonfun$initRandom$2(covVec, x0$1);
            return BoxedUnit.UNIT;
        });
        DenseVector cov = covVec;
        return new Tuple2((Object)mean, (Object)cov);
    }

    public GaussianMixture(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasWeightCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        HasAggregationDepth.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.numSamples = 5;
    }

    public GaussianMixture() {
        this(Identifiable$.MODULE$.randomUID("GaussianMixture"));
    }
}

