/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\r\u001b\u0005\u0015B\u0001B\u0010\u0001\u0003\u0006\u0004%\te\u0010\u0005\t-\u0002\u0011\t\u0011)A\u0005\u0001\")\u0001\f\u0001C\u00013\")\u0001\f\u0001C\u0001=\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007BB4\u0001A\u0003%!\rC\u0003j\u0001\u0011\u0005q\bC\u0003l\u0001\u0011\u0005A\u000eC\u0004r\u0001\t\u0007I\u0011\u0001:\t\re\u0004\u0001\u0015!\u0003t\u0011\u0015Y\b\u0001\"\u0001}\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0002BBA/\u0001\u0011\u0005C\u0010C\u0004\u0002b\u0001!\t%a\u0019\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x\u001d9\u0011Q\u0010\u000e\t\u0002\u0005}dAB\r\u001b\u0011\u0003\t\t\t\u0003\u0004Y+\u0011\u0005\u0011Q\u0013\u0005\b\u0003/+B\u0011IAM\u0011%\t)+FA\u0001\n\u0013\t9KA\nSK\u001e\u0014Xm]:j_:,e/\u00197vCR|'O\u0003\u0002\u001c9\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005uq\u0012AA7m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0019R#'\u000e\u001d\u0011\u0005\u001dBS\"\u0001\u000e\n\u0005%R\"!C#wC2,\u0018\r^8s!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0004tQ\u0006\u0014X\r\u001a\u0006\u0003_q\tQ\u0001]1sC6L!!\r\u0017\u0003!!\u000b7\u000f\u0015:fI&\u001cG/[8o\u0007>d\u0007CA\u00164\u0013\t!DFA\u0006ICNd\u0015MY3m\u0007>d\u0007CA\u00167\u0013\t9DF\u0001\u0007ICN<V-[4ii\u000e{G\u000e\u0005\u0002:y5\t!H\u0003\u0002<9\u0005!Q\u000f^5m\u0013\ti$HA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn],sSR\f'\r\\3\u0002\u0007ULG-F\u0001A!\t\t%J\u0004\u0002C\u0011B\u00111IR\u0007\u0002\t*\u0011Q\tJ\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013\u001aC3!\u0001(U!\ty%+D\u0001Q\u0015\t\tf$\u0001\u0006b]:|G/\u0019;j_:L!a\u0015)\u0003\u000bMKgnY3\"\u0003U\u000bQ!\r\u00185]A\nA!^5eA!\u001a!A\u0014+\u0002\rqJg.\u001b;?)\tQ6\f\u0005\u0002(\u0001!)ah\u0001a\u0001\u0001\"\u001a1L\u0014+)\u0007\rqE\u000bF\u0001[Q\r!a\nV\u0001\u000b[\u0016$(/[2OC6,W#\u00012\u0011\u0007\r$\u0007)D\u0001/\u0013\t)gFA\u0003QCJ\fW\u000eK\u0002\u0006\u001dR\u000b1\"\\3ue&\u001cg*Y7fA!\u001aaA\u0014+\u0002\u001b\u001d,G/T3ue&\u001cg*Y7fQ\r9a\nV\u0001\u000eg\u0016$X*\u001a;sS\u000et\u0015-\\3\u0015\u00055tW\"\u0001\u0001\t\u000b=D\u0001\u0019\u0001!\u0002\u000bY\fG.^3)\u0007!qE+A\u0007uQJ|Wo\u001a5Pe&<\u0017N\\\u000b\u0002gB\u00111\r^\u0005\u0003k:\u0012ABQ8pY\u0016\fg\u000eU1sC6D3!\u0003(xC\u0005A\u0018!B\u001a/a9\u0002\u0014A\u0004;ie>,x\r[(sS\u001eLg\u000e\t\u0015\u0004\u00159;\u0018\u0001E4fiRC'o\\;hQ>\u0013\u0018nZ5o+\u0005i\bC\u0001@\u0000\u001b\u00051\u0015bAA\u0001\r\n9!i\\8mK\u0006t\u0007fA\u0006Oo\u0006\u00012/\u001a;UQJ|Wo\u001a5Pe&<\u0017N\u001c\u000b\u0004[\u0006%\u0001\"B8\r\u0001\u0004i\bf\u0001\u0007Oo\u0006\u00012/\u001a;Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0004[\u0006E\u0001\"B8\u000e\u0001\u0004\u0001\u0005fA\u0007O)\u0006Y1/\u001a;MC\n,GnQ8m)\ri\u0017\u0011\u0004\u0005\u0006_:\u0001\r\u0001\u0011\u0015\u0004\u001d9#\u0016\u0001D:fi^+\u0017n\u001a5u\u0007>dGcA7\u0002\"!)qn\u0004a\u0001\u0001\"\u001aqBT<\u0002\u0011\u00154\u0018\r\\;bi\u0016$B!!\u000b\u00020A\u0019a0a\u000b\n\u0007\u00055bI\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003c\u0001\u0002\u0019AA\u001a\u0003\u001d!\u0017\r^1tKR\u0004D!!\u000e\u0002FA1\u0011qGA\u001f\u0003\u0003j!!!\u000f\u000b\u0007\u0005mb$A\u0002tc2LA!a\u0010\u0002:\t9A)\u0019;bg\u0016$\b\u0003BA\"\u0003\u000bb\u0001\u0001\u0002\u0007\u0002H\u0005=\u0012\u0011!A\u0001\u0006\u0003\tIEA\u0002`IE\nB!a\u0013\u0002RA\u0019a0!\u0014\n\u0007\u0005=cIA\u0004O_RD\u0017N\\4\u0011\u0007y\f\u0019&C\u0002\u0002V\u0019\u00131!\u00118zQ\u0011\u0001b*!\u0017\"\u0005\u0005m\u0013!\u0002\u001a/a9\u0002\u0014AD5t\u0019\u0006\u0014x-\u001a:CKR$XM\u001d\u0015\u0004#9#\u0016\u0001B2paf$2AWA3\u0011\u001d\t9G\u0005a\u0001\u0003S\nQ!\u001a=ue\u0006\u00042aYA6\u0013\r\tiG\f\u0002\t!\u0006\u0014\u0018-\\'ba\"\"!CTA9C\t\t\u0019(A\u00032]Ur\u0003'\u0001\u0005u_N#(/\u001b8h)\u0005\u0001\u0005fA\nOo\"\u001a\u0001A\u0014+\u0002'I+wM]3tg&|g.\u0012<bYV\fGo\u001c:\u0011\u0005\u001d*2cB\u000b\u0002\u0004\u0006%\u0015q\u0012\t\u0004}\u0006\u0015\u0015bAAD\r\n1\u0011I\\=SK\u001a\u0004B!OAF5&\u0019\u0011Q\u0012\u001e\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019a0!%\n\u0007\u0005MeI\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002\u0000\u0005!An\\1e)\rQ\u00161\u0014\u0005\u0007\u0003;;\u0002\u0019\u0001!\u0002\tA\fG\u000f\u001b\u0015\u0005/9\u000b\t+\t\u0002\u0002$\u0006)\u0011G\f\u001c/a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u000b\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\t1\fgn\u001a\u0006\u0003\u0003g\u000bAA[1wC&!\u0011qWAW\u0005\u0019y%M[3di\"\"QCTAQQ\u0011!b*!)")
public final class RegressionEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
HasWeightCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final BooleanParam throughOrigin;
    private final Param<String> weightCol;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static RegressionEvaluator load(String string) {
        return RegressionEvaluator$.MODULE$.load(string);
    }

    public static MLReader<RegressionEvaluator> read() {
        return RegressionEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public RegressionEvaluator setMetricName(String value) {
        return (RegressionEvaluator)this.set(this.metricName(), value);
    }

    public BooleanParam throughOrigin() {
        return this.throughOrigin;
    }

    public boolean getThroughOrigin() {
        return BoxesRunTime.unboxToBoolean((Object)this.$(this.throughOrigin()));
    }

    public RegressionEvaluator setThroughOrigin(boolean value) {
        return (RegressionEvaluator)this.set(this.throughOrigin(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public RegressionEvaluator setPredictionCol(String value) {
        return (RegressionEvaluator)this.set(this.predictionCol(), value);
    }

    public RegressionEvaluator setLabelCol(String value) {
        return (RegressionEvaluator)this.set(this.labelCol(), value);
    }

    public RegressionEvaluator setWeightCol(String value) {
        return (RegressionEvaluator)this.set(this.weightCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.predictionCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FractionalType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        RDD predictionAndLabelsWithWeights = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), !this.isDefined(this.weightCol()) || this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.col(this.$(this.weightCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            double d2;
            Object weight;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object prediction = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    weight = ((SeqLike)some.get()).apply(2);
                    if (!(prediction instanceof Double)) break block2;
                    d2 = BoxesRunTime.unboxToDouble((Object)prediction);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (weight instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d3 = BoxesRunTime.unboxToDouble((Object)weight);
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d3));
            return tuple3;
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RegressionMetrics metrics = new RegressionMetrics((RDD<? extends Product>)predictionAndLabelsWithWeights, BoxesRunTime.unboxToBoolean((Object)this.$(this.throughOrigin())));
        String string = this.$(this.metricName());
        if ("rmse".equals(string)) {
            d = metrics.rootMeanSquaredError();
        } else if ("mse".equals(string)) {
            d = metrics.meanSquaredError();
        } else if ("r2".equals(string)) {
            d = metrics.r2();
        } else if ("mae".equals(string)) {
            d = metrics.meanAbsoluteError();
        } else if ("var".equals(string)) {
            d = metrics.explainedVariance();
        } else {
            throw new MatchError((Object)string);
        }
        return d;
    }

    @Override
    public boolean isLargerBetter() {
        String string = this.$(this.metricName());
        boolean bl = "r2".equals(string) ? true : "var".equals(string);
        boolean bl2 = bl;
        return bl2;
    }

    @Override
    public RegressionEvaluator copy(ParamMap extra) {
        return (RegressionEvaluator)this.defaultCopy(extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(54).append("RegressionEvaluator: uid=").append(this.uid()).append(", metricName=").append((Object)this.$(this.metricName())).append(", ").append("throughOrigin=").append(this.$(this.throughOrigin())).toString();
    }

    public RegressionEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        HasWeightCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"mse", "rmse", "r2", "mae", "var"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (mse|rmse|r2|mae|var)", allowedParams);
        this.throughOrigin = new BooleanParam(this, "throughOrigin", "Whether the regression is through the origin.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("rmse"), this.throughOrigin().$minus$greater(BoxesRunTime.boxToBoolean((boolean)false))}));
    }

    public RegressionEvaluator() {
        this(Identifiable$.MODULE$.randomUID("regEval"));
    }
}

