/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaDoubleRDD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%g\u0001\u0002\u001c8\u0001\tC\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\tQ\u0002\u0011\t\u0011)A\u00053\"A!\u000e\u0001BC\u0002\u0013\u0005\u0001\f\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003Z\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002\u0003;\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u000bY\u0004A\u0011A<\t\u0013\u0005\r\u0001A1A\u0005\n\u0005\u0015\u0001\u0002CA\n\u0001\u0001\u0006I!a\u0002\t\rY\u0004A\u0011AA\u000b\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002^\u0001!\t!a\u001d\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\b\"A\u0011Q\u0012\u0001\u0005\u0002e\ny\t\u0003\u0005\u0002\u001e\u0002!\t!OAH\u0011\u001d\ty\n\u0001C!\u0003C;q!a28\u0011\u0003\tIM\u0002\u00047o!\u0005\u00111\u001a\u0005\u0007mN!\t!a6\b\u000f\u0005e7\u0003#\u0003\u0002\\\u001a9\u0011q\\\n\t\n\u0005\u0005\bB\u0002<\u0017\t\u0003\t\u0019\u000fC\u0004\u0002fZ!\t!a:\t\u000f\u0005%h\u0003\"\u0001\u0002h\u001a1\u00111\u001e\fA\u0003[D!\"!>\u001b\u0005+\u0007I\u0011AA|\u0011%\tIP\u0007B\tB\u0003%A\f\u0003\u0006\u0002|j\u0011)\u001a!C\u0001\u0003oD\u0011\"!@\u001b\u0005#\u0005\u000b\u0011\u0002/\t\rYTB\u0011AA\u0000\u0011%\u0011IAGA\u0001\n\u0003\u0011Y\u0001C\u0005\u0003\u0012i\t\n\u0011\"\u0001\u0003\u0014!I!q\u0005\u000e\u0012\u0002\u0013\u0005!1\u0003\u0005\n\u0005SQ\u0012\u0011!C!\u0005WA\u0011B!\r\u001b\u0003\u0003%\tAa\r\t\u0013\tm\"$!A\u0005\u0002\tu\u0002\"\u0003B%5\u0005\u0005I\u0011\tB&\u0011%\u0011IFGA\u0001\n\u0003\u0011Y\u0006C\u0005\u0003`i\t\t\u0011\"\u0011\u0003b!I!1\r\u000e\u0002\u0002\u0013\u0005#Q\r\u0005\n\u0005OR\u0012\u0011!C!\u0005S:\u0011B!\u001c\u0017\u0003\u0003E\tAa\u001c\u0007\u0013\u0005-h#!A\t\u0002\tE\u0004B\u0002<-\t\u0003\u0011y\bC\u0005\u0003d1\n\t\u0011\"\u0012\u0003f!I!\u0011\u0011\u0017\u0002\u0002\u0013\u0005%1\u0011\u0005\n\u0005\u0013c\u0013\u0011!CA\u0005\u0017C\u0011B!(-\u0003\u0003%IAa(\t\u000f\u0005}e\u0003\"\u0001\u0003(\"9!1\u0017\f\u0005\u0002\tU\u0006b\u0002BZ'\u0011\u0005#Q\u0018\u0005\n\u0005;\u001b\u0012\u0011!C\u0005\u0005?\u0013q#S:pi>t\u0017n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005aJ\u0014A\u0003:fOJ,7o]5p]*\u0011!hO\u0001\u0006[2d\u0017N\u0019\u0006\u0003yu\nQa\u001d9be.T!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO\u000e\u00011\u0003\u0002\u0001D\u0013F\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013a!\u00118z%\u00164\u0007C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\tIwNC\u0001O\u0003\u0011Q\u0017M^1\n\u0005A[%\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001*V\u001b\u0005\u0019&B\u0001+:\u0003\u0011)H/\u001b7\n\u0005Y\u001b&\u0001C*bm\u0016\f'\r\\3\u0002\u0015\t|WO\u001c3be&,7/F\u0001Z!\r!%\fX\u0005\u00037\u0016\u0013Q!\u0011:sCf\u0004\"\u0001R/\n\u0005y+%A\u0002#pk\ndW\rK\u0002\u0002A\u001a\u0004\"!\u00193\u000e\u0003\tT!aY\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002fE\n)1+\u001b8dK\u0006\nq-A\u00032]Mr\u0003'A\u0006c_VtG-\u0019:jKN\u0004\u0003f\u0001\u0002aM\u0006Y\u0001O]3eS\u000e$\u0018n\u001c8tQ\r\u0019\u0001MZ\u0001\raJ,G-[2uS>t7\u000f\t\u0015\u0004\t\u00014\u0017\u0001C5t_R|g.[2\u0016\u0003A\u0004\"\u0001R9\n\u0005I,%a\u0002\"p_2,\u0017M\u001c\u0015\u0004\u000b\u00014\u0017!C5t_R|g.[2!Q\r1\u0001MZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\taTHP \t\u0003s\u0002i\u0011a\u000e\u0005\u0006/\u001e\u0001\r!\u0017\u0015\u0004u\u00024\u0007\"\u00026\b\u0001\u0004I\u0006f\u0001?aM\")an\u0002a\u0001a\"\u001aa\u0010\u00194)\u0007\u001d\u0001g-A\u0007qe\u0016$\u0017n\u0019;j_:|%\u000fZ\u000b\u0003\u0003\u000f\u0001R!!\u0003\u0002\u0010qk!!a\u0003\u000b\u0007\u00055Q)\u0001\u0003nCRD\u0017\u0002BA\t\u0003\u0017\u0011\u0001b\u0014:eKJLgnZ\u0001\u000faJ,G-[2uS>twJ\u001d3!)\u001dA\u0018qCA\u0013\u0003OAaa\u0016\u0006A\u0002\u0005e\u0001#BA\u000e\u0003CaVBAA\u000f\u0015\r\ty\"T\u0001\u0005Y\u0006tw-\u0003\u0003\u0002$\u0005u!\u0001C%uKJ\f'\r\\3\t\r)T\u0001\u0019AA\r\u0011\u0019q'\u00021\u0001\u0002*A!\u00111DA\u0016\u0013\r\u0011\u0018Q\u0004\u0015\u0005\u0015\u0001\fy#\t\u0002\u00022\u0005)\u0011G\f\u001b/a\u0005i\u0011m]:feR|%\u000fZ3sK\u0012$B!a\u000e\u0002ZQ!\u0011\u0011HA !\r!\u00151H\u0005\u0004\u0003{)%\u0001B+oSRDq!!\u0011\f\u0001\b\t\u0019%A\u0002pe\u0012\u0004R!!\u0012\u0002VqsA!a\u0012\u0002R9!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\u0005\u000ba\u0001\u0010:p_Rt\u0014\"\u0001$\n\u0007\u0005MS)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u0011q\u000b\u0006\u0004\u0003'*\u0005BBA.\u0017\u0001\u0007\u0011,\u0001\u0002yg\u00069\u0001O]3eS\u000e$H\u0003BA1\u0003[\u0002R!a\u0019\u0002jqk!!!\u001a\u000b\u0007\u0005\u001d4(A\u0002sI\u0012LA!a\u001b\u0002f\t\u0019!\u000b\u0012#\t\u000f\u0005=D\u00021\u0001\u0002b\u0005AA/Z:u\t\u0006$\u0018\rK\u0002\rA\u001a$B!!\u001e\u0002\u0004B!\u0011qOA@\u001b\t\tIHC\u0002O\u0003wR1!! <\u0003\r\t\u0007/[\u0005\u0005\u0003\u0003\u000bIHA\u0007KCZ\fGi\\;cY\u0016\u0014F\t\u0012\u0005\b\u0003_j\u0001\u0019AA;Q\ri\u0001M\u001a\u000b\u00049\u0006%\u0005BBA8\u001d\u0001\u0007A\fK\u0002\u000fA\u001a\faBY8v]\u0012\f'/\u001f,fGR|'/\u0006\u0002\u0002\u0012B!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018f\na\u0001\\5oC2<\u0017\u0002BAN\u0003+\u0013aAV3di>\u0014\u0018\u0001\u00059sK\u0012L7\r^5p]Z+7\r^8s\u0003\u0011\u0019\u0018M^3\u0015\r\u0005e\u00121UAX\u0011\u001d\t)+\u0005a\u0001\u0003O\u000b!a]2\u0011\t\u0005%\u00161V\u0007\u0002w%\u0019\u0011QV\u001e\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000f\u0005E\u0016\u00031\u0001\u00024\u0006!\u0001/\u0019;i!\u0011\t),!0\u000f\t\u0005]\u0016\u0011\u0018\t\u0004\u0003\u0013*\u0015bAA^\u000b\u00061\u0001K]3eK\u001aLA!a0\u0002B\n11\u000b\u001e:j]\u001eT1!a/FQ\u0011\t\u0002-a\f)\u0007\u0001\u0001g-A\fJg>$xN\\5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011\u0011pE\n\u0007'\r\u000bi-a5\u0011\tI\u000by\r_\u0005\u0004\u0003#\u001c&A\u0002'pC\u0012,'\u000fE\u0002E\u0003+L!\u0001U#\u0015\u0005\u0005%\u0017\u0001D*bm\u0016du.\u00193Wc}\u0003\u0004cAAo-5\t1C\u0001\u0007TCZ,Gj\\1e-Fz\u0006g\u0005\u0002\u0017\u0007R\u0011\u00111\\\u0001\u0012i\"L7OR8s[\u0006$h+\u001a:tS>tWCAAZ\u00035!\b.[:DY\u0006\u001c8OT1nK\n!A)\u0019;b'\u0019Q2)a<\u0002TB\u0019A)!=\n\u0007\u0005MXIA\u0004Qe>$Wo\u0019;\u0002\u0011\t|WO\u001c3bef,\u0012\u0001X\u0001\nE>,h\u000eZ1ss\u0002\n!\u0002\u001d:fI&\u001cG/[8o\u0003-\u0001(/\u001a3jGRLwN\u001c\u0011\u0015\r\t\u0005!Q\u0001B\u0004!\r\u0011\u0019AG\u0007\u0002-!1\u0011Q_\u0010A\u0002qCa!a? \u0001\u0004a\u0016\u0001B2paf$bA!\u0001\u0003\u000e\t=\u0001\u0002CA{AA\u0005\t\u0019\u0001/\t\u0011\u0005m\b\u0005%AA\u0002q\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0016)\u001aALa\u0006,\u0005\te\u0001\u0003\u0002B\u000e\u0005Gi!A!\b\u000b\t\t}!\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012T!aY#\n\t\t\u0015\"Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t5\u0002\u0003BA\u000e\u0005_IA!a0\u0002\u001e\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u0007\t\u0004\t\n]\u0012b\u0001B\u001d\u000b\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\bB#!\r!%\u0011I\u0005\u0004\u0005\u0007*%aA!os\"I!qI\u0013\u0002\u0002\u0003\u0007!QG\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t5\u0003C\u0002B(\u0005+\u0012y$\u0004\u0002\u0003R)\u0019!1K#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003X\tE#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001\u001dB/\u0011%\u00119eJA\u0001\u0002\u0004\u0011y$\u0001\u0005iCND7i\u001c3f)\t\u0011)$\u0001\u0005u_N#(/\u001b8h)\t\u0011i#\u0001\u0004fcV\fGn\u001d\u000b\u0004a\n-\u0004\"\u0003B$U\u0005\u0005\t\u0019\u0001B \u0003\u0011!\u0015\r^1\u0011\u0007\t\rAfE\u0003-\u0005g\n\u0019\u000e\u0005\u0005\u0003v\tmD\f\u0018B\u0001\u001b\t\u00119HC\u0002\u0003z\u0015\u000bqA];oi&lW-\u0003\u0003\u0003~\t]$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!qN\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005\u0003\u0011)Ia\"\t\r\u0005Ux\u00061\u0001]\u0011\u0019\tYp\fa\u00019\u00069QO\\1qa2LH\u0003\u0002BG\u00053\u0003R\u0001\u0012BH\u0005'K1A!%F\u0005\u0019y\u0005\u000f^5p]B)AI!&]9&\u0019!qS#\u0003\rQ+\b\u000f\\33\u0011%\u0011Y\nMA\u0001\u0002\u0004\u0011\t!A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0015\t\u0005\u00037\u0011\u0019+\u0003\u0003\u0003&\u0006u!AB(cU\u0016\u001cG\u000f\u0006\u0007\u0002:\t%&1\u0016BW\u0005_\u0013\t\fC\u0004\u0002&J\u0002\r!a*\t\u000f\u0005E&\u00071\u0001\u00024\")qK\ra\u00013\")!N\ra\u00013\")aN\ra\u0001a\u0006!An\\1e)\u0019\u00119L!/\u0003<B)AI!&Z3\"9\u0011QU\u001aA\u0002\u0005\u001d\u0006bBAYg\u0001\u0007\u00111\u0017\u000b\u0006q\n}&\u0011\u0019\u0005\b\u0003K#\u0004\u0019AAT\u0011\u001d\t\t\f\u000ea\u0001\u0003gCC\u0001\u000e1\u00020!\"1\u0003YA\u0018Q\u0011\u0011\u0002-a\f")
public class IsotonicRegressionModel
implements Serializable,
Saveable {
    private final double[] boundaries;
    private final double[] predictions;
    private final boolean isotonic;
    private final Ordering<Object> predictionOrd;

    public static IsotonicRegressionModel load(SparkContext sparkContext, String string) {
        return IsotonicRegressionModel$.MODULE$.load(sparkContext, string);
    }

    public double[] boundaries() {
        return this.boundaries;
    }

    public double[] predictions() {
        return this.predictions;
    }

    public boolean isotonic() {
        return this.isotonic;
    }

    private Ordering<Object> predictionOrd() {
        return this.predictionOrd;
    }

    private void assertOrdered(double[] xs, Ordering<Object> ord) {
        IntRef i = IntRef.create((int)1);
        int len = xs.length;
        while (i.elem < len) {
            Predef$.MODULE$.require(ord.compare((Object)BoxesRunTime.boxToDouble((double)xs[i.elem - 1]), (Object)BoxesRunTime.boxToDouble((double)xs[i.elem])) <= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Elements (").append(xs[i$1.elem - 1]).append(", ").append(xs[i$1.elem]).append(") are not ordered.").toString());
            ++i.elem;
        }
    }

    public RDD<Object> predict(RDD<Object> testData2) {
        return testData2.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)testData -> this.predict(testData), ClassTag$.MODULE$.Double());
    }

    public JavaDoubleRDD predict(JavaDoubleRDD testData) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.predict((RDD<Object>)testData.rdd().retag(ClassTag$.MODULE$.apply(Double.class))));
    }

    public double predict(double testData) {
        int foundIndex = Arrays.binarySearch(this.boundaries(), testData);
        int insertIndex = -foundIndex - 1;
        return insertIndex == 0 ? BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.predictions())).head()) : (insertIndex == this.boundaries().length ? BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.predictions())).last()) : (foundIndex < 0 ? IsotonicRegressionModel.linearInterpolation$1(this.boundaries()[insertIndex - 1], this.predictions()[insertIndex - 1], this.boundaries()[insertIndex], this.predictions()[insertIndex], testData) : this.predictions()[foundIndex]));
    }

    public Vector boundaryVector() {
        return Vectors$.MODULE$.dense(this.boundaries());
    }

    public Vector predictionVector() {
        return Vectors$.MODULE$.dense(this.predictions());
    }

    @Override
    public void save(SparkContext sc, String path) {
        IsotonicRegressionModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.boundaries(), this.predictions(), this.isotonic());
    }

    private static final double linearInterpolation$1(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public IsotonicRegressionModel(double[] boundaries, double[] predictions, boolean isotonic) {
        this.boundaries = boundaries;
        this.predictions = predictions;
        this.isotonic = isotonic;
        this.predictionOrd = isotonic ? package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$) : package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$).reverse();
        Predef$.MODULE$.require(boundaries.length == predictions.length);
        this.assertOrdered(boundaries, (Ordering<Object>)Ordering.Double$.MODULE$);
        this.assertOrdered(predictions, this.predictionOrd());
    }

    public IsotonicRegressionModel(Iterable<Object> boundaries, Iterable<Object> predictions, Boolean isotonic) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(boundaries).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(predictions).asScala()).toArray(ClassTag$.MODULE$.Double()), Predef$.MODULE$.Boolean2boolean(isotonic));
    }
}

