/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.PartitionwiseSampledRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.BernoulliCellSampler;
import org.apache.spark.util.random.RandomSampler;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

public final class MLUtils$
implements Logging {
    public static MLUtils$ MODULE$;
    private double EPSILON;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new MLUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> convertVectorColumnsToML(Dataset<?> dataset, String ... cols) {
        return this.convertVectorColumnsToML(dataset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertVectorColumnsFromML(Dataset<?> dataset, String ... cols) {
        return this.convertVectorColumnsFromML(dataset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertMatrixColumnsToML(Dataset<?> dataset, String ... cols) {
        return this.convertMatrixColumnsToML(dataset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public Dataset<Row> convertMatrixColumnsFromML(Dataset<?> dataset, String ... cols) {
        return this.convertMatrixColumnsFromML(dataset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    /*
     * WARNING - void declaration
     */
    private double EPSILON$lzycompute() {
        MLUtils$ mLUtils$ = this;
        synchronized (mLUtils$) {
            if (!this.bitmap$0) {
                void var2_2;
                double eps = 1.0;
                while (1.0 + eps / 2.0 != 1.0) {
                    eps /= 2.0;
                }
                this.EPSILON = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.EPSILON;
    }

    public double EPSILON() {
        return !this.bitmap$0 ? this.EPSILON$lzycompute() : this.EPSILON;
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, int numFeatures, int minPartitions) {
        int n;
        RDD<Tuple3<Object, int[], double[]>> parsed = this.parseLibSVMFile(sc, path, minPartitions);
        if (numFeatures > 0) {
            n = numFeatures;
        } else {
            parsed.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
            n = this.computeNumFeatures(parsed);
        }
        int d = n;
        return parsed.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            double label = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            int[] indices = (int[])tuple3._2();
            double[] values = (double[])tuple3._3();
            LabeledPoint labeledPoint = new LabeledPoint(label, Vectors$.MODULE$.sparse(d, indices, values));
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public int computeNumFeatures(RDD<Tuple3<Object, int[], double[]>> rdd) {
        return BoxesRunTime.unboxToInt((Object)rdd.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)MLUtils$.$anonfun$computeNumFeatures$1(x0$1)), ClassTag$.MODULE$.Int()).reduce((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x, y) -> scala.math.package$.MODULE$.max(x, y))) + 1;
    }

    public RDD<Tuple3<Object, int[], double[]>> parseLibSVMFile(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class)).filter((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$parseLibSVMFile$2(line))).map((Function1 & Serializable & scala.Serializable)line -> MODULE$.parseLibSVMRecord((String)line), ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public RDD<Tuple3<Object, int[], double[]>> parseLibSVMFile(SparkSession sparkSession, Seq<String> paths, Map<String, String> options) {
        SparkSession x$1 = sparkSession;
        Seq<String> x$2 = paths;
        String x$3 = TextFileFormat.class.getName();
        Map x$4 = options.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSource$.MODULE$.GLOB_PATHS_KEY()), (Object)"false")})));
        Option x$5 = DataSource$.MODULE$.apply$default$4();
        Seq x$6 = DataSource$.MODULE$.apply$default$5();
        Option x$7 = DataSource$.MODULE$.apply$default$6();
        Option x$8 = DataSource$.MODULE$.apply$default$8();
        Dataset lines = sparkSession.baseRelationToDataFrame(new DataSource(x$1, x$3, x$2, x$5, x$6, x$7, x$4, x$8).resolveRelation(false)).select("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return lines.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.trim((Column)lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)).as("line")})).filter(functions$.MODULE$.not(functions$.MODULE$.length((Column)lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"line"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)).or(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"line"}))).$((Seq)Nil$.MODULE$).startsWith("#")))).as(lines.sqlContext().implicits().newStringEncoder()).rdd().map((Function1 & Serializable & scala.Serializable)line -> MODULE$.parseLibSVMRecord((String)line), ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public Tuple3<Object, int[], double[]> parseLibSVMRecord(String line) {
        String[] items = new StringOps(Predef$.MODULE$.augmentString(line)).split(' ');
        double label = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])items)).head())).toDouble();
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])items)).tail())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$parseLibSVMRecord$1(x$2))))).map((Function1 & Serializable & scala.Serializable)item -> {
            String[] indexAndValue = new StringOps(Predef$.MODULE$.augmentString(item)).split(':');
            int index = new StringOps(Predef$.MODULE$.augmentString(indexAndValue[0])).toInt() - 1;
            double value = new StringOps(Predef$.MODULE$.augmentString(indexAndValue[1])).toDouble();
            return new Tuple2.mcID.sp(index, value);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] indices = (int[])tuple2._1();
        double[] values = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indices, (Object)values);
        Tuple2 tuple23 = tuple22;
        int[] indices2 = (int[])tuple23._1();
        double[] values2 = (double[])tuple23._2();
        IntRef previous = IntRef.create((int)-1);
        int indicesLength = indices2.length;
        for (int i = 0; i < indicesLength; ++i) {
            int current = indices2[i];
            Predef$.MODULE$.require(current > previous.elem, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(86).append("indices should be one-based and in ascending order;").append(" found current=").append(current).append(", previous=").append(previous$1.elem).append("; line=\"").append(line).append("\"").toString());
            previous.elem = current;
        }
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices2)).toArray(ClassTag$.MODULE$.Int()), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values2)).toArray(ClassTag$.MODULE$.Double()));
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path, int numFeatures) {
        return this.loadLibSVMFile(sc, path, numFeatures, sc.defaultMinPartitions());
    }

    public RDD<LabeledPoint> loadLibSVMFile(SparkContext sc, String path) {
        return this.loadLibSVMFile(sc, path, -1);
    }

    public void saveAsLibSVMFile(RDD<LabeledPoint> data, String dir) {
        RDD dataStr = data.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint == null) {
                throw new MatchError((Object)labeledPoint);
            }
            double label = labeledPoint.label();
            Vector features = labeledPoint.features();
            StringBuilder sb = new StringBuilder(((Object)BoxesRunTime.boxToDouble((double)label)).toString());
            features.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                int i = sp2._1$mcI$sp();
                double v = sp2._2$mcD$sp();
                sb.$plus$eq(' ');
                sb.$plus$plus$eq(new java.lang.StringBuilder(1).append(i + 1).append(":").append(v).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
            String string = sb.mkString();
            return string;
        }, ClassTag$.MODULE$.apply(String.class));
        dataStr.saveAsTextFile(dir);
    }

    public RDD<Vector> loadVectors(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1 & Serializable & scala.Serializable)s -> Vectors$.MODULE$.parse((String)s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<Vector> loadVectors(SparkContext sc, String path) {
        return sc.textFile(path, sc.defaultMinPartitions()).map((Function1 & Serializable & scala.Serializable)s -> Vectors$.MODULE$.parse((String)s), ClassTag$.MODULE$.apply(Vector.class));
    }

    public RDD<LabeledPoint> loadLabeledPoints(SparkContext sc, String path, int minPartitions) {
        return sc.textFile(path, minPartitions).map((Function1 & Serializable & scala.Serializable)s -> LabeledPoint$.MODULE$.parse((String)s), ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public RDD<LabeledPoint> loadLabeledPoints(SparkContext sc, String dir) {
        return this.loadLabeledPoints(sc, dir, sc.defaultMinPartitions());
    }

    public <T> Tuple2<RDD<T>, RDD<T>>[] kFold(RDD<T> rdd, int numFolds, int seed, ClassTag<T> evidence$1) {
        return this.kFold(rdd, numFolds, (long)seed, evidence$1);
    }

    public <T> Tuple2<RDD<T>, RDD<T>>[] kFold(RDD<T> rdd, int numFolds, long seed, ClassTag<T> evidence$2) {
        float numFoldsF = numFolds;
        return (Tuple2[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFolds).map((Function1 & Serializable & scala.Serializable)fold -> MLUtils$.$anonfun$kFold$1(numFoldsF, rdd, seed, evidence$2, BoxesRunTime.unboxToInt((Object)fold)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Vector appendBias(Vector vector) {
        Vector vector2;
        Vector vector3 = vector;
        if (vector3 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector3;
            double[] inputValues = denseVector.values();
            int inputLength = inputValues.length;
            double[] outputValues = (double[])Array$.MODULE$.ofDim(inputLength + 1, ClassTag$.MODULE$.Double());
            System.arraycopy(inputValues, 0, outputValues, 0, inputLength);
            outputValues[inputLength] = 1.0;
            vector2 = Vectors$.MODULE$.dense(outputValues);
        } else if (vector3 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector3;
            double[] inputValues = sparseVector.values();
            int[] inputIndices = sparseVector.indices();
            int inputValuesLength = inputValues.length;
            int dim = sparseVector.size();
            double[] outputValues = (double[])Array$.MODULE$.ofDim(inputValuesLength + 1, ClassTag$.MODULE$.Double());
            int[] outputIndices = (int[])Array$.MODULE$.ofDim(inputValuesLength + 1, ClassTag$.MODULE$.Int());
            System.arraycopy(inputValues, 0, outputValues, 0, inputValuesLength);
            System.arraycopy(inputIndices, 0, outputIndices, 0, inputValuesLength);
            outputValues[inputValuesLength] = 1.0;
            outputIndices[inputValuesLength] = dim;
            vector2 = Vectors$.MODULE$.sparse(dim + 1, outputIndices, outputValues);
        } else {
            throw new IllegalArgumentException(new java.lang.StringBuilder(27).append("Do not support vector type ").append(vector.getClass()).toString());
        }
        return vector2;
    }

    public Dataset<Row> convertVectorColumnsToML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((TraversableOnce)cols.flatMap((Function1 & Serializable & scala.Serializable)c -> {
            Iterable iterable;
            DataType dataType = schema.apply(c).dataType();
            Class clazz = dataType.getClass();
            Class<org.apache.spark.mllib.linalg.VectorUDT> clazz2 = org.apache.spark.mllib.linalg.VectorUDT.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some(c));
            } else {
                Class clazz3 = dataType.getClass();
                Class<VectorUDT> clazz4 = VectorUDT.class;
                Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(69).append("Column ").append((String)c).append(" must be old Vector type to be converted to new type but got ").append(dataType).append(".").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).toSet() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$convertVectorColumnsToML$3(x$4))))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Vector column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator1$1() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator2$1() {
            }
        }
        UserDefinedFunction convertToML = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)v -> v.asML(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator2$1()));
        Column[] exprs = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String c = field.name();
            return colSet.contains((Object)c) ? convertToML.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata()) : functions$.MODULE$.col(c);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> convertVectorColumnsFromML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((TraversableOnce)cols.flatMap((Function1 & Serializable & scala.Serializable)c -> {
            Iterable iterable;
            DataType dataType = schema.apply(c).dataType();
            Class clazz = dataType.getClass();
            Class<VectorUDT> clazz2 = VectorUDT.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some(c));
            } else {
                Class clazz3 = dataType.getClass();
                Class<org.apache.spark.mllib.linalg.VectorUDT> clazz4 = org.apache.spark.mllib.linalg.VectorUDT.class;
                Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(69).append("Column ").append((String)c).append(" must be new Vector type to be converted to old type but got ").append(dataType).append(".").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).toSet() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$convertVectorColumnsFromML$3(x$6))))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Vector column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator1$2() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator2$2() {
            }
        }
        UserDefinedFunction convertFromML = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)v -> Vectors$.MODULE$.fromML((org.apache.spark.ml.linalg.Vector)v), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator2$2()));
        Column[] exprs = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String c = field.name();
            return colSet.contains((Object)c) ? convertFromML.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata()) : functions$.MODULE$.col(c);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> convertMatrixColumnsToML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((TraversableOnce)cols.flatMap((Function1 & Serializable & scala.Serializable)c -> {
            Iterable iterable;
            DataType dataType = schema.apply(c).dataType();
            Class clazz = dataType.getClass();
            Class<MatrixUDT> clazz2 = MatrixUDT.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some(c));
            } else {
                Class clazz3 = dataType.getClass();
                Class<org.apache.spark.ml.linalg.MatrixUDT> clazz4 = org.apache.spark.ml.linalg.MatrixUDT.class;
                Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(69).append("Column ").append((String)c).append(" must be old Matrix type to be converted to new type but got ").append(dataType).append(".").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).toSet() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$convertMatrixColumnsToML$3(x$8))))).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Matrix column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator1$3() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator2$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator2$3() {
            }
        }
        UserDefinedFunction convertToML = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)v -> v.asML(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator1$3()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator2$3()));
        Column[] exprs = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String c = field.name();
            return colSet.contains((Object)c) ? convertToML.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata()) : functions$.MODULE$.col(c);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> convertMatrixColumnsFromML(Dataset<?> dataset, Seq<String> cols) {
        Set colSet;
        StructType schema = dataset.schema();
        Set set = colSet = cols.nonEmpty() ? ((TraversableOnce)cols.flatMap((Function1 & Serializable & scala.Serializable)c -> {
            Iterable iterable;
            DataType dataType = schema.apply(c).dataType();
            Class clazz = dataType.getClass();
            Class<org.apache.spark.ml.linalg.MatrixUDT> clazz2 = org.apache.spark.ml.linalg.MatrixUDT.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some(c));
            } else {
                Class clazz3 = dataType.getClass();
                Class<MatrixUDT> clazz4 = MatrixUDT.class;
                Predef$.MODULE$.require(!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(69).append("Column ").append((String)c).append(" must be new Matrix type to be converted to old type but got ").append(dataType).append(".").toString());
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).toSet() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$convertMatrixColumnsFromML$3(x$10))))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        if (colSet.isEmpty()) {
            return dataset.toDF();
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Matrix column conversion has serialization overhead. Please migrate your datasets and workflows to use the spark.ml package.");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator1$4() {
            }
        }
        public final class Org_apache_spark_mllib_util_MLUtils$$typecreator2$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Matrix").asType().toTypeConstructor();
            }

            public Org_apache_spark_mllib_util_MLUtils$$typecreator2$4() {
            }
        }
        UserDefinedFunction convertFromML = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)m -> Matrices$.MODULE$.fromML((Matrix)m), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator1$4()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_mllib_util_MLUtils$$typecreator2$4()));
        Column[] exprs = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String c = field.name();
            return colSet.contains((Object)c) ? convertFromML.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(c)})).as(c, field.metadata()) : functions$.MODULE$.col(c);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public double fastSquaredDistance(Vector v1, double norm1, Vector v2, double norm2, double precision) {
        double sqDist;
        block1: {
            double sumSquaredNorm;
            block2: {
                block0: {
                    int n = v1.size();
                    Predef$.MODULE$.require(v2.size() == n);
                    Predef$.MODULE$.require(norm1 >= 0.0 && norm2 >= 0.0);
                    sqDist = 0.0;
                    if (!(v1 instanceof DenseVector) || !(v2 instanceof DenseVector)) break block0;
                    sqDist = Vectors$.MODULE$.sqdist(v1, v2);
                    break block1;
                }
                sumSquaredNorm = norm1 * norm1 + norm2 * norm2;
                double normDiff = norm1 - norm2;
                double precisionBound1 = 2.0 * this.EPSILON() * sumSquaredNorm / (normDiff * normDiff + this.EPSILON());
                if (!(precisionBound1 < precision)) break block2;
                sqDist = sumSquaredNorm - 2.0 * BLAS$.MODULE$.dot(v1, v2);
                break block1;
            }
            double dotValue = BLAS$.MODULE$.dot(v1, v2);
            sqDist = scala.math.package$.MODULE$.max(sumSquaredNorm - 2.0 * dotValue, 0.0);
            double precisionBound2 = this.EPSILON() * (sumSquaredNorm + 2.0 * scala.math.package$.MODULE$.abs(dotValue)) / (sqDist + this.EPSILON());
            if (!(precisionBound2 > precision)) break block1;
            sqDist = Vectors$.MODULE$.sqdist(v1, v2);
        }
        return sqDist;
    }

    public double fastSquaredDistance$default$5() {
        return 1.0E-6;
    }

    public double log1pExp(double x) {
        return x > 0.0 ? x + scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(-x)) : scala.math.package$.MODULE$.log1p(scala.math.package$.MODULE$.exp(x));
    }

    public static final /* synthetic */ int $anonfun$computeNumFeatures$1(Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int[] indices = (int[])tuple3._2();
        int n = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).lastOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$parseLibSVMFile$2(String line) {
        return !line.isEmpty() && !line.startsWith("#");
    }

    public static final /* synthetic */ boolean $anonfun$parseLibSVMRecord$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ Tuple2 $anonfun$kFold$1(float numFoldsF$1, RDD rdd$1, long seed$1, ClassTag evidence$2$1, int fold) {
        BernoulliCellSampler sampler = new BernoulliCellSampler((double)((float)(fold - 1) / numFoldsF$1), (double)((float)fold / numFoldsF$1), false);
        PartitionwiseSampledRDD validation = new PartitionwiseSampledRDD(rdd$1, (RandomSampler)sampler, true, seed$1, evidence$2$1, evidence$2$1);
        PartitionwiseSampledRDD training = new PartitionwiseSampledRDD(rdd$1, (RandomSampler)sampler.cloneComplement(), true, seed$1, evidence$2$1, evidence$2$1);
        return new Tuple2((Object)training, (Object)validation);
    }

    public static final /* synthetic */ boolean $anonfun$convertVectorColumnsToML$3(StructField x$4) {
        Class clazz = x$4.dataType().getClass();
        Class<org.apache.spark.mllib.linalg.VectorUDT> clazz2 = org.apache.spark.mllib.linalg.VectorUDT.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertVectorColumnsFromML$3(StructField x$6) {
        Class clazz = x$6.dataType().getClass();
        Class<VectorUDT> clazz2 = VectorUDT.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertMatrixColumnsToML$3(StructField x$8) {
        Class clazz = x$8.dataType().getClass();
        Class<MatrixUDT> clazz2 = MatrixUDT.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertMatrixColumnsFromML$3(StructField x$10) {
        Class clazz = x$10.dataType().getClass();
        Class<org.apache.spark.ml.linalg.MatrixUDT> clazz2 = org.apache.spark.ml.linalg.MatrixUDT.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    private MLUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

