/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.neural_network;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.LocalTransformations;
import org.sparkproject.dmg.pmml.MathContext;
import org.sparkproject.dmg.pmml.MiningFunction;
import org.sparkproject.dmg.pmml.MiningSchema;
import org.sparkproject.dmg.pmml.Model;
import org.sparkproject.dmg.pmml.ModelExplanation;
import org.sparkproject.dmg.pmml.ModelStats;
import org.sparkproject.dmg.pmml.ModelVerification;
import org.sparkproject.dmg.pmml.Output;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.StringValue;
import org.sparkproject.dmg.pmml.Targets;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitable;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.neural_network.NeuralInputs;
import org.sparkproject.dmg.pmml.neural_network.NeuralLayer;
import org.sparkproject.dmg.pmml.neural_network.NeuralOutputs;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "neuralInputs", "neuralLayers", "neuralOutputs", "modelVerification"})
@XmlRootElement(name="NeuralNetwork", namespace="http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "activationFunction", "normalizationMethod", "threshold", "width", "altitude", "numberOfLayers", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "neuralInputs", "neuralLayers", "neuralOutputs", "modelVerification"})
public class NeuralNetwork
extends Model
implements HasExtensions<NeuralNetwork> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="activationFunction", required=true)
    @JsonProperty(value="activationFunction")
    private ActivationFunction activationFunction;
    @XmlAttribute(name="normalizationMethod")
    @JsonProperty(value="normalizationMethod")
    private NormalizationMethod normalizationMethod;
    @XmlAttribute(name="threshold")
    @JsonProperty(value="threshold")
    private Double threshold;
    @XmlAttribute(name="width")
    @JsonProperty(value="width")
    private Double width;
    @XmlAttribute(name="altitude")
    @JsonProperty(value="altitude")
    private Double altitude;
    @XmlAttribute(name="numberOfLayers")
    @JsonProperty(value="numberOfLayers")
    private Integer numberOfLayers;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @org.sparkproject.jpmml.model.annotations.Extension
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="NeuralInputs", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="NeuralInputs")
    private NeuralInputs neuralInputs;
    @XmlElement(name="NeuralLayer", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="NeuralLayer")
    private List<NeuralLayer> neuralLayers;
    @XmlElement(name="NeuralOutputs", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="NeuralOutputs")
    private NeuralOutputs neuralOutputs;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Double DEFAULT_THRESHOLD = 0.0;
    private static final Double DEFAULT_ALTITUDE = 1.0;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67305485L;

    public NeuralNetwork() {
    }

    public NeuralNetwork(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="activationFunction") ActivationFunction activationFunction, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="neuralInputs") NeuralInputs neuralInputs, @Property(value="neuralLayers") List<NeuralLayer> neuralLayers) {
        this.miningFunction = miningFunction;
        this.activationFunction = activationFunction;
        this.miningSchema = miningSchema;
        this.neuralInputs = neuralInputs;
        this.neuralLayers = neuralLayers;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public NeuralNetwork setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public NeuralNetwork setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public NeuralNetwork setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public NeuralNetwork setActivationFunction(@Property(value="activationFunction") ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
        return this;
    }

    public NormalizationMethod getNormalizationMethod() {
        if (this.normalizationMethod == null) {
            return NormalizationMethod.NONE;
        }
        return this.normalizationMethod;
    }

    public NeuralNetwork setNormalizationMethod(@Property(value="normalizationMethod") NormalizationMethod normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    public Double getThreshold() {
        if (this.threshold == null) {
            return DEFAULT_THRESHOLD;
        }
        return this.threshold;
    }

    public NeuralNetwork setThreshold(@Property(value="threshold") Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Double getWidth() {
        return this.width;
    }

    public NeuralNetwork setWidth(@Property(value="width") Double width) {
        this.width = width;
        return this;
    }

    public Double getAltitude() {
        if (this.altitude == null) {
            return DEFAULT_ALTITUDE;
        }
        return this.altitude;
    }

    public NeuralNetwork setAltitude(@Property(value="altitude") Double altitude) {
        this.altitude = altitude;
        return this;
    }

    public Integer getNumberOfLayers() {
        return this.numberOfLayers;
    }

    public NeuralNetwork setNumberOfLayers(@Property(value="numberOfLayers") Integer numberOfLayers) {
        this.numberOfLayers = numberOfLayers;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public NeuralNetwork setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public NeuralNetwork setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NeuralNetwork addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public NeuralNetwork setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public NeuralNetwork setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public NeuralNetwork setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public NeuralNetwork setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public NeuralNetwork setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public NeuralNetwork setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public NeuralInputs getNeuralInputs() {
        return this.neuralInputs;
    }

    public NeuralNetwork setNeuralInputs(@Property(value="neuralInputs") NeuralInputs neuralInputs) {
        this.neuralInputs = neuralInputs;
        return this;
    }

    public boolean hasNeuralLayers() {
        return this.neuralLayers != null && this.neuralLayers.size() > 0;
    }

    public List<NeuralLayer> getNeuralLayers() {
        if (this.neuralLayers == null) {
            this.neuralLayers = new ArrayList<NeuralLayer>();
        }
        return this.neuralLayers;
    }

    public NeuralNetwork addNeuralLayers(NeuralLayer ... neuralLayers) {
        this.getNeuralLayers().addAll(Arrays.asList(neuralLayers));
        return this;
    }

    public NeuralOutputs getNeuralOutputs() {
        return this.neuralOutputs;
    }

    public NeuralNetwork setNeuralOutputs(@Property(value="neuralOutputs") NeuralOutputs neuralOutputs) {
        this.neuralOutputs = neuralOutputs;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public NeuralNetwork setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getNeuralInputs());
            }
            if (status == VisitorAction.CONTINUE && this.hasNeuralLayers()) {
                status = PMMLObject.traverse(visitor, this.getNeuralLayers());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getNeuralOutputs(), (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum NormalizationMethod implements StringValue<NormalizationMethod>
    {
        NONE("none"),
        SIMPLEMAX("simplemax"),
        SOFTMAX("softmax");

        private final String value;

        private NormalizationMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static NormalizationMethod fromValue(String v) {
            for (NormalizationMethod c : NormalizationMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ActivationFunction implements StringValue<ActivationFunction>
    {
        THRESHOLD("threshold"),
        LOGISTIC("logistic"),
        TANH("tanh"),
        IDENTITY("identity"),
        EXPONENTIAL("exponential"),
        RECIPROCAL("reciprocal"),
        SQUARE("square"),
        GAUSS("Gauss"),
        SINE("sine"),
        COSINE("cosine"),
        ELLIOTT("Elliott"),
        ARCTAN("arctan"),
        RECTIFIER("rectifier"),
        RADIAL_BASIS("radialBasis");

        private final String value;

        private ActivationFunction(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ActivationFunction fromValue(String v) {
            for (ActivationFunction c : ActivationFunction.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

