/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.fpm;

import java.io.Serializable;
import org.apache.spark.mllib.fpm.AssociationRules;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AssociationRules$ {
    public static AssociationRules$ MODULE$;

    static {
        new AssociationRules$();
    }

    public <T> Dataset<Row> getAssociationRulesFromFP(Dataset<?> dataset, String itemsCol, String freqCol, double minConfidence, Map<T, Object> itemSupport, long numTrainingRecords, ClassTag<T> evidence$2) {
        RDD freqItemSetRdd = dataset.select(itemsCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{freqCol})).rdd().map((Function1 & Serializable & scala.Serializable)row -> new FPGrowth.FreqItemset(row.getSeq(0).toArray(evidence$2), row.getLong(1)), ClassTag$.MODULE$.apply(FPGrowth.FreqItemset.class));
        RDD rows = new AssociationRules().setMinConfidence(minConfidence).run(freqItemSetRdd, itemSupport, evidence$2).map((Function1 & Serializable & scala.Serializable)r -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r.antecedent(), r.consequent(), BoxesRunTime.boxToDouble((double)r.confidence()), r.lift().orNull(Predef$.MODULE$.$conforms()), BoxesRunTime.boxToDouble((double)(r.freqUnion() / (double)numTrainingRecords))})), ClassTag$.MODULE$.apply(Row.class));
        DataType dt = dataset.schema().apply(itemsCol).dataType();
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("antecedent", dt, false, StructField$.MODULE$.apply$default$4()), new StructField("consequent", dt, false, StructField$.MODULE$.apply$default$4()), new StructField("confidence", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("lift", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("support", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
        Dataset rules = dataset.sparkSession().createDataFrame(rows, schema);
        return rules;
    }

    private AssociationRules$() {
        MODULE$ = this;
    }
}

