/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-c\u0001\u0002\"D\u00019C\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0005\u001a\u0005\tw\u0002\u0011\t\u0011)A\u0005K\"AQ\u0010\u0001BC\u0002\u0013\u0005a\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005'\"Q\u0011\u0011\u0002\u0001\u0003\u0006\u0004%\t!a\u0003\t\u0015\u0005]\u0001A!A!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u001c\u0001\u0011)\u0019!C\u0001\u0003\u0017A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011!\t\u0019\u0003\u0001C\u0001\u000b\u0006\u0015\u0002bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\tI\u0006\u0001C\u0001\u00037B!\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u007f\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0004%I!!\u001a\t\u0015\u0005E\u0004\u00011A\u0001B\u0003&1\u000b\u0003\u0005\u0002t\u0001!\t%RA;\u0011\u001d\ti\n\u0001C\u0005\u0003?Cq!!*\u0001\t\u0003\t9\u000bC\u0004\u00020\u0002!\t!!-\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u00111\u001f\u0001\u0005B\u0005U\bb\u0002B\u0005\u0001\u0011\u0005#1\u0002\u0005\b\u00053\u0001A\u0011\tB\u000e\u0011\u001d\u0011)\u0003\u0001C!\u0005O9qA!\fD\u0011\u0003\u0011yC\u0002\u0004C\u0007\"\u0005!\u0011\u0007\u0005\b\u0003GQB\u0011\u0001B#\u0011\u001d\u00119E\u0007C!\u0005\u0013BqAa\u0015\u001b\t\u0003\u0012)FB\u0004\u0003^i\u0001!Da\u0018\t\u0013\t5dD!A!\u0002\u0013I\u0006bBA\u0012=\u0011\u0005!q\u000e\u0004\u0007\u0005orBI!\u001f\t\u0011u\f#Q3A\u0005\u0002yD\u0011\"!\u0002\"\u0005#\u0005\u000b\u0011B*\t\u0015\u0005%\u0011E!f\u0001\n\u0003\tY\u0001\u0003\u0006\u0002\u0018\u0005\u0012\t\u0012)A\u0005\u0003\u001bA!\"a\u0007\"\u0005+\u0007I\u0011AA\u0006\u0011)\ty\"\tB\tB\u0003%\u0011Q\u0002\u0005\b\u0003G\tC\u0011\u0001BA\u0011%\u0011I!IA\u0001\n\u0003\u0011i\tC\u0005\u0003\u0016\u0006\n\n\u0011\"\u0001\u0003\u0018\"I!1V\u0011\u0012\u0002\u0013\u0005!Q\u0016\u0005\n\u0005c\u000b\u0013\u0013!C\u0001\u0005[C\u0011Ba-\"\u0003\u0003%\tE!.\t\u0013\t\u0015\u0017%!A\u0005\u0002\u0005e\u0002\"\u0003BdC\u0005\u0005I\u0011\u0001Be\u0011%\u0011i-IA\u0001\n\u0003\u0012y\rC\u0005\u0003^\u0006\n\t\u0011\"\u0001\u0003`\"I!\u0011^\u0011\u0002\u0002\u0013\u0005#1\u001e\u0005\n\u0005K\t\u0013\u0011!C!\u0005[D\u0011Ba<\"\u0003\u0003%\tE!=\b\u0013\tUh$!A\t\n\t]h!\u0003B<=\u0005\u0005\t\u0012\u0002B}\u0011\u001d\t\u0019C\u000eC\u0001\u0007\u000fA\u0011B!\n7\u0003\u0003%)E!<\t\u0013\r%a'!A\u0005\u0002\u000e-\u0001\"CB\nm\u0005\u0005I\u0011QB\u000b\u0011\u001d\u00199C\bC)\u0007S1aa!\f\u001b\t\r=\u0002bBA\u0012y\u0011\u00051\u0011\u0007\u0005\n\u0007ka$\u0019!C\u0005\u0005kC\u0001ba\u000e=A\u0003%!q\u0017\u0005\b\u0005'bD\u0011IB\u001d\u0011%\u0019iDGA\u0001\n\u0013\u0019yD\u0001\u000eB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002E\u000b\u0006Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u0019;\u0015AA7m\u0015\tA\u0015*A\u0003ta\u0006\u00148N\u0003\u0002K\u0017\u00061\u0011\r]1dQ\u0016T\u0011\u0001T\u0001\u0004_J<7\u0001A\n\u0005\u0001=SV\f\u0005\u0003Q#NKV\"A\"\n\u0005I\u001b%a\u0004*fOJ,7o]5p]6{G-\u001a7\u0011\u0005Q;V\"A+\u000b\u0005Y+\u0015A\u00027j]\u0006dw-\u0003\u0002Y+\n1a+Z2u_J\u0004\"\u0001\u0015\u0001\u0011\u0005A[\u0016B\u0001/D\u0005m\te\tV*veZLg/\u00197SK\u001e\u0014Xm]:j_:\u0004\u0016M]1ngB\u0011a,Y\u0007\u0002?*\u0011\u0001-R\u0001\u0005kRLG.\u0003\u0002c?\nQQ\nT,sSR\f'\r\\3\u0002\u0007ULG-F\u0001f!\t1wN\u0004\u0002h[B\u0011\u0001n[\u0007\u0002S*\u0011!.T\u0001\u0007yI|w\u000e\u001e \u000b\u00031\fQa]2bY\u0006L!A\\6\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003].D3!A:z!\t!x/D\u0001v\u0015\t1x)\u0001\u0006b]:|G/\u0019;j_:L!\u0001_;\u0003\u000bMKgnY3\"\u0003i\fQ!\r\u00187]A\nA!^5eA!\u001a!a]=\u0002\u0019\r|WM\u001a4jG&,g\u000e^:\u0016\u0003MCCaA:\u0002\u0002\u0005\u0012\u00111A\u0001\u0006e9\u0002d\u0006M\u0001\u000eG>,gMZ5dS\u0016tGo\u001d\u0011)\t\u0011\u0019\u0018\u0011A\u0001\nS:$XM]2faR,\"!!\u0004\u0011\t\u0005=\u0011\u0011C\u0007\u0002W&\u0019\u00111C6\u0003\r\u0011{WO\u00197fQ\r)1/_\u0001\u000bS:$XM]2faR\u0004\u0003f\u0001\u0004ts\u0006)1oY1mK\"\u001aqa]=\u0002\rM\u001c\u0017\r\\3!Q\rA1/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013e\u000b9#a\u000b\u00020\u0005M\u0002\"B2\n\u0001\u0004)\u0007\u0006BA\u0014gfDQ!`\u0005A\u0002MCS!a\u000bt\u0003\u0003Aq!!\u0003\n\u0001\u0004\ti\u0001\u000b\u0003\u00020ML\bbBA\u000e\u0013\u0001\u0007\u0011Q\u0002\u0015\u0005\u0003g\u0019\u00180A\u0006ok64U-\u0019;ve\u0016\u001cXCAA\u001e!\u0011\ty!!\u0010\n\u0007\u0005}2NA\u0002J]RDCAC:\u0002D\u0005\u0012\u0011QI\u0001\u0006g9\u0002d\u0006M\u0001\u0019g\u0016$\u0018+^1oi&dW\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cH\u0003BA&\u0003\u001bj\u0011\u0001\u0001\u0005\b\u0003\u001fZ\u0001\u0019AA)\u0003\u00151\u0018\r\\;f!\u0019\ty!a\u0015\u0002\u000e%\u0019\u0011QK6\u0003\u000b\u0005\u0013(/Y=)\u0007-\u0019\u00180A\btKR\fV/\u00198uS2,7oQ8m)\u0011\tY%!\u0018\t\r\u0005=C\u00021\u0001fQ\ra1/_\u0001\u000b?F,\u0018M\u001c;jY\u0016\u001c\u0018AD0rk\u0006tG/\u001b7fg~#S-\u001d\u000b\u0005\u0003O\ni\u0007\u0005\u0003\u0002\u0010\u0005%\u0014bAA6W\n!QK\\5u\u0011!\tyGDA\u0001\u0002\u0004\u0019\u0016a\u0001=%c\u0005Yq,];b]RLG.Z:!\u00035yg\u000eU1sC6\u001c\u0005.\u00198hKR!\u0011qMA<\u0011\u001d\tI\b\u0005a\u0001\u0003w\nQ\u0001]1sC6\u0004D!! \u0002\fB1\u0011qPAB\u0003\u000fk!!!!\u000b\u0007\u0005eT)\u0003\u0003\u0002\u0006\u0006\u0005%!\u0002)be\u0006l\u0007\u0003BAE\u0003\u0017c\u0001\u0001\u0002\u0007\u0002\u000e\u0006]\u0014\u0011!A\u0001\u0006\u0003\tyIA\u0002`II\nB!!%\u0002\u0018B!\u0011qBAJ\u0013\r\t)j\u001b\u0002\b\u001d>$\b.\u001b8h!\u0011\ty!!'\n\u0007\u0005m5NA\u0002B]f\f\u0001\u0003\\1nE\u0012\f''U;b]RLG.Z:\u0015\u0007M\u000b\t\u000bC\u0004\u0002$F\u0001\r!!\u0004\u0002\r1\fWN\u00193b\u0003A\u0001(/\u001a3jGR\fV/\u00198uS2,7\u000fF\u0002T\u0003SCa!a+\u0013\u0001\u0004\u0019\u0016\u0001\u00034fCR,(/Z:)\tI\u0019\u0018\u0011A\u0001\baJ,G-[2u)\u0011\ti!a-\t\r\u0005-6\u00031\u0001TQ\u0011\u00192/!\u0001\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA^\u0003;\u0004B!!0\u0002X:!\u0011qXAi\u001d\u0011\t\t-!4\u000f\t\u0005\r\u00171\u001a\b\u0005\u0003\u000b\fIMD\u0002i\u0003\u000fL\u0011\u0001T\u0005\u0003\u0015.K!\u0001S%\n\u0007\u0005=w)A\u0002tc2LA!a5\u0002V\u00069\u0001/Y2lC\u001e,'bAAh\u000f&!\u0011\u0011\\An\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002T\u0006U\u0007bBAp)\u0001\u0007\u0011\u0011]\u0001\bI\u0006$\u0018m]3ua\u0011\t\u0019/!<\u0011\r\u0005\u0015\u0018q]Av\u001b\t\t).\u0003\u0003\u0002j\u0006U'a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u0013\u000bi\u000f\u0002\u0007\u0002p\u0006u\u0017\u0011!A\u0001\u0006\u0003\tyIA\u0002`IMBC\u0001F:\u0002\u0002\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002x\n\r\u0001\u0003BA}\u0003\u007fl!!a?\u000b\t\u0005u\u0018Q[\u0001\u0006if\u0004Xm]\u0005\u0005\u0005\u0003\tYP\u0001\u0006TiJ,8\r\u001e+za\u0016DqA!\u0002\u0016\u0001\u0004\t90\u0001\u0004tG\",W.\u0019\u0015\u0004+ML\u0018\u0001B2paf$2!\u0017B\u0007\u0011\u001d\u0011yA\u0006a\u0001\u0005#\tQ!\u001a=ue\u0006\u0004B!a \u0003\u0014%!!QCAA\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\fts\u0006)qO]5uKV\u0011!Q\u0004\t\u0004=\n}\u0011b\u0001B\u0011?\nAQ\nT,sSR,'\u000fK\u0002\u0018gf\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002K\"\"\u0001d]A\"Q\r\u00011/_\u0001\u001b\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003!j\u0019rA\u0007B\u001a\u0005s\u0011y\u0004\u0005\u0003\u0002\u0010\tU\u0012b\u0001B\u001cW\n1\u0011I\\=SK\u001a\u0004BA\u0018B\u001e3&\u0019!QH0\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0002\u0010\t\u0005\u0013b\u0001B\"W\na1+\u001a:jC2L'0\u00192mKR\u0011!qF\u0001\u0005e\u0016\fG-\u0006\u0002\u0003LA!aL!\u0014Z\u0013\r\u0011ye\u0018\u0002\t\u001b2\u0013V-\u00193fe\"\u001aAd]=\u0002\t1|\u0017\r\u001a\u000b\u00043\n]\u0003B\u0002B-;\u0001\u0007Q-\u0001\u0003qCRD\u0007fA\u000fts\n\u0001\u0013I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\u0015q\"Q\u0004B1!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$b\u0001B4\u000f\u0006A\u0011N\u001c;fe:\fG.\u0003\u0003\u0003l\t\u0015$a\u0002'pO\u001eLgnZ\u0001\tS:\u001cH/\u00198dKR!!\u0011\u000fB;!\r\u0011\u0019HH\u0007\u00025!1!Q\u000e\u0011A\u0002e\u0013A\u0001R1uCN9\u0011Ea\r\u0003|\t}\u0002\u0003BA\b\u0005{J1Aa l\u0005\u001d\u0001&o\u001c3vGR$\u0002Ba!\u0003\b\n%%1\u0012\t\u0004\u0005\u000b\u000bS\"\u0001\u0010\t\u000buD\u0003\u0019A*\t\u000f\u0005%\u0001\u00061\u0001\u0002\u000e!9\u00111\u0004\u0015A\u0002\u00055A\u0003\u0003BB\u0005\u001f\u0013\tJa%\t\u000fuL\u0003\u0013!a\u0001'\"I\u0011\u0011B\u0015\u0011\u0002\u0003\u0007\u0011Q\u0002\u0005\n\u00037I\u0003\u0013!a\u0001\u0003\u001b\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u001a*\u001a1Ka',\u0005\tu\u0005\u0003\u0002BP\u0005Ok!A!)\u000b\t\t\r&QU\u0001\nk:\u001c\u0007.Z2lK\u0012T!A^6\n\t\t%&\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005_SC!!\u0004\u0003\u001c\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00038B!!\u0011\u0018Bb\u001b\t\u0011YL\u0003\u0003\u0003>\n}\u0016\u0001\u00027b]\u001eT!A!1\u0002\t)\fg/Y\u0005\u0004a\nm\u0016\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003/\u0013Y\rC\u0005\u0002p=\n\t\u00111\u0001\u0002<\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003RB1!1\u001bBm\u0003/k!A!6\u000b\u0007\t]7.\u0001\u0006d_2dWm\u0019;j_:LAAa7\u0003V\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\tOa:\u0011\t\u0005=!1]\u0005\u0004\u0005K\\'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003_\n\u0014\u0011!a\u0001\u0003/\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003w!\"Aa.\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tOa=\t\u0013\u0005=D'!AA\u0002\u0005]\u0015\u0001\u0002#bi\u0006\u00042A!\"7'\u00151$1 B !-\u0011ipa\u0001T\u0003\u001b\tiAa!\u000e\u0005\t}(bAB\u0001W\u00069!/\u001e8uS6,\u0017\u0002BB\u0003\u0005\u007f\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u001190A\u0003baBd\u0017\u0010\u0006\u0005\u0003\u0004\u000e51qBB\t\u0011\u0015i\u0018\b1\u0001T\u0011\u001d\tI!\u000fa\u0001\u0003\u001bAq!a\u0007:\u0001\u0004\ti!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r]11\u0005\t\u0007\u0003\u001f\u0019Ib!\b\n\u0007\rm1N\u0001\u0004PaRLwN\u001c\t\n\u0003\u001f\u0019ybUA\u0007\u0003\u001bI1a!\tl\u0005\u0019!V\u000f\u001d7fg!I1Q\u0005\u001e\u0002\u0002\u0003\u0007!1Q\u0001\u0004q\u0012\u0002\u0014\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\u0005\u001d41\u0006\u0005\u0007\u00053Z\u0004\u0019A3\u0003A\u00053EkU;sm&4\u0018\r\u001c*fOJ,7o]5p]6{G-\u001a7SK\u0006$WM]\n\u0004y\t-CCAB\u001a!\r\u0011\u0019\bP\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00197bgNt\u0015-\\3!)\rI61\b\u0005\u0007\u00053\u0002\u0005\u0019A3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007\u0003\u0002BA!/\u0004D%!1Q\tB^\u0005\u0019y%M[3di\"\u001a!d]=)\u0007e\u0019\u0018\u0010")
public class AFTSurvivalRegressionModel
extends RegressionModel<Vector, AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private Vector _quantiles;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final DoubleParam maxBlockSizeInMB;
    private final IntParam aggregationDepth;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;

    public static AFTSurvivalRegressionModel load(String string) {
        return AFTSurvivalRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public int numFeatures() {
        return this.coefficients().size();
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    private Vector _quantiles() {
        return this._quantiles;
    }

    private void _quantiles_$eq(Vector x$1) {
        this._quantiles = x$1;
    }

    @Override
    public void onParamChange(Param<?> param) {
        block2: {
            String string = param.name();
            String string2 = "quantileProbabilities";
            if (string != null ? !string.equals(string2) : string2 != null) break block2;
            if (this.isDefined(this.quantileProbabilities())) {
                this._quantiles_$eq(Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)q -> scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log1p(-q)) * this.scale()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
            } else {
                this._quantiles_$eq(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Vector lambda2Quantiles(double lambda) {
        void var3_2;
        Vector quantiles = this._quantiles().copy();
        BLAS$.MODULE$.scal(lambda, quantiles);
        return var3_2;
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = this.predict(features);
        return this.lambda2Quantiles(lambda);
    }

    @Override
    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)Nil$.MODULE$;
        Seq predictionColumns = (Seq)Nil$.MODULE$;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
                }
            }
            Column predCol = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predCol.as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (this.hasQuantilesCol()) {
            Column column;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)lambda -> this.lambda2Quantiles(BoxesRunTime.unboxToDouble((Object)lambda)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)predictionColumns.head()}));
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictQuantiles((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column quanCol = column;
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.quantilesCol()), Seq$.MODULE$.canBuildFrom());
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)quanCol.as(this.$(this.quantilesCol()), outputSchema.apply(this.$(this.quantilesCol())).metadata()), Seq$.MODULE$.canBuildFrom());
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append(this.uid()).append(": AFTSurvivalRegressionModel.transform() does nothing").append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block1: {
            StructType outputSchema = this.validateAndTransformSchema(schema, false);
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.predictionCol()));
            }
            if (!this.isDefined(this.quantilesCol()) || !new StringOps(Predef$.MODULE$.augmentString(this.$(this.quantilesCol()))).nonEmpty()) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.quantilesCol()), this.$(this.quantileProbabilities()).length);
        }
        return var2_2;
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(46).append("AFTSurvivalRegressionModel: uid=").append(this.uid()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
    }

    private static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            double d;
            Vector vector;
            Object scale;
            DefaultParamsReader.Metadata metadata;
            block3: {
                Row row;
                block2: {
                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                    String dataPath = new Path(path, "data").toString();
                    Dataset data = this.sparkSession().read().parquet(dataPath);
                    row = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object coefficients = ((SeqLike)some.get()).apply(0);
                    Object intercept = ((SeqLike)some.get()).apply(1);
                    scale = ((SeqLike)some.get()).apply(2);
                    if (!(coefficients instanceof Vector)) break block2;
                    vector = (Vector)coefficients;
                    if (!(intercept instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                    if (scale instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)scale);
            Tuple3 tuple3 = new Tuple3((Object)vector, (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2));
            Tuple3 tuple32 = tuple3;
            Vector coefficients = (Vector)tuple32._1();
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double scale2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data$module;
        private final AFTSurvivalRegressionModel instance;

        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                }
            }
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        scala.Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.coefficients();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(Integer.toString(x$1));
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients, double intercept, double scale) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

